/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils.bb;

import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.tcuilite.smiles.SmileLink;
import com.tomclaw.tcuilite.smiles.Smiles;
import com.tomclaw.utils.bb.BBResult;
import com.tomclaw.utils.bb.BBStyle;
import com.tomclaw.utils.bb.BBStyleString;
import com.tomclaw.utils.bb.UnsupportedTagException;
import java.util.Stack;
import java.util.Vector;

public class BBUtil {
    private static Stack elements;
    private static BBStyle style;
    private static int length;
    private static char ch;
    private static boolean state_ReadingTag;
    private static boolean state_ReadingValue;
    private static boolean is_TagClosing;
    private static boolean is_TagSelfClosing;
    private static boolean is_PrevChSlash;
    private static String buffer;
    private static String tag;
    private static String value;
    private static int line_width;
    private static int line_height;
    private static int total_height;
    private static int local_x;
    private static int breakpoint;
    private static boolean isOverflow;
    private static boolean isTagStart;
    private static String printText;
    private static SmileLink smileLink;
    public static String[][] colors;
    private static Vector styledStrings;

    public static BBResult processText(String text, int x, int y, int width, int baseColor) throws Throwable {
        BBResult bbResult = new BBResult();
        bbResult.originalString = new String();
        styledStrings.removeAllElements();
        style = new BBStyle(Theme.font, baseColor);
        if (Settings.BB_FORMATTING_ENABLED) {
            if (elements == null) {
                elements = new Stack();
            }
            elements.removeAllElements();
            elements.push(style);
        } else {
            elements = null;
        }
        length = text.length();
        state_ReadingTag = false;
        state_ReadingValue = false;
        is_TagClosing = false;
        is_TagSelfClosing = false;
        is_PrevChSlash = false;
        buffer = "";
        tag = "";
        value = "";
        line_width = 0;
        line_height = 0;
        total_height = 0;
        local_x = 0;
        breakpoint = 0;
        isOverflow = false;
        isTagStart = false;
        printText = "";
        for (int c = 0; c < length; ++c) {
            BBStyleString styleString;
            ch = text.charAt(c);
            if (!is_PrevChSlash && ch == '\\') {
                is_PrevChSlash = true;
                continue;
            }
            if (state_ReadingTag && !is_PrevChSlash) {
                if (ch == ']') {
                    if (is_TagClosing && Settings.BB_FORMATTING_ENABLED) {
                        elements.pop();
                        if (!elements.empty()) {
                            style = (BBStyle)elements.lastElement();
                        }
                    } else if (is_TagSelfClosing) {
                        if (tag.equals("br") && Settings.BB_BR_TAG_ENABLED) {
                            local_x = 0;
                            total_height += line_height;
                            line_height = BBUtil.detectHeight(style, 0);
                            bbResult.originalString = bbResult.originalString + "\n";
                        } else if (tag.equals("smile") && Settings.BB_SMILE_TAG_ENABLED) {
                            smileLink = new SmileLink(Integer.parseInt(value));
                            styleString = new BBStyleString();
                            styleString.style = style;
                            styleString.smileLink = smileLink;
                            if (x + local_x + smileLink.getWidth() > width) {
                                local_x = 0;
                                total_height += line_height;
                                line_height = BBUtil.detectHeight(style, 0);
                            }
                            styleString.local_x = x + local_x;
                            styleString.local_y = y + total_height;
                            styledStrings.addElement(styleString.trim());
                            bbResult.originalString = bbResult.originalString + Smiles.smiles[BBUtil.smileLink.smileIndex].getSmileDefinitions()[0];
                            if (smileLink.getHeight() > line_height) {
                                line_height = smileLink.getHeight();
                            }
                            local_x += smileLink.getWidth();
                        }
                    } else if (Settings.BB_FORMATTING_ENABLED) {
                        try {
                            style = BBUtil.processTag(tag, value, style);
                            elements.push(style);
                        }
                        catch (UnsupportedTagException ex) {
                            // empty catch block
                        }
                    }
                    line_height = BBUtil.detectHeight(style, line_height);
                    tag = "";
                    value = "";
                    state_ReadingTag = false;
                    state_ReadingValue = false;
                    is_TagClosing = false;
                    is_TagSelfClosing = false;
                    continue;
                }
                if (state_ReadingTag && tag.length() == 0 && ch == '/') {
                    is_TagClosing = true;
                    continue;
                }
                if (state_ReadingTag && ch == '/' && text.charAt(c + 1) == ']') {
                    is_TagSelfClosing = true;
                    continue;
                }
                if (ch == '=') {
                    state_ReadingValue = true;
                    continue;
                }
                if (state_ReadingValue) {
                    value = value + ch;
                    continue;
                }
                if (!state_ReadingTag) continue;
                tag = tag + ch;
                continue;
            }
            line_width = BBUtil.style.font.stringWidth(buffer + ch);
            isOverflow = x + local_x + line_width > width;
            boolean bl = isTagStart = ch == '[' && !is_PrevChSlash;
            if ((isOverflow || isTagStart) && buffer.length() != 0 || c == length) {
                if (isOverflow && breakpoint > 0) {
                    printText = buffer.substring(0, breakpoint);
                    buffer = buffer.substring(breakpoint);
                } else if (isOverflow && breakpoint == 0 && local_x == 0) {
                    printText = buffer;
                    buffer = "";
                } else if (isOverflow && breakpoint == 0) {
                    printText = "";
                } else {
                    printText = buffer;
                    buffer = "";
                }
                styleString = new BBStyleString();
                styleString.style = style;
                styleString.string = printText;
                styleString.local_x = x + local_x;
                styleString.local_y = y + total_height;
                styledStrings.addElement(styleString.trim());
                bbResult.originalString = bbResult.originalString + printText;
                local_x += BBUtil.style.font.stringWidth(printText);
                breakpoint = 0;
                if (isOverflow) {
                    total_height += line_height;
                    local_x = 0;
                    line_height = BBUtil.detectHeight(style, 0);
                    --c;
                    continue;
                }
            }
            if (isTagStart) {
                state_ReadingTag = true;
                continue;
            }
            buffer = buffer + ch;
            if (ch == ' ' || ch == ',' || ch == '.' || ch == ';' || ch == ':' || ch == '-' || ch == '(' || ch == ')' || ch == '?' || ch == '!' || ch == '\"' || ch == '`') {
                breakpoint = buffer.length() - 1;
            }
            is_PrevChSlash = false;
        }
        bbResult.height = total_height += line_height;
        bbResult.bbStyleString = new BBStyleString[styledStrings.size()];
        styledStrings.copyInto(bbResult.bbStyleString);
        styledStrings.copyInto(bbResult.bbStyleString);
        return bbResult;
    }

    private static BBStyle processTag(String tag, String value, BBStyle t_style) throws Throwable {
        BBStyle bbStyle = t_style.clone();
        if (tag.equals("b")) {
            bbStyle.setStyle(1);
        } else if (tag.equals("i")) {
            bbStyle.setStyle(2);
        } else if (tag.equals("u")) {
            bbStyle.setStyle(4);
        } else if (tag.equals("p")) {
            bbStyle.setStyle(0);
        } else if (tag.equals("l")) {
            bbStyle.setSize(16);
        } else if (tag.equals("m")) {
            bbStyle.setSize(0);
        } else if (tag.equals("s")) {
            bbStyle.setSize(8);
        } else if (tag.equals("c")) {
            value = value.toLowerCase();
            for (int c = 0; c < colors.length; ++c) {
                if (!colors[c][0].equals(value)) continue;
                value = colors[c][1];
                break;
            }
            if (value.length() == 0) {
                bbStyle.color = 0;
            } else {
                try {
                    bbStyle.color = Integer.parseInt(value, 16);
                }
                catch (Throwable ex) {
                    bbStyle.color = 0;
                }
            }
        } else {
            throw new UnsupportedTagException();
        }
        return bbStyle;
    }

    private static int detectHeight(BBStyle style, int line_height) {
        return style.font.getHeight() > line_height ? style.font.getHeight() + Theme.upSize : line_height;
    }

    static {
        colors = new String[][]{{"red", "FF0000"}, {"white", "FFFFFF"}, {"cyan", "00FFFF"}, {"silver", "C0C0C0"}, {"blue", "0000FF"}, {"grey", "808080"}, {"dark_blue", "0000A0"}, {"black", "000000"}, {"light_purple", "FF0080"}, {"orange", "FFA500"}, {"purple", "800080"}, {"brown", "A52A2A"}, {"yellow", "FFFF00"}, {"maroon", "800000"}, {"lime", "00FF00"}, {"green", "008000"}, {"fuchsia", "FF00FF"}, {"olive", "808000"}};
        styledStrings = new Vector();
    }
}

