/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils;

import com.tomclaw.utils.LogUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class HexUtil {
    public static final char[] HEX_DIGITS_CHARS = "0123456789abcdef".toCharArray();
    public static final byte[] HEX_DIGITS_BYTES = "0123456789abcdef".getBytes();
    public static boolean isLoggerEnabled = true;

    public static void dump_(byte[] data, String linePrefix) {
        if (isLoggerEnabled) {
            HexUtil.dump_(data, linePrefix, data.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump_(byte[] data, String linePrefix, int lenToPrint) {
        if (isLoggerEnabled) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                HexUtil.dump_(System.err, data, linePrefix, lenToPrint);
                System.err.flush();
            }
        }
    }

    public static void dump_(OutputStream os, byte[] data, String linePrefix) {
        if (isLoggerEnabled) {
            HexUtil.dump_(os, data, linePrefix, data.length);
        }
    }

    public static void dump_(OutputStream os, byte[] data, String linePrefix, int lenToPrint) {
        if (!isLoggerEnabled) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("\r\n" + linePrefix);
            int printed = 0;
            int printedThisLine = 0;
            int lineStart = 0;
            int actuallyPrinted = 0;
            if (lenToPrint > data.length) {
                lenToPrint = data.length;
            }
            while (printed < lenToPrint) {
                if ((printedThisLine & 3) == 0 && printedThisLine > 0) {
                    sb.append("  ");
                }
                sb.append((printed >= lenToPrint ? "  " : HexUtil.pad_(Integer.toHexString(data[printed] & 0xFF), 2)).toLowerCase() + " ");
                ++printedThisLine;
                if (++printed < lenToPrint) {
                    ++actuallyPrinted;
                }
                if (printedThisLine < 16 && printed != lenToPrint) continue;
                sb.append("  ");
                HexUtil.dumpChars(sb, data, lineStart, actuallyPrinted);
                lineStart = printed;
                printedThisLine = 0;
                actuallyPrinted = 0;
                sb.append("\r\n");
                if (printed >= lenToPrint) continue;
                sb.append(linePrefix);
            }
        }
        catch (Exception e) {
            sb.append("\r\n");
        }
        try {
            LogUtil.outMessage(sb.toString());
            os.write(sb.append("\r\n").toString().getBytes());
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static void dumpChars(StringBuffer sb, byte[] data, int lineStart, int maxLen) {
        int printed = lineStart;
        sb.append("\"");
        for (int printedThisLine = 0; printed < data.length && printedThisLine <= maxLen; ++printed, ++printedThisLine) {
            if ((printedThisLine & 7) == 0 && printedThisLine > 0) {
                sb.append(" ");
            }
            if (data[printed] >= 32) {
                sb.append((char)data[printed]);
                continue;
            }
            sb.append(".");
        }
        sb.append("\"");
    }

    private static String pad_(String str, int resultingStringLength) {
        StringBuffer buf = new StringBuffer();
        while (buf.length() < resultingStringLength - str.length()) {
            buf.append("0");
        }
        return buf.append(str).toString().toLowerCase();
    }

    public static String toHexString(int word) {
        return HexUtil.pad_(Integer.toHexString(word & 0xFFFF), 4);
    }

    public static String toHexString(long n, long mask, int resultingStringLength) {
        return HexUtil.pad_(Long.toString(n & mask), resultingStringLength);
    }

    public static String toHexString0x(int word) {
        return "0x" + HexUtil.pad_(Integer.toHexString(word & 0xFFFF), 4);
    }

    public static String toHexString0x(long n, long mask, int resultingDigitStringLengthWithout0x) {
        return "0x" + HexUtil.toHexString(n, mask, resultingDigitStringLengthWithout0x);
    }

    public static String bytesToString(byte[] data) {
        String string = new String();
        for (int c = 0; c < data.length; ++c) {
            string = string + HexUtil.pad_(Integer.toHexString(data[c] & 0xFF), 2);
        }
        return string;
    }

    public static byte[] stringToBytes(String string) {
        byte[] data = new byte[string.length() / 2];
        for (int c = 0; c < string.length(); c += 2) {
            data[c / 2] = (byte)Integer.parseInt(string.substring(c, c + 2), 16);
        }
        return data;
    }
}

