/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.Button;
import com.tomclaw.tcuilite.ChatItem;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Dialog;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Gauge;
import com.tomclaw.tcuilite.Grid;
import com.tomclaw.tcuilite.Group;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.Popup;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Scroll;
import com.tomclaw.tcuilite.Smile;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Tab;
import com.tomclaw.utils.FontUtil;
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;

public class Theme {
    public static final int BLOCK_BUTTON = 1;
    public static final int BLOCK_CHAT_ITEM = 2;
    public static final int BLOCK_CHECK = 3;
    public static final int BLOCK_DIALOG = 4;
    public static final int BLOCK_FIELD = 5;
    public static final int BLOCK_GAUGE = 6;
    public static final int BLOCK_GRID = 7;
    public static final int BLOCK_GROUP = 8;
    public static final int BLOCK_HEADER = 9;
    public static final int BLOCK_LABEL = 10;
    public static final int BLOCK_LIST = 11;
    public static final int BLOCK_PANE = 12;
    public static final int BLOCK_POPUP = 13;
    public static final int BLOCK_RADIO = 14;
    public static final int BLOCK_SCROLL = 15;
    public static final int BLOCK_SMILE = 16;
    public static final int BLOCK_SOFT = 17;
    public static final int BLOCK_TAB = 18;
    public static Font font = FontUtil.getFont(64, 0, 8);
    public static Font titleFont = FontUtil.getFont(64, 1, 8);
    public static Font italicFont = FontUtil.getFont(64, 2, 8);
    public static int upSize = 1;
    public static int scrollWidth = 15;
    public static int version;
    public static String title;
    public static String author;
    public static boolean isThemeChangeActive;
    private static Thread thread;
    private static int[] data_tr;

    private static DataInputStream getInputStream(String resDatFile) {
        DataInputStream dis = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream(resDatFile));
        return dis;
    }

    public static int[] loadTheme(String resDatFile) {
        try {
            return Theme.loadTheme(Theme.getInputStream(resDatFile));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static String loadTitle(String resDatFile) {
        try {
            return Theme.loadTitle(Theme.getInputStream(resDatFile));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static String loadTitle(DataInputStream dis) {
        try {
            char header = dis.readChar();
            if (header == '\u00af') {
                version = dis.readChar();
                title = dis.readUTF();
                author = dis.readUTF();
                return title;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static int[] loadTheme(DataInputStream dis) {
        try {
            char header = dis.readChar();
            if (header == '\u00af') {
                version = dis.readChar();
                title = dis.readUTF();
                author = dis.readUTF();
            }
            int size = dis.readInt();
            int[] data = new int[size];
            for (int c = 0; c < data.length; ++c) {
                data[c] = dis.readInt();
            }
            return data;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int readBlock(int offset, int[] theme) {
        int type = theme[offset++];
        int size = theme[offset++];
        int defo = offset;
        switch (type) {
            case 1: {
                Button.unactForeColor = theme[offset++];
                Button.unactForeShadowColor = theme[offset++];
                Button.unactOnlTopBorder = theme[offset++];
                Button.unactBotBorder = theme[offset++];
                Button.unactInTopBorder = theme[offset++];
                Button.unactInOnlBotBorder = theme[offset++];
                Button.unactGradFrom = theme[offset++];
                Button.unactGradTo = theme[offset++];
                Button.actForeColor = theme[offset++];
                Button.actForeShadowColor = theme[offset++];
                Button.actOnlTopBorder = theme[offset++];
                Button.actBotBorder = theme[offset++];
                Button.actInOnlBotBorder = theme[offset++];
                Button.actGradFrom = theme[offset++];
                Button.actGradMidd = theme[offset++];
                Button.actGradAftr = theme[offset++];
                Button.actGradFinl = theme[offset++];
                Button.actOuterLight = theme[offset++];
                Button.actInnerLight = theme[offset++];
                Button.prsdGradFrom = theme[offset++];
                Button.prsdGradFinl = theme[offset++];
                break;
            }
            case 2: {
                ChatItem.foreColor = theme[offset++];
                ChatItem.titleColor = theme[offset++];
                ChatItem.borderColor = theme[offset++];
                ChatItem.actOuterLight = theme[offset++];
                ChatItem.actInnerLight = theme[offset++];
                break;
            }
            case 3: {
                Check.foreColor = theme[offset++];
                Check.actOuterLight = theme[offset++];
                Check.actInnerLight = theme[offset++];
                break;
            }
            case 4: {
                Dialog.titleColor = theme[offset++];
                Dialog.textColor = theme[offset++];
                Dialog.alphaBackColor = theme[offset++];
                Dialog.plainBackColor = theme[offset++];
                Dialog.hrLineColor = theme[offset++];
                Dialog.hrLineShadow = theme[offset++];
                Dialog.shadowColor = theme[offset++];
                break;
            }
            case 5: {
                Field.foreColor = theme[offset++];
                Field.backColor = theme[offset++];
                Field.borderColor = theme[offset++];
                Field.actOuterLight = theme[offset++];
                Field.actInnerLight = theme[offset++];
                break;
            }
            case 6: {
                Gauge.backColorGradFrom = theme[offset++];
                Gauge.backColorGradFinl = theme[offset++];
                Gauge.unactForeColor = theme[offset++];
                Gauge.unactForeShadowColor = theme[offset++];
                Gauge.unactOnlTopBorder = theme[offset++];
                Gauge.unactBotBorder = theme[offset++];
                Gauge.unactInTopBorder = theme[offset++];
                Gauge.unactInOnlBotBorder = theme[offset++];
                Gauge.unactGradFrom = theme[offset++];
                Gauge.unactGradTo = theme[offset++];
                Gauge.actForeColor = theme[offset++];
                Gauge.actForeShadowColor = theme[offset++];
                Gauge.actOnlTopBorder = theme[offset++];
                Gauge.actBotBorder = theme[offset++];
                Gauge.actInOnlBotBorder = theme[offset++];
                Gauge.actGradFrom = theme[offset++];
                Gauge.actGradMidd = theme[offset++];
                Gauge.actGradAftr = theme[offset++];
                Gauge.actGradFinl = theme[offset++];
                Gauge.actOuterLight = theme[offset++];
                Gauge.actInnerLight = theme[offset++];
                break;
            }
            case 15: {
                Scroll.scrollBack = theme[offset++];
                Scroll.scrollGradFrom = theme[offset++];
                Scroll.scrollGradTo = theme[offset++];
                Scroll.scrollBorder = theme[offset++];
                Scroll.scrollFix = theme[offset++];
                Scroll.scrollFixShadow = theme[offset++];
                break;
            }
            case 7: {
                Grid.backColor = theme[offset++];
                Grid.hrLine = theme[offset++];
                break;
            }
            case 8: {
                Group.foreColor = theme[offset++];
                Group.foreSelColor = theme[offset++];
                Group.backColor = theme[offset++];
                Group.hrLine = theme[offset++];
                Group.selectedGradFrom = theme[offset++];
                Group.selectedGradTo = theme[offset++];
                Group.selectedUpOutline = theme[offset++];
                Group.selectedBottomOutline = theme[offset++];
                break;
            }
            case 9: {
                Header.headerGradFrom = theme[offset++];
                Header.headerGradTo = theme[offset++];
                Header.headerLine1 = theme[offset++];
                Header.headerLine2 = theme[offset++];
                Header.fontColor = theme[offset++];
                Header.fontShadow = theme[offset++];
                break;
            }
            case 10: {
                Label.foreColor = theme[offset++];
                Label.borderColor = theme[offset++];
                Label.focusedBackColor = theme[offset++];
                Label.actOuterLight = theme[offset++];
                Label.actInnerLight = theme[offset++];
                Label.headerForeColor = theme[offset++];
                Label.headerGradFrom = theme[offset++];
                Label.headerGradTo = theme[offset++];
                Label.headerHr = theme[offset++];
                break;
            }
            case 11: {
                List.foreColor = theme[offset++];
                List.foreSelColor = theme[offset++];
                List.backColor = theme[offset++];
                List.hrLine = theme[offset++];
                List.selectedGradFrom = theme[offset++];
                List.selectedGradTo = theme[offset++];
                List.selectedUpOutline = theme[offset++];
                List.selectedBottomOutline = theme[offset++];
                break;
            }
            case 12: {
                Pane.backColor = theme[offset++];
                break;
            }
            case 13: {
                Popup.foreColor = theme[offset++];
                Popup.foreSelColor = theme[offset++];
                Popup.backGradFrom = theme[offset++];
                Popup.backGradTo = theme[offset++];
                Popup.selectedGradFrom = theme[offset++];
                Popup.selectedGradTo = theme[offset++];
                Popup.selectedUpOutline = theme[offset++];
                Popup.selectedBottomOutline = theme[offset++];
                Popup.shadowBorder = theme[offset++];
                Popup.alphaBackColor = theme[offset++];
                Popup.shadowColor = theme[offset++];
                break;
            }
            case 14: {
                Radio.foreColor = theme[offset++];
                Radio.actOuterLight = theme[offset++];
                Radio.actInnerLight = theme[offset++];
                break;
            }
            case 16: {
                Smile.actOuterLight = theme[offset++];
                Smile.actInnerLight = theme[offset++];
                break;
            }
            case 17: {
                Soft.softLine1 = theme[offset++];
                Soft.softLine2 = theme[offset++];
                Soft.softGradFrom = theme[offset++];
                Soft.softGradTo = theme[offset++];
                Soft.fontColor = theme[offset++];
                Soft.fontShadow = theme[offset++];
                break;
            }
            case 18: {
                Tab.backGradFrom = theme[offset++];
                Tab.backGradTo = theme[offset++];
                Tab.selectedForeColor = theme[offset++];
                Tab.selectedGradFrom = theme[offset++];
                Tab.selectedGradTo = theme[offset++];
                Tab.selectedUpOutline = theme[offset++];
                Tab.selectedBottomOutline = theme[offset++];
                Tab.unSelectedForeColor = theme[offset++];
                Tab.unSelectedGradFrom = theme[offset++];
                Tab.unSelectedGradTo = theme[offset++];
                Tab.unSelectedUpOutline = theme[offset++];
                Tab.unSelectedBottomOutline = theme[offset++];
            }
        }
        return defo + size;
    }

    public static void applyData(int[] theme) {
        int offset = 0;
        int count = theme[offset++];
        for (int c = 0; c < count; ++c) {
            offset = Theme.readBlock(offset, theme);
        }
        Theme.clearCache();
    }

    public static void clearCache() {
        Dialog.clearCache();
        Popup.clearCache();
    }

    public static boolean startThemeChange(String theme_fr, String theme_to) {
        try {
            int[] data_fr = Theme.loadTheme(theme_fr);
            int[] data_to = Theme.loadTheme(theme_to);
            return Theme.startThemeChange(data_fr, data_to);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean startThemeChange(final int[] data_fr, final int[] data_to) {
        if (isThemeChangeActive) {
            isThemeChangeActive = false;
            try {
                thread.join();
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        if (data_tr != null) {
            System.arraycopy(data_tr, 0, data_fr, 0, data_tr.length);
        } else {
            data_tr = new int[data_to.length];
        }
        thread = new Thread(){

            public void run() {
                isThemeChangeActive = true;
                for (int c = 0; c <= 100; ++c) {
                    if (!isThemeChangeActive) {
                        return;
                    }
                    for (int i = 0; i < data_fr.length; ++i) {
                        int currPoint = data_fr[i];
                        int destPoint = data_to[i];
                        int a = ((currPoint & 0xFF000000) * (100 - c) + (destPoint & 0xFF000000) * c) / 100 & 0xFF000000;
                        int b = ((currPoint & 0xFF0000) * (100 - c) + (destPoint & 0xFF0000) * c) / 100 & 0xFF0000;
                        int g = ((currPoint & 0xFF00) * (100 - c) + (destPoint & 0xFF00) * c) / 100 & 0xFF00;
                        int r = ((currPoint & 0xFF) * (100 - c) + (destPoint & 0xFF) * c) / 100 & 0xFF;
                        data_tr[i] = a | r | g | b;
                    }
                    Theme.applyData(data_tr);
                    Screen.screen.repaint();
                    try {
                        1.sleep(25L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                isThemeChangeActive = false;
                Theme.access$002(null);
            }
        };
        thread.start();
        return true;
    }

    public static void checkForUpSize() {
        upSize = 1;
        if (font.getHeight() + 2 < Splitter.imageMaxSize) {
            upSize = (Splitter.imageMaxSize - font.getHeight()) / 2 + 1;
        }
        if (Screen.screen.isPointerEvents && upSize < Screen.screen.getHeight() / 70) {
            upSize = Screen.screen.getHeight() / 70;
        }
    }

    static /* synthetic */ int[] access$002(int[] x0) {
        data_tr = x0;
        return x0;
    }
}

