/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.GObject;
import com.tomclaw.tcuilite.Gauge;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.TabEvent;
import com.tomclaw.tcuilite.TabItem;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Tab
extends GObject {
    public Vector items = new Vector();
    public int xOffset = 0;
    public int selectedIndex = 0;
    public TabEvent tabEvent = null;
    public GObject gObject = null;
    public int KEY_LEFT_EVENT = 2;
    public int KEY_RIGHT_EVENT = 5;
    private TabItem tempTabItem;
    public int dragXStart = -1;
    public Screen screen;
    public int itemHeight;
    public int imageWidth = 0;
    public int totalWidth = 0;
    public int tabLabelHeight;
    public static int backGradFrom = 0xFFFFFF;
    public static int backGradTo = 0xFFFFFF;
    public static int selectedForeColor = 0x555555;
    public static int selectedGradFrom = 0xDDDDFF;
    public static int selectedGradTo = 0xBBAAEE;
    public static int selectedUpOutline = 0xCCCCEE;
    public static int selectedBottomOutline = 0xAAAACC;
    public static int unSelectedForeColor = 0x555555;
    public static int unSelectedGradFrom = 0xFFFFFF;
    public static int unSelectedGradTo = 0xFFFFFF;
    public static int unSelectedUpOutline = 0xDDDDDD;
    public static int unSelectedBottomOutline = 0xAAAAAA;

    public Tab(Screen screen) {
        this.screen = screen;
    }

    public void addTabItem(TabItem tabItem) {
        this.items.addElement(tabItem);
    }

    public void setGObject(GObject gObject) {
        this.gObject = gObject;
        this.gObject.setTouchOrientation(this.screen.isPointerEvents);
    }

    public void repaint(Graphics g) {
        this.repaint(g, 0, 0);
    }

    public void repaint(Graphics g, int paintX, int paintY) {
        g.setFont(Theme.font);
        this.itemHeight = Theme.font.getHeight() + Theme.upSize * 3;
        g.setClip(paintX + this.x, paintY + this.y, this.width, this.itemHeight + 1);
        DrawUtil.fillVerticalGradient(g, paintX + this.x, paintY + this.y, this.width, this.itemHeight, backGradFrom, backGradTo);
        int tempXOffset = 0;
        g.setColor(unSelectedBottomOutline);
        g.drawLine(paintX + this.x, paintY + this.y + this.itemHeight, paintX + this.x + this.width, paintY + this.y + this.itemHeight);
        for (int c = 0; c < this.items.size(); ++c) {
            this.tempTabItem = (TabItem)this.items.elementAt(c);
            this.imageWidth = this.tempTabItem.imageFileHash != 0 ? Splitter.getImageGroup((int)this.tempTabItem.imageFileHash).size : 0;
            int itemWidth = Theme.font.stringWidth(this.tempTabItem.title) + Theme.upSize * 2 + (this.tempTabItem.imageIndex == -1 ? 0 : this.imageWidth + Theme.upSize);
            this.tempTabItem.x = this.x + tempXOffset;
            this.tempTabItem.width = itemWidth;
            if (c == this.selectedIndex) {
                DrawUtil.fillVerticalGradient(g, paintX + this.x + tempXOffset - this.xOffset, paintY + this.y + 1, itemWidth * this.tempTabItem.fillPercent / 100, this.itemHeight, selectedGradFrom, selectedGradTo);
                g.setColor(selectedUpOutline);
                g.drawLine(paintX + this.x + tempXOffset - this.xOffset + 1, paintY + this.y, paintX + this.x + tempXOffset - this.xOffset + itemWidth - 1, paintY + this.y);
                g.drawLine(paintX + this.x + tempXOffset - this.xOffset, paintY + this.y + 1, paintX + this.x + tempXOffset - this.xOffset, paintY + this.y + this.itemHeight - 1);
                g.drawLine(paintX + this.x + tempXOffset + itemWidth - this.xOffset, paintY + this.y + 1, paintX + this.x + tempXOffset + itemWidth - this.xOffset, paintY + this.y + this.itemHeight - 1);
                g.setColor(selectedBottomOutline);
                g.drawLine(paintX + this.x + tempXOffset - this.xOffset + 1, paintY + this.y + this.itemHeight, paintX + this.x + tempXOffset - this.xOffset + itemWidth - 1, paintY + this.y + this.itemHeight);
            } else {
                DrawUtil.fillVerticalGradient(g, paintX + this.x + tempXOffset - this.xOffset + 1, paintY + this.y + 1, itemWidth - 1, this.itemHeight - 1, unSelectedGradFrom, unSelectedGradTo);
                g.setColor(unSelectedUpOutline);
                g.drawLine(paintX + this.x + tempXOffset - this.xOffset + 1, paintY + this.y + Theme.upSize, paintX + this.x + tempXOffset - this.xOffset + itemWidth - 1, paintY + this.y + Theme.upSize);
                if (c == 0) {
                    g.drawLine(paintX + this.x + tempXOffset - this.xOffset, paintY + this.y + 1 + Theme.upSize, paintX + this.x + tempXOffset - this.xOffset, paintY + this.y + this.itemHeight - 1);
                }
                g.drawLine(paintX + this.x + tempXOffset + itemWidth - this.xOffset, paintY + this.y + 1 + Theme.upSize, paintX + this.x + tempXOffset + itemWidth - this.xOffset, paintY + this.y + this.itemHeight - 1);
            }
            if (this.tempTabItem.imageIndex != -1) {
                Splitter.drawImage(g, this.tempTabItem.imageFileHash, this.tempTabItem.imageIndex, paintX + this.x + tempXOffset - this.xOffset + Theme.upSize, paintY + this.y + Theme.upSize * 2, false);
            }
            g.setColor(c == this.selectedIndex ? selectedForeColor : unSelectedForeColor);
            g.drawString(this.tempTabItem.title, paintX + this.x + tempXOffset - this.xOffset + Theme.upSize + (this.tempTabItem.imageIndex == -1 ? 0 : this.imageWidth + Theme.upSize), paintY + this.y + Theme.upSize * 2, 20);
            tempXOffset += itemWidth;
        }
        this.totalWidth = tempXOffset;
        this.tabLabelHeight = 0;
        if (this.selectedIndex >= 0 && this.selectedIndex < this.items.size()) {
            this.tempTabItem = (TabItem)this.items.elementAt(this.selectedIndex);
            if (this.tempTabItem != null && this.tempTabItem.tabLabel != null) {
                this.tempTabItem.tabLabel.setLocation(paintX + this.x, paintY + this.y + this.itemHeight + 1);
                this.tempTabItem.tabLabel.setSize(this.width, -1);
                g.setClip(paintX + this.x, paintY + this.y + this.itemHeight + 1, this.width, this.height - this.itemHeight - 1);
                this.tempTabItem.tabLabel.repaint(g);
                this.tabLabelHeight = this.tempTabItem.tabLabel.getHeight();
            }
        }
        this.gObject.setLocation(this.x, this.y + this.itemHeight + 1 + this.tabLabelHeight);
        this.gObject.setSize(this.width, this.height - this.itemHeight - 1 - this.tabLabelHeight);
        g.setClip(paintX + this.x, paintY + this.y + this.itemHeight + 1 + this.tabLabelHeight, this.width, this.height - this.itemHeight - 1 - this.tabLabelHeight);
        this.gObject.repaint(g, paintX, paintY);
        g.setClip(0, 0, this.screen.getWidth(), this.screen.getHeight());
    }

    public void keyPressed(int keyCode) {
        if ((Screen.getExtGameAct(keyCode) == this.KEY_LEFT_EVENT || keyCode == this.KEY_LEFT_EVENT || Screen.getExtGameAct(keyCode) == this.KEY_RIGHT_EVENT || keyCode == this.KEY_RIGHT_EVENT) && this.gObject instanceof Pane && !((Pane)this.gObject).items.isEmpty() && ((Pane)this.gObject).psvLstFocusedIndex >= 0 && (PaneObject)((Pane)this.gObject).items.elementAt(((Pane)this.gObject).psvLstFocusedIndex) instanceof Gauge) {
            this.gObject.keyPressed(keyCode);
            return;
        }
        if (Screen.getExtGameAct(keyCode) == this.KEY_LEFT_EVENT || keyCode == this.KEY_LEFT_EVENT) {
            this.focusLeft();
        } else if (Screen.getExtGameAct(keyCode) == this.KEY_RIGHT_EVENT || keyCode == this.KEY_RIGHT_EVENT) {
            this.focusRight();
        } else {
            this.gObject.keyPressed(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        if (!(Screen.getExtGameAct(keyCode) == this.KEY_LEFT_EVENT && keyCode == this.KEY_LEFT_EVENT || Screen.getExtGameAct(keyCode) == this.KEY_RIGHT_EVENT && keyCode == this.KEY_RIGHT_EVENT)) {
            this.gObject.keyReleased(keyCode);
        } else if (this.gObject instanceof Pane && !((Pane)this.gObject).items.isEmpty() && ((Pane)this.gObject).psvLstFocusedIndex >= 0 && (PaneObject)((Pane)this.gObject).items.elementAt(((Pane)this.gObject).psvLstFocusedIndex) instanceof Gauge) {
            this.gObject.keyReleased(keyCode);
        }
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void pointerPressed(int x, int y) {
        if (y >= this.y && y <= this.y + this.itemHeight) {
            this.dragXStart = this.xOffset + x;
            this.screen.isSlideAwaiting = false;
            this.screen.isSlideMode = false;
            this.screen.isDirectScroll = true;
            for (int c = 0; c < this.items.size(); ++c) {
                this.tempTabItem = (TabItem)this.items.elementAt(c);
                if (this.tempTabItem.x > x + this.xOffset || this.tempTabItem.x + this.tempTabItem.width < x + this.xOffset) continue;
                if (this.tabEvent != null) {
                    this.tabEvent.stateChanged(this.selectedIndex, c, this.items.size());
                }
                this.selectedIndex = c;
                this.focusSelectedItem();
                return;
            }
            return;
        }
        this.dragXStart = -1;
        this.gObject.pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        if (this.dragXStart == -1) {
            this.gObject.pointerReleased(x, y);
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.dragXStart != -1) {
            this.xOffset = this.dragXStart - x;
            if (this.xOffset < 0) {
                this.xOffset = 0;
            }
            if (this.totalWidth > this.width) {
                if (this.xOffset >= this.totalWidth - this.width + 1) {
                    this.xOffset = this.totalWidth - this.width + 1;
                }
            } else {
                this.xOffset = 0;
            }
            return true;
        }
        return this.gObject.pointerDragged(x, y);
    }

    public void focusLeft() {
        if (this.selectedIndex - 1 >= 0) {
            if (this.tabEvent != null) {
                this.tabEvent.stateChanged(this.selectedIndex, --this.selectedIndex, this.items.size());
            } else {
                --this.selectedIndex;
            }
        }
        this.tempTabItem = (TabItem)this.items.elementAt(this.selectedIndex);
        if (this.tempTabItem.x - this.xOffset < 0) {
            this.xOffset = this.tempTabItem.x;
        }
    }

    public void focusRight() {
        if (this.selectedIndex + 1 < this.items.size()) {
            if (this.tabEvent != null) {
                this.tabEvent.stateChanged(this.selectedIndex, ++this.selectedIndex, this.items.size());
            } else {
                ++this.selectedIndex;
            }
        }
        this.tempTabItem = (TabItem)this.items.elementAt(this.selectedIndex);
        if (this.tempTabItem.x + this.tempTabItem.width - this.xOffset + 1 > this.width) {
            this.xOffset = this.tempTabItem.x + this.tempTabItem.width - this.width + 1;
        }
    }

    public void focusSelectedItem() {
        this.tempTabItem = (TabItem)this.items.elementAt(this.selectedIndex);
        if (this.tempTabItem.x - this.xOffset < 0) {
            this.xOffset = this.tempTabItem.x;
        }
        if (this.tempTabItem.x + this.tempTabItem.width - this.xOffset + 1 > this.width) {
            this.xOffset = this.tempTabItem.x + this.tempTabItem.width - this.width + 1;
        }
    }

    public boolean switchTabTo(int tabIndex) {
        if (tabIndex == this.selectedIndex) {
            return false;
        }
        if (tabIndex >= 0 && tabIndex < this.items.size()) {
            if (this.tabEvent != null) {
                this.tabEvent.stateChanged(this.selectedIndex, tabIndex, this.items.size());
            }
            this.selectedIndex = tabIndex;
            if (this.totalWidth > this.width) {
                TabItem tabItem = (TabItem)this.items.elementAt(tabIndex);
                if (this.totalWidth - this.xOffset < this.width) {
                    this.xOffset = this.totalWidth - this.width;
                }
                if (tabItem.x + tabItem.width + 1 > this.xOffset + this.width) {
                    this.xOffset = tabItem.x + tabItem.width - this.width + 1;
                }
                if (tabItem.x < this.xOffset) {
                    this.xOffset = tabItem.x;
                }
            } else {
                this.xOffset = 0;
            }
            return true;
        }
        return false;
    }

    public boolean validateSelection() {
        if (this.items.isEmpty()) {
            this.selectedIndex = -1;
            return true;
        }
        if (this.selectedIndex < 0) {
            this.selectedIndex = 0;
            this.switchTabTo(this.selectedIndex);
            return true;
        }
        if (this.selectedIndex >= this.items.size()) {
            this.selectedIndex = this.items.size() - 1;
            this.switchTabTo(this.selectedIndex);
            return true;
        }
        return false;
    }
}

