/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.Content;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.StringUtil;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlainContent
implements Content {
    public String text = "";
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;
    private String[] strings = new String[0];
    private boolean isBold = false;
    private boolean isItalic = false;
    public Image image = null;
    public int interlineheight = 2;

    public PlainContent(String text) {
        this.setText(text);
    }

    public final void setText(String text) {
        this.text = text;
        this.update();
    }

    public void setColor(int color) {
    }

    public String getText() {
        return this.text;
    }

    public void update() {
        this.strings = StringUtil.wrapText(this.text, this.width - (Theme.upSize + 4) * 2 - (this.image != null ? Theme.upSize * 2 + this.image.getWidth() : 0), this.getFont());
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.width = width;
            this.update();
        } else {
            this.width = width;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        this.height = Math.max(this.image != null ? Theme.upSize * 2 + this.image.getHeight() : 0, this.getFont().getHeight() + Theme.upSize * 2 + 4 + (this.strings.length - 1) * (this.getFont().getHeight() + this.interlineheight));
        return this.height;
    }

    private Font getFont() {
        return this.isBold ? Theme.titleFont : (this.isItalic ? Theme.italicFont : Theme.font);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public void setItalic(boolean isItalic) {
        this.isItalic = isItalic;
    }

    public void paint(Graphics g) {
        g.setFont(this.getFont());
        if (this.image != null) {
            g.drawImage(this.image, this.x + Theme.upSize, this.y + this.height / 2, 6);
        }
        for (int c = 0; c < this.strings.length; ++c) {
            g.drawString(this.strings[c], this.x + 2 + Theme.upSize + (this.image != null ? Theme.upSize * 2 + this.image.getWidth() : 0), this.y + 2 + (this.image == null ? Theme.upSize : this.height / 2 - (this.getFont().getHeight() + this.interlineheight) * this.strings.length / 2) + c * (this.getFont().getHeight() + this.interlineheight), 20);
        }
    }
}

