/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.GroupChild;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.StringUtil;

public class GroupRmsRenderer {
    public GroupHeader getRmsGroupHeader(byte[] data) {
        int offset = DataUtil.get16(data, 0);
        GroupHeader groupHeader = new GroupHeader(StringUtil.byteArrayToString(data, 2, offset, true));
        int childsCount = DataUtil.get16(data, offset += 2);
        offset += 2;
        for (int c = 0; c < childsCount; ++c) {
            int i;
            int t_Int = DataUtil.get16(data, offset);
            GroupChild groupChild = new GroupChild(StringUtil.byteArrayToString(data, offset += 2, t_Int, true));
            offset += t_Int;
            t_Int = DataUtil.get16(data, offset);
            offset += 2;
            if (t_Int > 0) {
                groupChild.imageLeftIndex = new int[t_Int];
                for (i = 0; i < t_Int; ++i) {
                    groupChild.imageLeftIndex[i] = DataUtil.get16(data, offset);
                    offset += 2;
                }
            }
            t_Int = DataUtil.get16(data, offset);
            offset += 2;
            if (t_Int > 0) {
                groupChild.imageRightIndex = new int[t_Int];
                for (i = 0; i < t_Int; ++i) {
                    groupChild.imageRightIndex[i] = DataUtil.get16(data, offset);
                    offset += 2;
                }
            }
            groupHeader.addChild(groupChild);
        }
        return groupHeader;
    }

    public byte[] getRmsData(GroupHeader groupHeader) {
        byte[] titleData = StringUtil.stringToByteArray(groupHeader.title, true);
        byte[] data = new byte[4 + titleData.length];
        DataUtil.put16(data, 0, titleData.length);
        DataUtil.putArray(data, 2, titleData);
        DataUtil.put16(data, 2 + titleData.length, groupHeader.getChildsCount());
        for (int c = 0; c < groupHeader.getChildsCount(); ++c) {
            int i;
            GroupChild groupChild = (GroupChild)groupHeader.childs.elementAt(c);
            titleData = StringUtil.stringToByteArray(groupChild.title, true);
            byte[] itemData = new byte[(groupChild.imageLeftIndex == null ? 0 : groupChild.imageLeftIndex.length * 2) + (groupChild.imageRightIndex == null ? 0 : groupChild.imageRightIndex.length * 2) + 6 + titleData.length];
            DataUtil.put16(itemData, 0, titleData.length);
            DataUtil.putArray(itemData, 2, titleData);
            int offset = 2 + titleData.length;
            if (groupChild.imageLeftIndex == null) {
                DataUtil.put16(itemData, offset, 0);
                offset += 2;
            } else {
                DataUtil.put16(itemData, offset, groupChild.imageLeftIndex.length);
                offset += 2;
                for (i = 0; i < groupChild.imageLeftIndex.length; ++i) {
                    DataUtil.put16(itemData, offset, groupChild.imageLeftIndex[i]);
                    offset += 2;
                }
            }
            if (groupChild.imageRightIndex == null) {
                DataUtil.put16(itemData, offset, 0);
                offset += 2;
            } else {
                DataUtil.put16(itemData, offset, groupChild.imageRightIndex.length);
                offset += 2;
                for (i = 0; i < groupChild.imageRightIndex.length; ++i) {
                    DataUtil.put16(itemData, offset, groupChild.imageRightIndex[i]);
                    offset += 2;
                }
            }
            byte[] t_Byte = new byte[data.length + itemData.length];
            System.arraycopy(data, 0, t_Byte, 0, data.length);
            System.arraycopy(itemData, 0, t_Byte, data.length, itemData.length);
            data = t_Byte;
        }
        return data;
    }
}

