/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.PaneEvent;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Scroll;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.smiles.Smiles;
import com.tomclaw.utils.LogUtil;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Grid
extends Scroll {
    public Vector items = new Vector();
    public int itemWidth = 42;
    public int itemHeight = 42;
    public int focusedRow = 0;
    public int focusedColumn = 0;
    public boolean isShowGrid = false;
    private int startIndex = 0;
    private int finlIndex = 0;
    private int eqvYOffset = 0;
    private int xStart = 0;
    public int rows = 0;
    public int columns = 0;
    private int finlRow = 0;
    private int finlColumn = 0;
    private PaneObject paneObject;
    public Thread animationThread = null;
    public PaneObject actionObject;
    public PaneEvent actionPerformedEvent = null;
    public boolean isSelectedState = false;
    public static int backColor = 0xFFFFFF;
    public static int hrLine = 0xDDDDDD;

    public Grid(final Window window, boolean isAnimated) {
        this.repaintScrollWidth = Theme.scrollWidth;
        if (isAnimated && Smiles.smilesType == 0) {
            this.animationThread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(100L);
                                if (Screen.screen.activeWindow == null || !Screen.screen.activeWindow.equals(window) || Screen.screen.isSwitchMode || Screen.screen.isSlideMode || Screen.screen.activeWindow.soft.isLeftPressed || Screen.screen.activeWindow.soft.isRightPressed || Screen.screen.activeWindow.dialog != null || Grid.this.prevYDrag != -1) continue;
                                Screen.screen.repaint(1);
                            }
                        }
                        catch (Throwable ex) {
                            LogUtil.outMessage("Grid animation exception", true);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.animationThread.setPriority(1);
            this.animationThread.start();
        }
    }

    public void repaint(Graphics g) {
        this.repaint(g, 0, 0);
    }

    public void repaint(Graphics g, int paintX, int paintY) {
        if (g != null) {
            g.setFont(Theme.font);
            g.setColor(backColor);
            g.fillRect(paintX + this.x, paintY + this.y, this.width, this.height);
            g.setColor(hrLine);
        }
        this.columns = (this.width - Theme.scrollWidth) / this.itemWidth;
        this.rows = this.height / this.itemHeight;
        this.eqvYOffset = this.yOffset % this.itemHeight;
        this.xStart = (this.width - Theme.scrollWidth) % this.itemWidth;
        if (g != null && this.isShowGrid) {
            for (int pX = paintX + this.x + this.xStart / 2; pX < paintX + this.x + this.width - Theme.scrollWidth; pX += this.itemWidth) {
                g.drawLine(pX, paintY + this.y, pX, paintY + this.y + this.height);
            }
            for (int pY = paintY + this.y - this.eqvYOffset; pY < paintY + this.y + this.height + this.itemHeight; pY += this.itemHeight) {
                g.drawLine(paintX + this.xStart / 2, pY, paintX + this.width - Theme.scrollWidth - this.xStart / 2, pY);
            }
        }
        this.startIndex = this.yOffset / this.itemHeight * this.columns;
        this.finlIndex = this.startIndex + Math.min(this.columns * (this.rows + 2), this.items.size() - this.startIndex);
        for (int c = this.startIndex; c < this.finlIndex; ++c) {
            this.paneObject = (PaneObject)this.items.elementAt(c);
            this.paneObject.setLocation(paintX + this.x + this.xStart / 2 + c % this.columns * this.itemWidth, paintY + this.y - this.eqvYOffset + (c - this.startIndex) / this.columns * this.itemHeight);
            if (c % this.columns == this.focusedColumn && c / this.columns == this.focusedRow) {
                this.paneObject.setFocused(true);
            } else {
                this.paneObject.setFocused(false);
            }
            this.paneObject.setSize(this.itemWidth, this.itemHeight);
            if (g == null) continue;
            this.paneObject.repaint(g);
        }
        this.finlColumn = (this.finlIndex - 1) % this.columns;
        this.finlRow = (this.finlIndex - 1) / this.columns;
        this.totalHeight = ((this.items.size() - 1) / this.columns + 1) * this.itemHeight;
        super.repaint(g, paintX, paintY);
    }

    public void keyPressed(int keyCode) {
        if (Screen.getExtGameAct(keyCode) == 1) {
            --this.focusedRow;
        } else if (Screen.getExtGameAct(keyCode) == 6) {
            ++this.focusedRow;
        } else if (Screen.getExtGameAct(keyCode) == 2) {
            --this.focusedColumn;
        } else if (Screen.getExtGameAct(keyCode) == 5) {
            ++this.focusedColumn;
        } else {
            this.actionObject = !this.items.isEmpty() ? (PaneObject)this.items.elementAt(this.focusedColumn + this.columns * this.focusedRow) : null;
            if (Screen.getExtGameAct(keyCode) == 8 && this.actionPerformedEvent != null) {
                this.actionPerformedEvent.actionPerformed(this.actionObject);
            }
            if (this.actionObject != null) {
                this.actionObject.keyPressed(keyCode);
            }
        }
        this.checkFocus();
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void pointerPressed(int x, int y) {
        this.actionObject = null;
        if (this.items.isEmpty()) {
            return;
        }
        if (x < this.x || y < this.y || x > this.x + this.width || y > this.y + this.height) {
            return;
        }
        if (x > this.x + this.width - Theme.scrollWidth) {
            this.isScrollAction = true;
        } else {
            this.isScrollAction = false;
            if ((x - this.x) / this.itemWidth + this.columns * ((y + this.yOffset - this.y) / this.itemHeight) < this.items.size()) {
                this.actionObject = (PaneObject)this.items.elementAt((x - this.x) / this.itemWidth + this.columns * ((y + this.yOffset - this.y) / this.itemHeight));
                this.setFocusedRowColomn((y + this.yOffset - this.y) / this.itemHeight, (x - this.x) / this.itemWidth);
                if (this.isSelectedState && this.actionPerformedEvent != null) {
                    this.actionPerformedEvent.actionPerformed(this.actionObject);
                }
                if (this.actionObject != null) {
                    this.actionObject.pointerPressed(x, y);
                }
            }
            this.isSelectedState = true;
        }
    }

    public void pointerReleased(int x, int y) {
        this.prevYDrag = -1;
        if (this.items.isEmpty()) {
            return;
        }
        if (this.actionObject != null) {
            this.actionObject.pointerReleased(x, y);
            this.actionObject = null;
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.actionObject != null) {
            this.actionObject.pointerDragged(x, y);
            this.actionObject = null;
        }
        if (this.items.isEmpty() || this.totalHeight < this.height) {
            return false;
        }
        if (this.isScrollAction) {
            this.scrollStart = y - this.y - this.scrollHeight / 2;
            this.yOffset = this.scrollStart * this.totalHeight / this.height;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.totalHeight - this.height) {
                this.yOffset = this.totalHeight - this.height;
            } else {
                return true;
            }
            return false;
        }
        if (this.totalHeight > this.height) {
            if (this.prevYDrag == -1) {
                this.prevYDrag = this.yOffset + y;
                return true;
            }
            this.yOffset = this.prevYDrag - y;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.totalHeight - this.height) {
                this.yOffset = this.totalHeight - this.height;
            } else {
                return true;
            }
            return false;
        }
        return true;
    }

    public void addItem(PaneObject paneObject) {
        this.items.addElement(paneObject);
    }

    public void checkFocus() {
        if (this.focusedColumn >= this.columns) {
            this.focusedColumn = 0;
            ++this.focusedRow;
        }
        if (this.focusedColumn < 0) {
            this.focusedColumn = this.columns - 1;
            --this.focusedRow;
        }
        if (this.focusedRow >= this.finlRow) {
            this.focusedRow = this.finlRow;
            if (this.focusedColumn > this.finlColumn) {
                this.focusedColumn = this.finlColumn;
            }
        }
        if (this.focusedRow < 0) {
            this.focusedRow = 0;
        }
        if (this.focusedRow * this.itemHeight + this.itemHeight > this.yOffset + this.height) {
            this.yOffset = this.focusedRow * this.itemHeight + this.itemHeight - this.height;
        }
        if (this.focusedRow * this.itemHeight < this.yOffset) {
            this.yOffset = this.focusedRow * this.itemHeight;
        }
        if (this.yOffset < 0) {
            this.yOffset = 0;
        }
        if (this.yOffset > (this.items.size() / this.columns + 1) * this.itemHeight - this.height + 1) {
            this.yOffset = (this.items.size() / this.columns + 1) * this.itemHeight - this.height + 1 > 0 ? (this.items.size() / this.columns + 1) * this.itemHeight - this.height + 1 : 0;
        }
    }

    private void setFocusedRowColomn(int focusedRow, int focusedColumn) {
        if (focusedRow != this.focusedRow || focusedColumn != this.focusedColumn) {
            this.focusedRow = focusedRow;
            this.focusedColumn = focusedColumn;
            this.isSelectedState = false;
        }
    }
}

