/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.bb.BBResult;
import com.tomclaw.utils.bb.BBUtil;
import javax.microedition.lcdui.Graphics;

public class ChatItem
extends PaneObject {
    public String text = "";
    public Pane pane;
    public BBResult bbResult;
    public static int foreColor = 0x555555;
    public static int titleColor = 0x424142;
    public static int borderColor = 8095450;
    public static int actOuterLight = 12437503;
    public static int actInnerLight = 9214719;
    public int interlineheight = 2;
    private int imageOffset = 0;
    public String buddyId = null;
    public String buddyNick = null;
    public String itemDateTime = null;
    public int itemType = 0;
    public static final int TYPE_HYPERLINK_MSG = 0;
    public static final int TYPE_AUTH_REQ_MSG = 1;
    public static final int TYPE_AUTH_DENY_MSG = 2;
    public static final int TYPE_AUTH_OK_MSG = 3;
    public static final int TYPE_INFO_MSG = 4;
    public static final int TYPE_ERROR_MSG = 5;
    public static final int TYPE_FILE_TRANSFER = 6;
    public static final int TYPE_PLAIN_MSG = 7;
    public byte[] cookie = null;
    public byte dlvStatus = 0;
    public static final byte DLV_STATUS_NOT_SENT = 0;
    public static final byte DLV_STATUS_SENT = 1;
    public static final byte DLV_STATUS_DELIVERED = 2;
    public static final byte DLV_STATUS_INCOMING = 3;

    public ChatItem(Pane pane, String caption) {
        this.text = caption;
        this.pane = pane;
        this.updateCaption();
    }

    public ChatItem(Pane pane, String buddyId, String buddyNick, String itemDateTime, int itemType, String text) {
        this.pane = pane;
        this.buddyId = buddyId;
        this.buddyNick = buddyNick;
        this.itemDateTime = itemDateTime;
        this.itemType = itemType;
        this.text = text;
        this.updateCaption();
    }

    public void repaint(Graphics g) {
        if (this.isFocusable && this.isFocused && g != null) {
            g.setColor(actOuterLight);
            g.drawRect(this.x, this.y, this.width, this.height);
            g.setColor(actInnerLight);
            g.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        }
        if (g != null) {
            if (Settings.CHAT_IMAGE_GROUP_FILE != 0) {
                this.imageOffset = Splitter.drawImage(g, Settings.CHAT_IMAGE_GROUP_FILE, this.itemType == 7 ? this.itemType + this.dlvStatus : this.itemType, this.x + 2 + Theme.upSize, this.y + 2 + Theme.upSize, false) + Theme.upSize;
            }
            g.setColor(borderColor);
            g.drawLine(this.x + 2 + Theme.upSize + this.imageOffset, this.y + 2 + Theme.upSize + Math.max(Theme.titleFont.getHeight(), Theme.font.getHeight()), this.x + this.width - 2 - Theme.upSize, this.y + 2 + Theme.upSize + Math.max(Theme.titleFont.getHeight(), Theme.font.getHeight()));
            g.setFont(Theme.titleFont);
            g.setColor(titleColor);
            g.drawString(this.buddyNick, this.x + this.imageOffset + 2 + Theme.upSize, this.y + 2 + Theme.upSize, 20);
            g.setFont(Theme.font);
            g.drawString(this.itemDateTime, this.x + this.width - Theme.upSize - Theme.font.stringWidth(this.itemDateTime), this.y + 2 + Theme.upSize, 20);
            g.setColor(foreColor);
        }
        if (g != null) {
            for (int c = 0; c < this.bbResult.bbStyleString.length; ++c) {
                this.bbResult.bbStyleString[c].paint(g, this.x + 2 + Theme.upSize, this.y + (Theme.titleFont.getHeight() + Theme.upSize * 2) + 2 + Theme.upSize);
            }
        }
    }

    public void setLocation(int x, int y) {
        if (this.x != x || this.y != y || this.height == 0) {
            this.x = x;
            this.y = y;
            this.repaint(null);
        }
    }

    public void setSize(int width, int height) {
        if (this.width != width) {
            this.width = width;
            this.updateCaption();
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public final void setCaption(String text) {
        this.text = text;
        this.updateCaption();
    }

    public final void updateCaption() {
        if (this.width != 0) {
            try {
                this.bbResult = BBUtil.processText(this.text, 0, 0, this.width - (Theme.upSize + 4) * 2, foreColor);
                this.height = Theme.titleFont.getHeight() + Theme.upSize * 2 + 2 + Theme.upSize + this.bbResult.height + 2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getStringValue() {
        return this.text;
    }
}

