/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import javax.microedition.lcdui.Graphics;

public class Button
extends PaneObject {
    public String caption = "";
    public boolean isPressed = false;
    public static int unactForeColor = 0x424142;
    public static int unactForeShadowColor = 0xDEDFDE;
    public static int unactOnlTopBorder = 0xBDBABD;
    public static int unactBotBorder = 0xADAAAD;
    public static int unactInTopBorder = 0xE7E3E7;
    public static int unactInOnlBotBorder = 0xD6D3D6;
    public static int unactGradFrom = 0xD6D3D6;
    public static int unactGradTo = 0xADAEAD;
    public static int actForeColor = 0x424142;
    public static int actForeShadowColor = 0xDEDFDE;
    public static int actOnlTopBorder = 11907815;
    public static int actBotBorder = 10854094;
    public static int actInOnlBotBorder = 13025015;
    public static int actGradFrom = 14605303;
    public static int actGradMidd = 11905775;
    public static int actGradAftr = 10854127;
    public static int actGradFinl = 11380463;
    public static int actOuterLight = 12437503;
    public static int actInnerLight = 9214719;
    public static int prsdGradFrom = 11905775;
    public static int prsdGradFinl = 14605303;

    public Button(String caption) {
        this.caption = caption;
    }

    public void repaint(Graphics g) {
        if (this.isFocused) {
            g.setColor(actBotBorder);
            g.drawRect(this.x + 2, this.y + 2, this.width - 4, this.height - 4);
            g.setColor(actOnlTopBorder);
            g.drawLine(this.x + 2, this.y + 2, this.x + this.width - 2, this.y + 2);
            if (this.isPressed) {
                DrawUtil.fillVerticalGradient(g, this.x + 2, this.y + 2, this.width - 4 + 1, this.height - 4, prsdGradFrom, prsdGradFinl);
            } else {
                g.setColor(actInOnlBotBorder);
                g.drawLine(this.x + 3, this.y + this.height - 3, this.x + this.width - 3, this.y + this.height - 3);
                DrawUtil.fillSharpVerticalGradient(g, this.x + 3, this.y + 3, this.width - 6 + 1, this.height - 6, actGradFrom, actGradMidd, actGradAftr, actGradFinl, 70);
            }
            g.setColor(actOuterLight);
            g.drawRect(this.x, this.y, this.width, this.height);
            g.setColor(actInnerLight);
            g.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        } else {
            g.setColor(unactBotBorder);
            g.drawRect(this.x + 2, this.y + 2, this.width - 4, this.height - 4);
            g.setColor(unactOnlTopBorder);
            g.drawLine(this.x + 2, this.y + 2, this.x + this.width - 2, this.y + 2);
            g.setColor(unactInTopBorder);
            g.drawRect(this.x + 3, this.y + 3, this.width - 6, this.height - 6);
            g.setColor(unactInOnlBotBorder);
            g.drawLine(this.x + 3, this.y + this.height - 3, this.x + this.width - 3, this.y + this.height - 3);
            DrawUtil.fillVerticalGradient(g, this.x + 4, this.y + 4, this.width - 8 + 1, this.height - 8 + 1, unactGradFrom, unactGradTo);
        }
        g.setFont(Theme.font);
        g.setColor(this.isFocused ? actForeShadowColor : unactForeShadowColor);
        g.drawString(this.caption, this.x + (this.isPressed ? 1 : 0) + (this.width - Theme.font.stringWidth(this.caption)) / 2 + 1, this.y + this.height / 2 - Theme.font.getHeight() / 2 + 1, 20);
        g.setColor(this.isFocused ? actForeColor : unactForeColor);
        g.drawString(this.caption, this.x + (this.isPressed ? 1 : 0) + (this.width - Theme.font.stringWidth(this.caption)) / 2, this.y + this.height / 2 - Theme.font.getHeight() / 2, 20);
    }

    public void keyPressed(int keyCode) {
        if (Screen.getExtGameAct(keyCode) == 8) {
            this.isPressed = true;
        }
    }

    public void keyReleased(int keyCode) {
        if (Screen.getExtGameAct(keyCode) == 8 && this.isPressed) {
            this.actionPerformed();
            this.isPressed = false;
        }
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        this.isPressed = true;
    }

    public void pointerReleased(int x, int y) {
        if (this.isPressed) {
            this.actionPerformed();
        }
        this.isPressed = false;
    }

    public void pointerDragged(int x, int y) {
        this.isPressed = false;
    }

    public int getHeight() {
        this.height = Theme.font.getHeight() + Theme.upSize * 2 + 4;
        return this.height;
    }

    public String getStringValue() {
        return this.caption;
    }
}

