/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.TransactionItemFrame;
import com.tomclaw.mandarin.net.NetConnection;
import com.tomclaw.mandarin.xmpp.Bookmark;
import com.tomclaw.mandarin.xmpp.GroupChatUser;
import com.tomclaw.mandarin.xmpp.Identity;
import com.tomclaw.mandarin.xmpp.ServiceItem;
import com.tomclaw.mandarin.xmpp.XmlReader;
import com.tomclaw.mandarin.xmpp.XmlWriter;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppGroup;
import com.tomclaw.mandarin.xmpp.XmppIBBytestream;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.Base64;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class XmppSession {
    public XmppAccountRoot xmppAccountRoot;
    public NetConnection netConnection = new NetConnection();
    public XmlReader xmlReader;
    public XmlWriter xmlWriter;
    public int int_id;
    public Hashtable roster;
    private boolean isAlive = true;

    public XmppSession(XmppAccountRoot xmppAccountRoot) {
        this.xmppAccountRoot = xmppAccountRoot;
        this.roster = new Hashtable();
    }

    public void connect(int status) throws IOException, Throwable {
        Handler.setConnectionStage(this.xmppAccountRoot, 0);
        this.netConnection.connectAddress(this.xmppAccountRoot.host, Integer.parseInt(this.xmppAccountRoot.port));
        Handler.setConnectionStage(this.xmppAccountRoot, 2);
        this.xmlReader = new XmlReader(this.netConnection.inputStream);
        this.xmlWriter = new XmlWriter(this.netConnection.outputStream);
        Handler.setConnectionStage(this.xmppAccountRoot, 4);
        LogUtil.outMessage("host=" + this.xmppAccountRoot.host);
        LogUtil.outMessage("username=" + this.xmppAccountRoot.username);
        LogUtil.outMessage("password=" + this.xmppAccountRoot.getUserPassword());
        LogUtil.outMessage("resource=" + this.xmppAccountRoot.resource);
        if (this.xmppAccountRoot.isUseSsl) {
            String msg = "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' to='" + this.xmppAccountRoot.host + "' version='1.0'>";
            this.xmlWriter.writeDirect(msg.getBytes());
            do {
                this.xmlReader.nextTag();
            } while (this.xmlReader.tagType != 3 || !this.xmlReader.tagName.equals("stream:features"));
            Handler.setConnectionStage(this.xmppAccountRoot, 6);
            LogUtil.outMessage("SASL phase1");
            msg = "<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl' mechanism='PLAIN'>";
            byte[] auth_msg = (this.xmppAccountRoot.username + "@" + this.xmppAccountRoot.host + "\u0000" + this.xmppAccountRoot.username + "\u0000" + this.xmppAccountRoot.getUserPassword()).getBytes();
            msg = msg + Base64.encode(auth_msg, 0, auth_msg.length) + "</auth>";
            this.xmlWriter.writeDirect(msg.getBytes());
            this.xmlReader.nextTag();
            if (this.xmlReader.tagName.equals("success")) {
                while (this.xmlReader.tagType != 3 && this.xmlReader.tagType != 2 || !this.xmlReader.tagName.equals("success")) {
                    this.xmlReader.nextTag();
                }
            } else {
                LogUtil.outMessage("SASL failed");
                return;
            }
            LogUtil.outMessage("SASL phase2");
            Handler.setConnectionStage(this.xmppAccountRoot, 7);
            msg = "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' to='" + this.xmppAccountRoot.host + "' version='1.0'>";
            this.xmlWriter.writeDirect(msg.getBytes());
            this.xmlReader.nextTag();
            while (this.xmlReader.tagType != 3 || !this.xmlReader.tagName.equals("stream:features")) {
                this.xmlReader.nextTag();
            }
            LogUtil.outMessage("SASL done");
            msg = this.xmppAccountRoot.resource == null ? "<iq type='set' id='res_binding'><bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'/></iq>" : "<iq type='set' id='res_binding'><bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'><resource>" + this.xmppAccountRoot.resource + "</resource></bind></iq>";
            this.xmlWriter.writeDirect(msg.getBytes());
            this.xmlWriter.writeDirect("<iq type=\"set\" id=\"mir_17\"><session xmlns=\"urn:ietf:params:xml:ns:xmpp-session\" /></iq>".getBytes());
        } else {
            this.netConnection.write("<?xml version=\"1.0\"?>".getBytes());
            Handler.setConnectionStage(this.xmppAccountRoot, 6);
            this.xmlWriter.startTag("stream:stream");
            this.xmlWriter.attribute("from", this.xmppAccountRoot.userId.concat("/").concat(this.xmppAccountRoot.resource));
            this.xmlWriter.attribute("to", this.xmppAccountRoot.domain);
            this.xmlWriter.attribute("xmlns", "jabber:client");
            this.xmlWriter.attribute("xmlns:stream", "http://etherx.jabber.org/streams");
            this.xmlWriter.flush();
            Handler.setConnectionStage(this.xmppAccountRoot, 7);
            this.xmlWriter.startTag("iq");
            this.xmlWriter.attribute("type", "set");
            this.xmlWriter.attribute("id", "auth");
            this.xmlWriter.startTag("query");
            this.xmlWriter.attribute("xmlns", "jabber:iq:auth");
            this.xmlWriter.startTag("username");
            this.xmlWriter.text(this.xmppAccountRoot.username);
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("password");
            this.xmlWriter.text(this.xmppAccountRoot.getUserPassword());
            this.xmlWriter.endTag();
            this.xmlWriter.startTag("resource");
            this.xmlWriter.text(this.xmppAccountRoot.resource);
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
            this.xmlWriter.endTag();
            this.xmlWriter.flush();
        }
        Handler.setConnectionStage(this.xmppAccountRoot, 8);
        XmppSender.sendRosterRequest(this);
        Handler.setConnectionStage(this.xmppAccountRoot, 9);
        XmppSender.setStatus(this.xmlWriter, this.xmppAccountRoot.userId.concat("/").concat(this.xmppAccountRoot.resource), XmppStatusUtil.statuses[status], "", 5);
        this.xmppAccountRoot.statusIndex = status;
        Handler.setConnectionStage(this.xmppAccountRoot, 10);
        this.isAlive = true;
        new Thread(){

            public void run() {
                try {
                    while (XmppSession.this.isAlive) {
                        XmppSession.this.netConnection.write(" ".getBytes());
                        1.sleep(20000L);
                    }
                }
                catch (Throwable ex) {
                    LogUtil.outMessage("XmppSession: " + ex.getMessage());
                }
            }
        }.start();
        new Thread(){

            public void run() {
                try {
                    XmppSession.this.parse();
                }
                catch (Throwable ex) {
                    LogUtil.outMessage("Throwable while XMPP parsing");
                    LogUtil.outMessage("XmppSession: " + ex.getMessage());
                    System.err.println(ex.getMessage());
                }
                LogUtil.outMessage("XMPP parsing completed");
                XmppSession.this.xmppAccountRoot.statusIndex = XmppStatusUtil.offlineIndex;
                Handler.disconnectEvent(XmppSession.this.xmppAccountRoot);
                if (XmppSession.this.isAlive) {
                    int prevStatus = XmppSession.this.xmppAccountRoot.getStatusIndex();
                    while (MidletMain.autoReconnect && XmppSession.this.xmppAccountRoot.statusIndex == XmppStatusUtil.offlineIndex) {
                        try {
                            XmppSession.this.xmppAccountRoot.xmppSession.disconnect();
                        }
                        catch (IOException ex1) {
                            // empty catch block
                        }
                        try {
                            2.sleep(MidletMain.reconnectTime);
                            XmppSession.this.connect(prevStatus);
                        }
                        catch (Throwable ex1) {
                            LogUtil.outMessage("XmppSession: " + ex1.getMessage());
                        }
                    }
                }
            }
        }.start();
    }

    public void parse() throws Throwable {
        while (this.xmlReader.nextTag()) {
            boolean isSelfClose;
            LogUtil.outMessage("Tag start");
            if (MidletMain.logLevel == 1) {
                LogUtil.outMessage("0x" + Integer.toString(this.xmlReader.tagType, 16) + ": '" + this.xmlReader.tagName + "' " + this.xmlReader.attributes.size());
                LogUtil.outMessage("[" + this.xmlReader.body + "]");
            }
            if (this.xmlReader.tagName == null) continue;
            boolean bl = isSelfClose = this.xmlReader.tagType == 2;
            if (this.xmlReader.tagName.equals("message")) {
                LogUtil.outMessage("Message tag");
                this.parseMessage(isSelfClose, this.xmlReader.getAttrValue("from", true), this.xmlReader.getAttrValue("to", true), this.xmlReader.getAttrValue("type", true));
                LogUtil.outMessage("Message tag closed");
            } else if (this.xmlReader.tagName.equals("presence")) {
                LogUtil.outMessage("Presence tag");
                this.parsePresence(isSelfClose, this.xmlReader.getAttrValue("from", true), this.xmlReader.getAttrValue("to", true), this.xmlReader.getAttrValue("type", false));
                LogUtil.outMessage("Presence tag closed");
            } else if (this.xmlReader.tagName.equals("iq")) {
                LogUtil.outMessage("Iq tag");
                this.parseIq(isSelfClose, this.xmlReader.getAttrValue("type", true));
                LogUtil.outMessage("Iq tag closed");
            }
            if (MidletMain.pack_count > MidletMain.pack_count_invoke_gc) {
                System.gc();
                MidletMain.pack_count = 0;
            }
            ++MidletMain.pack_count;
        }
    }

    public void disconnect() throws IOException {
        XmppSender.sendPresence(this.xmppAccountRoot.xmppSession.xmlWriter, null, null, "unavailable", null, null, 0, false, null, null);
        this.isAlive = false;
        this.netConnection.disconnect();
    }

    public void parsePresence(boolean isSelfClose, String from, String to, String type) throws IOException {
        try {
            String t_show = XmppStatusUtil.statuses[XmppStatusUtil.onlineIndex];
            String t_status = "";
            String t_priority = "";
            String t_id = this.xmlReader.getAttrValue("id", true);
            String errorText = "";
            int errorId = 0;
            String capsNode = null;
            String capsVer = null;
            while (!(isSelfClose || !this.xmlReader.nextTag() || this.xmlReader.tagName != null && this.xmlReader.tagName.equals("presence") && this.xmlReader.tagType == 3)) {
                if (this.xmlReader.tagName == null) continue;
                if (type.equals("error")) {
                    if (!this.xmlReader.tagName.equals("error")) continue;
                    String errorCode = this.xmlReader.getAttrValue("code", false);
                    String errorType = this.xmlReader.getAttrValue("type", false);
                    if (!errorType.equals("cancel") || !errorCode.equals("409") || !t_id.startsWith("groupchat_join_")) continue;
                    errorText = "NICK_IS_USED";
                    errorId = 1;
                    continue;
                }
                if (this.xmlReader.tagName.equals("show")) {
                    if (this.xmlReader.tagType == 0) continue;
                    if (this.xmlReader.tagType == 3) {
                        t_show = this.xmlReader.body;
                        continue;
                    }
                    if (this.xmlReader.tagType != 2) continue;
                    t_show = XmppStatusUtil.statuses[XmppStatusUtil.onlineIndex];
                    continue;
                }
                if (this.xmlReader.tagName.equals("status")) {
                    if (this.xmlReader.tagType == 0) continue;
                    if (this.xmlReader.tagType == 3) {
                        t_status = this.xmlReader.body;
                        continue;
                    }
                    if (this.xmlReader.tagType != 2) continue;
                    t_status = "";
                    continue;
                }
                if (this.xmlReader.tagName.equals("priority")) {
                    if (this.xmlReader.tagType == 0 || this.xmlReader.tagType != 3) continue;
                    t_priority = this.xmlReader.body;
                    continue;
                }
                if (!this.xmlReader.tagName.equals("c") || !this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/caps")) continue;
                capsNode = this.xmlReader.getAttrValue("node", true);
                capsVer = this.xmlReader.getAttrValue("ver", true);
            }
            LogUtil.outMessage("Presence from: " + from + " to " + to + " type = [" + type + "]: show = \"" + t_show + "\" status = \"" + t_status + "\" priority = \"" + t_priority + "\"");
            if (type.equals("unavailable")) {
                t_show = XmppStatusUtil.statuses[XmppStatusUtil.offlineIndex];
            }
            if (from == null) {
                return;
            }
            LogUtil.outMessage("Searching for... " + XmppSession.getClearJid(from));
            if (t_id != null && t_id.startsWith("groupchat_join_") && type.equals("error")) {
                Handler.setBookmarkError(this.xmppAccountRoot, t_id, errorText, errorId);
            } else if (!type.equals("error")) {
                if (MidletMain.bookmarksFrame != null) {
                    MidletMain.bookmarksFrame.setBookmarkStatus(this.xmppAccountRoot, XmppSession.getClearJid(from));
                }
                Handler.setXmppStatus(this.xmppAccountRoot, from, t_show, t_status, capsNode, capsVer);
            }
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("XmppSession: " + ex1.getMessage());
        }
    }

    public static String getClearJid(String fullJid) {
        if (fullJid != null && fullJid.indexOf("/") != -1) {
            return fullJid.substring(0, fullJid.indexOf("/"));
        }
        return fullJid;
    }

    public static String getJidResource(String fullJid) {
        if (fullJid != null && fullJid.indexOf("/") != -1) {
            return fullJid.substring(fullJid.indexOf("/") + 1);
        }
        return "";
    }

    public void parseMessage(boolean isSelfClose, String from, String to, String type) throws IOException {
        try {
            String t_id = this.xmlReader.getAttrValue("id", false);
            boolean isStoreData = false;
            XmppIBBytestream directConnection = null;
            String seq = "";
            while (!(isSelfClose || !this.xmlReader.nextTag() || this.xmlReader.tagName != null && this.xmlReader.tagName.equals("message") && this.xmlReader.tagType == 3)) {
                if (this.xmlReader.tagName == null) continue;
                if (type != null && (type.equals("chat") || type.equals("groupchat"))) {
                    if (this.xmlReader.tagName.equals("body") && this.xmlReader.tagType == 3) {
                        LogUtil.outMessage("Message or subject from " + from + ": " + this.xmlReader.body);
                        if (type.equals("chat")) {
                            Handler.recMess(this.xmppAccountRoot, XmppSession.getClearJid(from), XmppSession.getJidResource(from), null, this.xmlReader.body, t_id.getBytes(), 7);
                        } else if (type.equals("groupchat")) {
                            if (MidletMain.bookmarksFrame != null) {
                                MidletMain.bookmarksFrame.setBookmarkStatus(this.xmppAccountRoot, XmppSession.getClearJid(from));
                            }
                            String messageText = this.xmlReader.body;
                            String nick = XmppSession.getJidResource(from).length() == 0 ? Localization.getMessage("SYSTEM_MSG") : XmppSession.getJidResource(from);
                            Handler.recMess(this.xmppAccountRoot, XmppSession.getClearJid(from), "", nick, messageText, t_id.getBytes(), 7);
                        }
                    } else if (this.xmlReader.tagName.equals("subject") && this.xmlReader.tagType == 3) {
                        if (MidletMain.bookmarksFrame != null) {
                            MidletMain.bookmarksFrame.setBookmarkStatus(this.xmppAccountRoot, XmppSession.getClearJid(from));
                        }
                        LogUtil.outMessage("Subject to: " + from);
                        LogUtil.outMessage("Subject: " + this.xmlReader.body);
                        XmppItem xmppItem = (XmppItem)this.roster.get(XmppSession.getClearJid(from));
                        xmppItem.groupChatSubject = this.xmlReader.body;
                    }
                }
                if (!this.xmlReader.tagName.equals("data")) continue;
                if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/ibb")) {
                    String sid = this.xmlReader.getAttrValue("sid", false);
                    seq = this.xmlReader.getAttrValue("seq", false);
                    directConnection = (XmppIBBytestream)this.xmppAccountRoot.getTransactionManager().getTransaction(StringUtil.stringToByteArray(sid, true));
                    isStoreData = true;
                }
                if (this.xmlReader.tagType != 3 || directConnection == null) continue;
                directConnection.storeData(seq, Base64.decode(this.xmlReader.body));
                isStoreData = false;
            }
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("XmppSession: " + ex1.getMessage());
        }
    }

    public void parseIq(boolean isSelfClose, String type) throws IOException {
        try {
            String from = this.xmlReader.getAttrValue("from", true);
            final String id = this.xmlReader.getAttrValue("id", true);
            while (isSelfClose || this.xmlReader.nextTag() && (this.xmlReader.tagName == null || !this.xmlReader.tagName.equals("iq") || this.xmlReader.tagType != 3)) {
                if (this.xmlReader.tagName == null) continue;
                LogUtil.outMessage("TAG: ".concat(this.xmlReader.tagName));
                LogUtil.outMessage("type: ".concat(type));
                if (type != null && type.equals("result")) {
                    if (this.xmlReader.tagName.equals("query")) {
                        if (this.xmlReader.getAttrValue("xmlns", false).equals("jabber:iq:roster") && this.xmlReader.tagType == 0) {
                            LogUtil.outMessage("Roster parsing...");
                            String t_jid = "";
                            String t_name = "";
                            Vector<XmppGroup> groups = new Vector<XmppGroup>();
                            this.roster.clear();
                            Vector<XmppGroup> buddyItems = new Vector<XmppGroup>();
                            XmppGroup unclassified = new XmppGroup(Localization.getMessage("XMPP_UNCLASSIFIED"));
                            while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("query") || this.xmlReader.tagType != 3)) {
                                LogUtil.outMessage(this.xmlReader.tagName);
                                if (this.xmlReader.tagName.equals("item") && (this.xmlReader.tagType == 0 || this.xmlReader.tagType == 2)) {
                                    t_jid = this.xmlReader.getAttrValue("jid", false);
                                    t_name = this.xmlReader.getAttrValue("name", true);
                                    LogUtil.outMessage(t_jid + ": " + t_name);
                                }
                                if (this.xmlReader.tagName.equals("group") && this.xmlReader.tagType == 3) {
                                    boolean isExist = false;
                                    XmppGroup rosterItem = null;
                                    for (int c = 0; c < buddyItems.size(); ++c) {
                                        if (!((XmppGroup)buddyItems.elementAt((int)c)).userId.equals(this.localizeString(this.xmlReader.body))) continue;
                                        isExist = true;
                                        rosterItem = (XmppGroup)buddyItems.elementAt(c);
                                        break;
                                    }
                                    if (!isExist) {
                                        rosterItem = new XmppGroup(this.localizeString(this.xmlReader.body));
                                        buddyItems.addElement(rosterItem);
                                    }
                                    groups.addElement(rosterItem);
                                }
                                if (!this.xmlReader.tagName.equals("item") || this.xmlReader.tagType != 3 && this.xmlReader.tagType != 2) continue;
                                XmppItem rosterItem = new XmppItem(this.localizeString(t_jid), this.localizeString(t_name));
                                this.roster.put(t_jid, rosterItem);
                                if (groups.isEmpty()) {
                                    unclassified.addChild(rosterItem);
                                    LogUtil.outMessage("Not in group");
                                    continue;
                                }
                                for (int c = 0; c < groups.size(); ++c) {
                                    ((XmppGroup)groups.elementAt(c)).addChild(rosterItem);
                                    LogUtil.outMessage("Group: " + ((XmppGroup)groups.elementAt((int)c)).userId);
                                }
                                groups.removeAllElements();
                            }
                            if (unclassified.getChildsCount() > 0) {
                                buddyItems.addElement(unclassified);
                                LogUtil.outMessage("unclassified appended");
                            }
                            LogUtil.outMessage("Roster parsed.");
                            Handler.setBuddyList(this.xmppAccountRoot, buddyItems, null, 0, 0, new byte[0]);
                        } else if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/disco#items") && this.xmlReader.tagType == 0) {
                            Vector<ServiceItem> discoItems = new Vector<ServiceItem>();
                            if (!this.xmlReader.tagName.equals("query") || this.xmlReader.tagType != 2) {
                                while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("query") || this.xmlReader.tagType != 3)) {
                                    LogUtil.outMessage("Service: " + this.xmlReader.getAttrValue("jid", false));
                                    ServiceItem t_Service = new ServiceItem(this.xmlReader.getAttrValue("jid", false), this.xmlReader.getAttrValue("node", true), this.xmlReader.getAttrValue("name", true));
                                    discoItems.addElement(t_Service);
                                }
                            }
                            if (id.startsWith("srvfrm_items")) {
                                LogUtil.outMessage("Services list");
                                Handler.setServicesList(this.xmppAccountRoot, discoItems, id);
                            }
                        } else if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/disco#info") && this.xmlReader.tagType == 0) {
                            Vector<String> features = new Vector<String>();
                            Vector<Identity> identityes = new Vector<Identity>();
                            while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("query") || this.xmlReader.tagType != 3)) {
                                if (this.xmlReader.tagName.equals("identity")) {
                                    identityes.addElement(new Identity(this.xmlReader.getAttrValue("category", false), this.xmlReader.getAttrValue("type", false), this.xmlReader.getAttrValue("name", true)));
                                    continue;
                                }
                                if (!this.xmlReader.tagName.equals("feature")) continue;
                                features.addElement(this.xmlReader.getAttrValue("var", true));
                                LogUtil.outMessage("Feature: " + this.xmlReader.getAttrValue("var", true));
                            }
                            if (id.startsWith("srvfrm_host")) {
                                LogUtil.outMessage("Host info");
                                Handler.setHostInfo(this.xmppAccountRoot, id, identityes, features);
                            } else if (id.startsWith("srvfrm_info")) {
                                LogUtil.outMessage("Service info");
                                Handler.setServiceInfo(this.xmppAccountRoot, from, id, identityes, features);
                            }
                        } else if (this.xmlReader.getAttrValue("xmlns", false).equals("jabber:iq:private")) {
                            Vector<Bookmark> bookmarks = null;
                            LogUtil.outMessage("jabber:iq:private");
                            if (this.xmlReader.tagType != 2) {
                                while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("query") || this.xmlReader.tagType != 3)) {
                                    LogUtil.outMessage("TAG: ".concat(this.xmlReader.tagName));
                                    if (this.xmlReader.tagName.equals("storage") && this.xmlReader.getAttrValue("xmlns", false).equals("storage:bookmarks")) {
                                        bookmarks = new Vector<Bookmark>();
                                        continue;
                                    }
                                    if (bookmarks == null || !this.xmlReader.tagName.equals("conference")) continue;
                                    Bookmark bookmark = new Bookmark(this.xmlReader.getAttrValue("jid", false), this.xmlReader.getAttrValue("name", false), this.xmlReader.getAttrValue("minimize", true), this.xmlReader.getAttrValue("autojoin", true));
                                    if (this.xmlReader.tagType != 2) {
                                        while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("conference") || this.xmlReader.tagType != 3)) {
                                            if (this.xmlReader.tagName.equals("nick")) {
                                                bookmark.nick = this.xmlReader.body;
                                                continue;
                                            }
                                            if (!this.xmlReader.tagName.equals("password")) continue;
                                            bookmark.password = this.xmlReader.body;
                                        }
                                    }
                                    bookmarks.addElement(bookmark);
                                }
                            }
                            LogUtil.outMessage("id: " + id);
                            if (id.startsWith("bookmrksfrm_get")) {
                                LogUtil.outMessage("Host info");
                                Handler.setBookmarks(this.xmppAccountRoot, id, bookmarks);
                            } else if (id.startsWith("bookmrksfrm_set")) {
                                Handler.setBookmarks(this.xmppAccountRoot, id, null);
                            }
                        } else if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/muc#owner")) {
                            Vector<PaneObject> objects = new Vector<PaneObject>();
                            String FORM_TYPE = null;
                            boolean isFocused = true;
                            LogUtil.outMessage("http://jabber.org/protocol/muc#owner");
                            if (this.xmlReader.tagType != 2) {
                                while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("x") || this.xmlReader.tagType != 3)) {
                                    LogUtil.outMessage("TAG: ".concat(this.xmlReader.tagName));
                                    if (this.xmlReader.tagName.equals("title") && this.xmlReader.tagType == 3) {
                                        Label label = new Label(this.xmlReader.body);
                                        label.setTitle(true);
                                        objects.addElement(label);
                                        continue;
                                    }
                                    if (!this.xmlReader.tagName.equals("field")) continue;
                                    String fieldType = this.xmlReader.getAttrValue("type", false);
                                    String fieldVar = this.xmlReader.getAttrValue("var", false);
                                    String fieldLabel = this.xmlReader.getAttrValue("label", true);
                                    LogUtil.outMessage("fieldType = ".concat(fieldType));
                                    LogUtil.outMessage("fieldVar = ".concat(fieldVar));
                                    LogUtil.outMessage("fieldLabel = " + fieldLabel);
                                    Field field = null;
                                    Check check = null;
                                    RadioGroup radioGroup = null;
                                    String radioValue = null;
                                    if (fieldType.equals("text-single")) {
                                        if (fieldLabel != null) {
                                            objects.addElement(new Label(fieldLabel));
                                        }
                                        field = new Field("");
                                        field.setFocusable(true);
                                        field.setFocused(isFocused);
                                        isFocused = false;
                                        field.setName(fieldVar);
                                        field.setTitle(fieldLabel);
                                        objects.addElement(field);
                                    }
                                    if (fieldType.equals("text-private")) {
                                        if (fieldLabel != null) {
                                            objects.addElement(new Label(fieldLabel));
                                        }
                                        field = new Field("");
                                        field.setFocusable(true);
                                        field.setFocused(isFocused);
                                        isFocused = false;
                                        field.setName(fieldVar);
                                        field.setTitle(fieldLabel);
                                        field.constraints = 65536;
                                        objects.addElement(field);
                                    }
                                    if (fieldType.equals("boolean")) {
                                        check = new Check(fieldLabel, false);
                                        check.setFocusable(true);
                                        check.setFocused(isFocused);
                                        isFocused = false;
                                        check.setName(fieldVar);
                                        objects.addElement(check);
                                    }
                                    if (fieldType.equals("list-single")) {
                                        if (fieldLabel != null) {
                                            objects.addElement(new Label(fieldLabel));
                                        }
                                        radioGroup = new RadioGroup();
                                        radioGroup.setName(fieldVar);
                                        radioValue = null;
                                    }
                                    if (fieldType.equals("jid-multi")) {
                                        if (fieldLabel != null) {
                                            objects.addElement(new Label(fieldLabel));
                                        }
                                        field = new Field("");
                                        field.setFocusable(true);
                                        field.setFocused(isFocused);
                                        isFocused = false;
                                        field.setName(fieldVar);
                                        field.title = fieldLabel;
                                        objects.addElement(field);
                                    }
                                    if (this.xmlReader.tagType == 2) continue;
                                    while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("field") || this.xmlReader.tagType != 3)) {
                                        LogUtil.outMessage("SUBTAG: ".concat(this.xmlReader.tagName));
                                        if (fieldType.equals("hidden") && fieldVar.equals("FORM_TYPE") && this.xmlReader.tagName.equals("value") && this.xmlReader.tagType == 3) {
                                            FORM_TYPE = this.xmlReader.getBody();
                                        }
                                        if (fieldType.equals("text-single") && this.xmlReader.tagName.equals("value") && this.xmlReader.tagType == 3) {
                                            field.setText(this.xmlReader.getBody());
                                        }
                                        if (fieldType.equals("text-private") && this.xmlReader.tagName.equals("value") && this.xmlReader.tagType == 3) {
                                            field.setText(this.xmlReader.getBody());
                                        }
                                        if (fieldType.equals("boolean") && this.xmlReader.tagName.equals("value") && this.xmlReader.tagType == 3) {
                                            check.setState(this.xmlReader.getBody().equals("1") || this.xmlReader.getBody().equals("true"));
                                        }
                                        if (!fieldType.equals("list-single")) continue;
                                        if (this.xmlReader.tagName.equals("option")) {
                                            Radio radio = new Radio(this.xmlReader.getAttrValue("label", false), false);
                                            radio.setFocusable(true);
                                            radio.setFocused(isFocused);
                                            isFocused = false;
                                            while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("option") || this.xmlReader.tagType != 3 && this.xmlReader.tagType != 2)) {
                                                if (!this.xmlReader.tagName.equals("value") || this.xmlReader.tagType != 3) continue;
                                                radio.setName(this.xmlReader.getBody());
                                            }
                                            objects.addElement(radio);
                                            radioGroup.addRadio(radio);
                                            if (radioValue != null && radio.getName().equals(radioValue)) {
                                                radioGroup.setCombed(radio);
                                            }
                                        }
                                        if (!this.xmlReader.tagName.equals("value") || this.xmlReader.tagType != 3) continue;
                                        radioValue = this.xmlReader.getBody();
                                    }
                                }
                            }
                            LogUtil.outMessage("id: " + id);
                            if (id.startsWith("grconffrm_get")) {
                                LogUtil.outMessage("Settings info");
                                Handler.setGroupChatSettings(this.xmppAccountRoot, id, objects, FORM_TYPE);
                            } else if (id.startsWith("grconffrm_set")) {
                                LogUtil.outMessage("Settings info set");
                                Handler.setGroupChatResult(this.xmppAccountRoot, id);
                            }
                        } else if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/muc#admin")) {
                            LogUtil.outMessage("http://jabber.org/protocol/muc#admin");
                            Vector<GroupChatUser> items = new Vector<GroupChatUser>();
                            if (this.xmlReader.tagType != 2) {
                                while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("query") || this.xmlReader.tagType != 3)) {
                                    LogUtil.outMessage("TAG: ".concat(this.xmlReader.tagName));
                                    if (!this.xmlReader.tagName.equals("item")) continue;
                                    GroupChatUser groupChatUser = new GroupChatUser();
                                    groupChatUser.role = this.xmlReader.getAttrValue("role", false);
                                    groupChatUser.affiliation = this.xmlReader.getAttrValue("affiliation", false);
                                    groupChatUser.nick = this.xmlReader.getAttrValue("nick", false);
                                    groupChatUser.jid = this.xmlReader.getAttrValue("jid", false);
                                    groupChatUser.title = groupChatUser.jid.concat(groupChatUser.nick.length() > 0 ? " (".concat(groupChatUser.nick).concat(")") : "");
                                    if (this.xmlReader.tagType == 0) {
                                        while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("item") || this.xmlReader.tagType != 3)) {
                                            if (!this.xmlReader.tagName.equals("reason") || this.xmlReader.tagType != 3) continue;
                                            groupChatUser.reason = this.xmlReader.body;
                                        }
                                    }
                                    items.addElement(groupChatUser);
                                }
                            }
                            if (id.startsWith("grchus_frm_")) {
                                LogUtil.outMessage("Setting users list");
                                Handler.setGroupChatResult(this.xmppAccountRoot, id, items);
                            } else if (id.startsWith("afladd_frm_")) {
                                LogUtil.outMessage("Affiliation add result");
                                Handler.setAffiliationAddResult(this.xmppAccountRoot, id);
                            }
                        }
                    } else if (this.xmlReader.tagName.equals("si")) {
                        if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/si")) {
                            boolean isOk = false;
                            while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("feature") || this.xmlReader.tagType != 3)) {
                                if (!this.xmlReader.tagName.equals("feature") || this.xmlReader.tagType == 2 || !this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/feature-neg")) continue;
                                this.xmlReader.nextTag();
                                if (!this.xmlReader.getAttrValue("x", false).equals("jabber:x:data") || !this.xmlReader.getAttrValue("type", false).equals("submit")) continue;
                                while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("field") || this.xmlReader.tagType != 3)) {
                                    if (!this.xmlReader.tagName.equals("value") || this.xmlReader.tagType == 3 || !this.xmlReader.body.equals("http://jabber.org/protocol/ibb")) continue;
                                    isOk = true;
                                }
                            }
                            isOk = true;
                            if (true) {
                                LogUtil.outMessage("Receipment ".concat(from).concat(" is ok to receive file for id ".concat(id)));
                                XmppIBBytestream xmppIBBytestream = (XmppIBBytestream)this.xmppAccountRoot.getTransactionManager().getTransaction(StringUtil.stringToByteArray(id, true));
                                if (xmppIBBytestream != null) {
                                    xmppIBBytestream.sendStreamOpen();
                                }
                            }
                        }
                    } else if (id.startsWith("transaction_")) {
                        LogUtil.outMessage("Searching for id in transaction");
                        final XmppIBBytestream xmppIBBytestream = (XmppIBBytestream)this.xmppAccountRoot.getTransactionManager().getTransaction(StringUtil.stringToByteArray(id.substring("transaction_".length()), true));
                        if (xmppIBBytestream != null) {
                            LogUtil.outMessage("Transaction fround");
                            new Thread(){

                                public void run() {
                                    LogUtil.outMessage("File receiving ack");
                                    xmppIBBytestream.startTransfer();
                                }
                            }.start();
                        }
                    } else if (id.startsWith("transactionabort_")) {
                        LogUtil.outMessage("Transaction abort received");
                    } else if (id.startsWith("transactioncomplete_")) {
                        LogUtil.outMessage("Transaction complete received");
                    }
                } else if (type != null && type.equals("error")) {
                    if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/disco#info")) {
                        if (id.startsWith("srvfrm_host")) {
                            LogUtil.outMessage("No host info");
                        } else if (id.startsWith("srvfrm_info")) {
                            LogUtil.outMessage("No service info");
                        }
                    } else if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/muc#admin")) {
                        if (id.startsWith("grchus_frm_")) {
                            LogUtil.outMessage("Permission denied");
                            MidletMain.groupChatUsersFrame.setError(this.xmppAccountRoot, id);
                        }
                    } else if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/muc#owner") && id.startsWith("grchus_frm_")) {
                        LogUtil.outMessage("Permission denied");
                        MidletMain.groupChatUsersFrame.setError(this.xmppAccountRoot, id);
                    }
                } else if (type != null && type.equals("get")) {
                    if (this.xmlReader.tagName.equals("query")) {
                        if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/disco#info")) {
                            XmppSender.sendDiscoInfo(this, from, id, this.xmlReader.getAttrValue("node", true));
                        } else if (this.xmlReader.getAttrValue("xmlns", false).equals("jabber:iq:last")) {
                            XmppSender.sendLast(this, from, id);
                        }
                    }
                    if (this.xmlReader.getAttrValue("xmlns", false).equals("jabber:iq:version") && type.equals("get") && this.xmlReader.tagType == 2) {
                        XmppSender.sendClientVersion(this, from, id);
                    }
                    if (this.xmlReader.tagName.equals("time") && this.xmlReader.getAttrValue("xmlns", false).equals("urn:xmpp:time")) {
                        XmppSender.sendTime(this, from, id);
                    }
                } else if (type != null && type.equals("set")) {
                    if (this.xmlReader.tagName.equals("si")) {
                        if (this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/si")) {
                            String sid = this.xmlReader.getAttrValue("id", false);
                            String mimeType = this.xmlReader.getAttrValue("mime-type", false);
                            String profile = this.xmlReader.getAttrValue("profile", false);
                            String name = "";
                            String size = "";
                            String desc = "";
                            boolean isOk = false;
                            boolean isFileBlock = false;
                            while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("feature") || this.xmlReader.tagType != 3)) {
                                if (this.xmlReader.tagName.equals("feature") && this.xmlReader.tagType != 2) {
                                    if (!this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/feature-neg")) continue;
                                    this.xmlReader.nextTag();
                                    if (!this.xmlReader.getAttrValue("x", false).equals("jabber:x:data") || !this.xmlReader.getAttrValue("type", false).equals("submit")) continue;
                                    while (this.xmlReader.nextTag() && (!this.xmlReader.tagName.equals("field") || this.xmlReader.tagType != 3)) {
                                        if (!this.xmlReader.tagName.equals("value") || this.xmlReader.tagType == 3 || !this.xmlReader.body.equals("http://jabber.org/protocol/ibb")) continue;
                                        isOk = true;
                                    }
                                    continue;
                                }
                                if (this.xmlReader.tagName.equals("file")) {
                                    if (this.xmlReader.tagType == 3) {
                                        isFileBlock = false;
                                    }
                                    if (!this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/si/profile/file-transfer")) continue;
                                    name = this.xmlReader.getAttrValue("name", false);
                                    size = this.xmlReader.getAttrValue("size", false);
                                    isFileBlock = this.xmlReader.tagType == 0;
                                    continue;
                                }
                                if (!this.xmlReader.tagName.equals("desc") || this.xmlReader.tagType != 3) continue;
                                desc = this.xmlReader.body;
                            }
                            isOk = true;
                            if (true) {
                                LogUtil.outMessage("Receiving file from ".concat(from).concat(" name: ".concat(name).concat(" size: ").concat(size).concat(" desc: ").concat(desc)));
                                final XmppIBBytestream directConnection = (XmppIBBytestream)this.xmppAccountRoot.getDirectConnectionInstance();
                                directConnection.setIsReceivingFile(false);
                                directConnection.setTransactionInfo(StringUtil.stringToByteArray(name, true), MidletMain.incomingFilesFolder, Long.parseLong(size), from);
                                directConnection.generateCookie();
                                directConnection.icbmCookie = StringUtil.stringToByteArray(sid, true);
                                this.xmppAccountRoot.getTransactionManager().addTransaction(directConnection);
                                new Thread(){

                                    public void run() {
                                        try {
                                            LogUtil.outMessage("Sending file receive");
                                            directConnection.receiveFile(id);
                                        }
                                        catch (IOException ex) {
                                            LogUtil.outMessage("IOException: " + ex.getMessage(), true);
                                        }
                                    }
                                }.start();
                                this.xmppAccountRoot.getTransactionsFrame().transactionItemFrame = new TransactionItemFrame(directConnection);
                                this.xmppAccountRoot.getTransactionsFrame().transactionItemFrame.s_prevWindow = this.xmppAccountRoot.getTransactionsFrame();
                            }
                        }
                    } else if (this.xmlReader.tagName.equals("open") && this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/ibb")) {
                        LogUtil.outMessage("Sending file ack");
                        String sid = this.xmlReader.getAttrValue("sid", false);
                        String blockSize = this.xmlReader.getAttrValue("block-size", false);
                        String stanza = this.xmlReader.getAttrValue("stanza", false);
                        XmppIBBytestream directConnection = (XmppIBBytestream)this.xmppAccountRoot.getTransactionManager().getTransaction(StringUtil.stringToByteArray(sid, true));
                        directConnection.setParamsAndAck(blockSize, id);
                    } else if (this.xmlReader.tagName.equals("close") && this.xmlReader.getAttrValue("xmlns", false).equals("http://jabber.org/protocol/ibb")) {
                        LogUtil.outMessage("Received file finish");
                        String sid = this.xmlReader.getAttrValue("sid", false);
                        XmppIBBytestream directConnection = (XmppIBBytestream)this.xmppAccountRoot.getTransactionManager().getTransaction(StringUtil.stringToByteArray(sid, true));
                        directConnection.closeFileAndAck(id);
                    }
                }
                if (!isSelfClose) continue;
                break;
            }
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("XmppSession: " + ex1.getMessage());
        }
    }

    public String localizeString(String string) {
        if (string == null) {
            return null;
        }
        return string;
    }

    public String getId() {
        ++this.int_id;
        return String.valueOf(this.int_id);
    }
}

