/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.Bookmark;
import com.tomclaw.mandarin.xmpp.XmlWriter;
import com.tomclaw.mandarin.xmpp.XmppSession;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.utils.Base64;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.TimeUtil;
import java.io.IOException;
import java.util.Vector;

public class XmppSender {
    public static void setStatus(XmlWriter xmlWriter, String from, String statusId, String status, int priority) throws IOException {
        if (statusId.equals("invisible")) {
            XmppSender.sendPresence(xmlWriter, from, null, "invisible", null, null, priority, false, null, null);
        } else {
            XmppSender.sendPresence(xmlWriter, from, null, null, statusId, status, priority, false, null, null);
        }
    }

    public static void joinConfrence(XmppSession xmppSession, String id, String jid, String nick, String password) throws IOException {
        XmppSender.sendPresence(xmppSession.xmlWriter, null, jid.concat("/").concat(nick), null, XmppStatusUtil.statuses[xmppSession.xmppAccountRoot.getStatusIndex()], "", 5, true, id, password);
    }

    public static void sendPresence(XmlWriter xmlWriter, String from, String to, String type, String statusId, String status, int priority, boolean isConference, String id, String password) throws IOException {
        xmlWriter.startTag("presence");
        if (from != null && !isConference) {
            xmlWriter.attribute("from", from);
        }
        if (type != null && !isConference) {
            xmlWriter.attribute("type", type);
        }
        if (to != null) {
            xmlWriter.attribute("to", to);
        }
        if (isConference) {
            xmlWriter.attribute("xml:lang", "ru");
            xmlWriter.attribute("xmlns", "jabber:client");
            xmlWriter.attribute("id", id);
        }
        if (statusId != null) {
            xmlWriter.startTag("show");
            xmlWriter.text(statusId);
            xmlWriter.endTag();
        }
        if (status != null) {
            xmlWriter.startTag("status");
            xmlWriter.text(status);
            xmlWriter.endTag();
        }
        if (priority != 0) {
            xmlWriter.startTag("priority");
            xmlWriter.text(Integer.toString(priority));
            xmlWriter.endTag();
        }
        if (isConference) {
            xmlWriter.startTag("x");
            xmlWriter.attribute("xmlns", "http://jabber.org/protocol/muc");
            if (password != null) {
                xmlWriter.startTag("password");
                xmlWriter.text(password);
                xmlWriter.endTag();
            }
            xmlWriter.endTag();
        }
        String version = MidletMain.version + " " + MidletMain.type + "-build " + MidletMain.build;
        xmlWriter.startTag("c");
        xmlWriter.attribute("xmlns", "http://jabber.org/protocol/caps");
        xmlWriter.attribute("node", "http://tomclaw.com/mandarin_im/caps");
        xmlWriter.attribute("ver", version);
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.flush();
    }

    public static void sendRosterRequest(XmppSession xmppSession) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("from", xmppSession.xmppAccountRoot.userId.concat("/").concat(xmppSession.xmppAccountRoot.resource));
        xmppSession.xmlWriter.attribute("type", "get");
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "jabber:iq:roster");
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static String sendMessage(XmppSession xmppSession, String to, String body, String type, boolean isSubject) {
        String id = xmppSession.getId();
        try {
            LogUtil.outMessage("Message start");
            xmppSession.xmlWriter.startTag("message");
            if (isSubject) {
                xmppSession.xmlWriter.attribute("xmlns", "jabber:client");
                xmppSession.xmlWriter.attribute("id", id);
            }
            xmppSession.xmlWriter.attribute("type", type);
            xmppSession.xmlWriter.attribute("to", to);
            xmppSession.xmlWriter.startTag(isSubject ? "subject" : "body");
            LogUtil.outMessage("Coding body");
            xmppSession.xmlWriter.text(body);
            LogUtil.outMessage("Body coded");
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
            LogUtil.outMessage("Message sent");
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
        return id;
    }

    public static void queryingForInformation(XmppSession xmppSession, String to, String id) {
        try {
            LogUtil.outMessage(xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.startTag("iq");
            xmppSession.xmlWriter.attribute("type", "get");
            xmppSession.xmlWriter.attribute("from", xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.attribute("to", to);
            if (id != null) {
                xmppSession.xmlWriter.attribute("id", id);
            }
            xmppSession.xmlWriter.startTag("query");
            xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/disco#info");
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
    }

    public static void requesingAllItems(XmppSession xmppSession, String to, String node, String id) {
        try {
            LogUtil.outMessage(xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.startTag("iq");
            xmppSession.xmlWriter.attribute("type", "get");
            xmppSession.xmlWriter.attribute("from", xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.attribute("to", to);
            if (id != null) {
                xmppSession.xmlWriter.attribute("id", id);
            }
            xmppSession.xmlWriter.startTag("query");
            xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/disco#items");
            if (node != null) {
                xmppSession.xmlWriter.attribute("node", node);
            }
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
    }

    public static void requesBookmarks(XmppSession xmppSession, String id) {
        try {
            LogUtil.outMessage(xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.startTag("iq");
            xmppSession.xmlWriter.attribute("xmlns", "jabber:client");
            xmppSession.xmlWriter.attribute("type", "get");
            if (id != null) {
                xmppSession.xmlWriter.attribute("id", id);
            }
            xmppSession.xmlWriter.startTag("query");
            xmppSession.xmlWriter.attribute("xmlns", "jabber:iq:private");
            xmppSession.xmlWriter.startTag("storage");
            xmppSession.xmlWriter.attribute("xmlns", "storage:bookmarks");
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
    }

    public static void exitConfrence(XmppSession xmppSession, String jid, String nick) {
        try {
            LogUtil.outMessage(xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.startTag("presence");
            xmppSession.xmlWriter.attribute("to", jid.concat("/").concat(nick));
            xmppSession.xmlWriter.attribute("type", "unavailable");
            xmppSession.xmlWriter.startTag("status");
            xmppSession.xmlWriter.text("Mandarin IM was here");
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
    }

    public static void sendBookmarks(XmppSession xmppSession, String id, Vector items) {
        try {
            LogUtil.outMessage(xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
            xmppSession.xmlWriter.startTag("iq");
            xmppSession.xmlWriter.attribute("xmlns", "jabber:client");
            xmppSession.xmlWriter.attribute("type", "set");
            if (id != null) {
                xmppSession.xmlWriter.attribute("id", id);
            }
            xmppSession.xmlWriter.startTag("query");
            xmppSession.xmlWriter.attribute("xmlns", "jabber:iq:private");
            xmppSession.xmlWriter.startTag("storage");
            xmppSession.xmlWriter.attribute("xmlns", "storage:bookmarks");
            for (int c = 0; c < items.size(); ++c) {
                Bookmark bookmark = (Bookmark)items.elementAt(c);
                xmppSession.xmlWriter.startTag("conference");
                xmppSession.xmlWriter.attribute("jid", bookmark.jid);
                xmppSession.xmlWriter.attribute("name", bookmark.name);
                xmppSession.xmlWriter.attribute("minimize", bookmark.minimize ? "1" : "0");
                xmppSession.xmlWriter.attribute("autojoin", bookmark.autojoin ? "1" : "0");
                xmppSession.xmlWriter.startTag("nick");
                xmppSession.xmlWriter.text(bookmark.nick);
                xmppSession.xmlWriter.endTag();
                if (bookmark.password != null && bookmark.password.length() > 0) {
                    xmppSession.xmlWriter.startTag("password");
                    xmppSession.xmlWriter.text(bookmark.password);
                    xmppSession.xmlWriter.endTag();
                }
                xmppSession.xmlWriter.endTag();
            }
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
            LogUtil.outMessage("Bookmarks sent");
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
    }

    public static void sendClientVersion(XmppSession xmppSession, String jid, String id) {
        try {
            String version = MidletMain.version + " " + MidletMain.type + "-build " + MidletMain.build;
            String device = null;
            try {
                device = System.getProperty("microedition.platform") + " [" + System.getProperty("microedition.configuration") + "]";
            }
            catch (Throwable ex1) {
                // empty catch block
            }
            if (device == null) {
                device = "J2ME";
            }
            LogUtil.outMessage("version=".concat(version));
            LogUtil.outMessage("os=".concat(device));
            LogUtil.outMessage("sendClientVersion to ".concat(jid));
            xmppSession.xmlWriter.startTag("iq");
            xmppSession.xmlWriter.attribute("to", jid);
            xmppSession.xmlWriter.attribute("xml:lang", "ru");
            xmppSession.xmlWriter.attribute("id", id);
            xmppSession.xmlWriter.attribute("type", "result");
            xmppSession.xmlWriter.startTag("query");
            xmppSession.xmlWriter.attribute("xmlns", "jabber:iq:version");
            xmppSession.xmlWriter.startTag("name");
            xmppSession.xmlWriter.text("Mandarin IM");
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.startTag("version");
            xmppSession.xmlWriter.text(version);
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.startTag("os");
            xmppSession.xmlWriter.text(device);
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.flush();
            LogUtil.outMessage("Client info sent");
        }
        catch (Exception e) {
            LogUtil.outMessage("ERR: " + e.getMessage());
        }
    }

    public static void requestGroupChatSettings(XmppSession xmppSession, String groupChatJid, String id) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "get");
        xmppSession.xmlWriter.attribute("to", groupChatJid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/muc#owner");
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void sendGroupChatSettings(XmppSession xmppSession, String groupChatJid, Vector items, String FORM_TYPE, String id) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "set");
        xmppSession.xmlWriter.attribute("to", groupChatJid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/muc#owner");
        xmppSession.xmlWriter.startTag("x");
        xmppSession.xmlWriter.attribute("xmlns", "jabber:x:data");
        xmppSession.xmlWriter.attribute("type", "submit");
        if (FORM_TYPE != null) {
            xmppSession.xmlWriter.startTag("field");
            xmppSession.xmlWriter.attribute("var", "FORM_TYPE");
            xmppSession.xmlWriter.startTag("value");
            xmppSession.xmlWriter.text(FORM_TYPE);
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
        }
        for (int c = 0; c < items.size(); ++c) {
            PaneObject paneObject = (PaneObject)items.elementAt(c);
            if (paneObject.getName() == null) continue;
            if (paneObject instanceof Field) {
                xmppSession.xmlWriter.startTag("field");
                xmppSession.xmlWriter.attribute("var", paneObject.getName());
                xmppSession.xmlWriter.startTag("value");
                xmppSession.xmlWriter.text(((Field)paneObject).getText());
                xmppSession.xmlWriter.endTag();
                xmppSession.xmlWriter.endTag();
            }
            if (paneObject instanceof Check) {
                xmppSession.xmlWriter.startTag("field");
                xmppSession.xmlWriter.attribute("var", paneObject.getName());
                xmppSession.xmlWriter.startTag("value");
                xmppSession.xmlWriter.text(((Check)paneObject).getState() ? "1" : "0");
                xmppSession.xmlWriter.endTag();
                xmppSession.xmlWriter.endTag();
            }
            if (!(paneObject instanceof Radio) || !((Radio)paneObject).radioState) continue;
            xmppSession.xmlWriter.startTag("field");
            xmppSession.xmlWriter.attribute("var", ((Radio)paneObject).radioGroup.getName());
            xmppSession.xmlWriter.startTag("value");
            xmppSession.xmlWriter.text(((Radio)paneObject).getName());
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
        }
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void requestGroupChatLists(XmppSession xmppSession, String groupChatJid, String id, String itemType, String itemValue) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "get");
        xmppSession.xmlWriter.attribute("to", groupChatJid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/muc#admin");
        xmppSession.xmlWriter.startTag("item");
        xmppSession.xmlWriter.attribute(itemType, itemValue);
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void affiliationAddGroupChatLists(XmppSession xmppSession, String groupChatJid, String id, String itemJid, String itemAffl, String reason) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "set");
        xmppSession.xmlWriter.attribute("to", groupChatJid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/muc#admin");
        xmppSession.xmlWriter.startTag("item");
        xmppSession.xmlWriter.attribute("jid", itemJid);
        xmppSession.xmlWriter.attribute("affiliation", itemAffl);
        xmppSession.xmlWriter.startTag("reason");
        xmppSession.xmlWriter.text(reason);
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void ibbOpen(XmppSession xmppSession, String jid, String id, String sid, int blockSize, String stanza) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "set");
        xmppSession.xmlWriter.attribute("to", jid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("open");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/ibb");
        xmppSession.xmlWriter.attribute("sid", sid);
        xmppSession.xmlWriter.attribute("block-size", String.valueOf(blockSize));
        xmppSession.xmlWriter.attribute("stanza", stanza);
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void sendIBBFileBlockMessage(XmppSession xmppSession, String jid, String id, String sid, int seq, byte[] data, int offset, int length) throws IOException {
        xmppSession.xmlWriter.startTag("message");
        xmppSession.xmlWriter.attribute("to", jid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("data");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/ibb");
        xmppSession.xmlWriter.attribute("sid", sid);
        xmppSession.xmlWriter.attribute("seq", String.valueOf(seq));
        xmppSession.xmlWriter.text(Base64.encode(data, offset, length));
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.startTag("amp");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/amp");
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.startTag("rule");
        xmppSession.xmlWriter.attribute("condition", "deliver-at");
        xmppSession.xmlWriter.attribute("value", "stored");
        xmppSession.xmlWriter.attribute("action", "error");
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.startTag("rule");
        xmppSession.xmlWriter.attribute("condition", "match-resource");
        xmppSession.xmlWriter.attribute("value", "exact");
        xmppSession.xmlWriter.attribute("action", "error");
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void ibbClose(XmppSession xmppSession, String jid, String id, String sid) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "set");
        xmppSession.xmlWriter.attribute("to", jid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("close");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/ibb");
        xmppSession.xmlWriter.attribute("sid", sid);
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void sendDiscoInfo(XmppSession xmppSession, String jid, String id, String node) throws IOException {
        int c;
        String[] features = new String[]{"http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/caps", "http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer", "http://jabber.org/protocol/ibb", "http://jabber.org/protocol/muc", "jabber:iq:version", "jabber:x:data", "jabber:iq:time"};
        String platform = null;
        try {
            platform = System.getProperty("microedition.platform");
        }
        catch (Throwable ex1) {
            // empty catch block
        }
        if (platform == null) {
            platform = "J2ME";
        }
        String configuration = null;
        try {
            configuration = System.getProperty("microedition.configuration");
        }
        catch (Throwable ex1) {
            // empty catch block
        }
        if (configuration == null) {
            configuration = "J2ME";
        }
        String version = MidletMain.version + " " + MidletMain.type + "-build " + MidletMain.build;
        String[][] fields = new String[][]{{"FORM_TYPE", "os", "os_version", "software", "software_version"}, {"urn:xmpp:dataforms:softwareinfo", platform, configuration, "Mandarin IM", version}};
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "result");
        xmppSession.xmlWriter.attribute("to", jid);
        xmppSession.xmlWriter.attribute("from", xmppSession.xmppAccountRoot.username.concat("@").concat(xmppSession.xmppAccountRoot.domain).concat("/").concat(xmppSession.xmppAccountRoot.resource));
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "http://jabber.org/protocol/disco#info");
        if (node != null) {
            xmppSession.xmlWriter.attribute("node", node);
        }
        xmppSession.xmlWriter.startTag("identity");
        xmppSession.xmlWriter.attribute("category", "client");
        xmppSession.xmlWriter.attribute("type", "pc");
        xmppSession.xmlWriter.attribute("name", "Mandarin");
        xmppSession.xmlWriter.endTag();
        for (c = 0; c < features.length; ++c) {
            xmppSession.xmlWriter.startTag("feature");
            xmppSession.xmlWriter.attribute("var", features[c]);
            xmppSession.xmlWriter.endTag();
        }
        xmppSession.xmlWriter.startTag("x");
        xmppSession.xmlWriter.attribute("xmlns", "jabber:x:data");
        xmppSession.xmlWriter.attribute("type", "result");
        for (c = 0; c < fields[0].length; ++c) {
            xmppSession.xmlWriter.startTag("field");
            xmppSession.xmlWriter.attribute("var", fields[0][c]);
            if (fields[0][c].equals("FORM_TYPE")) {
                xmppSession.xmlWriter.attribute("type", "hidden");
            }
            xmppSession.xmlWriter.startTag("value");
            xmppSession.xmlWriter.text(fields[1][c]);
            xmppSession.xmlWriter.endTag();
            xmppSession.xmlWriter.endTag();
        }
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void sendTime(XmppSession xmppSession, String jid, String id) throws IOException {
        String utcTime = TimeUtil.getUtcTimeString(TimeUtil.getCurrentTime());
        String tzoTime = (TimeUtil.getGmtOffset() / 3600 > 0 ? "+" : "-").concat(TimeUtil.getGmtOffset() / 3600 >= 10 ? "" : "0").concat(String.valueOf(TimeUtil.getGmtOffset() / 3600)).concat(":00");
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "result");
        xmppSession.xmlWriter.attribute("xmlns", "jabber:client");
        xmppSession.xmlWriter.attribute("to", jid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("time");
        xmppSession.xmlWriter.attribute("xmlns", "urn:xmpp:time");
        xmppSession.xmlWriter.startTag("utc");
        xmppSession.xmlWriter.text(utcTime);
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.startTag("tzo");
        xmppSession.xmlWriter.text(tzoTime);
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }

    public static void sendLast(XmppSession xmppSession, String jid, String id) throws IOException {
        xmppSession.xmlWriter.startTag("iq");
        xmppSession.xmlWriter.attribute("type", "result");
        xmppSession.xmlWriter.attribute("xmlns", "jabber:client");
        xmppSession.xmlWriter.attribute("to", jid);
        xmppSession.xmlWriter.attribute("id", id);
        xmppSession.xmlWriter.startTag("query");
        xmppSession.xmlWriter.attribute("xmlns", "jabber:iq:last");
        xmppSession.xmlWriter.attribute("seconds", "1");
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.endTag();
        xmppSession.xmlWriter.flush();
    }
}

