/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.XmlWriter;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class XmppIBBytestream
implements DirectConnection {
    public String proxyIp = null;
    public byte[] proxyIpBytes = null;
    public int proxyPort = -1;
    public byte[] fileName = null;
    public long fileByteSize = -1L;
    public String buddyId;
    public byte[] icbmCookie = new byte[8];
    public boolean isReceivingFile = false;
    public boolean isComplete = false;
    public boolean isError = false;
    public String statusString = "NO_STATUS";
    public int percentValue = 0;
    public int speed = 0;
    public int blockSize = 4096;
    public String fileLocation = null;
    public boolean isStop = false;
    public XmppAccountRoot xmppAccountRoot = null;
    public OutputStream outputStream = null;
    public FileConnection fileConnection = null;
    public long startTime = 0L;
    public long fileRecvBytes = 0L;

    public XmppIBBytestream(XmppAccountRoot xmppAccountRoot) {
        this.xmppAccountRoot = xmppAccountRoot;
    }

    public String getBuddyId() {
        return this.buddyId;
    }

    public byte[] getFileName() {
        return this.fileName;
    }

    public long getFileByteSize() {
        return this.fileByteSize;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public int getPercentValue() {
        return this.percentValue;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void sendStop() throws IOException {
        XmppSender.ibbClose(this.xmppAccountRoot.xmppSession, this.buddyId, "tansactionabort_".concat(this.xmppAccountRoot.xmppSession.getId()), StringUtil.byteArrayToString(this.icbmCookie));
    }

    public boolean isErrorFlag() {
        return this.isError;
    }

    public boolean isReceivingFileFlag() {
        return this.isReceivingFile;
    }

    public boolean isCompleteFlag() {
        return this.isComplete;
    }

    public boolean isStopFlag() {
        return this.isStop;
    }

    public void setIsReceivingFile(boolean isReceivingFile) {
        this.isReceivingFile = isReceivingFile;
    }

    public boolean equals(DirectConnection directConnection) {
        return directConnection instanceof XmppIBBytestream && ArrayUtil.equals(((XmppIBBytestream)directConnection).icbmCookie, this.icbmCookie);
    }

    public byte[] getSessCookie() {
        return this.icbmCookie;
    }

    public void sendFile() throws IOException, InterruptedException {
        this.statusString = "SENDING_REQUEST";
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
        LogUtil.outMessage("Sending file thru XMPP");
        XmlWriter xmlWriter = this.xmppAccountRoot.xmppSession.xmlWriter;
        String sid = StringUtil.byteArrayToString(this.icbmCookie);
        String toJid = this.buddyId;
        String desc = "file:///".concat(this.fileLocation).concat(StringUtil.byteArrayToString(this.fileName, true));
        xmlWriter.startTag("iq");
        xmlWriter.attribute("type", "set");
        xmlWriter.attribute("to", toJid);
        xmlWriter.attribute("id", sid);
        xmlWriter.startTag("si");
        xmlWriter.attribute("xmlns", "http://jabber.org/protocol/si");
        xmlWriter.attribute("id", sid);
        xmlWriter.attribute("mime-type", "binary/octet-stream");
        xmlWriter.attribute("profile", "http://jabber.org/protocol/si/profile/file-transfer");
        xmlWriter.startTag("file");
        xmlWriter.attribute("xmlns", "http://jabber.org/protocol/si/profile/file-transfer");
        xmlWriter.attribute("name", StringUtil.byteArrayToString(this.fileName, true));
        xmlWriter.attribute("size", String.valueOf(this.fileByteSize));
        xmlWriter.startTag("desc");
        xmlWriter.text(desc);
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.startTag("feature");
        xmlWriter.attribute("xmlns", "http://jabber.org/protocol/feature-neg");
        xmlWriter.startTag("x");
        xmlWriter.attribute("xmlns", "jabber:x:data");
        xmlWriter.attribute("type", "form");
        xmlWriter.startTag("field");
        xmlWriter.attribute("var", "stream-method");
        xmlWriter.attribute("type", "list-single");
        xmlWriter.startTag("option");
        xmlWriter.startTag("value");
        xmlWriter.text("http://jabber.org/protocol/ibb");
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.flush();
        this.statusString = "ACK_WAITING";
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
    }

    public void setTransactionInfo(byte[] fileName, String fileLocation, long fileByteSize, String buddyId) {
        this.fileName = fileName;
        this.fileLocation = fileLocation;
        this.fileByteSize = fileByteSize;
        this.buddyId = buddyId;
    }

    public void generateCookie() {
        String fullTime = String.valueOf(System.currentTimeMillis() / 100L);
        this.icbmCookie = StringUtil.stringToByteArray(fullTime.substring(fullTime.length() - 8), true);
    }

    public void sendStreamOpen() {
        try {
            this.statusString = "STREAM_OPEN";
            LogUtil.outMessage("Opening inbound bytestream");
            XmppSender.ibbOpen(this.xmppAccountRoot.xmppSession, this.buddyId, "transaction_".concat(StringUtil.byteArrayToString(this.icbmCookie)), StringUtil.byteArrayToString(this.icbmCookie), this.blockSize, "message");
        }
        catch (IOException ex) {
            this.isError = true;
            this.statusString = "IO_EXCEPTION";
            this.isError = true;
        }
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
    }

    public void startTransfer() {
        LogUtil.outMessage("Starting transfer");
        String sid = StringUtil.byteArrayToString(this.icbmCookie);
        this.fileConnection = null;
        try {
            LogUtil.outMessage("Full file path: ".concat("file://" + this.fileLocation + StringUtil.byteArrayToString(this.fileName, true)));
            this.fileConnection = (FileConnection)Connector.open((String)("file://" + this.fileLocation + StringUtil.byteArrayToString(this.fileName, true)), (int)1);
            if (!this.fileConnection.exists()) {
                LogUtil.outMessage("File not exist", true);
                this.statusString = "FILE_NOT_EXIST";
                this.isError = true;
                Handler.updateTransactions(this.xmppAccountRoot);
                Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
                return;
            }
            InputStream inputStream = this.fileConnection.openInputStream();
            long fileSentBytes = 0L;
            byte[] buffer = new byte[this.blockSize];
            this.startTime = System.currentTimeMillis();
            int seq = 0;
            this.statusString = "TRANSFERING_FILE";
            Handler.updateTransactions(this.xmppAccountRoot);
            Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
            while (fileSentBytes < this.fileByteSize) {
                int bufferRead = inputStream.read(buffer);
                if (seq > 65535) {
                    seq = 0;
                }
                XmppSender.sendIBBFileBlockMessage(this.xmppAccountRoot.xmppSession, this.buddyId, this.xmppAccountRoot.xmppSession.getId(), sid, seq, buffer, 0, bufferRead);
                ++seq;
                MidletMain.incrementDataCount(bufferRead);
                this.percentValue = (int)((fileSentBytes += (long)bufferRead) * 100L / this.fileByteSize);
                if (System.currentTimeMillis() - this.startTime > 1000L) {
                    this.speed = (int)(8000L * fileSentBytes / (System.currentTimeMillis() - this.startTime)) / 1024;
                }
                Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
                if (!this.isStop) continue;
                inputStream.close();
                this.fileConnection.close();
                this.isError = true;
                this.statusString = "STOPPED";
                Handler.updateTransactions(this.xmppAccountRoot);
                Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
                return;
            }
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("Local file error: " + ex1.getMessage(), true);
            this.statusString = "LOCAL_ERROR";
            this.isError = true;
            Handler.updateTransactions(this.xmppAccountRoot);
            Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
            return;
        }
        LogUtil.outMessage("Transfering complete");
        this.statusString = "TRANSFERING_COMPLETE";
        this.isComplete = true;
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
        Handler.updateTransactions(this.xmppAccountRoot);
        try {
            XmppSender.ibbClose(this.xmppAccountRoot.xmppSession, this.buddyId, "tansactioncomplete_".concat(this.xmppAccountRoot.xmppSession.getId()), sid);
        }
        catch (IOException ex) {
            LogUtil.outMessage("Couldn't complete transaction by final packet");
            this.statusString = "IO_EXCEPTION";
            this.isError = true;
            Handler.updateTransactions(this.xmppAccountRoot);
            Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
        }
    }

    public void receiveFile(String id) throws IOException {
        this.statusString = "SENDING_PARAMS";
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
        this.isReceivingFile = true;
        XmlWriter xmlWriter = this.xmppAccountRoot.xmppSession.xmlWriter;
        xmlWriter.startTag("iq");
        xmlWriter.attribute("type", "result");
        xmlWriter.attribute("to", this.buddyId);
        xmlWriter.attribute("id", id);
        xmlWriter.startTag("si");
        xmlWriter.attribute("xmlns", "http://jabber.org/protocol/si");
        xmlWriter.startTag("feature");
        xmlWriter.attribute("xmlns", "http://jabber.org/protocol/feature-neg");
        xmlWriter.startTag("x");
        xmlWriter.attribute("xmlns", "jabber:x:data");
        xmlWriter.attribute("type", "submit");
        xmlWriter.startTag("field");
        xmlWriter.attribute("var", "stream-method");
        xmlWriter.startTag("value");
        xmlWriter.text("http://jabber.org/protocol/ibb");
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.endTag();
        xmlWriter.flush();
        this.statusString = "RECEIVE_READY";
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
    }

    public void setParamsAndAck(String blockSize, String id) throws IOException {
        this.blockSize = Integer.parseInt(blockSize);
        XmlWriter xmlWriter = this.xmppAccountRoot.xmppSession.xmlWriter;
        xmlWriter.startTag("iq");
        xmlWriter.attribute("type", "result");
        xmlWriter.attribute("to", this.buddyId);
        xmlWriter.attribute("id", id);
        xmlWriter.endTag();
        xmlWriter.flush();
        this.fileConnection = null;
        try {
            this.fileConnection = (FileConnection)Connector.open((String)("file://" + MidletMain.incomingFilesFolder + StringUtil.byteArrayToString(this.fileName, true)), (int)3);
            if (this.fileConnection.exists()) {
                this.fileConnection.delete();
            }
            this.fileConnection.create();
            this.outputStream = this.fileConnection.openOutputStream();
            this.startTime = System.currentTimeMillis();
            this.fileRecvBytes = 0L;
            this.statusString = "RECEIVE_READY";
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("Local file error: " + ex1.getMessage(), true);
            this.statusString = "LOCAL_ERROR";
            this.isError = true;
        }
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
    }

    public void storeData(String seq, byte[] decode) {
        try {
            this.fileRecvBytes += (long)decode.length;
            this.outputStream.write(decode);
            this.outputStream.flush();
            this.percentValue = (int)(this.fileRecvBytes * 100L / this.fileByteSize);
            if (System.currentTimeMillis() - this.startTime > 1000L) {
                this.speed = (int)(8000L * this.fileRecvBytes / (System.currentTimeMillis() - this.startTime)) / 1024;
            }
            Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
            if (this.isStop) {
                this.outputStream.close();
                this.fileConnection.close();
                this.isError = true;
                this.statusString = "STOPPED";
                Handler.updateTransactions(this.xmppAccountRoot);
            } else {
                this.statusString = "STORING_BLOCK";
            }
        }
        catch (IOException ex) {
            this.statusString = "LOCAL_ERROR";
            this.isError = true;
        }
        Handler.updateTransactions(this.xmppAccountRoot);
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
    }

    public void closeFileAndAck(String id) throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
        this.fileConnection.close();
        LogUtil.outMessage("Transfering complete");
        this.statusString = "TRANSFERING_COMPLETE";
        this.isComplete = true;
        Handler.updateTransactionInfo(this.xmppAccountRoot, this.icbmCookie);
        Handler.updateTransactions(this.xmppAccountRoot);
        XmlWriter xmlWriter = this.xmppAccountRoot.xmppSession.xmlWriter;
        xmlWriter.startTag("iq");
        xmlWriter.attribute("type", "result");
        xmlWriter.attribute("to", this.buddyId);
        xmlWriter.attribute("id", id);
        xmlWriter.endTag();
        xmlWriter.flush();
    }
}

