/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.XmppGroup;
import com.tomclaw.mandarin.xmpp.XmppIBBytestream;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.mandarin.xmpp.XmppSession;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.util.Vector;

public class XmppAccountRoot
extends AccountRoot {
    public String domain;
    public String username;
    public String resource;
    public int priority;
    public XmppSession xmppSession;
    public XmppGroup conferenceGroup = null;
    public XmppGroup tempGroup;

    public XmppAccountRoot(String userId) {
        super(userId);
    }

    public void construct() {
    }

    public void initSpecialData() {
        this.xmppSession = new XmppSession(this);
        this.username = this.userId.substring(0, this.userId.indexOf(64));
        this.domain = this.userId.substring(this.userId.indexOf(64) + 1);
        if (StringUtil.isNullOrEmpty(this.host)) {
            this.host = this.domain;
        }
        this.resource = "Mandarin IM ".concat(MidletMain.version).concat(" [").concat(MidletMain.build.concat("]"));
    }

    public void saveSpecialSettings() throws Throwable {
        MidletMain.accounts.addItem(this.userId, "resource", this.resource);
    }

    public String getAccType() {
        return "xmpp";
    }

    public void sendTypingStatus(String userId, boolean b) {
    }

    public byte[] sendMessage(BuddyItem buddyItem, String string, String resource) {
        String fullJid = buddyItem.getUserId();
        if (resource.length() > 0) {
            fullJid = fullJid + "/".concat(resource);
        }
        String type = ((XmppItem)buddyItem).isGroupChat && resource.length() == 0 ? "groupchat" : "chat";
        LogUtil.outMessage("fullJid: " + fullJid);
        LogUtil.outMessage("string: " + string);
        LogUtil.outMessage("type: " + type);
        return XmppSender.sendMessage(this.xmppSession, fullJid, string, type, false).getBytes();
    }

    public void updateMainFrameBuddyList() {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            LogUtil.outMessage(((GroupHeader)this.buddyItems.elementAt((int)c)).title);
            for (int i = 0; i < ((GroupHeader)this.buddyItems.elementAt(c)).getChildsCount(); ++i) {
                ((XmppItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(i)).updateUiData();
                LogUtil.outMessage("\t" + ((XmppItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(i)).getUserId());
            }
        }
        this.updateMainFrameUI();
    }

    public XmppItem getBuddyItem(String jid) {
        return (XmppItem)this.xmppSession.roster.get(XmppSession.getClearJid(jid));
    }

    public void removeBuddyItem(String jid) {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            for (int i = 0; i < ((GroupHeader)this.buddyItems.elementAt(c)).getChildsCount(); ++i) {
                XmppItem xmppItem = (XmppItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(i);
                if (!xmppItem.userId.equals(jid)) continue;
                this.unrMsgs -= xmppItem.getUnreadCount();
                ((GroupHeader)this.buddyItems.elementAt(c)).getChilds().removeElementAt(i);
            }
        }
    }

    public void addTempItem(XmppItem xmppItem) {
        if (this.tempGroup == null || !this.buddyItems.contains(this.tempGroup)) {
            this.tempGroup = new XmppGroup(Localization.getMessage("XMPP_TEMP_GROUP"));
            this.buddyItems.addElement(this.tempGroup);
        }
        this.tempGroup.addChild(xmppItem);
        this.xmppSession.roster.put(xmppItem.userId, xmppItem);
        this.updateMainFrameUI();
    }

    public String getStatusImages() {
        return "/res/groups/img_xmppstatus.png";
    }

    public void setTreeItems(Vector buddyList) {
        this.buddyItems = buddyList;
    }

    public void setPrivateItems(Vector privateList) {
    }

    public BuddyGroup getGroupInstance() {
        return new XmppGroup();
    }

    public BuddyItem getBuddyInstance() {
        return new XmppItem();
    }

    public Cookie addGroup(BuddyGroup buddyGroup) {
        return null;
    }

    public Cookie addBuddy(BuddyItem buddyItem, BuddyGroup buddyGroup) {
        return null;
    }

    public Cookie renameBuddy(String itemName, BuddyItem buddyItem, String phones) {
        return null;
    }

    public Cookie renameGroup(String text, BuddyGroup buddyGroup) {
        return null;
    }

    public void requestAuth(String text, BuddyItem buddyItem) {
    }

    public void acceptAuthorization(BuddyItem buddyItem) {
    }

    public void requestInfo(String userId, int reqSeqNum) {
    }

    public Cookie removeBuddy(BuddyItem buddyItem) {
        return null;
    }

    public Cookie removeGroup(BuddyGroup buddyGroup) {
        return null;
    }

    public DirectConnection getDirectConnectionInstance() {
        return new XmppIBBytestream(this);
    }

    public int getNextBuddyId() {
        return 0;
    }

    public int getNextGroupId() {
        return 0;
    }

    public void connectAction(final int statusIndex) {
        if (this.isConnecting || this.statusIndex != 0) {
            return;
        }
        new Thread(){

            public void run() {
                try {
                    do {
                        try {
                            XmppAccountRoot.this.xmppSession.connect(statusIndex);
                            XmppAccountRoot.this.statusIndex = statusIndex;
                            MidletMain.mainFrame.updateAccountsStatus();
                            XmppAccountRoot.this.isConnecting = false;
                            return;
                        }
                        catch (IOException ex) {
                            LogUtil.outMessage("IO Exception");
                            Handler.showError(Localization.getMessage("IO_EXCEPTION"));
                        }
                        catch (Throwable ex) {
                            LogUtil.outMessage("Throwable");
                            Handler.showError(Localization.getMessage("THROWABLE"));
                        }
                        1.sleep(MidletMain.reconnectTime);
                    } while (MidletMain.autoReconnect);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                XmppAccountRoot.this.isConnecting = false;
            }
        }.start();
    }

    public String getStatusDescr(int statusIndex) {
        return XmppStatusUtil.getStatusDescr(statusIndex);
    }
}

