/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.net;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.net.IncorrectAddressException;
import com.tomclaw.mandarin.net.SporedStream;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.SocketConnection;

public class NetConnection {
    private SocketConnection socket = null;
    public SporedStream outputStream = null;
    public InputStream inputStream = null;

    public void connectAddress(String host, int port) throws IOException {
        this.connectAddress(host, port, false);
    }

    public void connectAddress(String host, int port, boolean isUseSsl) throws IOException {
        this.socket = isUseSsl ? (SecureConnection)Connector.open((String)("ssl://" + host + ":" + port), (int)3) : (SocketConnection)Connector.open((String)("socket://" + host + ":" + port), (int)3);
        this.outputStream = new SporedStream(this.socket.openOutputStream());
        this.inputStream = this.socket.openInputStream();
        LogUtil.outMessage("Connected successfull");
    }

    public void connectAddress(String hostPort) throws IncorrectAddressException, IOException {
        int port;
        String host;
        int dividor = hostPort.lastIndexOf(58);
        if (dividor != -1) {
            host = hostPort.substring(0, dividor);
            try {
                port = Integer.parseInt(hostPort.substring(dividor + 1, hostPort.length()));
            }
            catch (NumberFormatException ex1) {
                throw new IncorrectAddressException();
            }
        } else {
            throw new IncorrectAddressException();
        }
        this.connectAddress(host, port);
    }

    public void disconnect() throws IOException {
        this.outputStream.close();
        this.inputStream.close();
        this.socket.close();
    }

    public void write(byte[] data) throws IOException {
        this.outputStream.write(data);
        MidletMain.incrementDataCount(data.length);
    }

    public void write(byte[] data, int from, int size) throws IOException {
        this.outputStream.write(data, from, size);
        MidletMain.incrementDataCount(data.length);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public byte[] read(int length) throws IOException, InterruptedException, InterruptedIOException, IndexOutOfBoundsException {
        int dataRead;
        byte[] data = new byte[length];
        int dataReadSum = 0;
        do {
            if ((dataRead = this.inputStream.read(data, dataReadSum, data.length - dataReadSum)) != -1) continue;
            throw new IOException();
        } while ((dataReadSum += dataRead) < data.length);
        MidletMain.incrementDataCount(length);
        return data;
    }

    public byte[] readTo(byte stopByte) throws IOException, InterruptedException, InterruptedIOException {
        ArrayUtil data = new ArrayUtil();
        byte[] b = new byte[1];
        do {
            this.inputStream.read(b, 0, 1);
            data.append(b);
        } while (b[0] != stopByte);
        MidletMain.incrementDataCount(data.byteString.length);
        return data.byteString;
    }

    public int getAvailable() throws IOException {
        return this.inputStream.available();
    }

    public static void httpPing(String url) throws IOException {
        HttpConnection c = (HttpConnection)Connector.open((String)url);
        c.openInputStream();
    }

    public static String retreiveData(String url) throws IOException {
        int read;
        String data = new String();
        HttpConnection httpConnection = (HttpConnection)Connector.open((String)url);
        InputStream is = httpConnection.openInputStream();
        byte[] buffer = new byte[128];
        while ((read = is.read(buffer)) != -1) {
            data = data + new String(buffer, 0, read);
        }
        return data;
    }
}

