/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.mmp;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import java.io.IOException;
import java.io.OutputStream;

public class Packet {
    ArrayUtil data = new ArrayUtil();
    long proto = 65558L;
    long seq = 0L;
    long msg = 0L;
    long dlen = 0L;
    long from = 0L;
    long fromport = 0L;
    byte[] reserved = new byte[16];

    public boolean parseHeader(byte[] header) {
        if (-559038737L != DataUtil.get32_reversed(header, 0, true)) {
            return false;
        }
        this.proto = DataUtil.get32_reversed(header, 4, true);
        this.seq = DataUtil.get32_reversed(header, 8, true);
        this.msg = DataUtil.get32_reversed(header, 12, true);
        this.dlen = DataUtil.get32_reversed(header, 16, true);
        this.from = DataUtil.get32_reversed(header, 20, true);
        this.fromport = DataUtil.get32_reversed(header, 24, true);
        this.reserved = DataUtil.getByteArray(header, 28, 16);
        return true;
    }

    public void send(OutputStream outputStream) throws IOException {
        byte[] header = new byte[44];
        this.dlen = this.data.byteString.length;
        DataUtil.put32_reversed(header, 0, -559038737L);
        DataUtil.put32_reversed(header, 4, this.proto);
        DataUtil.put32_reversed(header, 8, this.seq);
        DataUtil.put32_reversed(header, 12, this.msg);
        DataUtil.put32_reversed(header, 16, this.dlen);
        DataUtil.put32_reversed(header, 20, this.from);
        DataUtil.put32_reversed(header, 24, this.fromport);
        DataUtil.putArray_reversed(header, 28, this.reserved);
        outputStream.write(header);
        outputStream.write(this.data.byteString);
        outputStream.flush();
    }

    public void dumpPacketData() {
        if (MidletMain.logLevel == 1) {
            LogUtil.outMessage(">> proto = 0x".concat(Long.toString(this.proto, 16).concat("\n")));
            LogUtil.outMessage("   seq = ".concat(String.valueOf(this.seq)).concat("\n"));
            LogUtil.outMessage("   msg = 0x".concat(Long.toString(this.msg, 16)).concat("\n"));
            LogUtil.outMessage("   dlen = ".concat(String.valueOf(this.dlen)).concat("\n"));
            LogUtil.outMessage("   from = ".concat(String.valueOf(this.from)).concat("\n"));
            LogUtil.outMessage("   fromport = ".concat(String.valueOf(this.fromport)).concat("\n"));
            LogUtil.outMessage("   reserved = ".concat(HexUtil.bytesToString(this.reserved)).concat("\n"));
            LogUtil.outMessage("   data = ".concat(HexUtil.bytesToString(this.data.byteString)).concat("\n"));
        }
    }
}

