/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.IconsType;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.TransactionItemFrame;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;

public class TransactionsFrame
extends Window {
    private List list;
    private AccountRoot accountRoot;
    public TransactionItemFrame transactionItemFrame;

    public TransactionsFrame(final AccountRoot accountRoot) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("TRANSACTIONS_FRAME"));
        this.accountRoot = accountRoot;
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(TransactionsFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("MENU"));
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("SELECT")){

            public void actionPerformed() {
                if (((TransactionsFrame)TransactionsFrame.this).list.selectedIndex >= 0 && ((TransactionsFrame)TransactionsFrame.this).list.selectedIndex < ((TransactionsFrame)TransactionsFrame.this).list.items.size()) {
                    ((ListItem)((TransactionsFrame)TransactionsFrame.this).list.items.elementAt(((TransactionsFrame)TransactionsFrame.this).list.selectedIndex)).actionPerformed();
                }
            }
        });
        this.soft.rightSoft.addSubItem(new PopupItem(Localization.getMessage("REMOVE_COMPLETED")){

            public void actionPerformed() {
                accountRoot.getTransactionManager().removeCompleted();
            }
        });
        this.list = new List();
        this.updateTransactions();
        this.setGObject(this.list);
    }

    public final void updateTransactions() {
        this.list.items.removeAllElements();
        if (this.accountRoot.getTransactionManager().transactions.size() > 0) {
            for (int c = 0; c < this.accountRoot.getTransactionManager().transactions.size(); ++c) {
                final DirectConnection directConnection = (DirectConnection)this.accountRoot.getTransactionManager().transactions.elementAt(c);
                ListItem item = new ListItem(directConnection.getBuddyId() + " - " + StringUtil.byteArrayToString(directConnection.getFileName(), true)){

                    public void actionPerformed() {
                        LogUtil.outMessage("Transaction showed");
                        TransactionsFrame.this.transactionItemFrame = new TransactionItemFrame(directConnection);
                        TransactionsFrame.this.transactionItemFrame.s_prevWindow = TransactionsFrame.this;
                        MidletMain.screen.setActiveWindow(TransactionsFrame.this.transactionItemFrame);
                    }
                };
                item.imageFileHash = IconsType.HASH_FILES;
                item.imageIndex = directConnection.isErrorFlag() ? 4 : (directConnection.isReceivingFileFlag() ? 0 : 2) + (directConnection.isCompleteFlag() ? 1 : 0);
                this.list.addItem(item);
            }
        }
        MidletMain.screen.repaint();
    }
}

