/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.core.Queue;
import com.tomclaw.mandarin.core.QueueAction;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.util.Hashtable;

public class RenameItemFrame
extends Window {
    private Field itemNameField;
    private Field phoneNumberField;

    public RenameItemFrame(final AccountRoot accountRoot, final BuddyItem buddyItem) {
        super(MidletMain.screen);
        final boolean isPhone = buddyItem.isPhone();
        this.header = new Header(Localization.getMessage("RENAME_BUDDY"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(RenameItemFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("RENAME")){

            public void actionPerformed() {
                LogUtil.outMessage("Rename pressed");
                if (!StringUtil.isFill(RenameItemFrame.this.itemNameField.getText())) {
                    LogUtil.outMessage("Empty field");
                    Handler.showNotify(Localization.getMessage("EMPTY_FIELD"));
                } else {
                    try {
                        LogUtil.outMessage("Rename start");
                        Cookie cookie = accountRoot.renameBuddy(RenameItemFrame.this.itemNameField.getText(), buddyItem, isPhone ? RenameItemFrame.this.phoneNumberField.getText() : "");
                        LogUtil.outMessage("Request queued, cookie received");
                        QueueAction queueAction = new QueueAction(accountRoot, buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                this.buddyItem.setUserNick(RenameItemFrame.this.itemNameField.getText());
                                if (isPhone) {
                                    this.buddyItem.setUserPhone(RenameItemFrame.this.phoneNumberField.getText());
                                }
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                        LogUtil.outMessage("queueAction: " + queueAction.getCookie().cookieString);
                        LogUtil.outMessage("Switching window...");
                        MidletMain.screen.setActiveWindow(RenameItemFrame.this.s_prevWindow);
                    }
                    catch (Throwable ex) {
                        Handler.showError(Localization.getMessage("IO_EXCEPTION"));
                    }
                }
            }
        };
        Pane pane = new Pane(null, false);
        Label notifyLabel = new Label(Localization.getMessage("BUDDY_RENAME"));
        notifyLabel.setHeader(true);
        pane.addItem(notifyLabel);
        pane.addItem(new Label(Localization.getMessage("BUDDY_RENAME_INFO")));
        this.itemNameField = new Field(buddyItem.getUserNick());
        this.itemNameField.setFocusable(true);
        this.itemNameField.setFocused(true);
        this.itemNameField.title = Localization.getMessage("BUDDY_NICK");
        pane.addItem(this.itemNameField);
        if (isPhone) {
            pane.addItem(new Label(Localization.getMessage("PHONE_EDIT")));
            this.phoneNumberField = new Field(buddyItem.getUserPhone());
            this.phoneNumberField.setFocusable(true);
            this.phoneNumberField.title = Localization.getMessage("VALIDATED_CELLULAR_LABEL");
            pane.addItem(this.phoneNumberField);
        }
        this.setGObject(pane);
    }

    public RenameItemFrame(final AccountRoot accountRoot, final BuddyGroup buddyGroup) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("RENAME_GROUP"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(RenameItemFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("RENAME")){

            public void actionPerformed() {
                if (!StringUtil.isFill(RenameItemFrame.this.itemNameField.getText())) {
                    Handler.showNotify(Localization.getMessage("EMPTY_FIELD"));
                } else {
                    LogUtil.outMessage("Rename start");
                    Cookie cookie = accountRoot.renameGroup(RenameItemFrame.this.itemNameField.getText(), buddyGroup);
                    LogUtil.outMessage("Request queued, cookie received");
                    QueueAction queueAction = new QueueAction(accountRoot, buddyGroup, cookie){

                        public void actionPerformed(Hashtable params) {
                            LogUtil.outMessage("Action Performed");
                            this.buddyGroup.setUserId(RenameItemFrame.this.itemNameField.getText());
                            this.buddyGroup.updateUiData();
                            this.accountRoot.updateOfflineBuddylist();
                        }
                    };
                    LogUtil.outMessage("QueueAction created");
                    Queue.pushQueueAction(queueAction);
                    LogUtil.outMessage("queueAction: " + queueAction.getCookie().cookieString);
                    LogUtil.outMessage("Switching window...");
                    MidletMain.screen.setActiveWindow(RenameItemFrame.this.s_prevWindow);
                }
            }
        };
        Pane pane = new Pane(null, false);
        Label notifyLabel = new Label(Localization.getMessage("GROUP_RENAME"));
        notifyLabel.setHeader(true);
        pane.addItem(notifyLabel);
        pane.addItem(new Label(Localization.getMessage("GROUP_RENAME_INFO")));
        this.itemNameField = new Field(buddyGroup.getUserId() == null ? "" : buddyGroup.getUserId());
        this.itemNameField.setFocusable(true);
        this.itemNameField.setFocused(true);
        this.itemNameField.title = Localization.getMessage("GROUP_NAME");
        pane.addItem(this.itemNameField);
        this.setGObject(pane);
    }
}

