/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.bingear.BinGear;
import com.tomclaw.bingear.GroupNotFoundException;
import com.tomclaw.bingear.IncorrectValueException;
import com.tomclaw.images.Splitter;
import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.core.IconsType;
import com.tomclaw.mandarin.core.Queue;
import com.tomclaw.mandarin.core.QueueAction;
import com.tomclaw.mandarin.icq.CapUtil;
import com.tomclaw.mandarin.icq.ClientInfoFrame;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.IcqItem;
import com.tomclaw.mandarin.icq.IcqPacketSender;
import com.tomclaw.mandarin.icq.IcqStatusUtil;
import com.tomclaw.mandarin.icq.SetExtStatusFrame;
import com.tomclaw.mandarin.icq.StatusReaderFrame;
import com.tomclaw.mandarin.main.AboutFrame;
import com.tomclaw.mandarin.main.AccountEditorFrame;
import com.tomclaw.mandarin.main.AccountTab;
import com.tomclaw.mandarin.main.AddingBuddyFrame;
import com.tomclaw.mandarin.main.AddingGroupFrame;
import com.tomclaw.mandarin.main.AuthRequestFrame;
import com.tomclaw.mandarin.main.BuddyInfoFrame;
import com.tomclaw.mandarin.main.ChatTab;
import com.tomclaw.mandarin.main.DonateFrame;
import com.tomclaw.mandarin.main.FileBrowserFrame;
import com.tomclaw.mandarin.main.HistoryFrame;
import com.tomclaw.mandarin.main.LockFrame;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.main.NetTestFrame;
import com.tomclaw.mandarin.main.OpinionSendFrame;
import com.tomclaw.mandarin.main.PhotoPreparingFrame;
import com.tomclaw.mandarin.main.RenameItemFrame;
import com.tomclaw.mandarin.main.SetStatusTextFrame;
import com.tomclaw.mandarin.main.TrafficInfoFrame;
import com.tomclaw.mandarin.main.UniqueFrame;
import com.tomclaw.mandarin.main.UpdateCheckFrame;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.mmp.MmpPacketSender;
import com.tomclaw.mandarin.mmp.MmpSmsSendFrame;
import com.tomclaw.mandarin.mmp.MmpStatusUtil;
import com.tomclaw.mandarin.xmpp.BookmarksFrame;
import com.tomclaw.mandarin.xmpp.GroupChatConfFrame;
import com.tomclaw.mandarin.xmpp.GroupChatNickEditFrame;
import com.tomclaw.mandarin.xmpp.GroupChatUsersFrame;
import com.tomclaw.mandarin.xmpp.Resource;
import com.tomclaw.mandarin.xmpp.ServicesFrame;
import com.tomclaw.mandarin.xmpp.TopicEditFrame;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.Button;
import com.tomclaw.tcuilite.Group;
import com.tomclaw.tcuilite.GroupChild;
import com.tomclaw.tcuilite.GroupEvent;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.KeyEvent;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Tab;
import com.tomclaw.tcuilite.TabEvent;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.RecordUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class MainFrame
extends Window {
    public Soft icqSoft;
    public PopupItem icqBuddyRightPopupItem;
    public PopupItem icqGroupRightPopupItem;
    public Soft mmpSoft;
    public PopupItem mmpBuddyRightPopupItem;
    public PopupItem mmpPhoneRightPopupItem;
    public PopupItem mmpGroupRightPopupItem;
    public Soft xmppSoft;
    public PopupItem xmppBuddyRightPopupItem;
    public PopupItem xmppGroupRightPopupItem;
    public PopupItem xmppConfrRightPopupItem;
    public Group buddyList;
    public Tab accountTabs;
    public PopupItem accountPopupItem;
    public PopupItem settingsPopupItem;
    public PopupItem servicePopupItem;
    public PopupItem servicesPopupItem;
    public PopupItem donatePopupItem;
    public PopupItem infoPopupItem;
    public PopupItem lockPopupItem;
    public PopupItem minimizePopupItem;
    public PopupItem exitPopupItem;
    public Pane pane;
    public BuddyInfoFrame buddyInfoFrame;
    public StatusReaderFrame statusReaderFrame;

    public MainFrame(Screen screen) {
        super(screen);
        this.addKeyEvent(new KeyEvent(0, "KEY_CLIENTINFO", true){

            public void actionPerformed() {
                BuddyItem buddyItem;
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot instanceof IcqAccountRoot && (buddyItem = MainFrame.this.getSelectedBuddyItem()) != null && ((IcqItem)buddyItem).clientInfo != null) {
                    ClientInfoFrame clientInfoFrame = new ClientInfoFrame((IcqAccountRoot)accountRoot, (IcqItem)buddyItem);
                    clientInfoFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(clientInfoFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_BUDDYINFO", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    MainFrame.this.buddyInfoFrame = new BuddyInfoFrame(accountRoot, buddyItem);
                    MainFrame.this.buddyInfoFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(MainFrame.this.buddyInfoFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_DIALOG", true){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    ChatTab chatTab;
                    Resource resource = null;
                    String resourceTitle = "";
                    if (buddyItem instanceof XmppItem) {
                        if (((XmppItem)buddyItem).getUnreadCount() > 0) {
                            resource = ((XmppItem)buddyItem).getUnreadResource();
                            resourceTitle = resource.resource;
                        } else {
                            resource = ((XmppItem)buddyItem).getDefaultResource();
                            resourceTitle = resource.resource;
                        }
                    }
                    if ((chatTab = MidletMain.chatFrame.getChatTab(MainFrame.this.getActiveAccountRoot(), buddyItem.getUserId(), resourceTitle, true)) == null) {
                        chatTab = new ChatTab(MainFrame.this.getActiveAccountRoot(), buddyItem, resource, MainFrame.this.getActiveAccountRoot().getStatusImages().hashCode(), "/res/groups/img_chat.png".hashCode());
                        MidletMain.chatFrame.addChatTab(chatTab, true);
                    }
                }
                MidletMain.screen.setActiveWindow(MidletMain.chatFrame);
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_STATUSES", true){

            public void actionPerformed() {
                BuddyItem buddyItem;
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot instanceof IcqAccountRoot && (buddyItem = MainFrame.this.getSelectedBuddyItem()) != null) {
                    MainFrame.this.statusReaderFrame = new StatusReaderFrame((IcqAccountRoot)MainFrame.this.getActiveAccountRoot(), (IcqItem)buddyItem);
                    MainFrame.this.statusReaderFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(MainFrame.this.statusReaderFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_UNIQUE", true){

            public void actionPerformed() {
                BuddyItem buddyItem;
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot instanceof IcqAccountRoot && (buddyItem = MainFrame.this.getSelectedBuddyItem()) != null) {
                    try {
                        UniqueFrame uniqueFrame = new UniqueFrame(MainFrame.this.getActiveAccountRoot(), buddyItem);
                        uniqueFrame.s_prevWindow = MainFrame.this;
                        MidletMain.screen.setActiveWindow(uniqueFrame);
                    }
                    catch (Throwable ex) {
                        LogUtil.outMessage("Error loading UniqueFrame: " + ex.getMessage());
                    }
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_REMOVE", true){

            public void actionPerformed() {
                try {
                    AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                    BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                    if (buddyItem != null) {
                        Cookie cookie = accountRoot.removeBuddy(buddyItem);
                        QueueAction queueAction = new QueueAction(accountRoot, buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                Vector buddyItems = this.accountRoot.getBuddyItems();
                                if (buddyItems != null && !buddyItems.isEmpty()) {
                                    LogUtil.outMessage("BuddyItems present");
                                    for (int c = 0; c < buddyItems.size(); ++c) {
                                        GroupHeader groupHeader = (GroupHeader)buddyItems.elementAt(c);
                                        if (groupHeader == null || groupHeader.getChildsCount() == 0 || groupHeader.getChilds().indexOf(this.buddyItem) == -1) continue;
                                        groupHeader.getChilds().removeElement(this.buddyItem);
                                        LogUtil.outMessage("Removed.");
                                        break;
                                    }
                                    this.accountRoot.updateOfflineBuddylist();
                                    LogUtil.outMessage("Updated.");
                                }
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    } else {
                        BuddyGroup buddyGroup = MainFrame.this.getSelectedGroupItem();
                        if (buddyGroup != null) {
                            Cookie cookie = accountRoot.removeGroup(buddyGroup);
                            QueueAction queueAction = new QueueAction(accountRoot, buddyGroup, cookie){

                                public void actionPerformed(Hashtable params) {
                                    this.accountRoot.getBuddyItems().removeElement(this.buddyGroup);
                                    LogUtil.outMessage("Action Performed");
                                    this.accountRoot.updateOfflineBuddylist();
                                }
                            };
                            LogUtil.outMessage("QueueAction created");
                            Queue.pushQueueAction(queueAction);
                        }
                    }
                }
                catch (Throwable ex1) {
                    LogUtil.outMessage(ex1);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_SENDFILE", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    FileBrowserFrame fileBrowserFrame = new FileBrowserFrame(0, accountRoot, buddyItem.getUserId());
                    fileBrowserFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(fileBrowserFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_SENDPHOTO", true){

            public void actionPerformed() {
                if (System.getProperty("supports.video.capture").equals("true")) {
                    AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                    BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                    if (buddyItem != null) {
                        if (MidletMain.photoPreparingFrame == null) {
                            MidletMain.photoPreparingFrame = new PhotoPreparingFrame(accountRoot, buddyItem.getUserId());
                        } else {
                            MidletMain.photoPreparingFrame.accountRoot = accountRoot;
                            MidletMain.photoPreparingFrame.buddyId = buddyItem.getUserId();
                            MidletMain.photoPreparingFrame.createPlayer();
                        }
                        MidletMain.photoPreparingFrame.s_prevWindow = MainFrame.this;
                        MidletMain.screen.setActiveWindow(MidletMain.photoPreparingFrame);
                    }
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_HISTORY", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    HistoryFrame historyFrame = new HistoryFrame(accountRoot.getAccType(), buddyItem.getUserId());
                    historyFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(historyFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_RENAME", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    RenameItemFrame renameItemFrame = new RenameItemFrame(accountRoot, buddyItem);
                    renameItemFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(renameItemFrame);
                } else {
                    BuddyGroup buddyGroup = MainFrame.this.getSelectedGroupItem();
                    if (buddyGroup != null) {
                        RenameItemFrame renameItemFrame = new RenameItemFrame(accountRoot, buddyGroup);
                        renameItemFrame.s_prevWindow = MainFrame.this;
                        MidletMain.screen.setActiveWindow(renameItemFrame);
                    }
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_SOUNDS", true){

            public void actionPerformed() {
                MidletMain.isSound = !MidletMain.isSound;
                MidletMain.settingsFrame.soundEnabled.setState(MidletMain.isSound);
                try {
                    MidletMain.settings.setValue("Alarm", "soundEnabled", MidletMain.isSound ? "true" : "false");
                    MidletMain.saveRmsData(false, true, false);
                }
                catch (GroupNotFoundException ex) {
                }
                catch (IncorrectValueException incorrectValueException) {
                    // empty catch block
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_FILTERGROUPS", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot instanceof IcqAccountRoot) {
                    ((IcqAccountRoot)accountRoot).isShowGroups = !((IcqAccountRoot)accountRoot).isShowGroups;
                    MainFrame.this.buddyList.isShowGroups = ((IcqAccountRoot)accountRoot).isShowGroups;
                    ((IcqAccountRoot)accountRoot).saveAllSettings();
                } else if (accountRoot instanceof MmpAccountRoot) {
                    ((MmpAccountRoot)accountRoot).isShowGroups = !((MmpAccountRoot)accountRoot).isShowGroups;
                    MainFrame.this.buddyList.isShowGroups = ((MmpAccountRoot)accountRoot).isShowGroups;
                    ((MmpAccountRoot)accountRoot).saveAllSettings();
                } else if (accountRoot instanceof XmppAccountRoot) {
                    ((XmppAccountRoot)accountRoot).isShowGroups = !((XmppAccountRoot)accountRoot).isShowGroups;
                    MainFrame.this.buddyList.isShowGroups = ((XmppAccountRoot)accountRoot).isShowGroups;
                    ((XmppAccountRoot)accountRoot).saveAllSettings();
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_FILTEROFFLINE", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot instanceof IcqAccountRoot) {
                    ((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline = !((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline;
                    MainFrame.this.buddyList.maxWeight = ((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline ? 0 : -1;
                    ((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).saveAllSettings();
                } else if (accountRoot instanceof MmpAccountRoot) {
                    ((MmpAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline = !((MmpAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline;
                    MainFrame.this.buddyList.maxWeight = ((MmpAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline ? 0 : -1;
                    ((MmpAccountRoot)MainFrame.this.getActiveAccountRoot()).saveAllSettings();
                } else if (accountRoot instanceof XmppAccountRoot) {
                    ((XmppAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline = !((XmppAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline;
                    MainFrame.this.buddyList.maxWeight = ((XmppAccountRoot)MainFrame.this.getActiveAccountRoot()).isShowOffline ? 0 : -1;
                    ((XmppAccountRoot)MainFrame.this.getActiveAccountRoot()).saveAllSettings();
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_SERVMESSAGES", true){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot != null) {
                    MidletMain.serviceMessagesFrame.setItems(accountRoot.getServiceMessages());
                    MidletMain.screen.setActiveWindow(MidletMain.serviceMessagesFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_MINIMIZE", true){

            public void actionPerformed() {
                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent(null);
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_REQUESTAUTH", true){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    AuthRequestFrame authRequestFrame = new AuthRequestFrame(MainFrame.this.getActiveAccountRoot(), buddyItem);
                    authRequestFrame.s_prevWindow = MainFrame.this;
                    MidletMain.screen.setActiveWindow(authRequestFrame);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_ACCEPTAUTH", true){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    MainFrame.this.getActiveAccountRoot().acceptAuthorization(buddyItem);
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_DIALOGS", true){

            public void actionPerformed() {
                if (MainFrame.this.s_nextWindow != null) {
                    MidletMain.screen.setActiveWindow(MidletMain.chatFrame);
                    ChatTab chatTab = MidletMain.chatFrame.getSelectedChatTab();
                    if (chatTab != null) {
                        AccountRoot accountRoot;
                        String resource = null;
                        if (chatTab.resource != null) {
                            resource = chatTab.resource.resource;
                        }
                        if ((accountRoot = MainFrame.this.getActiveAccountRoot()) != null) {
                            accountRoot.setUnrMsgs(accountRoot.getUnrMsgs() - chatTab.buddyItem.getUnreadCount(resource));
                            MidletMain.mainFrame.updateAccountsStatus();
                        }
                        chatTab.buddyItem.setUnreadCount(0, resource);
                    }
                    MidletMain.chatFrame.chatTabs.tabEvent.stateChanged(MidletMain.chatFrame.chatTabs.selectedIndex, MidletMain.chatFrame.chatTabs.selectedIndex, MidletMain.chatFrame.chatTabs.items.size() - 1);
                    MidletMain.chatFrame.prepareGraphics();
                } else {
                    Handler.showNotify(Localization.getMessage("NO_DIALOGS_OPEN"));
                }
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_BUDDYLIST_TOP", true){

            public void actionPerformed() {
                MainFrame.this.buddyList.yOffset = 0;
                MainFrame.this.buddyList.selectedColumn = 0;
                MainFrame.this.buddyList.selectedRow = 0;
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_BUDDYLIST_BOTTOM", true){

            public void actionPerformed() {
                int maxOffset = MainFrame.this.buddyList.totalItemsCount * MainFrame.this.buddyList.itemHeight - MainFrame.this.buddyList.height;
                if (maxOffset < 0) {
                    maxOffset = 0;
                }
                MainFrame.this.buddyList.yOffset = maxOffset;
                MainFrame.this.buddyList.selectedColumn = 0;
                MainFrame.this.buddyList.selectedRow = MainFrame.this.buddyList.totalItemsCount - 1;
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_BUDDYLIST_SCREEN_HIGHER", true){

            public void actionPerformed() {
                int maxOffset = MainFrame.this.buddyList.yOffset - MainFrame.this.buddyList.height;
                int selRow = MainFrame.this.buddyList.selectedRow - MainFrame.this.buddyList.height / MainFrame.this.buddyList.itemHeight - 1;
                if (maxOffset < 0) {
                    maxOffset = 0;
                }
                if (selRow < 0) {
                    selRow = 0;
                }
                MainFrame.this.buddyList.yOffset = maxOffset;
                MainFrame.this.buddyList.selectedColumn = 0;
                MainFrame.this.buddyList.selectedRow = selRow;
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_BUDDYLIST_SCREEN_LOWER", true){

            public void actionPerformed() {
                int selOffset = MainFrame.this.buddyList.yOffset + MainFrame.this.buddyList.height;
                int maxOffset = MainFrame.this.buddyList.totalItemsCount * MainFrame.this.buddyList.itemHeight - MainFrame.this.buddyList.height;
                int selRow = MainFrame.this.buddyList.selectedRow + MainFrame.this.buddyList.height / MainFrame.this.buddyList.itemHeight + 1;
                if (maxOffset < 0) {
                    selOffset = 0;
                    selRow = MainFrame.this.buddyList.totalItemsCount - 1;
                } else {
                    if (selOffset > maxOffset) {
                        selOffset = maxOffset;
                    }
                    if (selRow >= MainFrame.this.buddyList.totalItemsCount) {
                        selRow = MainFrame.this.buddyList.totalItemsCount - 1;
                    }
                }
                MainFrame.this.buddyList.yOffset = selOffset;
                MainFrame.this.buddyList.selectedColumn = 0;
                MainFrame.this.buddyList.selectedRow = selRow;
            }
        });
        this.addKeyEvent(new KeyEvent(0, "KEY_LOCKSCREEN", true){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(new LockFrame());
            }
        });
        this.soft = new Soft(screen);
        this.accountTabs = new Tab(screen);
        this.accountTabs.tabEvent = new TabEvent(){

            public void stateChanged(int previousIndex, int selectedIndex, int tabsCount) {
                AccountRoot accountRoot = MainFrame.this.checkAccountRoot(previousIndex);
                if (accountRoot != null) {
                    accountRoot.setYOffset(MainFrame.this.buddyList.yOffset);
                    accountRoot.setSelectedIndex(MainFrame.this.buddyList.selectedColumn, MainFrame.this.buddyList.selectedRow);
                }
                if ((accountRoot = MainFrame.this.checkAccountRoot(selectedIndex)) != null) {
                    MainFrame.this.switchAccountRoot(accountRoot);
                }
            }
        };
        this.setGObject(this.accountTabs);
        this.accountPopupItem = new PopupItem(Localization.getMessage("ACCOUNT"), IconsType.HASH_MAIN, 7);
        this.accountPopupItem.addSubItem(new PopupItem(Localization.getMessage("CREATE"), IconsType.HASH_MAIN, 8){

            public void actionPerformed() {
                AccountEditorFrame accountEditorFrame = new AccountEditorFrame(null, null, null, null, null, true, null, false);
                MidletMain.screen.setActiveWindow(accountEditorFrame);
            }
        });
        this.accountPopupItem.addSubItem(new PopupItem(Localization.getMessage("EDIT"), IconsType.HASH_MAIN, 9){

            public void actionPerformed() {
                AccountRoot tempIcqAccountRoot = MainFrame.this.getActiveAccountRoot();
                AccountEditorFrame accountEditorFrame = new AccountEditorFrame(tempIcqAccountRoot.getUserId(), tempIcqAccountRoot.getUserNick(), tempIcqAccountRoot.getUserPassword(), tempIcqAccountRoot.getHost(), tempIcqAccountRoot.getPort(), tempIcqAccountRoot.getUseSsl(), tempIcqAccountRoot.getAccType(), true);
                MidletMain.screen.setActiveWindow(accountEditorFrame);
            }
        });
        this.accountPopupItem.addSubItem(new PopupItem(Localization.getMessage("REMOVE"), IconsType.HASH_MAIN, 10){

            public void actionPerformed() {
                AccountRoot tempIcqAccountRoot = MainFrame.this.getActiveAccountRoot();
                for (int c = 0; c < MainFrame.this.accountTabs.items.size(); ++c) {
                    if (!((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)c)).accountRoot.equals(tempIcqAccountRoot)) continue;
                    MainFrame.this.accountTabs.items.removeElementAt(c);
                    MidletMain.accounts.removeGroup(tempIcqAccountRoot.getUserId());
                    MidletMain.saveRmsData(true, false, false);
                    MainFrame.this.switchAccountRoot(MainFrame.this.getActiveAccountRoot());
                    return;
                }
            }
        });
        this.settingsPopupItem = new PopupItem(Localization.getMessage("SETTINGS"), IconsType.HASH_MAIN, 12){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(MidletMain.settingsFrame);
            }
        };
        this.servicePopupItem = new PopupItem(Localization.getMessage("SERVICE_MESSAGES"), IconsType.HASH_MAIN, 11){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_SERVMESSAGES").actionPerformed();
            }
        };
        this.servicesPopupItem = new PopupItem(Localization.getMessage("SERVICES"), IconsType.HASH_MAIN, 13);
        this.servicesPopupItem.addSubItem(new PopupItem(Localization.getMessage("UPDATE_CHECK"), IconsType.HASH_MAIN, 14){

            public void actionPerformed() {
                UpdateCheckFrame updateCheckFrame = new UpdateCheckFrame(false);
                updateCheckFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(updateCheckFrame);
            }
        });
        this.servicesPopupItem.addSubItem(new PopupItem(Localization.getMessage("SEND_OPINION"), IconsType.HASH_MAIN, 15){

            public void actionPerformed() {
                OpinionSendFrame opinionSendFrame = new OpinionSendFrame();
                opinionSendFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(opinionSendFrame);
            }
        });
        this.servicesPopupItem.addSubItem(new PopupItem(Localization.getMessage("CONNECTION_TEST"), IconsType.HASH_MAIN, 16){

            public void actionPerformed() {
                NetTestFrame netTestFrame = new NetTestFrame();
                netTestFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(netTestFrame);
            }
        });
        this.donatePopupItem = new PopupItem(Localization.getMessage("DONATE"), IconsType.HASH_MAIN, 17){

            public void actionPerformed() {
                DonateFrame donateFrame = new DonateFrame();
                donateFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(donateFrame);
            }
        };
        this.infoPopupItem = new PopupItem(Localization.getMessage("INFO"), IconsType.HASH_MAIN, 18);
        this.infoPopupItem.addSubItem(new PopupItem(Localization.getMessage("ABOUT"), IconsType.HASH_MAIN, 19){

            public void actionPerformed() {
                AboutFrame aboutFrame = new AboutFrame();
                aboutFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(aboutFrame);
            }
        });
        this.infoPopupItem.addSubItem(new PopupItem(Localization.getMessage("TRAFFIC"), IconsType.HASH_MAIN, 20){

            public void actionPerformed() {
                TrafficInfoFrame trafficInfoFrame = new TrafficInfoFrame();
                trafficInfoFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(trafficInfoFrame);
            }
        });
        this.infoPopupItem.addSubItem(this.donatePopupItem);
        this.lockPopupItem = new PopupItem(Localization.getMessage("LOCK_SCREEN"), IconsType.HASH_MAIN, 28){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_LOCKSCREEN").actionPerformed();
            }
        };
        this.minimizePopupItem = new PopupItem(Localization.getMessage("MINIMIZE"), IconsType.HASH_MAIN, 21){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_MINIMIZE").actionPerformed();
            }
        };
        this.exitPopupItem = new PopupItem(Localization.getMessage("EXIT"), IconsType.HASH_MAIN, 22){

            public void actionPerformed() {
                MidletMain.midletMain.notifyDestroyed();
            }
        };
        this.buddyList = new Group();
        this.buddyList.columnCount = 1;
        this.buddyList.setTouchOrientation(screen.isPointerEvents);
        this.buddyList.actionPerformedEvent = new GroupEvent(){

            public void actionPerformed(GroupChild buddyItem) {
                MainFrame.this.getKeyEvent("KEY_DIALOG").actionPerformed();
            }
        };
        this.accountTabs.gObject = this.buddyList;
        this.updateAccountsList();
        if (!this.accountTabs.items.isEmpty()) {
            this.checkAccountRoot(0);
            this.switchAccountRoot(((AccountTab)this.accountTabs.items.firstElement()).accountRoot);
        } else {
            if (this.pane == null) {
                this.initPane();
            }
            this.setGObject(this.pane);
            this.initEmptySoft();
        }
    }

    public void updateActiveAccountRoot() {
        if (this.accountTabs.items.isEmpty()) {
            return;
        }
        AccountRoot accountRoot = this.getActiveAccountRoot();
        if (accountRoot != null) {
            this.buddyList.columnCount = MidletMain.columnCount;
            accountRoot.updateMainFrameBuddyList();
            this.prepareGraphics();
            MidletMain.screen.repaint();
        }
    }

    public final void switchAccountRoot(AccountRoot accountRoot) {
        MidletMain.screen.setWaitScreenState(true);
        if (accountRoot == null) {
            if (this.getGObject().equals(this.accountTabs)) {
                if (this.pane == null) {
                    this.initPane();
                }
                this.setGObject(this.pane);
                this.initEmptySoft();
            }
        } else {
            this.accountTabs.validateSelection();
            if (!this.getGObject().equals(this.accountTabs)) {
                this.setGObject(this.accountTabs);
            }
            if (accountRoot.getBuddyItems() == null) {
                this.loadOfflineBuddyList(accountRoot);
            }
            if (accountRoot instanceof IcqAccountRoot) {
                LogUtil.outMessage("Installing images");
                this.buddyList.imageLeftFileHash = new int[]{"/res/groups/img_chat.png".hashCode(), "/res/groups/img_icqstatus.png".hashCode(), "/res/groups/img_xstatus.png".hashCode()};
                this.buddyList.imageRightFileHash = new int[]{IconsType.HASH_PLIST, IconsType.HASH_PLIST, IconsType.HASH_PLIST, IconsType.HASH_CLIENTS, IconsType.HASH_MAIN};
                LogUtil.outMessage("Preparing items");
                this.buddyList.items = ((IcqAccountRoot)accountRoot).buddyItems;
                LogUtil.outMessage("Checkong caps");
                if (CapUtil.dataCaps == null) {
                    LogUtil.outMessage("--- Loading caps...");
                    CapUtil.loadCaps();
                }
                LogUtil.outMessage("Checking and loading images");
                if (Splitter.getImageGroup("/res/groups/img_xstatus.png".hashCode()) == null) {
                    LogUtil.outMessage("Loading 1");
                    Splitter.splitImage("/res/groups/img_xstatus.png");
                }
                if (Splitter.getImageGroup("/res/groups/img_pstatus.png".hashCode()) == null) {
                    LogUtil.outMessage("Loading 2");
                    Splitter.splitImage("/res/groups/img_pstatus.png");
                }
                if (Splitter.getImageGroup("/res/groups/img_clients.png".hashCode()) == null) {
                    LogUtil.outMessage("Loading 3");
                    Splitter.splitImage("/res/groups/img_clients.png");
                }
                if (this.icqSoft == null) {
                    LogUtil.outMessage("Init icqSoft");
                    this.initIcqSoft();
                }
                this.soft = this.icqSoft;
                LogUtil.outMessage("Runtime settings");
                this.buddyList.yOffset = ((IcqAccountRoot)accountRoot).yOffset;
                this.buddyList.selectedColumn = ((IcqAccountRoot)accountRoot).selectedColumn;
                this.buddyList.selectedRow = ((IcqAccountRoot)accountRoot).selectedRow;
                LogUtil.outMessage("Complete.");
            } else if (accountRoot instanceof MmpAccountRoot) {
                this.buddyList.imageLeftFileHash = new int[]{"/res/groups/img_chat.png".hashCode(), "/res/groups/img_mmpstatus.png".hashCode()};
                this.buddyList.items = ((MmpAccountRoot)accountRoot).buddyItems;
                if (this.mmpSoft == null) {
                    this.initMmpSoft();
                }
                this.soft = this.mmpSoft;
                this.buddyList.yOffset = ((MmpAccountRoot)accountRoot).yOffset;
                this.buddyList.selectedColumn = ((MmpAccountRoot)accountRoot).selectedColumn;
                this.buddyList.selectedRow = ((MmpAccountRoot)accountRoot).selectedRow;
            } else if (accountRoot instanceof XmppAccountRoot) {
                this.buddyList.imageLeftFileHash = new int[]{"/res/groups/img_chat.png".hashCode(), "/res/groups/img_xmppstatus.png".hashCode()};
                this.buddyList.items = ((XmppAccountRoot)accountRoot).buddyItems;
                if (this.xmppSoft == null) {
                    this.initXmppSoft();
                }
                this.soft = this.xmppSoft;
                this.buddyList.yOffset = ((XmppAccountRoot)accountRoot).yOffset;
                this.buddyList.selectedColumn = ((XmppAccountRoot)accountRoot).selectedColumn;
                this.buddyList.selectedRow = ((XmppAccountRoot)accountRoot).selectedRow;
            }
            this.buddyList.maxWeight = accountRoot.getShowOffline() ? 0 : -1;
            this.buddyList.isShowGroups = accountRoot.getShowGroups();
            this.buddyList.columnCount = MidletMain.columnCount;
        }
        MidletMain.screen.setWaitScreenState(false);
    }

    public final void loadOfflineBuddyList(AccountRoot accountRoot) {
        BinGear dataGear = null;
        try {
            RecordUtil.readFile("/icq/".concat(String.valueOf(accountRoot.getUserId().hashCode())).concat("/buddylist.dat"), dataGear);
            Vector buddyItems = new Vector();
            accountRoot.setBuddyItems(buddyItems);
        }
        catch (Throwable ex) {
            accountRoot.setBuddyItems(new Vector());
        }
        accountRoot.updateMainFrameBuddyList();
    }

    public final void updateAccountsList() {
        String[] accounts = MidletMain.accounts.listGroups();
        for (int c = 0; c < accounts.length; ++c) {
            try {
                String accountUserId = accounts[c];
                AccountTab tempTabItem = new AccountTab(accountUserId, MidletMain.accounts.getValue(accounts[c], "nick"), "/res/groups/img_".concat(MidletMain.accounts.getValue(accounts[c], "type")).concat("status.png").hashCode(), 0);
                this.accountTabs.addTabItem(tempTabItem);
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    public final void updateAccountsStatus() {
        for (int c = 0; c < this.accountTabs.items.size(); ++c) {
            try {
                ((AccountTab)this.accountTabs.items.elementAt(c)).updateAccountStatus();
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getUnreadCount() {
        int totalUnread = 0;
        for (int c = 0; c < this.accountTabs.items.size(); ++c) {
            if (((AccountTab)this.accountTabs.items.elementAt((int)c)).accountRoot == null) continue;
            totalUnread += ((AccountTab)this.accountTabs.items.elementAt((int)c)).accountRoot.getUnrMsgs();
        }
        return totalUnread;
    }

    public final void initIcqSoft() {
        PopupItem tempPopupItem;
        this.icqSoft = new Soft(Screen.screen);
        final PopupItem statusItem = new PopupItem(Localization.getMessage("MSTATUS"));
        final PopupItem xStatusItem = new PopupItem(Localization.getMessage("XSTATUS"));
        final PopupItem pStatusItem = new PopupItem(Localization.getMessage("PSTATUS"));
        final PopupItem groupsPopup = new PopupItem(Localization.getMessage("GROUPS")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_FILTERGROUPS").actionPerformed();
            }
        };
        final PopupItem offlinePopup = new PopupItem(Localization.getMessage("OFFLINE_BUDDYES")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_FILTEROFFLINE").actionPerformed();
            }
        };
        this.icqSoft.leftSoft = new PopupItem(Localization.getMessage("MENU")){

            public void actionPerformed() {
                IcqAccountRoot icqAccountRoot = (IcqAccountRoot)MainFrame.this.getActiveAccountRoot();
                statusItem.imageFileHash = "/res/groups/img_icqstatus.png".hashCode();
                statusItem.imageIndex = icqAccountRoot.getStatusIndex();
                xStatusItem.imageFileHash = "/res/groups/img_xstatus.png".hashCode();
                xStatusItem.imageIndex = icqAccountRoot.xStatusId != -1 ? icqAccountRoot.xStatusId : 36;
                pStatusItem.imageFileHash = "/res/groups/img_pstatus.png".hashCode();
                pStatusItem.imageIndex = icqAccountRoot.pStatusId - 1;
                groupsPopup.title = (icqAccountRoot.isShowGroups ? Localization.getMessage("HIDE") : Localization.getMessage("SHOW")).concat(" ").concat(Localization.getMessage("GROUPS"));
                offlinePopup.title = (icqAccountRoot.isShowOffline ? Localization.getMessage("HIDE") : Localization.getMessage("SHOW")).concat(" ").concat(Localization.getMessage("OFFLINE_BUDDYES"));
            }
        };
        this.icqSoft.leftSoft.addSubItem(statusItem);
        int c = 0;
        while (c < IcqStatusUtil.getStatusCount()) {
            final int statusId = IcqStatusUtil.getStatus(c);
            final int statusIndex = c;
            tempPopupItem = new PopupItem(Localization.getMessage(IcqStatusUtil.getStatusDescr(c))){

                public void actionPerformed() {
                    IcqAccountRoot icqAccountRoot = (IcqAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                    if (icqAccountRoot.statusIndex == 0 && statusIndex != -1) {
                        icqAccountRoot.loadStatus(statusIndex);
                        icqAccountRoot.connectAction(statusIndex);
                    } else if (icqAccountRoot.statusIndex != 0 && statusIndex == 0) {
                        Handler.disconnectEvent(icqAccountRoot);
                        icqAccountRoot.session.disconnect();
                    } else if (icqAccountRoot.statusIndex != 0) {
                        icqAccountRoot.statusIndex = statusIndex;
                        icqAccountRoot.loadStatus(statusIndex);
                        IcqPacketSender.setStatus(icqAccountRoot.session, statusId < 4096 ? statusId : 0);
                        IcqPacketSender.sendCapabilities(icqAccountRoot.session, icqAccountRoot.xStatusId, statusId);
                        MainFrame.this.updateAccountsStatus();
                        SetStatusTextFrame setStatusTextFrame = new SetStatusTextFrame(icqAccountRoot, statusIndex);
                        setStatusTextFrame.s_prevWindow = MainFrame.this;
                        MidletMain.screen.setActiveWindow(setStatusTextFrame);
                    }
                }
            };
            tempPopupItem.imageFileHash = "/res/groups/img_icqstatus.png".hashCode();
            tempPopupItem.imageIndex = c++;
            statusItem.addSubItem(tempPopupItem);
        }
        this.icqSoft.leftSoft.addSubItem(xStatusItem);
        tempPopupItem = new PopupItem(Localization.getMessage("xstatus36")){

            public void actionPerformed() {
                IcqAccountRoot icqAccountRoot = (IcqAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                icqAccountRoot.xStatusId = -1;
                icqAccountRoot.xTitle = "";
                icqAccountRoot.xText = "";
                icqAccountRoot.isXStatusReadable = false;
                icqAccountRoot.saveAllSettings();
                if (icqAccountRoot.statusIndex != 0) {
                    IcqPacketSender.sendCapabilities(icqAccountRoot.session, icqAccountRoot.xStatusId, IcqStatusUtil.getStatus(icqAccountRoot.statusIndex));
                }
            }
        };
        tempPopupItem.imageFileHash = "/res/groups/img_xstatus.png".hashCode();
        tempPopupItem.imageIndex = 36;
        xStatusItem.addSubItem(tempPopupItem);
        String[] capGroups = CapUtil.dataCaps.listGroups();
        for (int c2 = 0; c2 < capGroups.length; ++c2) {
            try {
                String tempString = CapUtil.dataCaps.getValue(capGroups[c2], "type");
                if (tempString == null || Integer.parseInt(tempString) != 3) continue;
                final int iconIndex = Integer.parseInt(CapUtil.dataCaps.getValue(capGroups[c2], "icon").substring(7));
                tempPopupItem = new PopupItem(Localization.getMessage(CapUtil.dataCaps.getValue(capGroups[c2], "icon"))){

                    public void actionPerformed() {
                        IcqAccountRoot icqAccountRoot = (IcqAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                        icqAccountRoot.xStatusId = iconIndex;
                        icqAccountRoot.xTitle = "";
                        icqAccountRoot.xText = "";
                        icqAccountRoot.isXStatusReadable = false;
                        icqAccountRoot.saveAllSettings();
                        if (icqAccountRoot.statusIndex != 0) {
                            IcqPacketSender.sendCapabilities(icqAccountRoot.session, icqAccountRoot.xStatusId, IcqStatusUtil.getStatus(icqAccountRoot.statusIndex));
                        }
                        SetExtStatusFrame setExtStatusFrame = new SetExtStatusFrame(icqAccountRoot, icqAccountRoot.xStatusId);
                        setExtStatusFrame.s_prevWindow = MainFrame.this;
                        MidletMain.screen.setActiveWindow(setExtStatusFrame);
                    }
                };
                tempPopupItem.imageFileHash = "/res/groups/img_xstatus.png".hashCode();
                tempPopupItem.imageIndex = iconIndex;
                xStatusItem.addSubItem(tempPopupItem);
                continue;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        this.icqSoft.leftSoft.addSubItem(pStatusItem);
        String popupTitle = "";
        for (int c3 = 1; c3 <= 5; ++c3) {
            final int pStatusIndex = c3;
            switch (pStatusIndex) {
                case 1: {
                    popupTitle = Localization.getMessage("PSTATUS_ALLOW_ALL");
                    break;
                }
                case 2: {
                    popupTitle = Localization.getMessage("PSTATUS_BLOCK_ALL");
                    break;
                }
                case 3: {
                    popupTitle = Localization.getMessage("PSTATUS_PERMIT_LIST_ONLY");
                    break;
                }
                case 4: {
                    popupTitle = Localization.getMessage("PSTATUS_BLOCK_DENY_LIST");
                    break;
                }
                case 5: {
                    popupTitle = Localization.getMessage("PSTATUS_ALLOW_BUDDY_LIST");
                }
            }
            PopupItem _privateStatusItem = new PopupItem(popupTitle){

                public void actionPerformed() {
                    ((IcqAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot).setUpdatePrivacy(pStatusIndex);
                }
            };
            _privateStatusItem.imageFileHash = "/res/groups/img_pstatus.png".hashCode();
            _privateStatusItem.imageIndex = pStatusIndex - 1;
            pStatusItem.addSubItem(_privateStatusItem);
        }
        PopupItem filterPopup = new PopupItem(Localization.getMessage("FILTER"), IconsType.HASH_MAIN, 0);
        filterPopup.addSubItem(groupsPopup);
        filterPopup.addSubItem(offlinePopup);
        this.icqSoft.leftSoft.addSubItem(filterPopup);
        this.icqSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("DIALOGS"), IconsType.HASH_MAIN, 1){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_DIALOGS").actionPerformed();
            }
        });
        this.icqSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("FILETRANFSER"), IconsType.HASH_MAIN, 2){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                accountRoot.getTransactionsFrame().s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(accountRoot.getTransactionsFrame());
            }
        });
        PopupItem buddyListItem = new PopupItem(Localization.getMessage("BUDDYLIST"), IconsType.HASH_MAIN, 3);
        buddyListItem.addSubItem(new PopupItem(Localization.getMessage("ADD_GROUP"), IconsType.HASH_MAIN, 4){

            public void actionPerformed() {
                AddingGroupFrame addingGroupFrame = new AddingGroupFrame((IcqAccountRoot)MainFrame.this.getActiveAccountRoot());
                addingGroupFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(addingGroupFrame);
            }
        });
        buddyListItem.addSubItem(new PopupItem(Localization.getMessage("ADD_BUDDY"), IconsType.HASH_MAIN, 5){

            public void actionPerformed() {
                AddingBuddyFrame addingBuddyFrame = new AddingBuddyFrame((IcqAccountRoot)MainFrame.this.getActiveAccountRoot(), 0);
                addingBuddyFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(addingBuddyFrame);
            }
        });
        this.icqSoft.leftSoft.addSubItem(buddyListItem);
        this.icqSoft.leftSoft.addSubItem(this.accountPopupItem);
        this.icqSoft.leftSoft.addSubItem(this.settingsPopupItem);
        this.icqSoft.leftSoft.addSubItem(this.servicePopupItem);
        this.icqSoft.leftSoft.addSubItem(this.servicesPopupItem);
        this.icqSoft.leftSoft.addSubItem(this.infoPopupItem);
        this.icqSoft.leftSoft.addSubItem(this.lockPopupItem);
        this.icqSoft.leftSoft.addSubItem(this.minimizePopupItem);
        this.icqSoft.leftSoft.addSubItem(this.exitPopupItem);
        PopupItem privacyPopupItem = new PopupItem(Localization.getMessage("PRIVACY"));
        final PopupItem visiblePopupItem = new PopupItem(Localization.getMessage("PRI_VISIBLE_ADD")){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    if (((IcqItem)buddyItem).isInPermitList) {
                        LogUtil.outMessage(buddyItem.getUserId() + " is in visible list: permitBuddyId = " + ((IcqItem)buddyItem).permitBuddyId);
                        Cookie cookie = IcqPacketSender.deletePrivacy(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, ((IcqItem)buddyItem).userId, ((IcqItem)buddyItem).groupId, ((IcqItem)buddyItem).permitBuddyId, 2);
                        QueueAction queueAction = new QueueAction(MainFrame.this.getActiveAccountRoot(), buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                ((IcqItem)this.buddyItem).isInPermitList = false;
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    } else {
                        LogUtil.outMessage(buddyItem.getUserId() + " is not yet in visible list");
                        final int permitBuddyId = ((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).getNextBuddyId();
                        Cookie cookie = IcqPacketSender.addPrivacy(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, ((IcqItem)buddyItem).userId, ((IcqItem)buddyItem).groupId, permitBuddyId, 2);
                        QueueAction queueAction = new QueueAction(MainFrame.this.getActiveAccountRoot(), buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                ((IcqItem)this.buddyItem).isInPermitList = true;
                                ((IcqItem)this.buddyItem).permitBuddyId = permitBuddyId;
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    }
                }
            }
        };
        final PopupItem invisiblePopupItem = new PopupItem(Localization.getMessage("PRI_INVISIBLE_ADD")){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    if (((IcqItem)buddyItem).isInDenyList) {
                        Cookie cookie = IcqPacketSender.deletePrivacy(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, ((IcqItem)buddyItem).userId, ((IcqItem)buddyItem).groupId, ((IcqItem)buddyItem).denyBuddyId, 3);
                        QueueAction queueAction = new QueueAction(MainFrame.this.getActiveAccountRoot(), buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                ((IcqItem)this.buddyItem).isInDenyList = false;
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    } else {
                        final int denyBuddyId = ((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).getNextBuddyId();
                        Cookie cookie = IcqPacketSender.addPrivacy(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, ((IcqItem)buddyItem).userId, ((IcqItem)buddyItem).groupId, denyBuddyId, 3);
                        QueueAction queueAction = new QueueAction(MainFrame.this.getActiveAccountRoot(), buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                ((IcqItem)this.buddyItem).isInDenyList = true;
                                ((IcqItem)this.buddyItem).denyBuddyId = denyBuddyId;
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    }
                }
            }
        };
        final PopupItem ignorePopupItem = new PopupItem(Localization.getMessage("PRI_IGNORE_ADD")){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    if (((IcqItem)buddyItem).isInIgnoreList) {
                        Cookie cookie = IcqPacketSender.deletePrivacy(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, ((IcqItem)buddyItem).userId, ((IcqItem)buddyItem).groupId, ((IcqItem)buddyItem).ignoreBuddyId, 14);
                        QueueAction queueAction = new QueueAction(MainFrame.this.getActiveAccountRoot(), buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                ((IcqItem)this.buddyItem).isInIgnoreList = false;
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    } else {
                        final int ignoreBuddyId = ((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).getNextBuddyId();
                        Cookie cookie = IcqPacketSender.addPrivacy(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, ((IcqItem)buddyItem).userId, ((IcqItem)buddyItem).groupId, ignoreBuddyId, 14);
                        QueueAction queueAction = new QueueAction(MainFrame.this.getActiveAccountRoot(), buddyItem, cookie){

                            public void actionPerformed(Hashtable params) {
                                LogUtil.outMessage("Action Performed");
                                ((IcqItem)this.buddyItem).isInIgnoreList = true;
                                ((IcqItem)this.buddyItem).ignoreBuddyId = ignoreBuddyId;
                                this.buddyItem.updateUiData();
                                this.accountRoot.updateOfflineBuddylist();
                            }
                        };
                        LogUtil.outMessage("QueueAction created");
                        Queue.pushQueueAction(queueAction);
                    }
                }
            }
        };
        Thread rightAction = new Thread(){

            public void run() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    MainFrame.this.icqSoft.rightSoft = MainFrame.this.icqBuddyRightPopupItem;
                    visiblePopupItem.title = ((IcqItem)buddyItem).isInPermitList ? Localization.getMessage("PRI_VISIBLE_DELETE") : Localization.getMessage("PRI_VISIBLE_ADD");
                    invisiblePopupItem.title = ((IcqItem)buddyItem).isInDenyList ? Localization.getMessage("PRI_INVISIBLE_DELETE") : Localization.getMessage("PRI_INVISIBLE_ADD");
                    ignorePopupItem.title = ((IcqItem)buddyItem).isInIgnoreList ? Localization.getMessage("PRI_IGNORE_DELETE") : Localization.getMessage("PRI_IGNORE_ADD");
                } else {
                    MainFrame.this.icqSoft.rightSoft = MainFrame.this.icqGroupRightPopupItem;
                }
            }
        };
        this.icqBuddyRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.icqGroupRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.icqBuddyRightPopupItem.setActionPerformed(rightAction);
        this.icqGroupRightPopupItem.setActionPerformed(rightAction);
        this.icqSoft.rightSoft = this.icqBuddyRightPopupItem;
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("DIALOG")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_DIALOG").actionPerformed();
            }
        });
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("INFO")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_BUDDYINFO").actionPerformed();
            }
        });
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("CLIENT")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_CLIENTINFO").actionPerformed();
            }
        });
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("STATUSES")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_STATUSES").actionPerformed();
            }
        });
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("UNIQUE")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_UNIQUE").actionPerformed();
            }
        });
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("SENDFILE")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_SENDFILE").actionPerformed();
            }
        });
        if (System.getProperty("supports.video.capture") != null && System.getProperty("supports.video.capture").equals("true")) {
            this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("SENDPHOTO")){

                public void actionPerformed() {
                    MainFrame.this.getKeyEvent("KEY_SENDPHOTO").actionPerformed();
                }
            });
        }
        this.icqBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("HISTORY")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_HISTORY").actionPerformed();
            }
        });
        PopupItem renameItem = new PopupItem(Localization.getMessage("RENAME")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_RENAME").actionPerformed();
            }
        };
        this.icqBuddyRightPopupItem.addSubItem(renameItem);
        this.icqGroupRightPopupItem.addSubItem(renameItem);
        PopupItem removeItem = new PopupItem(Localization.getMessage("REMOVE")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_REMOVE").actionPerformed();
            }
        };
        this.icqBuddyRightPopupItem.addSubItem(removeItem);
        this.icqGroupRightPopupItem.addSubItem(removeItem);
        PopupItem authPopupItem = new PopupItem(Localization.getMessage("AUTH"));
        authPopupItem.addSubItem(new PopupItem(Localization.getMessage("AUTH_REQUEST")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_REQUESTAUTH").actionPerformed();
            }
        });
        authPopupItem.addSubItem(new PopupItem(Localization.getMessage("AUTH_ACCEPT")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_ACCEPTAUTH").actionPerformed();
            }
        });
        authPopupItem.addSubItem(new PopupItem(Localization.getMessage("AUTH_DENY")){

            public void actionPerformed() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                if (buddyItem != null) {
                    IcqPacketSender.authReply(((IcqAccountRoot)MainFrame.this.getActiveAccountRoot()).session, buddyItem.getUserId(), false, StringUtil.stringToByteArray(Localization.getMessage("DEFAULT_REJECT"), true));
                }
            }
        });
        this.icqBuddyRightPopupItem.addSubItem(authPopupItem);
        privacyPopupItem.addSubItem(visiblePopupItem);
        privacyPopupItem.addSubItem(invisiblePopupItem);
        privacyPopupItem.addSubItem(ignorePopupItem);
        this.icqBuddyRightPopupItem.addSubItem(privacyPopupItem);
    }

    public BuddyItem getSelectedBuddyItem() {
        try {
            if (this.buddyList.selectedRealGroup >= 0 && this.buddyList.selectedRealGroup < this.buddyList.items.size() && this.buddyList.selectedRealIndex >= 0 && this.buddyList.selectedRealIndex < ((GroupHeader)this.buddyList.items.elementAt(this.buddyList.selectedRealGroup)).getChildsCount()) {
                return (BuddyItem)((GroupHeader)this.buddyList.items.elementAt(this.buddyList.selectedRealGroup)).getChilds().elementAt(this.buddyList.selectedRealIndex);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public BuddyGroup getSelectedGroupItem() {
        try {
            if (this.buddyList.selectedRealGroup >= 0 && this.buddyList.selectedRealGroup < this.buddyList.items.size() && this.buddyList.selectedRealIndex == -1) {
                return (BuddyGroup)((GroupHeader)this.buddyList.items.elementAt(this.buddyList.selectedRealGroup));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public final void initMmpSoft() {
        this.mmpSoft = new Soft(Screen.screen);
        final PopupItem statusItem = new PopupItem(Localization.getMessage("MSTATUS"));
        final PopupItem groupsPopup = new PopupItem(Localization.getMessage("GROUPS")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_FILTERGROUPS").actionPerformed();
            }
        };
        final PopupItem offlinePopup = new PopupItem(Localization.getMessage("OFFLINE_BUDDYES")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_FILTEROFFLINE").actionPerformed();
            }
        };
        this.mmpSoft.leftSoft = new PopupItem(Localization.getMessage("MENU")){

            public void actionPerformed() {
                MmpAccountRoot mmpAccountRoot = (MmpAccountRoot)MainFrame.this.getActiveAccountRoot();
                statusItem.imageFileHash = "/res/groups/img_mmpstatus.png".hashCode();
                statusItem.imageIndex = mmpAccountRoot.getStatusIndex();
                groupsPopup.title = (mmpAccountRoot.isShowGroups ? Localization.getMessage("HIDE") : Localization.getMessage("SHOW")).concat(" ").concat(Localization.getMessage("GROUPS"));
                offlinePopup.title = (mmpAccountRoot.isShowOffline ? Localization.getMessage("HIDE") : Localization.getMessage("SHOW")).concat(" ").concat(Localization.getMessage("OFFLINE_BUDDYES"));
            }
        };
        this.mmpSoft.leftSoft.addSubItem(statusItem);
        PopupItem filterPopup = new PopupItem(Localization.getMessage("FILTER"), IconsType.HASH_MAIN, 0);
        filterPopup.addSubItem(groupsPopup);
        filterPopup.addSubItem(offlinePopup);
        this.mmpSoft.leftSoft.addSubItem(filterPopup);
        this.mmpSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("DIALOGS"), IconsType.HASH_MAIN, 1){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_DIALOGS").actionPerformed();
            }
        });
        PopupItem buddyListItem = new PopupItem(Localization.getMessage("BUDDYLIST"), IconsType.HASH_MAIN, 3);
        buddyListItem.addSubItem(new PopupItem(Localization.getMessage("ADD_GROUP"), IconsType.HASH_MAIN, 4){

            public void actionPerformed() {
                AddingGroupFrame addingGroupFrame = new AddingGroupFrame(MainFrame.this.getActiveAccountRoot());
                addingGroupFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(addingGroupFrame);
            }
        });
        buddyListItem.addSubItem(new PopupItem(Localization.getMessage("ADD_BUDDY"), IconsType.HASH_MAIN, 5){

            public void actionPerformed() {
                AddingBuddyFrame addingBuddyFrame = new AddingBuddyFrame(MainFrame.this.getActiveAccountRoot(), 1);
                addingBuddyFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(addingBuddyFrame);
            }
        });
        buddyListItem.addSubItem(new PopupItem(Localization.getMessage("ADD_PHONE"), IconsType.HASH_MAIN, 5){

            public void actionPerformed() {
                AddingBuddyFrame addingBuddyFrame = new AddingBuddyFrame(MainFrame.this.getActiveAccountRoot(), 2);
                addingBuddyFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(addingBuddyFrame);
            }
        });
        this.mmpSoft.leftSoft.addSubItem(buddyListItem);
        this.mmpSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("SEND_FREE_SMS"), IconsType.HASH_CHAT, 7){

            public void actionPerformed() {
                MmpSmsSendFrame mmpSmsSendFrame = new MmpSmsSendFrame((MmpAccountRoot)MainFrame.this.getActiveAccountRoot());
                mmpSmsSendFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(mmpSmsSendFrame);
            }
        });
        PopupItem extPopupItem = new PopupItem(Localization.getMessage("MMP_EXT_STATUS"));
        PopupItem parentPopupItem = statusItem;
        int statusImageHashCode = "/res/groups/img_mmpstatus.png".hashCode();
        for (int c = 0; c < MmpStatusUtil.getStatusCount(); ++c) {
            final long statusId = MmpStatusUtil.getStatus(c);
            final int statusIndex = c;
            if (Localization.getMessage(MmpStatusUtil.getStatusDescr(c)).equals("???")) continue;
            PopupItem tempPopupItem = new PopupItem(Localization.getMessage(MmpStatusUtil.getStatusDescr(c))){

                public void actionPerformed() {
                    MmpAccountRoot mmpAccountRoot = (MmpAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                    if (mmpAccountRoot.statusIndex == 0 && statusIndex != 0) {
                        mmpAccountRoot.loadStatus(statusIndex);
                        mmpAccountRoot.connectAction(statusIndex);
                    } else if (mmpAccountRoot.statusIndex != 0 && statusIndex == 0) {
                        Handler.disconnectEvent(mmpAccountRoot);
                        mmpAccountRoot.session.disconnect();
                    } else if (mmpAccountRoot.statusIndex != 0) {
                        try {
                            mmpAccountRoot.statusIndex = statusIndex;
                            mmpAccountRoot.loadStatus(statusIndex);
                            MmpPacketSender.MRIM_CS_CHANGE_STATUS(mmpAccountRoot, statusId, mmpAccountRoot.statusText);
                            MainFrame.this.updateAccountsStatus();
                        }
                        catch (Throwable ex) {
                            LogUtil.outMessage("Can't set status", true);
                        }
                        SetStatusTextFrame setStatusTextFrame = new SetStatusTextFrame(mmpAccountRoot, statusIndex);
                        setStatusTextFrame.s_prevWindow = MainFrame.this;
                        MidletMain.screen.setActiveWindow(setStatusTextFrame);
                    }
                }
            };
            tempPopupItem.imageFileHash = statusImageHashCode;
            tempPopupItem.imageIndex = c;
            parentPopupItem.addSubItem(tempPopupItem);
            if (c != MmpStatusUtil.baseStatusCount) continue;
            statusItem.addSubItem(extPopupItem);
            parentPopupItem = extPopupItem;
        }
        this.mmpSoft.leftSoft.addSubItem(this.accountPopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.settingsPopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.servicePopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.servicesPopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.infoPopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.lockPopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.minimizePopupItem);
        this.mmpSoft.leftSoft.addSubItem(this.exitPopupItem);
        Thread rightAction = new Thread(){

            public void run() {
                BuddyItem buddyItem = MainFrame.this.getSelectedBuddyItem();
                MainFrame.this.mmpSoft.rightSoft = buddyItem != null ? (buddyItem.isPhone() ? MainFrame.this.mmpPhoneRightPopupItem : MainFrame.this.mmpBuddyRightPopupItem) : MainFrame.this.mmpGroupRightPopupItem;
            }
        };
        this.mmpBuddyRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.mmpPhoneRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.mmpGroupRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.mmpBuddyRightPopupItem.setActionPerformed(rightAction);
        this.mmpPhoneRightPopupItem.setActionPerformed(rightAction);
        this.mmpGroupRightPopupItem.setActionPerformed(rightAction);
        this.mmpSoft.rightSoft = this.mmpBuddyRightPopupItem;
        PopupItem dialogItem = new PopupItem(Localization.getMessage("DIALOG")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_DIALOG").actionPerformed();
            }
        };
        this.mmpBuddyRightPopupItem.addSubItem(dialogItem);
        this.mmpPhoneRightPopupItem.addSubItem(dialogItem);
        PopupItem infoItem = new PopupItem(Localization.getMessage("INFO")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_BUDDYINFO").actionPerformed();
            }
        };
        this.mmpBuddyRightPopupItem.addSubItem(infoItem);
        this.mmpPhoneRightPopupItem.addSubItem(infoItem);
        PopupItem wakeupItem = new PopupItem(Localization.getMessage("WAKEUP")){

            public void actionPerformed() {
                BuddyItem buddyItem;
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                if (accountRoot instanceof MmpAccountRoot && (buddyItem = MainFrame.this.getSelectedBuddyItem()) != null) {
                    try {
                        ((MmpAccountRoot)accountRoot).sendWakeup(buddyItem);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.mmpBuddyRightPopupItem.addSubItem(wakeupItem);
        PopupItem historyItem = new PopupItem(Localization.getMessage("HISTORY")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_HISTORY").actionPerformed();
            }
        };
        this.mmpBuddyRightPopupItem.addSubItem(historyItem);
        this.mmpPhoneRightPopupItem.addSubItem(historyItem);
        PopupItem renameItem = new PopupItem(Localization.getMessage("RENAME")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_RENAME").actionPerformed();
            }
        };
        this.mmpBuddyRightPopupItem.addSubItem(renameItem);
        this.mmpPhoneRightPopupItem.addSubItem(renameItem);
        this.mmpGroupRightPopupItem.addSubItem(renameItem);
        PopupItem removeItem = new PopupItem(Localization.getMessage("REMOVE")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_REMOVE").actionPerformed();
            }
        };
        this.mmpBuddyRightPopupItem.addSubItem(removeItem);
        this.mmpPhoneRightPopupItem.addSubItem(removeItem);
        this.mmpGroupRightPopupItem.addSubItem(removeItem);
        PopupItem authPopupItem = new PopupItem(Localization.getMessage("AUTH"));
        authPopupItem.addSubItem(new PopupItem(Localization.getMessage("AUTH_REQUEST")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_REQUESTAUTH").actionPerformed();
            }
        });
        authPopupItem.addSubItem(new PopupItem(Localization.getMessage("AUTH_ACCEPT")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_ACCEPTAUTH").actionPerformed();
            }
        });
        this.mmpBuddyRightPopupItem.addSubItem(authPopupItem);
    }

    public void initXmppSoft() {
        this.xmppSoft = new Soft(Screen.screen);
        final PopupItem statusItem = new PopupItem(Localization.getMessage("MSTATUS"));
        final PopupItem groupsPopup = new PopupItem(Localization.getMessage("GROUPS")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_FILTERGROUPS").actionPerformed();
            }
        };
        final PopupItem offlinePopup = new PopupItem(Localization.getMessage("OFFLINE_BUDDYES")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_FILTEROFFLINE").actionPerformed();
            }
        };
        this.xmppSoft.leftSoft = new PopupItem(Localization.getMessage("MENU")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)MainFrame.this.getActiveAccountRoot();
                statusItem.imageFileHash = "/res/groups/img_xmppstatus.png".hashCode();
                statusItem.imageIndex = xmppAccountRoot.getStatusIndex();
                groupsPopup.title = (xmppAccountRoot.isShowGroups ? Localization.getMessage("HIDE") : Localization.getMessage("SHOW")).concat(" ").concat(Localization.getMessage("GROUPS"));
                offlinePopup.title = (xmppAccountRoot.isShowOffline ? Localization.getMessage("HIDE") : Localization.getMessage("SHOW")).concat(" ").concat(Localization.getMessage("OFFLINE_BUDDYES"));
            }
        };
        this.xmppSoft.leftSoft.addSubItem(statusItem);
        PopupItem filterPopup = new PopupItem(Localization.getMessage("FILTER"), IconsType.HASH_MAIN, 0);
        filterPopup.addSubItem(groupsPopup);
        filterPopup.addSubItem(offlinePopup);
        this.xmppSoft.leftSoft.addSubItem(filterPopup);
        this.xmppSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("DIALOGS"), IconsType.HASH_MAIN, 1){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_DIALOGS").actionPerformed();
            }
        });
        this.xmppSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("SERVICES"), IconsType.HASH_MAIN, 27){

            public void actionPerformed() {
                MidletMain.servicesFrame = new ServicesFrame((XmppAccountRoot)MainFrame.this.getActiveAccountRoot());
                MidletMain.servicesFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(MidletMain.servicesFrame);
            }
        });
        this.xmppSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("BOOKMARKS"), IconsType.HASH_MAIN, 26){

            public void actionPerformed() {
                MidletMain.bookmarksFrame = new BookmarksFrame((XmppAccountRoot)MainFrame.this.getActiveAccountRoot());
                MidletMain.bookmarksFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(MidletMain.bookmarksFrame);
            }
        });
        this.xmppSoft.leftSoft.addSubItem(new PopupItem(Localization.getMessage("FILETRANFSER"), IconsType.HASH_MAIN, 2){

            public void actionPerformed() {
                AccountRoot accountRoot = MainFrame.this.getActiveAccountRoot();
                accountRoot.getTransactionsFrame().s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(accountRoot.getTransactionsFrame());
            }
        });
        PopupItem buddyListItem = new PopupItem(Localization.getMessage("BUDDYLIST"), IconsType.HASH_MAIN, 3);
        buddyListItem.addSubItem(new PopupItem(Localization.getMessage("ADD_BUDDY"), IconsType.HASH_MAIN, 5){

            public void actionPerformed() {
                AddingBuddyFrame addingBuddyFrame = new AddingBuddyFrame(MainFrame.this.getActiveAccountRoot(), 1);
                addingBuddyFrame.s_prevWindow = MainFrame.this;
                MidletMain.screen.setActiveWindow(addingBuddyFrame);
            }
        });
        int c = 0;
        while (c < XmppStatusUtil.getStatusCount()) {
            final int statusIndex = c;
            PopupItem tempPopupItem = new PopupItem(Localization.getMessage(XmppStatusUtil.getStatusDescr(c))){

                public void actionPerformed() {
                    XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                    if (xmppAccountRoot.statusIndex == 0 && statusIndex != 0) {
                        xmppAccountRoot.connectAction(statusIndex);
                    } else if (xmppAccountRoot.statusIndex != 0 && statusIndex == 0) {
                        try {
                            xmppAccountRoot.xmppSession.disconnect();
                            xmppAccountRoot.statusIndex = statusIndex;
                            Handler.disconnectEvent(xmppAccountRoot);
                        }
                        catch (IOException ex) {
                            LogUtil.outMessage("Can't disconnect", true);
                        }
                    } else if (xmppAccountRoot.statusIndex != 0) {
                        try {
                            XmppSender.setStatus(xmppAccountRoot.xmppSession.xmlWriter, xmppAccountRoot.userId.concat("/").concat(xmppAccountRoot.resource), XmppStatusUtil.statuses[statusIndex], "", xmppAccountRoot.priority);
                            xmppAccountRoot.statusIndex = statusIndex;
                            if (xmppAccountRoot.conferenceGroup != null && xmppAccountRoot.conferenceGroup.getChildsCount() > 0) {
                                for (int c = 0; c < xmppAccountRoot.conferenceGroup.getChilds().size(); ++c) {
                                    XmppItem groupChatItem = (XmppItem)xmppAccountRoot.conferenceGroup.getChilds().elementAt(c);
                                    if (groupChatItem.getStatusIndex() == XmppStatusUtil.offlineIndex) continue;
                                    XmppSender.sendPresence(xmppAccountRoot.xmppSession.xmlWriter, null, groupChatItem.userId, null, XmppStatusUtil.statuses[statusIndex], "", xmppAccountRoot.priority, false, null, null);
                                }
                            }
                            MainFrame.this.updateAccountsStatus();
                        }
                        catch (IOException ex) {
                            LogUtil.outMessage("Can't set status", true);
                        }
                    }
                }
            };
            tempPopupItem.imageFileHash = "/res/groups/img_xmppstatus.png".hashCode();
            tempPopupItem.imageIndex = c++;
            statusItem.addSubItem(tempPopupItem);
        }
        this.xmppSoft.leftSoft.addSubItem(this.accountPopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.settingsPopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.servicePopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.servicesPopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.infoPopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.lockPopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.minimizePopupItem);
        this.xmppSoft.leftSoft.addSubItem(this.exitPopupItem);
        final PopupItem dialogsPopup = new PopupItem(Localization.getMessage("DIALOG"));
        final PopupItem sendFilePopup = new PopupItem(Localization.getMessage("SENDFILE"));
        Thread xmppRightPopupAction = new Thread(){

            public void run() {
                XmppItem xmppItem;
                if (!dialogsPopup.isEmpty()) {
                    dialogsPopup.subPopup.items.removeAllElements();
                    dialogsPopup.subPopup.yOffset = 0;
                    dialogsPopup.subPopup.selectedIndex = 0;
                }
                if (!sendFilePopup.isEmpty()) {
                    sendFilePopup.subPopup.items.removeAllElements();
                    sendFilePopup.subPopup.yOffset = 0;
                    sendFilePopup.subPopup.selectedIndex = 0;
                }
                if ((xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem()) != null) {
                    Enumeration resources = xmppItem.resources.elements();
                    if (xmppItem.resources.size() <= 1) {
                        final Resource resource = xmppItem.getDefaultResource();
                        dialogsPopup.setActionPerformed(new Thread(){

                            public void run() {
                                LogUtil.outMessage("One resource: " + resource.resource);
                                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)MainFrame.this.getActiveAccountRoot();
                                ChatTab chatTab = MidletMain.chatFrame.getChatTab(xmppAccountRoot, xmppItem.getUserId(), resource.resource, true);
                                if (chatTab == null) {
                                    chatTab = new ChatTab(xmppAccountRoot, xmppItem, resource, xmppAccountRoot.getStatusImages().hashCode(), "/res/groups/img_chat.png".hashCode());
                                    MidletMain.chatFrame.addChatTab(chatTab, true);
                                }
                                MidletMain.screen.setActiveWindow(MidletMain.chatFrame);
                            }
                        });
                        sendFilePopup.setActionPerformed(new Thread(){

                            public void run() {
                                LogUtil.outMessage("One resource: " + resource.resource);
                                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)MainFrame.this.getActiveAccountRoot();
                                FileBrowserFrame fileBrowserFrame = new FileBrowserFrame(0, xmppAccountRoot, xmppItem.getUserId().concat("/").concat(resource.resource));
                                fileBrowserFrame.s_prevWindow = MainFrame.this;
                                MidletMain.screen.setActiveWindow(fileBrowserFrame);
                            }
                        });
                    } else {
                        while (resources.hasMoreElements()) {
                            final Resource resource = (Resource)resources.nextElement();
                            dialogsPopup.addSubItem(new PopupItem(resource.resource.length() == 0 && xmppItem.isGroupChat ? Localization.getMessage("XMPP_ROOM") : (resource.resource.length() == 0 ? Localization.getMessage("XMPP_ALL_RESOURCES") : resource.resource), "/res/groups/img_xmppstatus.png".hashCode(), resource.resource.length() == 0 && xmppItem.isGroupChat ? XmppStatusUtil.groupChatIndex : (resource.resource.length() == 0 ? XmppStatusUtil.onlineIndex : resource.statusIndex)){

                                public void actionPerformed() {
                                    LogUtil.outMessage("Of multiple resource: " + resource.resource);
                                    XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)MainFrame.this.getActiveAccountRoot();
                                    ChatTab chatTab = MidletMain.chatFrame.getChatTab(xmppAccountRoot, xmppItem.getUserId(), resource.resource, true);
                                    if (chatTab == null) {
                                        chatTab = new ChatTab(xmppAccountRoot, xmppItem, resource, xmppAccountRoot.getStatusImages().hashCode(), "/res/groups/img_chat.png".hashCode());
                                        MidletMain.chatFrame.addChatTab(chatTab, true);
                                    }
                                    MidletMain.screen.setActiveWindow(MidletMain.chatFrame);
                                }
                            });
                            sendFilePopup.addSubItem(new PopupItem(resource.resource.length() == 0 && xmppItem.isGroupChat ? Localization.getMessage("XMPP_ROOM") : (resource.resource.length() == 0 ? Localization.getMessage("XMPP_ALL_RESOURCES") : resource.resource), "/res/groups/img_xmppstatus.png".hashCode(), resource.resource.length() == 0 && xmppItem.isGroupChat ? XmppStatusUtil.groupChatIndex : (resource.resource.length() == 0 ? XmppStatusUtil.onlineIndex : resource.statusIndex)){

                                public void actionPerformed() {
                                    LogUtil.outMessage("Of multiple resource: " + resource.resource);
                                    XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)MainFrame.this.getActiveAccountRoot();
                                    FileBrowserFrame fileBrowserFrame = new FileBrowserFrame(0, xmppAccountRoot, xmppItem.getUserId().concat("/").concat(resource.resource));
                                    fileBrowserFrame.s_prevWindow = MainFrame.this;
                                    MidletMain.screen.setActiveWindow(fileBrowserFrame);
                                }
                            });
                        }
                    }
                }
                MainFrame.this.xmppSoft.rightSoft = xmppItem != null && xmppItem.isGroupChat ? MainFrame.this.xmppConfrRightPopupItem : (xmppItem != null ? MainFrame.this.xmppBuddyRightPopupItem : MainFrame.this.xmppGroupRightPopupItem);
            }
        };
        this.xmppBuddyRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.xmppGroupRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.xmppConfrRightPopupItem = new PopupItem(Localization.getMessage("BUDDY"));
        this.xmppBuddyRightPopupItem.setActionPerformed(xmppRightPopupAction);
        this.xmppGroupRightPopupItem.setActionPerformed(xmppRightPopupAction);
        this.xmppConfrRightPopupItem.setActionPerformed(xmppRightPopupAction);
        this.xmppSoft.rightSoft = this.xmppBuddyRightPopupItem;
        this.xmppBuddyRightPopupItem.addSubItem(dialogsPopup);
        this.xmppBuddyRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("HISTORY")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_HISTORY").actionPerformed();
            }
        });
        this.xmppBuddyRightPopupItem.addSubItem(sendFilePopup);
        this.xmppConfrRightPopupItem.addSubItem(dialogsPopup);
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("HISTORY")){

            public void actionPerformed() {
                MainFrame.this.getKeyEvent("KEY_HISTORY").actionPerformed();
            }
        });
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("EDIT_TOPIC")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                XmppItem xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem();
                if (xmppItem != null) {
                    LogUtil.outMessage("JID: " + xmppItem.userId);
                    LogUtil.outMessage("Subject: " + xmppItem.groupChatSubject);
                    TopicEditFrame topicEditFrame = new TopicEditFrame(xmppAccountRoot, xmppItem.userId, xmppItem.groupChatSubject);
                    topicEditFrame.s_prevWindow = MidletMain.mainFrame;
                    MidletMain.screen.setActiveWindow(topicEditFrame);
                }
            }
        });
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("EDIT_NICK")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                XmppItem xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem();
                if (xmppItem != null) {
                    GroupChatNickEditFrame groupChatNickEditFrame = new GroupChatNickEditFrame(xmppAccountRoot, xmppItem);
                    groupChatNickEditFrame.s_prevWindow = MidletMain.mainFrame;
                    MidletMain.screen.setActiveWindow(groupChatNickEditFrame);
                }
            }
        });
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("CONFIGURE_CONFR")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                XmppItem xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem();
                if (xmppItem != null) {
                    MidletMain.groupChatConfFrame = new GroupChatConfFrame(xmppAccountRoot, xmppItem);
                    MidletMain.groupChatConfFrame.s_prevWindow = MidletMain.mainFrame;
                    MidletMain.screen.setActiveWindow(MidletMain.groupChatConfFrame);
                }
            }
        });
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("ROLE_LIST")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                XmppItem xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem();
                if (xmppItem != null) {
                    MidletMain.groupChatUsersFrame = new GroupChatUsersFrame(xmppAccountRoot, xmppItem.userId, true);
                    MidletMain.groupChatUsersFrame.s_prevWindow = MidletMain.mainFrame;
                    MidletMain.screen.setActiveWindow(MidletMain.groupChatUsersFrame);
                }
            }
        });
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("AFFILIATION_LIST")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                XmppItem xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem();
                if (xmppItem != null) {
                    MidletMain.groupChatUsersFrame = new GroupChatUsersFrame(xmppAccountRoot, xmppItem.userId, false);
                    MidletMain.groupChatUsersFrame.s_prevWindow = MidletMain.mainFrame;
                    MidletMain.screen.setActiveWindow(MidletMain.groupChatUsersFrame);
                }
            }
        });
        this.xmppConfrRightPopupItem.addSubItem(new PopupItem(Localization.getMessage("EXIT_CONFR")){

            public void actionPerformed() {
                XmppAccountRoot xmppAccountRoot = (XmppAccountRoot)((AccountTab)MainFrame.this.accountTabs.items.elementAt((int)MainFrame.this.accountTabs.selectedIndex)).accountRoot;
                XmppItem xmppItem = (XmppItem)MainFrame.this.getSelectedBuddyItem();
                if (xmppItem != null) {
                    xmppItem.offlineResources();
                    XmppSender.exitConfrence(xmppAccountRoot.xmppSession, xmppItem.userId, xmppItem.groupChatNick);
                    xmppAccountRoot.buddyItems.removeElement(xmppItem);
                    xmppAccountRoot.conferenceGroup.getChilds().removeElement(xmppItem);
                }
            }
        });
    }

    public AccountRoot getActiveAccountRoot() {
        this.accountTabs.validateSelection();
        if (this.accountTabs.items.isEmpty()) {
            return null;
        }
        if (this.accountTabs.selectedIndex == -1) {
            return null;
        }
        return this.checkAccountRoot(this.accountTabs.selectedIndex);
    }

    public final AccountRoot checkAccountRoot(int index) {
        AccountTab tempAccountTab = (AccountTab)this.accountTabs.items.elementAt(index);
        try {
            if (tempAccountTab.accountRoot == null) {
                if (MidletMain.accounts.getValue(tempAccountTab.accountUserId, "type").equals("icq")) {
                    tempAccountTab.accountRoot = new IcqAccountRoot(tempAccountTab.accountUserId);
                } else if (MidletMain.accounts.getValue(tempAccountTab.accountUserId, "type").equals("mmp")) {
                    tempAccountTab.accountRoot = new MmpAccountRoot(tempAccountTab.accountUserId);
                } else if (MidletMain.accounts.getValue(tempAccountTab.accountUserId, "type").equals("xmpp")) {
                    tempAccountTab.accountRoot = new XmppAccountRoot(tempAccountTab.accountUserId);
                }
                tempAccountTab.accountRoot.init(true);
            }
            return tempAccountTab.accountRoot;
        }
        catch (GroupNotFoundException ex) {
        }
        catch (IncorrectValueException incorrectValueException) {
            // empty catch block
        }
        return null;
    }

    public final void initPane() {
        this.pane = new Pane(null, false);
        this.pane.addItem(new Label(Localization.getMessage("INTRO_MSG")));
        Button button = new Button(Localization.getMessage("ADD_ACCOUNT")){

            public void actionPerformed() {
                AccountEditorFrame accountEditorFrame = new AccountEditorFrame(null, null, null, null, null, true, null, false);
                MidletMain.screen.setActiveWindow(accountEditorFrame);
            }
        };
        button.setFocusable(true);
        button.setFocused(true);
        this.pane.addItem(button);
    }

    public final void initEmptySoft() {
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("EXIT")){

            public void actionPerformed() {
                MidletMain.midletMain.notifyDestroyed();
            }
        };
        this.soft.rightSoft = new PopupItem("");
    }

    public AccountTab getAccountTab(String loginId) {
        for (int c = 0; c < this.accountTabs.items.size(); ++c) {
            AccountTab tempAccountTab = (AccountTab)this.accountTabs.items.elementAt(c);
            if (!tempAccountTab.accountUserId.equals(loginId)) continue;
            return tempAccountTab;
        }
        return null;
    }

    public BuddyItem getBuddyItem(AccountRoot accountRoot, String buddyId) {
        if (accountRoot == null || buddyId == null) {
            return null;
        }
        Vector buddyItems = accountRoot.getBuddyItems();
        for (int i = 0; i < buddyItems.size(); ++i) {
            GroupHeader buddyGroup = (GroupHeader)buddyItems.elementAt(i);
            if (buddyGroup.getChilds() == null || buddyGroup.getChildsCount() == 0) continue;
            for (int j = 0; j < buddyGroup.getChilds().size(); ++j) {
                BuddyItem buddyItem = (BuddyItem)buddyGroup.getChilds().elementAt(j);
                if (buddyItem == null || buddyItem.getUserId() == null || !buddyItem.getUserId().equals(buddyId)) continue;
                return buddyItem;
            }
        }
        return null;
    }

    public void typingNotify(AccountRoot accountRoot, String buddyId, boolean b) {
        BuddyItem buddyItem = this.getBuddyItem(accountRoot, buddyId);
        if (buddyItem != null) {
            buddyItem.setTypingStatus(b);
            buddyItem.updateUiData();
        }
    }

    public boolean typingNotify(AccountRoot accountRoot, String buddyId) {
        BuddyItem buddyItem = this.getBuddyItem(accountRoot, buddyId);
        if (buddyItem != null) {
            buddyItem.setTypingStatus(true);
            buddyItem.updateUiData();
        }
        boolean isTyping = buddyItem.getTypingStatus();
        return isTyping;
    }
}

