/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.xmpp.Resource;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.tcuilite.TabItem;
import com.tomclaw.utils.LogUtil;
import java.util.Vector;

public class ChatTab
extends TabItem {
    public AccountRoot accountRoot;
    public BuddyItem buddyItem;
    public Vector chatItems;
    public int statusFileHash;
    public int msgFileHash;
    public Resource resource;
    public String titleAddon;

    public ChatTab(AccountRoot accountRoot, BuddyItem buddyItem, int statusFileHash, int msgFileHash) {
        super(buddyItem.getUserNick(), statusFileHash, buddyItem.getLeftImages()[1]);
        this.accountRoot = accountRoot;
        this.buddyItem = buddyItem;
        this.statusFileHash = statusFileHash;
        this.msgFileHash = msgFileHash;
    }

    public ChatTab(AccountRoot accountRoot, BuddyItem buddyItem, Resource resource, int statusFileHash, int msgFileHash) {
        super(buddyItem.getUserNick(), statusFileHash, buddyItem.getLeftImages()[1]);
        this.accountRoot = accountRoot;
        this.buddyItem = buddyItem;
        this.statusFileHash = statusFileHash;
        this.msgFileHash = msgFileHash;
        this.resource = resource;
    }

    public void updateChatCaption() {
        if (this.buddyItem != null) {
            String resourceTitle = null;
            if (this.resource != null) {
                resourceTitle = this.resource.resource;
            }
            if (this.buddyItem.getUnreadCount(resourceTitle) == 0) {
                this.imageFileHash = this.statusFileHash;
                this.imageIndex = this.buddyItem instanceof XmppItem && this.resource != null && this.resource.resource.length() > 0 ? this.resource.statusIndex : this.buddyItem.getLeftImages()[1];
            } else {
                this.imageFileHash = this.msgFileHash;
                this.imageIndex = this.buddyItem.getLeftImages()[0];
            }
            if (this.buddyItem.getTypingStatus()) {
                this.imageFileHash = this.msgFileHash;
                this.imageIndex = this.buddyItem.getLeftImages()[0];
            }
            this.titleAddon = "";
            if (this.resource != null && this.buddyItem instanceof XmppItem) {
                if (((XmppItem)this.buddyItem).isGroupChat && (this.resource == null || this.resource.resource.length() == 0)) {
                    this.titleAddon = " (".concat(String.valueOf(((XmppItem)this.buddyItem).getResourcesCount() - 1)).concat(")");
                } else if (this.resource.resource.length() > 0) {
                    this.titleAddon = " [".concat(this.resource.resource).concat("]");
                }
            }
            this.title = this.buddyItem.getUserNick().concat(this.titleAddon);
            LogUtil.outMessage(this.title);
        }
    }
}

