/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.main.AccountTab;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.tcuilite.Check;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;

public class AccountEditorFrame
extends Window {
    public Pane pane;
    public RadioGroup protocolSwitcher;
    public Label protName;
    public Field fldLogin;
    public Field fldPassw;
    public Field fldNick;
    public Field fldHost;
    public Field fldPort;
    public Check isUseSsl;

    public void radioAction() {
        switch (this.protocolSwitcher.getCombed()) {
            case 0: {
                this.protName.setCaption(Localization.getMessage("UIN").concat(":"));
                this.fldLogin.setText("");
                this.fldLogin.updateCaption();
                this.fldLogin.constraints = 1;
                this.fldHost.setText("login.icq.com");
                this.fldHost.updateCaption();
                this.fldPort.setText("5190");
                this.fldPort.updateCaption();
                this.isUseSsl.setState(false);
                this.isUseSsl.setFocusable(false);
                break;
            }
            case 1: {
                this.protName.setCaption(Localization.getMessage("MAIL_RU_EMAIL").concat(":"));
                this.fldLogin.setText("");
                this.fldLogin.updateCaption();
                this.fldLogin.constraints = 1;
                this.fldHost.setText("mrim.mail.ru");
                this.fldHost.updateCaption();
                this.fldPort.setText("2042");
                this.fldPort.updateCaption();
                this.isUseSsl.setState(false);
                this.isUseSsl.setFocusable(false);
                break;
            }
            case 2: {
                this.protName.setCaption(Localization.getMessage("JID").concat(":"));
                this.fldLogin.setText("");
                this.fldLogin.updateCaption();
                this.fldLogin.constraints = 1;
                this.fldHost.setText("");
                this.fldHost.updateCaption();
                this.fldPort.setText("5222");
                this.fldPort.updateCaption();
                this.isUseSsl.setState(true);
                this.isUseSsl.setFocusable(true);
            }
        }
    }

    public AccountEditorFrame(String loginId, String nick, String passwd, String host, String port, boolean ussl, String type, final boolean isEdit) {
        super(MidletMain.screen);
        LogUtil.outMessage("ussl = " + ussl);
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(MidletMain.mainFrame);
            }
        };
        this.soft.rightSoft = new PopupItem(isEdit ? Localization.getMessage("SAVE") : Localization.getMessage("CREATE")){

            public void actionPerformed() {
                MidletMain.screen.setWaitScreenState(true);
                new Thread(){

                    public void run() {
                        try {
                            String accType = "";
                            (this).AccountEditorFrame.this.fldNick.setText((this).AccountEditorFrame.this.fldNick.getText().length() > 0 ? (this).AccountEditorFrame.this.fldNick.getText() : (this).AccountEditorFrame.this.fldLogin.getText());
                            AccountTab tempTabItem = MidletMain.mainFrame.getAccountTab((this).AccountEditorFrame.this.fldLogin.getText());
                            if (tempTabItem == null) {
                                tempTabItem = new AccountTab((this).AccountEditorFrame.this.fldLogin.getText(), (this).AccountEditorFrame.this.fldNick.getText(), 0, 0);
                            }
                            MidletMain.accounts.addGroup((this).AccountEditorFrame.this.fldLogin.getText());
                            MidletMain.accounts.addItem((this).AccountEditorFrame.this.fldLogin.getText(), "nick", (this).AccountEditorFrame.this.fldNick.getText());
                            MidletMain.accounts.addItem((this).AccountEditorFrame.this.fldLogin.getText(), "pass", (this).AccountEditorFrame.this.fldPassw.getText());
                            MidletMain.accounts.addItem((this).AccountEditorFrame.this.fldLogin.getText(), "host", (this).AccountEditorFrame.this.fldHost.getText());
                            MidletMain.accounts.addItem((this).AccountEditorFrame.this.fldLogin.getText(), "port", (this).AccountEditorFrame.this.fldPort.getText());
                            MidletMain.accounts.addItem((this).AccountEditorFrame.this.fldLogin.getText(), "ussl", (this).AccountEditorFrame.this.isUseSsl.getState() ? "true" : "false");
                            switch ((this).AccountEditorFrame.this.protocolSwitcher.getCombed()) {
                                case 0: {
                                    accType = "icq";
                                    if (isEdit) break;
                                    tempTabItem.accountRoot = new IcqAccountRoot((this).AccountEditorFrame.this.fldLogin.getText());
                                    break;
                                }
                                case 1: {
                                    accType = "mmp";
                                    if (isEdit) break;
                                    tempTabItem.accountRoot = new MmpAccountRoot((this).AccountEditorFrame.this.fldLogin.getText());
                                    break;
                                }
                                case 2: {
                                    accType = "xmpp";
                                    if (isEdit) break;
                                    tempTabItem.accountRoot = new XmppAccountRoot((this).AccountEditorFrame.this.fldLogin.getText());
                                }
                            }
                            MidletMain.accounts.addItem((this).AccountEditorFrame.this.fldLogin.getText(), "type", accType);
                            tempTabItem.protocolFileHash = tempTabItem.imageFileHash = "/res/groups/img_".concat(accType).concat("status.png").hashCode();
                            tempTabItem.accountRoot.saveAllSettings();
                            tempTabItem.accountRoot.init(!isEdit);
                            if (isEdit) {
                                tempTabItem.title = (this).AccountEditorFrame.this.fldNick.getText();
                            } else {
                                MidletMain.mainFrame.accountTabs.addTabItem(tempTabItem);
                            }
                            MidletMain.mainFrame.switchAccountRoot(MidletMain.mainFrame.getActiveAccountRoot());
                            MidletMain.screen.setActiveWindow(MidletMain.mainFrame);
                        }
                        catch (Throwable ex) {
                            Handler.showError("UNDEF_ACCOUNT_CREATING_ERROR");
                        }
                        MidletMain.screen.setWaitScreenState(false);
                    }
                }.start();
            }
        };
        this.protocolSwitcher = new RadioGroup();
        this.pane = new Pane(this, false);
        this.pane.addItem(new Label(Localization.getMessage("SEL_PROTOCOL").concat(":")));
        Radio radio = new Radio("ICQ", isEdit ? type.equals("icq") : true){

            public void actionPerformed() {
                AccountEditorFrame.this.radioAction();
            }
        };
        radio.setFocusable(!isEdit);
        this.protocolSwitcher.addRadio(radio);
        this.pane.addItem(radio);
        radio = new Radio("Mail.Ru", isEdit ? type.equals("mmp") : false){

            public void actionPerformed() {
                AccountEditorFrame.this.radioAction();
            }
        };
        radio.setFocusable(!isEdit);
        this.protocolSwitcher.addRadio(radio);
        this.pane.addItem(radio);
        radio = new Radio("XMPP (Jabber)", isEdit ? type.equals("xmpp") : false){

            public void actionPerformed() {
                AccountEditorFrame.this.radioAction();
            }
        };
        radio.setFocusable(!isEdit);
        this.protocolSwitcher.addRadio(radio);
        this.pane.addItem(radio);
        this.protName = new Label(Localization.getMessage("UIN").concat(":"));
        this.pane.addItem(this.protName);
        this.fldLogin = new Field(isEdit ? loginId : "");
        this.fldLogin.setFocusable(!isEdit);
        this.fldLogin.setFocused(!isEdit);
        this.fldLogin.constraints = 1;
        this.pane.addItem(this.fldLogin);
        this.pane.addItem(new Label(Localization.getMessage("PASSWORD").concat(":")));
        this.fldPassw = new Field(isEdit ? passwd : "");
        this.fldPassw.setFocusable(true);
        this.fldPassw.setFocused(isEdit);
        this.fldPassw.constraints = 65536;
        this.pane.addItem(this.fldPassw);
        this.pane.addItem(new Label(Localization.getMessage("NICK").concat(":")));
        this.fldNick = new Field(isEdit ? nick : "");
        this.fldNick.setFocusable(true);
        this.pane.addItem(this.fldNick);
        this.pane.addItem(new Label(Localization.getMessage("HOST").concat(":")));
        this.fldHost = new Field(isEdit ? host : "login.icq.com");
        this.fldHost.setFocusable(true);
        this.pane.addItem(this.fldHost);
        this.pane.addItem(new Label(Localization.getMessage("PORT").concat(":")));
        this.fldPort = new Field(isEdit ? port : "5190");
        this.fldPort.setFocusable(true);
        this.pane.addItem(this.fldPort);
        this.isUseSsl = new Check(Localization.getMessage("USE_SSL").concat(":"), isEdit ? ussl : true);
        this.isUseSsl.setFocusable(true);
        this.pane.addItem(this.isUseSsl);
        if (isEdit) {
            switch (this.protocolSwitcher.getCombed()) {
                case 0: {
                    this.protName.setCaption(Localization.getMessage("UIN").concat(":"));
                    this.fldLogin.constraints = 1;
                    this.isUseSsl.setFocusable(false);
                    break;
                }
                case 1: {
                    this.protName.setCaption(Localization.getMessage("MAIL_RU_EMAIL").concat(":"));
                    this.fldLogin.constraints = 1;
                    this.isUseSsl.setFocusable(false);
                    break;
                }
                case 2: {
                    this.protName.setCaption(Localization.getMessage("JID").concat(":"));
                    this.fldLogin.constraints = 1;
                    this.isUseSsl.setFocusable(true);
                }
            }
        }
        this.setGObject(this.pane);
    }
}

