/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.icq.CapUtil;
import com.tomclaw.mandarin.icq.Capability;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.IcqItem;
import com.tomclaw.mandarin.icq.IcqPacketSender;
import com.tomclaw.mandarin.icq.IcqStatusUtil;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.DataUtil;

public class StatusReaderFrame
extends Window {
    private Label statusText;
    private Label xStatusDescr;
    private Pane pane;
    private Capability capability;
    public byte[] plainCookie = new byte[8];
    public byte[] xStatCookie = new byte[8];

    public StatusReaderFrame(final IcqAccountRoot icqAccountRoot, final IcqItem icqItem) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("STATUS_OF").concat(" ").concat(icqItem.getUserNick()));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CLOSE")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(StatusReaderFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("COPY")){

            public void actionPerformed() {
                MidletMain.buffer = Localization.getMessage("STATUS_OF").concat(" ").concat(icqItem.getUserNick()).concat("\n").concat(Localization.getMessage("PLAIN_STATUS")).concat("\n").concat(Localization.getMessage(IcqStatusUtil.getStatusDescr(icqItem.getStatusIndex())));
                if (icqAccountRoot.statusIndex != 0) {
                    MidletMain.buffer = MidletMain.buffer + "\n".concat(StatusReaderFrame.this.statusText.getContent().getText());
                }
                if (StatusReaderFrame.this.capability != null) {
                    MidletMain.buffer = MidletMain.buffer + "\n".concat(Localization.getMessage("X_STATUS")).concat("\n").concat(Localization.getMessage(((StatusReaderFrame)StatusReaderFrame.this).capability.capIcon));
                    if (icqAccountRoot.statusIndex != 0) {
                        MidletMain.buffer = MidletMain.buffer + "\n".concat(StatusReaderFrame.this.xStatusDescr.getContent().getText());
                    }
                }
            }
        };
        this.pane = new Pane(null, false);
        Label statusHeader = new Label(Localization.getMessage("PLAIN_STATUS"));
        statusHeader.setTitle(true);
        this.pane.addItem(statusHeader);
        Label statusLabel = new Label(Localization.getMessage(IcqStatusUtil.getStatusDescr(icqItem.getStatusIndex())));
        this.pane.addItem(statusLabel);
        if (icqAccountRoot.statusIndex != 0) {
            this.statusText = new Label(Localization.getMessage("REQUESTING"));
            this.pane.addItem(this.statusText);
        }
        this.capability = CapUtil.getCapabilityByType(icqItem.capabilities, 3);
        if (this.capability != null) {
            Label xStatusHeader = new Label(Localization.getMessage("X_STATUS"));
            xStatusHeader.setTitle(true);
            this.pane.addItem(xStatusHeader);
            Label xStatusLabel = new Label(Localization.getMessage(this.capability.capIcon));
            this.pane.addItem(xStatusLabel);
            if (icqAccountRoot.statusIndex != 0) {
                this.xStatusDescr = new Label(Localization.getMessage("REQUESTING"));
                this.pane.addItem(this.xStatusDescr);
            }
        }
        this.setGObject(this.pane);
        if (icqAccountRoot.statusIndex != 0) {
            this.startStatusReading(icqAccountRoot, icqItem);
        }
    }

    public final void startStatusReading(IcqAccountRoot icqAccountRoot, IcqItem icqItem) {
        DataUtil.nextBytes(this.plainCookie);
        IcqPacketSender.requestStatusMessage(icqAccountRoot.session, this.plainCookie, icqItem.userId);
        DataUtil.nextBytes(this.xStatCookie);
        IcqPacketSender.requestXStatusText(icqAccountRoot.session, icqAccountRoot.userId, this.xStatCookie, icqItem.userId);
    }

    public void setPlainStatusText(String text) {
        this.statusText.setCaption(text);
        MidletMain.screen.repaint();
    }

    public void setXStatusText(String title, String description) {
        this.xStatusDescr.setCaption(title.concat(" ").concat(description));
        MidletMain.screen.repaint();
    }
}

