/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.icq.CapUtil;
import com.tomclaw.mandarin.icq.IcqSession;
import com.tomclaw.mandarin.icq.IcqStatusUtil;
import com.tomclaw.mandarin.icq.Snac;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.net.BinarySpore;
import com.tomclaw.tompacket.PacketBuilder;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.LogUtil;
import java.util.Hashtable;

public class IcqPacketSender {
    public static final int TLV_AV_AUTH = 102;
    public static final int TLV_GR_IDS = 200;
    public static final int TLV_UNK = 201;
    public static final int TLV_AIM_PR_SET = 202;
    public static final int TLV_VIS_CLASS = 203;
    public static final int TLV_ALL_OTH_SEE = 204;
    public static final int TLV_SHORTCUT = 205;
    public static final int TLV_IMPORT_TIME = 212;
    public static final int TLV_BUDDY_ICON = 213;
    public static final int TLV_NICK_NAME = 305;
    public static final int TLV_MAIL_ADDR = 311;
    public static final int TLV_SMS_NUMBER = 314;
    public static final int TLV_BUDDY_COMMENT = 316;
    public static final int TLV_PERS_ALERTS = 317;
    public static final int TLV_SOUND_BUDDY = 318;
    public static final int TLV_FIRST_MESS = 325;

    public static byte[] sendMessage(final IcqSession icqSession, final String buddyId, final String msgText) {
        final byte[] msgCookie = new byte[8];
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                DataUtil.nextBytes(msgCookie);
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("DATAGRAM_SEQ_NUM", new Integer(icqSession.getNextSeq()));
                data.put("FLAP_DATA_SIZE", "SNAC");
                data.put("FLAP_DATA", "SNAC");
                data.put("SERVICE_ID", new Integer(4));
                data.put("SUBTYPE_ID", new Integer(6));
                data.put("SNAC_REQUEST_ID", new Long(17L));
                data.put("SNAC_DATA", "CLI_SEND_ICBM");
                data.put("MSG_ID_COOKIE", msgCookie);
                data.put("SCREENNAME", buddyId);
                data.put("MESSAGE_TEXT_STRING", msgText);
                PacketBuilder.writePacket(this, "FLAP", data);
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return msgCookie;
    }

    public static Cookie sendMsgAck(final IcqSession icqSession, final int chanel, final String userId, final byte[] cookies) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("DATAGRAM_SEQ_NUM", new Integer(icqSession.getNextSeq()));
                data.put("FLAP_DATA_SIZE", "SNAC");
                data.put("FLAP_DATA", "SNAC");
                data.put("SERVICE_ID", new Integer(4));
                data.put("SUBTYPE_ID", new Integer(11));
                data.put("SNAC_REQUEST_ID", new Long(cookie.cookieValue));
                data.put("SNAC_DATA", "CLI_MSG_ACK");
                data.put("MSG_COOKIE", cookies);
                data.put("MSG_CHANNEL", new Integer(chanel));
                data.put("SCREENNAME", userId);
                PacketBuilder.writePacket(this, "FLAP", data);
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie setStatus(final IcqSession icqSession, final int statusId) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac snac = new Snac(1, 30, 0, 0, cookie.cookieValue);
                snac.addByteArray(new byte[]{0, 6, 0, 4});
                snac.addWord(1);
                snac.addWord(statusId);
                snac.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie setUpdatePrivacy(final IcqSession icqSession, final int privateBuddyId, final int privacyStatus) {
        Cookie cookie;
        if (privateBuddyId != -1) {
            cookie = new Cookie();
            BinarySpore binarySpore = new BinarySpore(){

                public void onRun() throws Throwable {
                    Snac snac = new Snac(19, 9, 0, 0, cookie.cookieValue);
                    snac.addWord(0);
                    snac.addWord(0);
                    snac.addWord(privateBuddyId);
                    snac.addWord(4);
                    snac.addWord(5);
                    snac.addWord(202);
                    snac.addWord(1);
                    snac.addByte(privacyStatus);
                    snac.send(this, icqSession.getNextSeq());
                }
            };
            icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        } else {
            cookie = null;
            LogUtil.outMessage("No private buddy");
        }
        return cookie;
    }

    public static Cookie addPrivacy(final IcqSession icqSession, final String user_uin, int groupId, final int itemId, final int itemFlag) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 8, 0, 0, cookie.cookieValue);
                p.addWordLString(user_uin);
                p.addWord(0);
                p.addWord(itemId);
                p.addWord(itemFlag);
                p.addWord(0);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie deletePrivacy(final IcqSession icqSession, final String user_uin, int groupId, final int itemId, final int itemFlag) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 10, 0, 0, cookie.cookieValue);
                p.addWordLString(user_uin);
                p.addWord(0);
                p.addWord(itemId);
                p.addWord(itemFlag);
                p.addWord(0);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie removeBuddy(final IcqSession icqSession, final String buddyId, final int groupId, final int itemId, final int itemFlag) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 10, 0, 0, cookie.cookieValue);
                p.addWordLString(buddyId);
                p.addWord(groupId);
                p.addWord(itemId);
                p.addWord(itemFlag);
                p.addWord(0);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie addBuddy(final IcqSession icqSession, final byte[] buddyId, final int groupId, final int itemId, final int itemFlag, final boolean authReq, final byte[] nickName) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 8, 0, 0, cookie.cookieValue);
                p.addWord(buddyId.length);
                p.addByteArray(buddyId);
                p.addWord(groupId);
                p.addWord(itemId);
                p.addWord(itemFlag);
                Snac p1 = new Snac(19, 8, 0, 0, cookie.cookieValue);
                if (authReq) {
                    p1.addTlv(102, new byte[0]);
                }
                if (nickName != null) {
                    p1.addTlv(305, nickName);
                }
                byte[] buffer = new byte[p1.getByteArray().toByteArray().length - 10];
                System.arraycopy(p1.getByteArray().toByteArray(), 10, buffer, 0, p1.getByteArray().toByteArray().length - 10);
                p.addWord(buffer.length);
                p.addByteArray(buffer);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie updateBuddy(final IcqSession icqSession, final byte[] buddyId, final int groupId, final int itemId, final int itemFlag, final boolean authReq, final byte[] nickName) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 9, 0, 0, cookie.cookieValue);
                p.addWord(buddyId.length);
                p.addByteArray(buddyId);
                p.addWord(groupId);
                p.addWord(itemId);
                p.addWord(itemFlag);
                Snac p1 = new Snac(19, 9, 0, 0, cookie.cookieValue);
                if (authReq) {
                    p1.addTlv(102, new byte[0]);
                }
                if (nickName != null) {
                    p1.addTlv(305, nickName);
                }
                byte[] buffer = new byte[p1.getByteArray().toByteArray().length - 10];
                System.arraycopy(p1.getByteArray().toByteArray(), 10, buffer, 0, p1.getByteArray().toByteArray().length - 10);
                p.addWord(buffer.length);
                p.addByteArray(buffer);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie removeYourself(final IcqSession icqSession, final String buddyId) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 22, 0, 0, cookie.cookieValue);
                p.addByteLString(buddyId);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie authRequest(final IcqSession icqSession, final String buddyId, final byte[] reasonMsg) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 24, 0, 0, cookie.cookieValue);
                p.addByteLString(buddyId);
                p.addWord(reasonMsg.length);
                p.addByteArray(reasonMsg);
                p.addWord(0);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie authReply(final IcqSession icqSession, final String buddyId, final boolean isAccepted, final byte[] reasonMsg) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(19, 26, 0, 0, cookie.cookieValue);
                p.addByteLString(buddyId);
                p.addByte(isAccepted ? 1 : 0);
                p.addWord(reasonMsg.length);
                p.addByteArray(reasonMsg);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie shortInfoRequest(final IcqSession icqSession, final String userId, int reqSeqNum) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("DATAGRAM_SEQ_NUM", new Integer(icqSession.getNextSeq()));
                data.put("FLAP_DATA_SIZE", "SNAC");
                data.put("FLAP_DATA", "SNAC");
                data.put("SERVICE_ID", new Integer(37));
                data.put("SUBTYPE_ID", new Integer(2));
                data.put("SNAC_REQUEST_ID", new Long(cookie.cookieValue));
                data.put("SNAC_DATA", "CLI_USER_INFO_REQUEST");
                data.put("MAP_NAME", "CLI_USER_INFO_REQUEST:BLOCK_OSCAR");
                data.put("SCREENNAME", userId);
                PacketBuilder.writePacket(this, "FLAP", data);
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static void sendKeepAlive(final IcqSession icqSession) {
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                this.write(Snac.createFlapHeader(5, icqSession.getNextSeq(), 0));
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
    }

    public static Cookie sendCapabilities(final IcqSession icqSession, final int xStatusId, final int aStatusId) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                int major = Integer.parseInt(MidletMain.version.substring(0, MidletMain.version.indexOf(".")));
                int minor = Integer.parseInt(MidletMain.version.substring(MidletMain.version.indexOf(".") + 1));
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("DATAGRAM_SEQ_NUM", new Integer(icqSession.getNextSeq()));
                data.put("FLAP_DATA_SIZE", "SNAC");
                data.put("FLAP_DATA", "SNAC");
                data.put("SERVICE_ID", new Integer(2));
                data.put("SUBTYPE_ID", new Integer(4));
                data.put("SNAC_REQUEST_ID", new Long(cookie.cookieValue));
                data.put("SNAC_DATA", "CLI_SET_LOCATION_INFO");
                if (!MidletMain.isTest) {
                    data.put("IS_TEST_BUILD", "NULL");
                }
                data.put("MANDARIN_ID", new byte[]{77, 97, 110, 100, 97, 114, 105, 110, 32, 73, 77, 0, 1, (byte)major, (byte)minor, 0});
                if (xStatusId != -1) {
                    data.put("CAP_XSTATUS", CapUtil.getXStatusCap(xStatusId));
                }
                if (aStatusId >= 4096) {
                    data.put("CAP_EXT_STATUS", IcqStatusUtil.getAStatusCap(aStatusId));
                }
                PacketBuilder.writePacket(this, "FLAP", data);
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie requestOfflineMessages(final IcqSession icqSession, final String buddyId) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(21, 2, 0, 0, cookie.cookieValue);
                p.addWord(1);
                p.addWord(10);
                p.addWordReversed(8);
                p.addDWordReversed(Long.parseLong(buddyId));
                p.addWordReversed(60);
                p.addWord(1);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie requestStatusMessage(final IcqSession icqSession, final byte[] cookies, final String buddyId) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("DATAGRAM_SEQ_NUM", new Integer(icqSession.getNextSeq()));
                data.put("FLAP_DATA_SIZE", "SNAC");
                data.put("FLAP_DATA", "SNAC");
                data.put("SERVICE_ID", new Integer(4));
                data.put("SUBTYPE_ID", new Integer(6));
                data.put("SNAC_REQUEST_ID", new Long(cookie.cookieValue));
                data.put("SNAC_DATA", "CLI_SEND_ICBM_CH2");
                data.put("MSG_ID_COOKIE", cookies);
                data.put("SCREENNAME", buddyId);
                PacketBuilder.writePacket(this, "FLAP", data);
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie sendStatusMessage(final IcqSession icqSession, final byte[] cookies, final String buddyId, final String statusText) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Hashtable<String, Object> data = new Hashtable<String, Object>();
                data.put("DATAGRAM_SEQ_NUM", new Integer(icqSession.getNextSeq()));
                data.put("FLAP_DATA_SIZE", "SNAC");
                data.put("FLAP_DATA", "SNAC");
                data.put("SERVICE_ID", new Integer(4));
                data.put("SUBTYPE_ID", new Integer(11));
                data.put("SNAC_REQUEST_ID", new Long(cookie.cookieValue));
                data.put("SNAC_DATA", "CLI_ICBM_SEND_STATUS_MSG");
                data.put("ICBM_COOKIE", cookies);
                data.put("SCREENNAME", buddyId);
                data.put("STATUS_TEXT", statusText);
                PacketBuilder.writePacket(this, "FLAP", data);
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie sendXStatusText(final IcqSession icqSession, final String userId, final byte[] cookies, final String buddyId, final byte[] xTitle, final byte[] xText) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(4, 11, 0, 0, cookie.cookieValue);
                p.addByteArray(cookies);
                p.addWord(2);
                p.addByteLString(buddyId);
                p.addWord(3);
                ArrayUtil extendedData = new ArrayUtil(new byte[]{27, 0});
                extendedData.append(new byte[]{8, 0});
                extendedData.append(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
                extendedData.append(new byte[]{0, 0});
                extendedData.append(new byte[]{3, 0, 0, 0});
                extendedData.append(new byte[]{4});
                extendedData.append(new byte[]{-2, -1});
                extendedData.append(new byte[]{14, 0});
                extendedData.append(new byte[]{-2, -1});
                extendedData.append(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
                extendedData.append(new byte[]{26});
                extendedData.append(new byte[]{0});
                extendedData.append(new byte[]{0, 0});
                extendedData.append(new byte[]{0, 0});
                extendedData.append(new byte[]{1, 0});
                extendedData.append(new byte[]{0});
                extendedData.append(new byte[]{79, 0, 59, 96, -77, -17, -40, 42, 108, 69, -92, -32, -100, 90, 94, 103, -24, 101, 8, 0, 42, 0, 0, 0});
                extendedData.append("Script Plug-in: Remote Notification Arrive".getBytes());
                extendedData.append(new byte[]{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -99, 1, 0, 0, -103, 1, 0, 0});
                String xTextResp = "<NR><RES>&lt;ret event='OnRemoteNotification'&gt;&lt;srv&gt;&lt;id&gt;cAwaySrv&lt;/id&gt;&lt;val srv_id='cAwaySrv'&gt;&lt;Root&gt;&lt;CASXtraSetAwayMessage&gt;&lt;/CASXtraSetAwayMessage&gt;&lt;uin&gt;" + userId + "&lt;" + "/uin&gt;&lt;index&gt;4&lt;/index&gt;&lt;title&gt;" + new String(xTitle) + "&lt;/title&gt;&lt;desc&gt;" + new String(xText) + "&lt;/desc&gt;&lt;/Root&gt;&lt;/val&gt;&lt;/srv&gt;&lt;" + "/ret&gt;</RES></NR>";
                extendedData.append(xTextResp.getBytes());
                p.addByteArray(extendedData.byteString);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie requestXStatusText(final IcqSession icqSession, final String userId, final byte[] cookies, final String buddyId) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(4, 6, 0, 0, cookie.cookieValue);
                p.addByteArray(cookies);
                p.addWord(2);
                p.addByteLString(buddyId);
                p.addWord(5);
                ArrayUtil radezvousData = new ArrayUtil();
                radezvousData.append(new byte[]{0, 0});
                radezvousData.append(cookies);
                radezvousData.append(new byte[]{9, 70, 19, 73, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
                radezvousData.append(new byte[]{0, 10, 0, 2, 0, 1});
                radezvousData.append(new byte[]{0, 15, 0, 0});
                radezvousData.append(new byte[]{39, 17});
                ArrayUtil extendedData = new ArrayUtil(new byte[]{27, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, -2, -1, 14, 0, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 1, 0, 1, 0, 0, 79, 0, 59, 96, -77, -17, -40, 42, 108, 69, -92, -32, -100, 90, 94, 103, -24, 101, 8, 0, 42, 0, 0, 0, 83, 99, 114, 105, 112, 116, 32, 80, 108, 117, 103, 45, 105, 110, 58, 32, 82, 101, 109, 111, 116, 101, 32, 78, 111, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 114, 114, 105, 118, 101, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 1, 0, 0, 15, 1, 0, 0, 60, 78, 62, 60, 81, 85, 69, 82, 89, 62, 38, 108, 116, 59, 81, 38, 103, 116, 59, 38, 108, 116, 59, 80, 108, 117, 103, 105, 110, 73, 68, 38, 103, 116, 59, 115, 114, 118, 77, 110, 103, 38, 108, 116, 59, 47, 80, 108, 117, 103, 105, 110, 73, 68, 38, 103, 116, 59, 38, 108, 116, 59, 47, 81, 38, 103, 116, 59, 60, 47, 81, 85, 69, 82, 89, 62, 60, 78, 79, 84, 73, 70, 89, 62, 38, 108, 116, 59, 115, 114, 118, 38, 103, 116, 59, 38, 108, 116, 59, 105, 100, 38, 103, 116, 59, 99, 65, 119, 97, 121, 83, 114, 118, 38, 108, 116, 59, 47, 105, 100, 38, 103, 116, 59, 38, 108, 116, 59, 114, 101, 113, 38, 103, 116, 59, 38, 108, 116, 59, 105, 100, 38, 103, 116, 59, 65, 119, 97, 121, 83, 116, 97, 116, 38, 108, 116, 59, 47, 105, 100, 38, 103, 116, 59, 38, 108, 116, 59, 116, 114, 97, 110, 115, 38, 103, 116, 59, 49, 38, 108, 116, 59, 47, 116, 114, 97, 110, 115, 38, 103, 116, 59, 38, 108, 116, 59, 115, 101, 110, 100, 101, 114, 73, 100, 38, 103, 116, 59});
                extendedData.append(userId.getBytes());
                extendedData.append(new byte[]{38, 108, 116, 59, 47, 115, 101, 110, 100, 101, 114, 73, 100, 38, 103, 116, 59, 38, 108, 116, 59, 47, 114, 101, 113, 38, 103, 116, 59, 38, 108, 116, 59, 47, 115, 114, 118, 38, 103, 116, 59, 60, 47, 78, 79, 84, 73, 70, 89, 62, 60, 47, 78, 62});
                p.addWord(radezvousData.byteString.length + 2 + extendedData.byteString.length);
                p.addByteArray(radezvousData.byteString);
                p.addWord(extendedData.byteString.length);
                p.addByteArray(extendedData.byteString);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie sendTypingStatus(final IcqSession icqSession, final String buddyId, final boolean typingStatus) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Snac p = new Snac(4, 20, 0, 0, cookie.cookieValue);
                p.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                p.addWord(1);
                p.addByteLString(buddyId);
                p.addWord(typingStatus ? 2 : 0);
                p.send(this, icqSession.getNextSeq());
            }
        };
        icqSession.getNetworkConnection().outputStream.releaseSpore(binarySpore);
        return cookie;
    }
}

