/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.icq.Capability;
import com.tomclaw.mandarin.icq.ClientInfo;
import com.tomclaw.mandarin.icq.IcqDirectConnection;
import com.tomclaw.mandarin.icq.IcqGroup;
import com.tomclaw.mandarin.icq.IcqItem;
import com.tomclaw.mandarin.icq.IcqPacketSender;
import com.tomclaw.mandarin.icq.IcqSession;
import com.tomclaw.mandarin.icq.IcqStatusUtil;
import com.tomclaw.mandarin.icq.LegacyProtocolException;
import com.tomclaw.mandarin.icq.LoginFailedException;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.net.IncorrectAddressException;
import com.tomclaw.mandarin.net.NetConnection;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class IcqAccountRoot
extends AccountRoot {
    public Vector t_OnlineItems = new Vector();
    public int xStatusId = -1;
    public int pStatusId = 1;
    public int privateBuddyId = -1;
    public String xTitle = "";
    public String xText = "";
    public boolean isXStatusReadable = true;
    public IcqSession session;

    public IcqAccountRoot(String userId) {
        super(userId);
    }

    public void construct() {
        this.host = "login.icq.com";
        this.port = "5190";
    }

    public void initSpecialData() {
        this.session = new IcqSession(this);
        this.xStatusId = MidletMain.getInteger(MidletMain.accounts, this.userId, "xStatusId");
        this.pStatusId = MidletMain.getInteger(MidletMain.accounts, this.userId, "pStatusId");
        this.privateBuddyId = MidletMain.getInteger(MidletMain.accounts, this.userId, "privateBuddyId");
        String extStatusText = MidletMain.getString(MidletMain.statuses, "XStatus", String.valueOf(this.xStatusId));
        if (extStatusText == null || extStatusText.length() == 0) {
            extStatusText = "&dsc";
        }
        this.xTitle = extStatusText.substring(0, extStatusText.indexOf("&dsc"));
        this.xText = extStatusText.substring(extStatusText.indexOf("&dsc") + 4, extStatusText.indexOf("&rdb") == -1 ? extStatusText.length() : extStatusText.indexOf("&rdb"));
        this.isXStatusReadable = extStatusText.indexOf("&rdb") == -1 ? false : extStatusText.substring(extStatusText.indexOf("&rdb") + 4).equals("true");
    }

    public void saveSpecialSettings() throws Throwable {
        MidletMain.accounts.addItem(this.userId, "xStatusId", String.valueOf(this.xStatusId));
        MidletMain.accounts.addItem(this.userId, "pStatusId", String.valueOf(this.pStatusId));
        MidletMain.accounts.addItem(this.userId, "privateBuddyId", String.valueOf(this.privateBuddyId));
    }

    public void show() {
    }

    public String getAccType() {
        return "icq";
    }

    public void sendTypingStatus(String userId, boolean b) {
        IcqPacketSender.sendTypingStatus(this.session, userId, b);
    }

    public void connectAction(final int statusIndex) {
        if (this.isConnecting || this.statusIndex != 0) {
            return;
        }
        new Thread(){

            public void run() {
                IcqAccountRoot.this.isConnecting = true;
                try {
                    do {
                        String errorCause;
                        if (MidletMain.httpHiddenPing > 0) {
                            try {
                                NetConnection.httpPing("http://www.icq.com");
                            }
                            catch (IOException ex) {
                                LogUtil.outMessage("HTTP hidden connection failed");
                            }
                        }
                        NetConnection netConnection = new NetConnection();
                        boolean isFail = false;
                        try {
                            Handler.setConnectionStage(IcqAccountRoot.this, 0);
                            netConnection.connectAddress(IcqAccountRoot.this.host + ":" + IcqAccountRoot.this.port);
                            Handler.setConnectionStage(IcqAccountRoot.this, 1);
                            IcqAccountRoot.this.session.setNetConnection(netConnection);
                            IcqAccountRoot.this.session.isRequestSsi = false;
                            IcqAccountRoot.this.session.login(IcqStatusUtil.getStatus(statusIndex));
                            IcqAccountRoot.this.statusIndex = statusIndex;
                            MidletMain.mainFrame.updateAccountsStatus();
                            IcqAccountRoot.this.isConnecting = false;
                            return;
                        }
                        catch (LoginFailedException ex) {
                            LogUtil.outMessage("Failed");
                            errorCause = Localization.getMessage("FAILED");
                            isFail = true;
                        }
                        catch (LegacyProtocolException ex) {
                            LogUtil.outMessage("Protocol support became old");
                            errorCause = Localization.getMessage("PROTOCOL_SUPPORT_BECAME_OLD");
                            isFail = true;
                        }
                        catch (InterruptedException ex) {
                            LogUtil.outMessage("Failed: " + ex.getMessage());
                            errorCause = Localization.getMessage("INTERRUPTED");
                        }
                        catch (IOException ex) {
                            LogUtil.outMessage("IO Exception");
                            errorCause = Localization.getMessage("IO_EXCEPTION");
                        }
                        catch (IncorrectAddressException ex) {
                            LogUtil.outMessage("Incorrect address");
                            errorCause = Localization.getMessage("INCORRECT_ADDRESS");
                            isFail = true;
                        }
                        catch (Throwable ex) {
                            LogUtil.outMessage("Throwable");
                            errorCause = Localization.getMessage("INCORRECT_ADDRESS");
                            isFail = true;
                        }
                        if (errorCause != null) {
                            Handler.showError(errorCause);
                            if (isFail) {
                                IcqAccountRoot.this.isConnecting = false;
                                return;
                            }
                        }
                        Thread.sleep(MidletMain.reconnectTime);
                    } while (MidletMain.autoReconnect);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IcqAccountRoot.this.isConnecting = false;
            }
        }.start();
    }

    public void setTreeItems(Vector buddyList) {
        LogUtil.outMessage("setTreeItems for " + buddyList.size());
        if (this.isReset) {
            LogUtil.outMessage("reset node");
            this.t_OnlineItems.removeAllElements();
            for (int c = 0; c < this.buddyItems.size(); ++c) {
                for (int j = 0; j < ((GroupHeader)this.buddyItems.elementAt(c)).getChildsCount(); ++j) {
                    IcqItem tempIcqItem = (IcqItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(j);
                    if (tempIcqItem.getStatusIndex() == 0) continue;
                    this.t_OnlineItems.addElement(tempIcqItem);
                }
            }
            this.buddyItems = buddyList;
        } else {
            LogUtil.outMessage("append node");
            for (int c = 0; c < buddyList.size(); ++c) {
                IcqGroup icqGroup = (IcqGroup)buddyList.elementAt(c);
                if (c == 0 && icqGroup.buddyType == -1) {
                    for (int i = 0; i < icqGroup.getChildsCount(); ++i) {
                        ((GroupHeader)this.buddyItems.lastElement()).getChilds().addElement(icqGroup.getChilds().elementAt(i));
                    }
                    continue;
                }
                this.buddyItems.addElement(buddyList.elementAt(c));
            }
        }
    }

    public void setPrivateItems(Vector privateList) {
        LogUtil.outMessage("Private list size: " + privateList.size());
        for (int i = 0; i < this.buddyItems.size(); ++i) {
            IcqGroup tempGroupItem = (IcqGroup)this.buddyItems.elementAt(i);
            for (int j = 0; j < tempGroupItem.getChildsCount(); ++j) {
                IcqItem tempIcqItem = (IcqItem)tempGroupItem.getChilds().elementAt(j);
                for (int q = 0; q < this.t_OnlineItems.size(); ++q) {
                    if (!tempIcqItem.userId.equals(((IcqItem)this.t_OnlineItems.elementAt((int)q)).userId)) continue;
                    tempIcqItem.setStatusIndex(((IcqItem)this.t_OnlineItems.elementAt(q)).getStatusIndex(), null);
                    tempIcqItem.capabilities = ((IcqItem)this.t_OnlineItems.elementAt((int)q)).capabilities;
                    tempIcqItem.clientInfo = ((IcqItem)this.t_OnlineItems.elementAt((int)q)).clientInfo;
                }
                for (int c = 0; c < privateList.size(); ++c) {
                    IcqItem privateItem = (IcqItem)privateList.elementAt(c);
                    if (!tempIcqItem.userId.equals(privateItem.userId)) continue;
                    if (privateItem.buddyType == 5) {
                        tempIcqItem.isInPermitList = true;
                        tempIcqItem.permitBuddyId = privateItem.buddyId;
                    } else if (privateItem.buddyType == 6) {
                        tempIcqItem.isInDenyList = true;
                        tempIcqItem.denyBuddyId = privateItem.buddyId;
                    } else if (privateItem.buddyType == 7) {
                        tempIcqItem.isInIgnoreList = true;
                        tempIcqItem.ignoreBuddyId = privateItem.buddyId;
                    }
                    tempIcqItem.updateUiData();
                    LogUtil.outMessage("Private data set");
                }
            }
        }
    }

    public IcqItem setBuddyStatus(String buddyId, int buddyStatus, Capability[] caps, ClientInfo clientInfo) {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            IcqGroup groupItem = (IcqGroup)this.buddyItems.elementAt(c);
            for (int i = 0; i < groupItem.getChildsCount(); ++i) {
                IcqItem icqItem = (IcqItem)groupItem.getChilds().elementAt(i);
                if (!icqItem.userId.equals(buddyId)) continue;
                icqItem.setStatusIndex(IcqStatusUtil.getStatusIndex(buddyStatus), null);
                icqItem.capabilities = caps;
                icqItem.clientInfo = clientInfo;
                icqItem.updateUiData();
                this.updateMainFrameBuddyList();
                return (IcqItem)groupItem.getChilds().elementAt(i);
            }
        }
        return null;
    }

    public int getBuddyStatus(String buddyId) {
        IcqItem icqItem = this.getBuddy(buddyId);
        if (icqItem != null) {
            return IcqStatusUtil.getStatus(icqItem.getStatusIndex());
        }
        return -1;
    }

    public IcqItem getBuddy(String buddyId) {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            IcqGroup groupItem = (IcqGroup)this.buddyItems.elementAt(c);
            for (int i = 0; i < groupItem.getChildsCount(); ++i) {
                if (!((IcqItem)groupItem.getChilds().elementAt((int)i)).userId.equals(buddyId)) continue;
                return (IcqItem)groupItem.getChilds().elementAt(i);
            }
        }
        return null;
    }

    public void updateMainFrameBuddyList() {
        for (int c = 0; c < this.buddyItems.size(); ++c) {
            for (int i = 0; i < ((GroupHeader)this.buddyItems.elementAt(c)).getChildsCount(); ++i) {
                ((BuddyItem)((GroupHeader)this.buddyItems.elementAt(c)).getChilds().elementAt(i)).updateUiData();
            }
        }
        this.updateMainFrameUI();
    }

    public void setUpdatePrivacy(int pStatus) {
        IcqPacketSender.setUpdatePrivacy(this.session, this.privateBuddyId, pStatus);
        this.pStatusId = pStatus;
        this.saveAllSettings();
    }

    public byte[] sendMessage(BuddyItem buddyItem, String string, String resource) {
        return IcqPacketSender.sendMessage(this.session, buddyItem.getUserId(), string);
    }

    public String getStatusImages() {
        return "/res/groups/img_icqstatus.png";
    }

    public BuddyGroup getGroupInstance() {
        return new IcqGroup();
    }

    public BuddyItem getBuddyInstance() {
        return new IcqItem();
    }

    public Cookie addGroup(BuddyGroup buddyGroup) {
        IcqGroup icqGroup = (IcqGroup)buddyGroup;
        icqGroup.groupId = this.getNextGroupId();
        return IcqPacketSender.addBuddy(this.session, StringUtil.stringToByteArray(icqGroup.getUserId(), true), icqGroup.groupId, 0, 1, false, null);
    }

    public Cookie addBuddy(BuddyItem buddyItem, BuddyGroup buddyGroup) {
        ((IcqItem)buddyItem).buddyId = this.getNextBuddyId();
        ((IcqItem)buddyItem).groupId = ((IcqGroup)buddyGroup).groupId;
        ((IcqItem)buddyItem).isAvaitingAuth = true;
        return IcqPacketSender.addBuddy(this.session, buddyItem.getUserId().getBytes(), ((IcqGroup)buddyGroup).groupId, ((IcqItem)buddyItem).buddyId, 0, true, StringUtil.stringToByteArray(buddyItem.getUserNick(), true));
    }

    public Cookie renameBuddy(String itemName, BuddyItem buddyItem, String phones) {
        return IcqPacketSender.updateBuddy(this.session, buddyItem.getUserId().getBytes(), ((IcqItem)buddyItem).groupId, ((IcqItem)buddyItem).buddyId, 0, ((IcqItem)buddyItem).isAvaitingAuth, StringUtil.stringToByteArray(itemName, true));
    }

    public Cookie renameGroup(String itemName, BuddyGroup buddyGroup) {
        return IcqPacketSender.updateBuddy(this.session, StringUtil.stringToByteArray(itemName, true), ((IcqGroup)buddyGroup).groupId, 0, 1, false, null);
    }

    public void requestAuth(String requestText, BuddyItem buddyItem) {
        IcqPacketSender.authRequest(this.session, buddyItem.getUserId(), StringUtil.stringToByteArray(requestText, true));
    }

    public void acceptAuthorization(BuddyItem buddyItem) {
        IcqPacketSender.authReply(this.session, buddyItem.getUserId(), true, StringUtil.stringToByteArray(Localization.getMessage("DEFAULT_ACCEPT"), true));
    }

    public void requestInfo(String userId, int reqSeqNum) {
        IcqPacketSender.shortInfoRequest(this.session, userId, reqSeqNum);
    }

    public Cookie removeBuddy(BuddyItem buddyItem) {
        return IcqPacketSender.removeBuddy(this.session, buddyItem.getUserId(), ((IcqItem)buddyItem).groupId, ((IcqItem)buddyItem).buddyId, ((IcqItem)buddyItem).buddyType);
    }

    public Cookie removeGroup(BuddyGroup buddyGroup) {
        return IcqPacketSender.removeBuddy(this.session, buddyGroup.getUserId(), ((IcqGroup)buddyGroup).groupId, ((IcqGroup)buddyGroup).buddyId, ((IcqGroup)buddyGroup).buddyType);
    }

    public DirectConnection getDirectConnectionInstance() {
        return new IcqDirectConnection(this);
    }

    public int getNextBuddyId() {
        int randInt = 0;
        boolean isComprare = false;
        while (!isComprare) {
            Random rand = new Random(System.currentTimeMillis());
            randInt = rand.nextInt();
            if (randInt < 0) {
                randInt *= -1;
            }
            randInt = randInt % 28671 + 4096;
            isComprare = true;
            block1: for (int c = 0; c < this.buddyItems.size(); ++c) {
                IcqGroup groupItem = (IcqGroup)this.buddyItems.elementAt(c);
                for (int i = 0; i < groupItem.getChildsCount(); ++i) {
                    if (((IcqItem)groupItem.getChilds().elementAt((int)i)).buddyId != randInt && ((IcqItem)groupItem.getChilds().elementAt((int)i)).groupId != randInt) continue;
                    isComprare = false;
                    continue block1;
                }
            }
        }
        return randInt;
    }

    public int getNextGroupId() {
        return this.getNextBuddyId();
    }

    public String getStatusDescr(int statusIndex) {
        return IcqStatusUtil.getStatusDescr(statusIndex);
    }
}

