/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.icq.CapUtil;
import com.tomclaw.mandarin.icq.Capability;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.IcqItem;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Tab;
import com.tomclaw.tcuilite.TabEvent;
import com.tomclaw.tcuilite.TabItem;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.TimeUtil;

public class ClientInfoFrame
extends Window {
    private Pane plainInfoPane;
    private Pane dcInfoPane;
    private List capsInfoList;
    private String clientBuffer = "";
    private Tab tab;

    public ClientInfoFrame(IcqAccountRoot icqAccountRoot, IcqItem icqItem) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("CLIENT_INFO"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CLOSE")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(ClientInfoFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("COPY")){

            public void actionPerformed() {
                MidletMain.buffer = ClientInfoFrame.this.clientBuffer;
            }
        };
        this.initPanes(icqItem);
        this.tab = new Tab(this.screen);
        this.tab.setGObject(this.plainInfoPane);
        this.tab.addTabItem(new TabItem(Localization.getMessage("PLAIN_INFO"), 0, -1));
        this.tab.addTabItem(new TabItem(Localization.getMessage("DC_INFO"), 0, -1));
        this.tab.addTabItem(new TabItem(Localization.getMessage("CAPS_INFO"), 0, -1));
        this.tab.selectedIndex = 0;
        this.tab.tabEvent = new TabEvent(){

            public void stateChanged(int i, int i1, int i2) {
                switch (i1) {
                    case 0: {
                        ClientInfoFrame.this.tab.setGObject(ClientInfoFrame.this.plainInfoPane);
                        break;
                    }
                    case 1: {
                        ClientInfoFrame.this.tab.setGObject(ClientInfoFrame.this.dcInfoPane);
                        break;
                    }
                    case 2: {
                        ClientInfoFrame.this.tab.setGObject(ClientInfoFrame.this.capsInfoList);
                    }
                }
            }
        };
        this.setGObject(this.tab);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void initPanes(IcqItem icqItem) {
        Label descriptionLabel;
        Label onlineLabel;
        int c;
        String labelMessage = "";
        String labelDescription = "";
        this.plainInfoPane = new Pane(null, false);
        this.plainInfoPane.setTouchOrientation(MidletMain.screen.isPointerEvents);
        block18: for (c = 0; c < 5; ++c) {
            onlineLabel = new Label("");
            onlineLabel.setTitle(true);
            descriptionLabel = new Label("");
            switch (c) {
                case 0: {
                    LogUtil.outMessage("CLIENTID_LABEL");
                    Capability capability = CapUtil.getCapabilityByType(icqItem.capabilities, 2);
                    if (capability == null || capability.capName.equals("")) continue block18;
                    labelMessage = "CLIENTID_LABEL";
                    labelDescription = capability.capName;
                    LogUtil.outMessage("capability.capName=" + capability.capName);
                    LogUtil.outMessage("capability.capIcon=" + capability.capIcon);
                    break;
                }
                case 1: {
                    LogUtil.outMessage("SIGNONTIME_LABEL");
                    if (icqItem.clientInfo.signOnTime == 0L) continue block18;
                    labelMessage = "SIGNONTIME_LABEL";
                    LogUtil.outMessage(labelMessage + ": " + icqItem.clientInfo.signOnTime);
                    labelDescription = TimeUtil.getDateString(TimeUtil.getMentionedTimeGMT(icqItem.clientInfo.signOnTime), true);
                    break;
                }
                case 2: {
                    LogUtil.outMessage("ONLINETIME_LABEL");
                    if (System.currentTimeMillis() / 1000L - icqItem.clientInfo.onLineTime == 0L) continue block18;
                    labelMessage = "ONLINETIME_LABEL";
                    LogUtil.outMessage(labelMessage + ": " + icqItem.clientInfo.onLineTime);
                    labelDescription = TimeUtil.getTimeString(System.currentTimeMillis() / 1000L - icqItem.clientInfo.onLineTime, true);
                    break;
                }
                case 3: {
                    LogUtil.outMessage("IDLE_LABEL");
                    if (icqItem.clientInfo.idleTime == 0) continue block18;
                    labelMessage = "IDLE_LABEL";
                    labelDescription = TimeUtil.getTimeString(icqItem.clientInfo.idleTime, true);
                    break;
                }
                case 4: {
                    LogUtil.outMessage("MEMBERSINCETIME_LABEL");
                    if (icqItem.clientInfo.memberSinceTime == 0L) continue block18;
                    labelMessage = "MEMBERSINCETIME_LABEL";
                    labelDescription = TimeUtil.getDateString(TimeUtil.getMentionedTimeGMT(icqItem.clientInfo.memberSinceTime), true);
                }
            }
            onlineLabel.setCaption(Localization.getMessage(labelMessage) + ": ");
            descriptionLabel.setCaption(labelDescription);
            this.clientBuffer = this.clientBuffer + onlineLabel.getContent().getText() + "\n";
            this.clientBuffer = this.clientBuffer + labelDescription + "\n";
            this.plainInfoPane.addItem(onlineLabel);
            this.plainInfoPane.addItem(descriptionLabel);
        }
        this.dcInfoPane = new Pane(null, false);
        this.dcInfoPane.setTouchOrientation(MidletMain.screen.isPointerEvents);
        labelMessage = "";
        labelDescription = "";
        block19: for (c = 0; c < 9; ++c) {
            onlineLabel = new Label("");
            onlineLabel.setTitle(true);
            descriptionLabel = new Label("");
            switch (c) {
                case 0: {
                    LogUtil.outMessage("EXTERNALIP_LABEL");
                    if (icqItem.clientInfo.externalIp[0] == 0 && icqItem.clientInfo.externalIp[1] == 0 && icqItem.clientInfo.externalIp[2] == 0 && icqItem.clientInfo.externalIp[3] == 0) continue block19;
                    labelMessage = "EXTERNALIP_LABEL";
                    labelDescription = icqItem.clientInfo.externalIp[0] + "." + icqItem.clientInfo.externalIp[1] + "." + icqItem.clientInfo.externalIp[2] + "." + icqItem.clientInfo.externalIp[3];
                    break;
                }
                case 1: {
                    LogUtil.outMessage("INTERNALIP_LABEL");
                    if (icqItem.clientInfo.internalIp[0] == 0 && icqItem.clientInfo.internalIp[1] == 0 && icqItem.clientInfo.internalIp[2] == 0 && icqItem.clientInfo.internalIp[3] == 0) continue block19;
                    labelMessage = "INTERNALIP_LABEL";
                    labelDescription = icqItem.clientInfo.internalIp[0] + "." + icqItem.clientInfo.internalIp[1] + "." + icqItem.clientInfo.internalIp[2] + "." + icqItem.clientInfo.internalIp[3];
                    break;
                }
                case 2: {
                    LogUtil.outMessage("DCTCPPORT_LABEL");
                    if (icqItem.clientInfo.dcTcpPort == 0L) continue block19;
                    labelMessage = "DCTCPPORT_LABEL";
                    labelDescription = String.valueOf(icqItem.clientInfo.dcTcpPort);
                    break;
                }
                case 3: {
                    LogUtil.outMessage("DCTYPE_LABEL");
                    labelMessage = "DCTYPE_LABEL";
                    labelDescription = Localization.getMessage("DCTYPE_" + icqItem.clientInfo.dcType);
                    break;
                }
                case 4: {
                    LogUtil.outMessage("DCPROTOCOLVERSION_LABEL");
                    labelMessage = "DCPROTOCOLVERSION_LABEL";
                    labelDescription = String.valueOf(icqItem.clientInfo.dcProtocolVersion);
                    break;
                }
                case 5: {
                    LogUtil.outMessage("DCAUTHCOOKIE_LABEL");
                    if (icqItem.clientInfo.dcAuthCookie == 0L) continue block19;
                    labelMessage = "DCAUTHCOOKIE_LABEL";
                    byte[] data = new byte[4];
                    DataUtil.put32(data, 0, icqItem.clientInfo.dcAuthCookie);
                    labelDescription = "0x".concat(HexUtil.bytesToString(data));
                    break;
                }
                case 6: {
                    LogUtil.outMessage("DCINFO_LABEL");
                    labelMessage = "DCINFO_LABEL";
                    byte[] data = new byte[4];
                    DataUtil.put32(data, 0, icqItem.clientInfo.lastInfoUpdateTime);
                    labelDescription = "0x".concat(HexUtil.bytesToString(data).concat("\n0x"));
                    DataUtil.put32(data, 0, icqItem.clientInfo.lastExtInfoUpdateTime);
                    labelDescription = labelDescription + HexUtil.bytesToString(data).concat("\n0x");
                    DataUtil.put32(data, 0, icqItem.clientInfo.lastExtStatusUpdateTime);
                    labelDescription = labelDescription + HexUtil.bytesToString(data).concat("\n");
                    break;
                }
                case 7: {
                    LogUtil.outMessage("WEBFRONTPORT_LABEL");
                    if (icqItem.clientInfo.webFrontPort == 0L) continue block19;
                    labelMessage = "WEBFRONTPORT_LABEL";
                    labelDescription = String.valueOf(icqItem.clientInfo.webFrontPort);
                    break;
                }
                case 8: {
                    LogUtil.outMessage("CLIENTFEATURES_LABEL");
                    if (icqItem.clientInfo.clientFeatures == 0L) continue block19;
                    labelMessage = "CLIENTFEATURES_LABEL";
                    byte[] data = new byte[4];
                    DataUtil.put32(data, 0, icqItem.clientInfo.clientFeatures);
                    labelDescription = "0x".concat(HexUtil.bytesToString(data));
                }
            }
            onlineLabel.setCaption(Localization.getMessage(labelMessage) + ": ");
            descriptionLabel.setCaption(labelDescription);
            this.clientBuffer = this.clientBuffer + onlineLabel.getContent().getText() + "\n";
            this.clientBuffer = this.clientBuffer + labelDescription + "\n";
            this.dcInfoPane.addItem(onlineLabel);
            this.dcInfoPane.addItem(descriptionLabel);
        }
        LogUtil.outMessage("/** Caps info **/");
        this.capsInfoList = new List();
        this.capsInfoList.setTouchOrientation(MidletMain.screen.isPointerEvents);
        c = 0;
        while (true) {
            if (c >= icqItem.capabilities.length) {
                LogUtil.outMessage("Panes inited");
                return;
            }
            ListItem listItem = new ListItem(icqItem.capabilities[c].capName == null ? HexUtil.bytesToString(icqItem.capabilities[c].capBytes) : icqItem.capabilities[c].capName);
            this.capsInfoList.addItem(listItem);
            this.clientBuffer = this.clientBuffer + listItem.title + "\n";
            ++c;
        }
    }
}

