/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.core;

import com.tomclaw.mandarin.core.IconsType;
import com.tomclaw.tcuilite.ChatItem;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.ListRmsRenderer;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.StringUtil;
import com.tomclaw.utils.bb.BBResult;
import com.tomclaw.utils.bb.BBUtil;

public class HistoryRmsRenderer
extends ListRmsRenderer {
    public ListItem getRmsItem(byte[] data) {
        int offset = 0;
        int length = DataUtil.get16(data, offset);
        String text = StringUtil.byteArrayToString(data, offset += 2, length, true);
        offset += length;
        length = DataUtil.get16(data, offset);
        StringUtil.byteArrayToString(data, offset += 2, length, true);
        offset += length;
        length = DataUtil.get16(data, offset);
        StringUtil.byteArrayToString(data, offset += 2, length, true);
        offset += length;
        length = DataUtil.get16(data, offset);
        StringUtil.byteArrayToString(data, offset += 2, length, true);
        int itemType = DataUtil.get16(data, offset += length);
        int dlvStatus = DataUtil.get8int(data, offset += 2);
        ++offset;
        try {
            BBResult bbResult = BBUtil.processText(text, 0, 0, 2048, ChatItem.foreColor);
            text = bbResult.originalString;
        }
        catch (Throwable ex) {
            // empty catch block
        }
        ListItem listItem = new ListItem(text, IconsType.HASH_CHAT, itemType == 7 ? itemType + dlvStatus : itemType);
        return listItem;
    }

    public ChatItem getRmsItem(byte[] data, Pane pane) {
        int offset = 0;
        int length = DataUtil.get16(data, offset);
        String text = StringUtil.byteArrayToString(data, offset += 2, length, true);
        offset += length;
        length = DataUtil.get16(data, offset);
        String buddyId = StringUtil.byteArrayToString(data, offset += 2, length, true);
        offset += length;
        length = DataUtil.get16(data, offset);
        String buddyNick = StringUtil.byteArrayToString(data, offset += 2, length, true);
        offset += length;
        length = DataUtil.get16(data, offset);
        String itemDateTime = StringUtil.byteArrayToString(data, offset += 2, length, true);
        int itemType = DataUtil.get16(data, offset += length);
        int dlvStatus = DataUtil.get8int(data, offset += 2);
        ++offset;
        ChatItem chatItem = new ChatItem(pane, buddyId, buddyNick, itemDateTime, itemType, text);
        chatItem.dlvStatus = (byte)dlvStatus;
        return chatItem;
    }

    public byte[] getRmsData(ChatItem chatItem) {
        byte[] text = StringUtil.stringToByteArray(chatItem.text, true);
        byte[] buddyId = StringUtil.stringToByteArray(chatItem.buddyId, true);
        byte[] buddyNick = StringUtil.stringToByteArray(chatItem.buddyNick, true);
        byte[] itemDateTime = StringUtil.stringToByteArray(chatItem.itemDateTime, true);
        byte[] data = new byte[2 + text.length + 2 + buddyId.length + 2 + buddyNick.length + 2 + itemDateTime.length + 2 + 1];
        int offset = 0;
        DataUtil.put16(data, offset, text.length);
        DataUtil.putArray(data, offset += 2, text);
        DataUtil.put16(data, offset += text.length, buddyId.length);
        DataUtil.putArray(data, offset += 2, buddyId);
        DataUtil.put16(data, offset += buddyId.length, buddyNick.length);
        DataUtil.putArray(data, offset += 2, buddyNick);
        DataUtil.put16(data, offset += buddyNick.length, itemDateTime.length);
        DataUtil.putArray(data, offset += 2, itemDateTime);
        DataUtil.put16(data, offset += itemDateTime.length, chatItem.itemType);
        DataUtil.put8(data, offset += 2, chatItem.dlvStatus);
        ++offset;
        return data;
    }
}

