/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.core;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyInfo;
import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Queue;
import com.tomclaw.mandarin.icq.CapUtil;
import com.tomclaw.mandarin.icq.Capability;
import com.tomclaw.mandarin.icq.ClientInfo;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.IcqDirectConnection;
import com.tomclaw.mandarin.icq.IcqItem;
import com.tomclaw.mandarin.icq.IcqPacketSender;
import com.tomclaw.mandarin.icq.IcqStatusUtil;
import com.tomclaw.mandarin.icq.IncomingFileFrame;
import com.tomclaw.mandarin.main.ChatTab;
import com.tomclaw.mandarin.main.LockFrame;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.mmp.MmpItem;
import com.tomclaw.mandarin.mmp.MmpStatusUtil;
import com.tomclaw.mandarin.xmpp.Resource;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppItem;
import com.tomclaw.mandarin.xmpp.XmppSession;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import com.tomclaw.tcuilite.Dialog;
import com.tomclaw.tcuilite.GroupHeader;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class Handler {
    static /* synthetic */ Class class$com$tomclaw$mandarin$main$LockFrame;

    public static void setConnectionStage(AccountRoot accountRoot, int i) {
        LogUtil.outMessage("setConnectionStage(".concat(accountRoot.getUserId()).concat(": ").concat(String.valueOf(i)).concat(")"));
        MidletMain.mainFrame.getAccountTab((String)accountRoot.getUserId()).fillPercent = 100 * i / 10;
        MidletMain.screen.repaint();
    }

    public static void disconnectEvent(AccountRoot accountRoot) {
        accountRoot.offlineAllBuddyes();
        accountRoot.offlineAccount();
        accountRoot.updateMainFrameBuddyList();
        MidletMain.mainFrame.updateAccountsStatus();
    }

    public static void setBuddyStatus(IcqAccountRoot icqAccountRoot, String buddyId, int buddyStatus, Capability[] caps, ClientInfo clientInfo) {
        ChatTab chatTab;
        if (caps != null) {
            for (int c = 0; c < caps.length; ++c) {
                caps[c] = CapUtil.fillCapFields(caps[c]);
            }
        }
        int prevBuddyStatus = icqAccountRoot.getBuddyStatus(buddyId);
        IcqItem icqItem = icqAccountRoot.setBuddyStatus(buddyId, buddyStatus, caps, clientInfo);
        if (icqItem != null && (chatTab = MidletMain.chatFrame.getChatTab(icqAccountRoot, buddyId, null)) != null) {
            chatTab.updateChatCaption();
        }
        if (prevBuddyStatus != -1 && buddyStatus == -1 || prevBuddyStatus == -1 && buddyStatus != -1) {
            icqAccountRoot.getServiceMessages().addMessage(buddyId, icqItem.getUserNick(), Localization.getMessage("CHANGED_STATUS").concat(" \"").concat(Localization.getMessage(IcqStatusUtil.getStatusDescr(IcqStatusUtil.getStatusIndex(prevBuddyStatus)))).concat("\" ").concat(Localization.getMessage("TO")).concat(" \"").concat(Localization.getMessage(IcqStatusUtil.getStatusDescr(IcqStatusUtil.getStatusIndex(buddyStatus)))).concat("\""), 1);
        }
        if (MidletMain.isSound || MidletMain.getBoolean(MidletMain.uniquest, "icq" + buddyId.hashCode(), "NOTIF_STAT_CHANGE")) {
            LogUtil.outMessage("Playing sound");
            if (prevBuddyStatus != -1 && buddyStatus == -1) {
                Handler.playSound(4);
            } else if (prevBuddyStatus == -1 && buddyStatus != -1) {
                Handler.playSound(3);
            }
        }
    }

    public static void setStatusMessage(IcqAccountRoot icqAccountRoot, byte[] msgCookie, byte[] msgText) {
        LogUtil.outMessage("Status msg cookie == " + HexUtil.bytesToString(msgCookie));
        LogUtil.outMessage("Window msg cookie == " + HexUtil.bytesToString(MidletMain.mainFrame.statusReaderFrame.plainCookie));
        if (MidletMain.mainFrame.statusReaderFrame != null && ArrayUtil.equals(MidletMain.mainFrame.statusReaderFrame.plainCookie, msgCookie)) {
            MidletMain.mainFrame.statusReaderFrame.setPlainStatusText(StringUtil.byteArrayToString(msgText, true));
        }
    }

    public static void setXStatusMessage(IcqAccountRoot icqAccountRoot, byte[] msgCookie, byte[] bytes, byte[] bytes0) {
        LogUtil.outMessage("Status x-msg cookie == " + HexUtil.bytesToString(msgCookie));
        LogUtil.outMessage("Window x-msg cookie == " + HexUtil.bytesToString(MidletMain.mainFrame.statusReaderFrame.xStatCookie));
        if (MidletMain.mainFrame.statusReaderFrame != null && ArrayUtil.equals(MidletMain.mainFrame.statusReaderFrame.xStatCookie, msgCookie)) {
            MidletMain.mainFrame.statusReaderFrame.setXStatusText(StringUtil.byteArrayToString(bytes, true), StringUtil.byteArrayToString(bytes0, true));
        }
    }

    public static void recMess(AccountRoot accountRoot, String screenName, String resourceTitle, String groupChatNick, String decodedString, byte[] msgCookie, int type) {
        LogUtil.outMessage("Received message from: ".concat(screenName));
        LogUtil.outMessage("Message text:          ".concat(decodedString));
        if (MidletMain.getBoolean(MidletMain.uniquest, accountRoot.getAccType() + screenName.hashCode(), "LOCK_INCOMING")) {
            return;
        }
        if (screenName.equals("AOL Instant Messenger")) {
            return;
        }
        try {
            boolean isExpandedFlag;
            BuddyItem buddyItem = MidletMain.mainFrame.getBuddyItem(accountRoot, screenName);
            ChatTab chatTab = MidletMain.chatFrame.getChatTab(accountRoot, screenName, resourceTitle, false);
            if (chatTab == null) {
                LogUtil.outMessage("Chat tab not exist");
                Resource resource = null;
                if (buddyItem == null) {
                    LogUtil.outMessage("BuddyItem is not exist. Creating...");
                    buddyItem = accountRoot.getBuddyInstance();
                    buddyItem.setUserId(screenName);
                    buddyItem.updateUiData();
                    if (accountRoot.getBuddyItems().isEmpty()) {
                        accountRoot.getBuddyItems().addElement(new GroupHeader("Temp group"));
                    }
                    LogUtil.outMessage("Group checking complete");
                    ((GroupHeader)accountRoot.getBuddyItems().elementAt(0)).addChild(buddyItem);
                }
                LogUtil.outMessage("Done. Creating ChatTab instance");
                if (accountRoot instanceof XmppAccountRoot) {
                    resource = ((XmppItem)buddyItem).getResource(resourceTitle);
                }
                chatTab = new ChatTab(accountRoot, buddyItem, resource, accountRoot.getStatusImages().hashCode(), "/res/groups/img_chat.png".hashCode());
                LogUtil.outMessage("ChatTab appending...");
                MidletMain.chatFrame.addChatTab(chatTab, false);
                LogUtil.outMessage("Almost done.");
            } else {
                LogUtil.outMessage("Chat tab exist.        ".concat(chatTab.title));
            }
            boolean isDisplayed = MidletMain.chatFrame.addChatItem(chatTab, groupChatNick, decodedString, msgCookie, type, true);
            LogUtil.outMessage("isDisplayed = " + isDisplayed);
            if (!MidletMain.screen.activeWindow.equals(MidletMain.chatFrame) || !isDisplayed) {
                buddyItem.setUnreadCount(buddyItem.getUnreadCount(resourceTitle) + 1, resourceTitle);
                accountRoot.setUnrMsgs(accountRoot.getUnrMsgs() + 1);
                MidletMain.mainFrame.updateAccountsStatus();
                if (buddyItem.getUnreadCount() == 1) {
                    buddyItem.updateUiData();
                    chatTab.updateChatCaption();
                }
            }
            boolean isAlarm = true;
            if (groupChatNick != null && accountRoot instanceof XmppAccountRoot) {
                LogUtil.outMessage("GroupChat detected");
                String groupChatRealNick = ((XmppItem)buddyItem).groupChatNick;
                LogUtil.outMessage("groupChatNick = " + groupChatNick);
                LogUtil.outMessage("groupChatRealNick = " + groupChatRealNick);
                LogUtil.outMessage("decodedString = " + decodedString);
                LogUtil.outMessage("decodedString = " + decodedString);
                if (groupChatRealNick.equals(groupChatNick)) {
                    isAlarm = false;
                    LogUtil.outMessage("Alarm switched off");
                } else if (MidletMain.alarmRepliesOnly && decodedString.indexOf(groupChatRealNick) == -1) {
                    isAlarm = false;
                    LogUtil.outMessage("Alarm switched off cause alarmRepliesOnly = " + MidletMain.alarmRepliesOnly);
                }
                if (((XmppItem)buddyItem).groupChatSubject == null) {
                    isAlarm = false;
                    LogUtil.outMessage("Alarm switched off cause groupChatSubject = null");
                }
            }
            if (!(MidletMain.isPhotoActive || !MidletMain.isExpand || Display.getDisplay((MIDlet)MidletMain.midletMain).getCurrent() instanceof TextBox && Display.getDisplay((MIDlet)MidletMain.midletMain).getCurrent() != null)) {
                Display.getDisplay((MIDlet)MidletMain.midletMain).setCurrent((Displayable)MidletMain.screen);
                isExpandedFlag = true;
            } else {
                isExpandedFlag = false;
            }
            boolean isUniqueNotify = MidletMain.getBoolean(MidletMain.uniquest, accountRoot.getAccType() + screenName.hashCode(), "NOTIF_MESSAGES");
            if ((MidletMain.vibrateDelay > 0 || isUniqueNotify) && isAlarm) {
                if (isExpandedFlag) {
                    Thread.sleep(400L);
                }
                Display.getDisplay((MIDlet)MidletMain.midletMain).vibrate(isUniqueNotify ? 500 : MidletMain.vibrateDelay);
            }
            MidletMain.screen.repaint();
            if ((MidletMain.isSound || isUniqueNotify) && isAlarm) {
                Handler.playSound(1);
            }
        }
        catch (Throwable ex1) {
            // empty catch block
        }
        if (Screen.screen.activeWindow.getClass() == (class$com$tomclaw$mandarin$main$LockFrame == null ? (class$com$tomclaw$mandarin$main$LockFrame = Handler.class$("com.tomclaw.mandarin.main.LockFrame")) : class$com$tomclaw$mandarin$main$LockFrame)) {
            ((LockFrame)Screen.screen.activeWindow).updateUnreadLabel();
            MidletMain.screen.repaint();
        }
    }

    public static void sendXStatusMessage(IcqAccountRoot icqAccountRoot, byte[] msgCookie, String screenName) {
        IcqItem icqItem = icqAccountRoot.getBuddy(screenName);
        icqAccountRoot.getServiceMessages().addMessage(screenName, icqItem != null ? icqItem.getUserNick() : screenName, Localization.getMessage("REQUEST_XSTATUS") + " " + (icqAccountRoot.isXStatusReadable ? Localization.getMessage("XSTATUS_SENT") : Localization.getMessage("XSTATUS_NOT_SENT")), 2);
        if (icqAccountRoot.isXStatusReadable && !MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "DISABLE_XSTATUS_READING") || MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "SEND_SPECIAL_XSTATUS") && !MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "DISABLE_XSTATUS_READING")) {
            String xDescr;
            String xTitle;
            if (MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "SEND_SPECIAL_XSTATUS")) {
                xTitle = MidletMain.getString(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "FLD_SPECIAL_XTITLE");
                xDescr = MidletMain.getString(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "FLD_SPECIAL_XDESCR");
            } else {
                xTitle = icqAccountRoot.xTitle;
                xDescr = icqAccountRoot.xText;
            }
            LogUtil.outMessage("xTitle == " + xTitle);
            LogUtil.outMessage("xDescr == " + xDescr);
            IcqPacketSender.sendXStatusText(icqAccountRoot.session, icqAccountRoot.userId, msgCookie, screenName, StringUtil.stringToByteArray(xTitle, true), StringUtil.stringToByteArray(xDescr, true));
        }
    }

    public static void sendStatusMessage(IcqAccountRoot icqAccountRoot, byte[] msgCookie, String screenName) {
        IcqItem icqItem = icqAccountRoot.getBuddy(screenName);
        icqAccountRoot.getServiceMessages().addMessage(screenName, icqItem != null ? icqItem.getUserNick() : screenName, Localization.getMessage("REQUEST_STATUS") + " " + (icqAccountRoot.isStatusReadable ? Localization.getMessage("STATUS_SENT") : Localization.getMessage("STATUS_NOT_SENT")), 3);
        if (icqAccountRoot.isStatusReadable && !MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "DISABLE_PSTATUS_READING") || MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "SEND_SPECIAL_PSTATUS") && !MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "DISABLE_PSTATUS_READING")) {
            String pStatus = MidletMain.getBoolean(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "SEND_SPECIAL_PSTATUS") ? MidletMain.getString(MidletMain.uniquest, icqAccountRoot.getAccType() + screenName.hashCode(), "FLD_SPECIAL_PSTATUS") : icqAccountRoot.statusText;
            LogUtil.outMessage("pStatus == " + pStatus);
            IcqPacketSender.sendStatusMessage(icqAccountRoot.session, msgCookie, screenName, pStatus);
        }
    }

    public static void msgAck(AccountRoot accountRoot, String buddyId, String resource, byte[] msgCookie) {
        if (buddyId == null) {
            MidletMain.chatFrame.msgAck(accountRoot, msgCookie, (byte)2);
        } else {
            MidletMain.chatFrame.msgAck(accountRoot, buddyId, resource, msgCookie, (byte)2);
        }
        MidletMain.screen.repaint();
        if (MidletMain.isSound) {
            Handler.playSound(2);
        }
    }

    public static void setBuddyTypingStatus(AccountRoot accountRoot, String buddyId, String resource, boolean isTyping, boolean isInvertTyping) {
        if (!isInvertTyping) {
            MidletMain.mainFrame.typingNotify(accountRoot, buddyId, isTyping);
        }
        ChatTab chatTab = MidletMain.chatFrame.getChatTab(accountRoot, buddyId, resource);
        if (chatTab != null) {
            chatTab.updateChatCaption();
        }
        MidletMain.screen.repaint();
    }

    public static void showUserShortInfo(AccountRoot accountRoot, BuddyInfo buddyInfo) {
        LogUtil.outMessage("buddyId = " + buddyInfo.buddyId);
        LogUtil.outMessage("nickName = " + buddyInfo.nickName);
        if (MidletMain.mainFrame.buddyInfoFrame != null && buddyInfo.buddyId != null && MidletMain.mainFrame.buddyInfoFrame.buddyItem.getUserId().equals(buddyInfo.buddyId)) {
            MidletMain.mainFrame.buddyInfoFrame.placeInfo(buddyInfo);
        }
    }

    public static void setBuddyList(AccountRoot accountRoot, Vector buddyList, Vector privateList, int privateBuddyId, int snacFlags, byte[] snacRequestId) {
        LogUtil.outMessage("setBuddyList(".concat(accountRoot.getUserId()).concat(")"));
        if (accountRoot instanceof IcqAccountRoot && privateBuddyId != -1) {
            ((IcqAccountRoot)accountRoot).privateBuddyId = privateBuddyId;
            LogUtil.outMessage("icqAccountRoot.privateBuddyId = " + privateBuddyId);
        }
        accountRoot.setTreeItems(buddyList);
        if (snacFlags == 0) {
            accountRoot.setPrivateItems(privateList);
            accountRoot.updateMainFrameBuddyList();
            MidletMain.screen.repaint();
            LogUtil.outMessage("Reset flag accepted");
            if (accountRoot instanceof IcqAccountRoot) {
                ((IcqAccountRoot)accountRoot).isReset = true;
            }
            accountRoot.updateOfflineBuddylist();
            MidletMain.chatFrame.updateChatTabBuddyes();
        } else if (accountRoot instanceof IcqAccountRoot) {
            ((IcqAccountRoot)accountRoot).isReset = false;
        }
    }

    private static void playSound(int eventType) {
        if (MidletMain.eventSound[--eventType].length() == 0) {
            return;
        }
        try {
            LogUtil.outMessage("Playing: " + MidletMain.defSoundLocation + MidletMain.eventSound[eventType]);
            InputStream is = Class.forName("com.tomclaw.mandarin.main.MidletMain").getResourceAsStream(MidletMain.defSoundLocation + MidletMain.eventSound[eventType]);
            if (is != null) {
                final Player p = Manager.createPlayer((InputStream)is, (String)"audio/mpeg");
                p.realize();
                VolumeControl volumeControl = (VolumeControl)p.getControl("VolumeControl");
                volumeControl.setLevel(MidletMain.volumeLevel);
                p.start();
                long mediaTime = 1500L;
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(1500L);
                            p.stop();
                        }
                        catch (Throwable ex) {
                            LogUtil.outMessage(ex.getMessage());
                        }
                        p.close();
                    }
                };
                thread.start();
            }
        }
        catch (Throwable ex1) {
            LogUtil.outMessage(ex1.getMessage());
        }
    }

    private static void showDialog(final Window window, String title, String message, final boolean isError) {
        Soft soft = new Soft(MidletMain.screen);
        soft.leftSoft = new PopupItem(Localization.getMessage("CLOSE")){

            public void actionPerformed() {
                window.closeDialog();
                if (isError) {
                    MidletMain.screen.setActiveWindow(MidletMain.mainFrame);
                }
            }
        };
        window.showDialog(new Dialog(MidletMain.screen, soft, title, message));
        MidletMain.screen.repaint();
    }

    public static void showDialog(String title, String message) {
        Handler.showDialog(MidletMain.screen.activeWindow, title, message, false);
    }

    public static void showInfo(String message) {
        Handler.showDialog(MidletMain.screen.activeWindow, Localization.getMessage("INFO_ITEM"), message, false);
    }

    public static void showNotify(String message) {
        Handler.showDialog(MidletMain.screen.activeWindow, Localization.getMessage("WARNING"), message, false);
    }

    public static void showError(String message) {
        Handler.showDialog(MidletMain.screen.activeWindow, Localization.getMessage("ERROR"), message, false);
    }

    public static void showFail(String message) {
        Handler.showDialog(MidletMain.screen.activeWindow, Localization.getMessage("ERROR"), message, true);
    }

    public static void performTransferAction(final IcqAccountRoot icqAccountRoot, int ch2msgType, String buddyId, final int[] externalIp, final int dcTcpPort, boolean isViaRendezvousServer, long fileLength, byte[] fileName, final byte[] cookie, boolean isFromMsgDialog) {
        IcqDirectConnection directConnection = (IcqDirectConnection)icqAccountRoot.getTransactionManager().getTransaction(cookie);
        if (directConnection == null || directConnection.isReceivingFile) {
            if (directConnection == null) {
                if (MidletMain.isAutoAcceptFiles || isFromMsgDialog) {
                    directConnection = new IcqDirectConnection(icqAccountRoot);
                    icqAccountRoot.getTransactionManager().addTransaction(directConnection);
                } else {
                    Handler.showFileRequestMessage(icqAccountRoot, ch2msgType, buddyId, externalIp, dcTcpPort, isViaRendezvousServer, fileLength, fileName, cookie);
                    return;
                }
            }
            LogUtil.outMessage("Receiving");
            if (ch2msgType == 0) {
                directConnection.isReceivingFile = true;
                directConnection.buddyId = buddyId;
                directConnection.icbmCookie = cookie;
                if (fileLength != -1L) {
                    directConnection.fileByteSize = fileLength;
                    LogUtil.outMessage("Accepted fileLength=" + fileLength);
                }
                if (fileName != null) {
                    directConnection.fileName = fileName;
                    LogUtil.outMessage("Accepted fileName=".concat(StringUtil.byteArrayToString(directConnection.fileName, true)));
                }
                Handler.updateTransactions(icqAccountRoot);
                if (!ArrayUtil.equals(externalIp, new int[]{0, 0, 0, 0}) && isViaRendezvousServer) {
                    LogUtil.outMessage("Proxy received");
                    directConnection.proxyIp = externalIp[0] + "." + externalIp[1] + "." + externalIp[2] + "." + externalIp[3];
                    directConnection.proxyIpBytes = new byte[4];
                    DataUtil.put8(directConnection.proxyIpBytes, 0, externalIp[0]);
                    DataUtil.put8(directConnection.proxyIpBytes, 1, externalIp[1]);
                    DataUtil.put8(directConnection.proxyIpBytes, 2, externalIp[2]);
                    DataUtil.put8(directConnection.proxyIpBytes, 3, externalIp[3]);
                    directConnection.proxyPort = dcTcpPort;
                    LogUtil.outMessage("Data accepted");
                    if (directConnection.remoteProxyConnectionSentFlag) {
                        try {
                            directConnection.localProxyConnection.disconnect();
                            directConnection.localProxyConnection = null;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    Thread thread = new Thread(){

                        public void run() {
                            ((IcqDirectConnection)icqAccountRoot.getTransactionManager().getTransaction(cookie)).sendToRemoteProxy(false);
                        }
                    };
                    thread.start();
                } else {
                    LogUtil.outMessage("Change connection to proxy");
                    try {
                        directConnection.seqNumber = (byte)(directConnection.seqNumber + 1);
                        directConnection.sendFileViaProxy();
                        Thread thread = new Thread(){

                            public void run() {
                                ((IcqDirectConnection)icqAccountRoot.getTransactionManager().getTransaction(cookie)).sendToRemoteProxy(true);
                            }
                        };
                        thread.start();
                    }
                    catch (Throwable ex) {}
                }
            } else if (ch2msgType == 2) {
                LogUtil.outMessage("Ack");
                if (!directConnection.remoteProxyConnectionSentFlag) {
                    Thread thread = new Thread(){

                        public void run() {
                            ((IcqDirectConnection)icqAccountRoot.getTransactionManager().getTransaction(cookie)).sendToRemoteProxy(true);
                        }
                    };
                    thread.start();
                }
            }
        } else if (!ArrayUtil.equals(externalIp, new int[]{0, 0, 0, 0})) {
            Thread thread = new Thread(){

                public void run() {
                    ((IcqDirectConnection)icqAccountRoot.getTransactionManager().getTransaction(cookie)).sendToRemoteProxy(externalIp, dcTcpPort);
                }
            };
            thread.start();
        } else if (ch2msgType != 0 && ch2msgType == 2) {
            LogUtil.outMessage("Incoming accept");
        }
    }

    public static void updateTransactionInfo(AccountRoot accountRoot, byte[] cookie) {
        if (accountRoot.getTransactionsFrame() != null && accountRoot.getTransactionsFrame().transactionItemFrame != null && ArrayUtil.equals(accountRoot.getTransactionsFrame().transactionItemFrame.directConnection.getSessCookie(), cookie) && MidletMain.screen.activeWindow.equals(accountRoot.getTransactionsFrame().transactionItemFrame)) {
            accountRoot.getTransactionsFrame().transactionItemFrame.updateData();
        }
    }

    public static void updateTransactions(AccountRoot accountRoot) {
        if (accountRoot.getTransactionsFrame() != null) {
            accountRoot.getTransactionsFrame().updateTransactions();
        } else if (MidletMain.mainFrame.equals(MidletMain.screen.activeWindow)) {
            MidletMain.screen.repaint();
        }
    }

    public static void showFileRequestMessage(IcqAccountRoot icqAccountRoot, int ch2msgType, String buddyId, int[] externalIp, int dcTcpPort, boolean isViaRendezvousServer, long fileLength, byte[] fileName, byte[] cookie) {
        IncomingFileFrame incomingFileFrame = new IncomingFileFrame(icqAccountRoot, ch2msgType, buddyId, externalIp, dcTcpPort, isViaRendezvousServer, fileLength, fileName, cookie);
        icqAccountRoot.getServiceMessages().addMessage(buddyId, buddyId, Localization.getMessage("FILE_NAME").concat(" \"").concat(StringUtil.byteArrayToString(fileName, true)).concat("\" "), 4);
        incomingFileFrame.s_prevWindow = MidletMain.screen.activeWindow;
        MidletMain.screen.setActiveWindow(incomingFileFrame);
    }

    public static void setMailStatus(MmpAccountRoot mmpAccountRoot, String userMail, long userStatus) {
        ChatTab chatTab;
        long prevBuddyStatus = mmpAccountRoot.getBuddyStatus(userMail);
        MmpItem mmpItem = mmpAccountRoot.setBuddyStatus(userMail, userStatus);
        if (mmpItem != null && (chatTab = MidletMain.chatFrame.getChatTab(mmpAccountRoot, userMail, null, false)) != null) {
            chatTab.updateChatCaption();
        }
        if (prevBuddyStatus != 0L && userStatus == 0L || prevBuddyStatus == 0L && userStatus != 0L) {
            LogUtil.outMessage("Changing status in service messages");
            mmpAccountRoot.getServiceMessages().addMessage(userMail, mmpItem != null ? mmpItem.getUserNick() : userMail, Localization.getMessage("CHANGED_STATUS").concat(" \"").concat(Localization.getMessage(MmpStatusUtil.getStatusDescr(MmpStatusUtil.getStatusIndex(prevBuddyStatus)))).concat("\" ").concat(Localization.getMessage("TO")).concat(" \"").concat(Localization.getMessage(MmpStatusUtil.getStatusDescr(MmpStatusUtil.getStatusIndex(userStatus)))).concat("\""), 1);
        }
        if (MidletMain.isSound) {
            if (prevBuddyStatus != 0L && userStatus == 0L) {
                Handler.playSound(4);
            } else if (prevBuddyStatus == 0L && userStatus != 0L) {
                Handler.playSound(3);
            }
        }
    }

    public static void setMainFrameAction(MmpAccountRoot mmpAccountRoot, String message) {
    }

    public static void showMainFrameMessage(MmpAccountRoot mmpAccountRoot, String message) {
    }

    public static void setXmppStatus(XmppAccountRoot xmppAccountRoot, String from, String t_show, String t_status, String capsNode, String capsVer) {
        XmppItem rosterItem = xmppAccountRoot.getBuddyItem(from);
        int prevBuddyStatus = XmppStatusUtil.offlineIndex;
        int statusIndex = XmppStatusUtil.getStatusIndex(t_show);
        if (rosterItem == null) {
            LogUtil.outMessage("... not found.");
            rosterItem = new XmppItem(XmppSession.getClearJid(from));
            xmppAccountRoot.xmppSession.roster.put(XmppSession.getClearJid(from), rosterItem);
            xmppAccountRoot.addTempItem(rosterItem);
        } else {
            prevBuddyStatus = rosterItem.getResource((String)XmppSession.getJidResource((String)from)).statusIndex;
        }
        LogUtil.outMessage("... present!");
        Resource _resource = rosterItem.getResource(XmppSession.getJidResource(from));
        _resource.statusIndex = statusIndex;
        _resource.statusText = t_status;
        _resource.caps = capsNode;
        _resource.ver = capsVer;
        rosterItem.updateUiData();
        ChatTab chatTab = MidletMain.chatFrame.getChatTab(xmppAccountRoot, XmppSession.getClearJid(from), XmppSession.getJidResource(from), false);
        if (chatTab != null) {
            LogUtil.outMessage("Chat tab exist.");
            chatTab.buddyItem = rosterItem;
            if (chatTab.resource != null) {
                chatTab.resource = rosterItem.getResource(chatTab.resource.resource);
            }
            chatTab.updateChatCaption();
            LogUtil.outMessage("Chat tab buddyItem updated.");
        } else if (statusIndex == XmppStatusUtil.offlineIndex && !XmppSession.getJidResource(from).equals("") && MidletMain.isRemoveResources) {
            rosterItem.removeResource(XmppSession.getJidResource(from));
            rosterItem.updateUiData();
        }
        if (prevBuddyStatus != XmppStatusUtil.offlineIndex && statusIndex == XmppStatusUtil.offlineIndex || prevBuddyStatus == XmppStatusUtil.offlineIndex && statusIndex != XmppStatusUtil.offlineIndex) {
            LogUtil.outMessage("Changing status in service messages from: " + prevBuddyStatus + " to " + statusIndex);
            xmppAccountRoot.getServiceMessages().addMessage(from, rosterItem.isGroupChat ? XmppSession.getJidResource(from) : rosterItem.getUserNick(), Localization.getMessage("CHANGED_STATUS").concat(" \"").concat(Localization.getMessage(XmppStatusUtil.getStatusDescr(prevBuddyStatus))).concat("\" ").concat(Localization.getMessage("TO")).concat(" \"").concat(Localization.getMessage(XmppStatusUtil.getStatusDescr(statusIndex))).concat("\""), 1);
        }
        if (MidletMain.isSound) {
            if (prevBuddyStatus != XmppStatusUtil.offlineIndex && statusIndex == XmppStatusUtil.offlineIndex) {
                Handler.playSound(4);
            } else if (prevBuddyStatus == XmppStatusUtil.offlineIndex && statusIndex != XmppStatusUtil.offlineIndex) {
                Handler.playSound(3);
            }
        }
        MidletMain.screen.repaint();
    }

    public static void setServicesList(XmppAccountRoot xmppAccountRoot, Vector servicesList, String id) {
        MidletMain.servicesFrame.setServicesList(xmppAccountRoot, servicesList, id);
    }

    public static void setServiceInfo(XmppAccountRoot xmppAccountRoot, String from, String id, Vector identityes, Vector features) {
        MidletMain.servicesFrame.setServiceInfo(xmppAccountRoot, from, id, identityes, features);
    }

    public static void setHostInfo(XmppAccountRoot xmppAccountRoot, String id, Vector identityes, Vector features) {
        MidletMain.servicesFrame.setHostInfo(xmppAccountRoot, id, identityes, features);
    }

    public static void setBookmarks(XmppAccountRoot xmppAccountRoot, String id, Vector bookmarks) {
        MidletMain.bookmarksFrame.setBookmarks(xmppAccountRoot, id, bookmarks);
    }

    public static void setGroupChatSettings(XmppAccountRoot xmppAccountRoot, String id, Vector objects, String FORM_TYPE) {
        MidletMain.groupChatConfFrame.setObjects(xmppAccountRoot, id, objects, FORM_TYPE);
    }

    public static void setGroupChatResult(XmppAccountRoot xmppAccountRoot, String id) {
        MidletMain.groupChatConfFrame.setResult(xmppAccountRoot, id);
    }

    public static void setGroupChatResult(XmppAccountRoot xmppAccountRoot, String id, Vector items) {
        MidletMain.groupChatUsersFrame.setResult(xmppAccountRoot, id, items);
    }

    public static void setBookmarkError(XmppAccountRoot xmppAccountRoot, String id, String errorText, int errorId) {
        MidletMain.bookmarksFrame.setBookmarkError(xmppAccountRoot, id, errorText, errorId);
    }

    public static void setAffiliationAddResult(XmppAccountRoot xmppAccountRoot, String id) {
        MidletMain.affiliationAddFrame.setRequestResult(xmppAccountRoot, id);
    }

    public static void processQueueAction(AccountRoot accountRoot, Cookie cookie, Hashtable params) {
        LogUtil.outMessage("processQueueAction for: " + cookie.cookieString);
        Queue.runQueueAction(cookie, params);
        MidletMain.screen.repaint();
    }

    public static void cancelQueueAction(AccountRoot accountRoot, Cookie cookie, String errorStringCode) {
        LogUtil.outMessage("cancelQueueAction for: " + cookie.cookieString);
        Queue.popQueueAction(cookie);
        Handler.showNotify(Localization.getMessage(errorStringCode));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

