/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.core;

import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.StringUtil;

public class Cookie {
    public byte[] cookie;
    public long cookieValue;
    public String cookieString;

    public Cookie() {
        this.cookieString = StringUtil.generateString(4);
        this.cookie = this.cookieString.getBytes();
        this.cookieValue = DataUtil.get32(this.cookie, 0, false);
    }

    public Cookie(byte[] cookie) {
        this.cookie = cookie;
        this.cookieValue = DataUtil.get32(cookie, 0, false);
        this.cookieString = new String(cookie);
    }

    public Cookie(long cookieValue) {
        this.cookie = new byte[4];
        this.cookieValue = cookieValue;
        DataUtil.put32_reversed(this.cookie, 0, cookieValue);
        this.cookieString = new String(this.cookie);
    }

    public Cookie(String cookieString) {
        this.cookie = new byte[4];
        this.cookieString = cookieString;
        this.cookie = cookieString.getBytes();
        this.cookieValue = DataUtil.get32(this.cookie, 0, false);
    }
}

