/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.images;

import com.tomclaw.images.ImageGroup;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Splitter {
    protected static Image tempImage;
    protected static Hashtable hashtable;
    public static int imageMaxSize;

    public static ImageGroup splitImage(String fileName) {
        return Splitter.splitImage(fileName, true);
    }

    public static ImageGroup splitImage(String fileName, boolean isSizeIndex) {
        ImageGroup imageGroup = new ImageGroup();
        try {
            tempImage = Image.createImage((String)fileName);
            imageGroup.size = tempImage.getHeight();
            imageGroup.images = tempImage;
            if (isSizeIndex && imageGroup.size > imageMaxSize) {
                imageMaxSize = imageGroup.size;
            }
            hashtable.put(String.valueOf(fileName.hashCode()), imageGroup);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempImage = null;
        return imageGroup;
    }

    public static int drawImage(Graphics g, ImageGroup imageGroup, int imageIndex, int x, int y, boolean isYCenter) {
        if (imageIndex < imageGroup.getCount() && imageIndex >= 0) {
            try {
                g.drawRegion(imageGroup.images, imageIndex * imageGroup.size, 0, imageGroup.size, imageGroup.size, 0, x, isYCenter ? y - imageGroup.size / 2 : y, 20);
                return imageGroup.size;
            }
            catch (NullPointerException ex1) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int drawImage(Graphics g, int imageFileHash, int imageIndex, int x, int y, boolean isYCenter) {
        try {
            return Splitter.drawImage(g, (ImageGroup)hashtable.get(String.valueOf(imageFileHash)), imageIndex, x, y, isYCenter);
        }
        catch (NullPointerException ex1) {
            return 0;
        }
    }

    public static int drawImage(Graphics g, String imageLink, int x, int y, boolean isYCenter) {
        int linkDivIndex = imageLink.lastIndexOf(58);
        if (linkDivIndex == -1) {
            return 0;
        }
        return Splitter.drawImage(g, Integer.parseInt(imageLink.substring(0, linkDivIndex)), Integer.parseInt(imageLink.substring(linkDivIndex + 1)), x, y, isYCenter);
    }

    public static ImageGroup getImageGroup(String imageLink) {
        int linkDivIndex = imageLink.lastIndexOf(58);
        if (linkDivIndex == -1) {
            return (ImageGroup)hashtable.get(imageLink);
        }
        return (ImageGroup)hashtable.get(imageLink.substring(0, linkDivIndex));
    }

    public static ImageGroup getImageGroup(int imageFileHash) {
        return (ImageGroup)hashtable.get(String.valueOf(imageFileHash));
    }

    static {
        hashtable = new Hashtable();
        imageMaxSize = 0;
    }
}

