/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils;

import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class StringUtil {
    public static final String S_QUOTE = "\"";
    public static final String S_EMPTY = "";
    public static final String S_NULL = "null";

    public static String byteArrayDirectToString(byte[] str) {
        String outString = S_EMPTY;
        for (int c = 0; c < str.length; ++c) {
            outString = outString + (char)str[c];
        }
        return outString;
    }

    public static String ipToString(byte[] ip) {
        if (ip == null) {
            return null;
        }
        StringBuffer strIP = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            int tmp = ip[i] & 0xFF;
            if (strIP.length() != 0) {
                strIP.append('.');
            }
            strIP.append(tmp);
        }
        return strIP.toString();
    }

    public static String concat(Vector v) {
        return StringUtil.concat(v, S_EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String concat(Vector v, String separator) {
        Vector vector = v;
        synchronized (vector) {
            Enumeration e = v.elements();
            StringBuffer sb = new StringBuffer();
            if (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
            }
            while (e.hasMoreElements()) {
                sb.append(separator).append(e.nextElement().toString());
            }
            return sb.toString();
        }
    }

    public static boolean isEmptyOrNull(String s) {
        return StringUtil.isNullOrEmpty(s);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNullOrTrimmedEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isTrimmedEmptyOrNull(String s) {
        return StringUtil.isNullOrTrimmedEmpty(s);
    }

    public static String mkEmpty(String s) {
        return s == null ? S_EMPTY : s;
    }

    public static String mkEmptyAndTrim(String s) {
        return s == null ? S_EMPTY : s.trim();
    }

    public static String mkNull(String s) {
        return s == null ? null : (s.length() == 0 ? null : s);
    }

    public static String mkNullAndTrim(String s) {
        if (s == null) {
            return null;
        }
        String s1 = s.trim();
        return s1.length() == 0 ? null : s1;
    }

    public static boolean startsWith(String s, String prefix) {
        return s.length() >= prefix.length() && s.startsWith(prefix);
    }

    public static String toPrintableString(Object object) {
        if (object == null) {
            return S_NULL;
        }
        return S_QUOTE + object + S_QUOTE;
    }

    public static boolean isDataUTF8(byte[] array, int start, int length) {
        if (length == 0) {
            return false;
        }
        if (array.length < start + length) {
            return false;
        }
        int i = start;
        int len = length;
        while (len > 0) {
            int seqLen = 0;
            byte bt = array[i++];
            --len;
            if ((bt & 0xE0) == 192) {
                seqLen = 1;
            } else if ((bt & 0xF0) == 224) {
                seqLen = 2;
            } else if ((bt & 0xF8) == 240) {
                seqLen = 3;
            } else if ((bt & 0xFC) == 248) {
                seqLen = 4;
            } else if ((bt & 0xFE) == 252) {
                seqLen = 5;
            }
            if (seqLen == 0) {
                if ((bt & 0x80) != 128) continue;
                return false;
            }
            for (int j = 0; j < seqLen; ++j) {
                if (len == 0) {
                    return false;
                }
                if (((bt = array[i++]) & 0xC0) != 128) {
                    return false;
                }
                --len;
            }
            if (len != 0) continue;
            break;
        }
        return true;
    }

    public static byte[] stringToByteArray1251(String s) {
        byte[] abyte0 = s.getBytes();
        block12: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0401': {
                    abyte0[i] = -88;
                    continue block12;
                }
                case '\u0451': {
                    abyte0[i] = -72;
                    continue block12;
                }
                case '\u0490': {
                    abyte0[i] = -91;
                    continue block12;
                }
                case '\u0404': {
                    abyte0[i] = -86;
                    continue block12;
                }
                case '\u0407': {
                    abyte0[i] = -81;
                    continue block12;
                }
                case '\u0406': {
                    abyte0[i] = -78;
                    continue block12;
                }
                case '\u0456': {
                    abyte0[i] = -77;
                    continue block12;
                }
                case '\u0491': {
                    abyte0[i] = -76;
                    continue block12;
                }
                case '\u0454': {
                    abyte0[i] = -70;
                    continue block12;
                }
                case '\u0457': {
                    abyte0[i] = -65;
                    continue block12;
                }
                default: {
                    char c1 = c;
                    if (c1 < '\u0410' || c1 > '\u044f') continue block12;
                    abyte0[i] = (byte)(c1 - 1040 + 192);
                }
            }
        }
        return abyte0;
    }

    public static byte[] string1251ToByteArray(String string) {
        byte[] data = new byte[string.length() * 2];
        for (int k = 0; k < string.length(); ++k) {
            char l = string.charAt(k);
            try {
                switch (l) {
                    case '\u00a8': {
                        data[k * 2 - 1] = 1;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00b8': {
                        data[k * 2 - 1] = 51;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00a5': {
                        data[k * 2 - 1] = 90;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00aa': {
                        data[k * 2 - 1] = 4;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00af': {
                        data[k * 2 - 1] = 7;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00b2': {
                        data[k * 2 - 1] = 6;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00b3': {
                        data[k * 2 - 1] = 56;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00b4': {
                        data[k * 2 - 1] = 91;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00ba': {
                        data[k * 2 - 1] = 54;
                        data[k * 2] = 4;
                        break;
                    }
                    case '\u00bf': {
                        data[k * 2 - 1] = 57;
                        data[k * 2] = 4;
                        break;
                    }
                    default: {
                        if (l >= '\u00c0' && l <= '\u00ff') {
                            DataUtil.put16_reversed(data, k * 2, 849);
                            break;
                        }
                        DataUtil.put16_reversed(data, k * 2, l);
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                DataUtil.put16_reversed(data, k * 2, 63);
            }
        }
        return data;
    }

    public static String byteArray1251ToString(byte[] abyte0, int i, int j) {
        StringBuffer stringbuffer = new StringBuffer(j);
        for (int k = 0; k < j; ++k) {
            int l = abyte0[k + i] & 0xFF;
            try {
                switch (l) {
                    case 168: {
                        stringbuffer.append('\u0401');
                        break;
                    }
                    case 184: {
                        stringbuffer.append('\u0451');
                        break;
                    }
                    case 165: {
                        stringbuffer.append('\u0490');
                        break;
                    }
                    case 170: {
                        stringbuffer.append('\u0404');
                        break;
                    }
                    case 175: {
                        stringbuffer.append('\u0407');
                        break;
                    }
                    case 178: {
                        stringbuffer.append('\u0406');
                        break;
                    }
                    case 179: {
                        stringbuffer.append('\u0456');
                        break;
                    }
                    case 180: {
                        stringbuffer.append('\u0491');
                        break;
                    }
                    case 186: {
                        stringbuffer.append('\u0454');
                        break;
                    }
                    case 191: {
                        stringbuffer.append('\u0457');
                        break;
                    }
                    default: {
                        if (l >= 192 && l <= 255) {
                            stringbuffer.append((char)(1040 + l - 192));
                            break;
                        }
                        stringbuffer.append((char)(l & 0xFF));
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                stringbuffer.append('?');
            }
        }
        return stringbuffer.toString();
    }

    public static String removeCr(String val) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char chr = val.charAt(i);
            if (chr == '\u0000' || chr == '\r') continue;
            result.append(chr);
        }
        return result.toString();
    }

    public static String ucs2beByteArrayToString(byte[] buf, int off, int len) {
        if (off + len > buf.length || len % 2 != 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = off; i < off + len; i += 2) {
            sb.append((char)DataUtil.get16(buf, i));
        }
        return sb.toString();
    }

    public static String ucs2beByteArrayToString(byte[] buf) {
        return StringUtil.ucs2beByteArrayToString(buf, 0, buf.length);
    }

    public static byte[] stringToUcs2beByteArray(String string) {
        byte[] data = new byte[string.length() * 2];
        for (int c = 0; c < string.length(); ++c) {
            DataUtil.put16(data, c * 2, string.charAt(c));
        }
        return data;
    }

    public static String byteArrayToString(byte[] buf, int off, int len, boolean utf8) {
        boolean is1251Enc;
        if (buf.length < off + len) {
            return null;
        }
        while (len > 0 && buf[off + len - 1] == 0) {
            --len;
        }
        if (utf8) {
            try {
                byte[] buf2 = new byte[len + 2];
                DataUtil.put16(buf2, 0, len);
                System.arraycopy(buf, off, buf2, 2, len);
                ByteArrayInputStream bais = new ByteArrayInputStream(buf2);
                DataInputStream dis = new DataInputStream(bais);
                return dis.readUTF();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is1251Enc = true) {
            return StringUtil.byteArray1251ToString(buf, off, len);
        }
        return new String(buf, off, len);
    }

    public static String byteArrayToString(byte[] buf, int off, int len) {
        return StringUtil.byteArrayToString(buf, off, len, false);
    }

    public static String byteArrayToString(byte[] buf, boolean utf8) {
        return StringUtil.byteArrayToString(buf, 0, buf.length, utf8);
    }

    public static String byteArrayToString(byte[] buf) {
        return StringUtil.byteArrayToString(buf, 0, buf.length, false);
    }

    public static long byteArrayToLong(byte[] b) {
        long l = 0L;
        l |= (long)(b[0] & 0xFF);
        l <<= 8;
        l |= (long)(b[1] & 0xFF);
        l <<= 8;
        if (b.length > 3) {
            l |= (long)(b[2] & 0xFF);
            l <<= 8;
            l |= (long)(b[3] & 0xFF);
        }
        return l;
    }

    public static String byteArrayToHexString(byte[] buf) {
        StringBuffer hexString = new StringBuffer(buf.length);
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(256 + (buf[i] & 0xFF)).substring(1);
            hexString.append((hex.length() < 2 ? "0" : S_EMPTY) + hex);
        }
        return hexString.toString();
    }

    public static byte[] stringToByteArray(String val, boolean utf8) {
        boolean is1251Enc;
        if (utf8) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeUTF(val);
                byte[] raw = baos.toByteArray();
                byte[] result = new byte[raw.length - 2];
                System.arraycopy(raw, 2, result, 0, raw.length - 2);
                return result;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is1251Enc = true) {
            return StringUtil.stringToByteArray1251(val);
        }
        return val.getBytes();
    }

    public static byte[] stringToByteArray(String val) {
        return StringUtil.stringToByteArray(val, false);
    }

    public static boolean isFill(String textData) {
        if (textData != null) {
            for (int c = 0; c < textData.length(); ++c) {
                if (textData.charAt(c) == ' ') continue;
                return true;
            }
        }
        return false;
    }

    public static String toXmlWellFormed(String string) {
        LogUtil.outMessage("To XML well formed");
        String[] symbols = new String[]{"&", "<", ">", "'", S_QUOTE};
        String[] replace = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
        int location = 0;
        for (int c = 0; c < symbols.length; ++c) {
            if ((location = string.indexOf(symbols[c], location)) >= 0) {
                string = string.substring(0, location).concat(replace[c]).concat(string.substring(location + 1));
                location += replace[c].length();
                --c;
                continue;
            }
            location = 0;
        }
        return string;
    }

    public static String toStringFromXmlWellFormed(String string) {
        String[] symbols = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
        String[] replace = new String[]{"&", "<", ">", "'", S_QUOTE};
        for (int c = 0; c < symbols.length; ++c) {
            int location = string.indexOf(symbols[c], 0);
            if (location < 0) continue;
            string = string.substring(0, location).concat(replace[c]).concat(string.substring(location + symbols[c].length()));
            --c;
        }
        return string;
    }

    public static String generateString(int length) {
        String resultString = S_EMPTY;
        String symbols = "abdefhiknrstyzABDEFGHKNQRSTYZ23456789";
        Random random = new Random();
        for (int c = 0; c < length; ++c) {
            int rand = Math.abs(random.nextInt()) & 0xF;
            if (rand < 0) {
                --c;
                continue;
            }
            resultString = resultString + symbols.charAt(rand);
        }
        return resultString;
    }

    public static String ucs2leByteArrayToString(byte[] buf, int off, int len) {
        if (off + len > buf.length || len % 2 != 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = off; i < off + len; i += 2) {
            sb.append((char)DataUtil.get16_reversed(buf, i));
        }
        return sb.toString();
    }

    public static String ucs2leByteArrayToString(byte[] buf) {
        return StringUtil.ucs2leByteArrayToString(buf, 0, buf.length);
    }

    public static byte[] stringToUcs2leByteArray(String string) {
        byte[] data = new byte[string.length() * 2];
        for (int c = 0; c < string.length(); ++c) {
            DataUtil.put16_reversed(data, c * 2, string.charAt(c));
        }
        return data;
    }

    public static int determEncoding(byte[] data) {
        int encIndex = 2;
        for (int c = 0; c < data.length; ++c) {
            if ((c + 1) % 2 != 0) continue;
            if (data[c] >= 0 && data[c] <= 10) {
                encIndex = 1;
                continue;
            }
            encIndex = 2;
            break;
        }
        return encIndex;
    }

    public static String[] wrapText(String text, int width, Font font) {
        return StringUtil.wrapText(text, width, font, false);
    }

    public static String[] wrapText(String text, int width, Font font, boolean isHidden) {
        int length = text.length();
        if (isHidden) {
            text = S_EMPTY;
            for (int c = 0; c < length; ++c) {
                text = text + "*";
            }
        }
        Vector<String> strings = new Vector<String>();
        if (font.stringWidth(text) <= width) {
            strings.addElement(text);
            Object[] anArray = new String[1];
            strings.copyInto(anArray);
            return anArray;
        }
        int offset = 0;
        for (int c = 1; c < text.length(); ++c) {
            String subString = text.substring(offset, c);
            length = font.stringWidth(subString);
            if (length >= width || text.charAt(c) == '\n') {
                int prevBrSymLoc;
                if (text.charAt(c) == '\n') {
                    prevBrSymLoc = -1;
                } else {
                    prevBrSymLoc = Math.max(subString.lastIndexOf(32), subString.lastIndexOf(46));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(44));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(59));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(58));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(41));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(40));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(45));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(33));
                    prevBrSymLoc = Math.max(prevBrSymLoc, subString.lastIndexOf(10));
                }
                if (prevBrSymLoc == -1) {
                    strings.addElement(subString.trim());
                    offset += subString.length() + 1;
                    continue;
                }
                strings.addElement(subString.substring(0, ++prevBrSymLoc).trim());
                offset += prevBrSymLoc;
                c -= subString.length() - prevBrSymLoc;
                continue;
            }
            if (c != text.length() - 1) continue;
            subString = text.substring(offset);
            strings.addElement(subString.trim());
            break;
        }
        Object[] anArray = new String[strings.size()];
        strings.copyInto(anArray);
        return anArray;
    }

    public static String replace(String where, String what, String with) {
        int index = -with.length();
        while ((index = where.indexOf(what, index + with.length())) != -1) {
            where = where.substring(0, index) + with + where.substring(index + what.length());
        }
        return where;
    }
}

