/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils;

import com.tomclaw.bingear.BinGear;
import com.tomclaw.bingear.GroupNotFoundException;
import com.tomclaw.bingear.IncorrectValueException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RecordUtil {
    public static void saveFile(final String fileName, final BinGear dataGear, boolean isBackground, final boolean isINIFormat) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    RecordUtil.removeFile(fileName);
                }
                catch (RecordStoreException ex) {
                    // empty catch block
                }
                try {
                    RecordUtil.saveFile(fileName, dataGear, isINIFormat);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        if (isBackground) {
            thread.setPriority(1);
            thread.start();
        } else {
            thread.run();
        }
    }

    public static int saveFile(String fileName, BinGear dataGear, boolean isIniFormat) throws IOException {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (isIniFormat) {
                dataGear.exportToIni(new DataOutputStream(baos));
            } else {
                dataGear.saveToDat(new DataOutputStream(baos));
            }
            int index = recordStore.addRecord(baos.toByteArray(), 0, baos.size());
            recordStore.closeRecordStore();
            return index;
        }
        catch (RecordStoreException recordStoreException) {
            return -1;
        }
    }

    public static void readFile(String fileName, BinGear dataGear) throws IOException, IncorrectValueException, GroupNotFoundException {
        dataGear.readFromDat(new DataInputStream(RecordUtil.openInputStream(fileName)));
    }

    public static InputStream openInputStream(String fileName) {
        return RecordUtil.openInputStream(fileName, 1);
    }

    public static InputStream openInputStream(String fileName, int index) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
            if (recordStore.getNumRecords() >= index) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(recordStore.getRecord(index));
                recordStore.closeRecordStore();
                return inputStream;
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public static int getRecordsCount(String fileName) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
            int numRecords = recordStore.getNumRecords();
            recordStore.closeRecordStore();
            return numRecords;
        }
        catch (RecordStoreException recordStoreException) {
            return -1;
        }
    }

    public static int getIndexSize(String fileName, int index) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)fileName, (boolean)true);
            int recordSize = recordStore.getRecordSize(index);
            recordStore.closeRecordStore();
            return recordSize;
        }
        catch (RecordStoreException recordStoreException) {
            return -1;
        }
    }

    public static void removeFile(String fileName) throws RecordStoreException {
        RecordStore.openRecordStore((String)fileName, (boolean)true).closeRecordStore();
        RecordStore.deleteRecordStore((String)fileName);
    }
}

