/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils;

import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.file.FileConnection;

public final class LogUtil {
    public static boolean isOutToSock = false;
    public static boolean isOutToFile = false;
    public static boolean isOutToCons = true;
    public static String filePath = "/root1/";
    private static OutputStream fileOutputStream = null;
    private static OutputStream sockOutputStream = null;
    private static OutputStream consOutputStream = null;
    public static long startTime = 0L;
    public static boolean isShowMessages = true;

    public static void initLogger(boolean isOutToCons, boolean isOutToSock, String host, int port, boolean isOutToFile, String filePath) {
        LogUtil.isOutToCons = isOutToCons;
        LogUtil.isOutToFile = isOutToFile;
        LogUtil.isOutToSock = isOutToSock;
        LogUtil.filePath = filePath;
        if (isOutToFile) {
            try {
                LogUtil.openFileConnection();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (isOutToCons) {
            try {
                LogUtil.openConsConnection();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (isOutToSock) {
            try {
                LogUtil.openSockConnection(host, port);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        startTime = System.currentTimeMillis();
        LogUtil.outSystem("Logger started at: " + startTime);
    }

    public static void outMessage(String logMessage) {
        LogUtil.outMessage(logMessage, false);
    }

    public static void outMessage(Class clazz, Throwable ex) {
        LogUtil.outMessage(clazz.getName() + " :: " + ex.toString() + " [ " + ex.getMessage() + " ]", true);
    }

    public static void outMessage(Throwable ex) {
        LogUtil.outMessage(ex.toString() + " : " + ex.getMessage(), true);
    }

    public static void outMessage(String logMessage, boolean isError) {
        if (isShowMessages) {
            logMessage = "[" + Runtime.getRuntime().freeMemory() / 1024L + " KiB / " + Runtime.getRuntime().totalMemory() / 1024L + " KiB] (" + (System.currentTimeMillis() - startTime) + " fs-ms.) " + (isError ? "[ERR] " : "") + logMessage;
            LogUtil.outSystem(logMessage + "\n");
        }
    }

    public static void outSystem(String logMessage) {
        if (isOutToFile) {
            LogUtil.write(fileOutputStream, logMessage);
        }
        if (isOutToSock) {
            LogUtil.write(sockOutputStream, logMessage);
        }
        if (isOutToCons) {
            LogUtil.write(consOutputStream, logMessage);
        }
    }

    public static OutputStream[] getOutputStreams() {
        return new OutputStream[]{fileOutputStream, sockOutputStream, consOutputStream};
    }

    private static void openFileConnection() throws IOException {
        String fileName = "file://" + filePath + "logutil_" + System.currentTimeMillis() + ".log";
        FileConnection fileConnection = (FileConnection)Connector.open((String)fileName, (int)3);
        if (!fileConnection.exists()) {
            fileConnection.create();
        }
        fileOutputStream = fileConnection.openOutputStream();
    }

    private static void openConsConnection() throws IOException {
        consOutputStream = System.out;
    }

    private static void openSockConnection(String host, int port) throws IOException {
        SocketConnection socket = (SocketConnection)Connector.open((String)("socket://" + host + ":" + port), (int)3);
        sockOutputStream = socket.openOutputStream();
    }

    private static void write(OutputStream outputStream, String logMessage) {
        if (outputStream != null && logMessage != null) {
            try {
                outputStream.write(logMessage.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

