/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawUtil {
    public static int smoothIndex = 1;
    public static boolean isHighQuality = false;
    public static boolean isLightGraphics = false;
    private static int pRed__ = 0;
    private static int pGreen = 0;
    private static int pBlue_ = 0;
    private static int sRed__ = 0;
    private static int sGreen = 0;
    private static int sBlue_ = 0;

    public static void fillSharpVerticalGradient(Graphics g, int objX, int objY, int objWidth, int objHeight, int color1, int color2, int color3, int color4, int divPrc) {
        int objHeightHalf = objHeight * divPrc / 100;
        DrawUtil.fillVerticalGradient(g, objX, objY, objWidth, objHeightHalf + 1, color1, color2);
        DrawUtil.fillVerticalGradient(g, objX, objY += objHeightHalf, objWidth, objHeight - objHeightHalf, color3, color4);
    }

    public static void fillVerticalGradient(Graphics g, int objX, int objY, int objWidth, int objHeight, int color1, int color2) {
        if (color1 == color2) {
            g.setColor(color1);
            g.fillRect(objX, objY, objWidth, objHeight);
        } else {
            pRed__ = (color1 & 0xFF0000) >> 16;
            pGreen = (color1 & 0xFF00) >> 8;
            pBlue_ = color1 & 0xFF;
            sRed__ = (color2 & 0xFF0000) >> 16;
            sGreen = (color2 & 0xFF00) >> 8;
            sBlue_ = color2 & 0xFF;
            if (isLightGraphics) {
                g.setColor((sRed__ - pRed__) / 2 + pRed__, (sGreen - pGreen) / 2 + pGreen, (sBlue_ - pBlue_) / 2 + pBlue_);
                g.fillRect(objX, objY, objWidth, objHeight);
            } else {
                for (int y = 0; y < objHeight; ++y) {
                    g.setColor((sRed__ - pRed__) * y / objHeight + pRed__, (sGreen - pGreen) * y / objHeight + pGreen, (sBlue_ - pBlue_) * y / objHeight + pBlue_);
                    g.drawLine(objX, objY + y, objX + objWidth - 1, objY + y);
                }
            }
        }
    }

    public static void drawVerticalGradientBorder(Graphics g, int objX, int objY, int objWidth, int objHeight, int color1, int color2) {
        if (color1 == color2) {
            g.setColor(color1);
            g.drawRect(objX, objY, objWidth, objHeight);
        } else {
            pRed__ = (color1 & 0xFF0000) >> 16;
            pGreen = (color1 & 0xFF00) >> 8;
            pBlue_ = color1 & 0xFF;
            sRed__ = (color2 & 0xFF0000) >> 16;
            sGreen = (color2 & 0xFF00) >> 8;
            sBlue_ = color2 & 0xFF;
            --objHeight;
            --objWidth;
            if (isLightGraphics) {
                g.setColor((sRed__ - pRed__) / 2 + pRed__, (sGreen - pGreen) / 2 + pGreen, (sBlue_ - pBlue_) / 2 + pBlue_);
                g.drawRect(objX, objY, objWidth, objHeight);
            } else {
                g.setColor(color1);
                g.drawLine(objX, objY, objX + objWidth, objY);
                g.setColor(color2);
                g.drawLine(objX, objY + objHeight, objX + objWidth, objY + objHeight);
                for (int y = 0; y < objHeight; ++y) {
                    g.setColor((sRed__ - pRed__) * y / objHeight + pRed__, (sGreen - pGreen) * y / objHeight + pGreen, (sBlue_ - pBlue_) * y / objHeight + pBlue_);
                    g.drawLine(objX, objY + y, objX, objY + y);
                    g.drawLine(objX + objWidth, objY + y, objX + objWidth, objY + y);
                }
            }
        }
    }

    public static void fillSharpHorizontalGradient(Graphics g, int objX, int objY, int objWidth, int objHeight, int color1, int color2, int color3, int color4) {
        int objWidthHalf = objWidth / 2;
        DrawUtil.fillHorizontalGradient(g, objX, objY, objWidthHalf, objHeight, color1, color2);
        DrawUtil.fillHorizontalGradient(g, objX += objWidthHalf, objY, objWidthHalf, objHeight, color3, color4);
    }

    public static void fillHorizontalGradient(Graphics g, int objX, int objY, int objWidth, int objHeight, int color1, int color2) {
        if (color1 == color2) {
            g.setColor(color1);
            g.fillRect(objX, objY, objWidth, objHeight);
        } else {
            pRed__ = (color1 & 0xFF0000) >> 16;
            pGreen = (color1 & 0xFF00) >> 8;
            pBlue_ = color1 & 0xFF;
            sRed__ = (color2 & 0xFF0000) >> 16;
            sGreen = (color2 & 0xFF00) >> 8;
            sBlue_ = color2 & 0xFF;
            if (isLightGraphics) {
                g.setColor((sRed__ - pRed__) / 2 + pRed__, (sGreen - pGreen) / 2 + pGreen, (sBlue_ - pBlue_) / 2 + pBlue_);
                g.fillRect(objX, objY, objWidth, objHeight);
            } else {
                for (int x = 0; x < objWidth; ++x) {
                    g.setColor((sRed__ - pRed__) * x / objWidth + pRed__, (sGreen - pGreen) * x / objWidth + pGreen, (sBlue_ - pBlue_) * x / objWidth + pBlue_);
                    g.drawLine(objX + x, objY, objX + x, objY + objHeight - 1);
                }
            }
        }
    }

    public static void drawHorizontalGradientBorder(Graphics g, int objX, int objY, int objWidth, int objHeight, int color1, int color2) {
        if (color1 == color2) {
            g.setColor(color1);
            g.drawRect(objX, objY, objWidth, objHeight);
        } else {
            pRed__ = (color1 & 0xFF0000) >> 16;
            pGreen = (color1 & 0xFF00) >> 8;
            pBlue_ = color1 & 0xFF;
            sRed__ = (color2 & 0xFF0000) >> 16;
            sGreen = (color2 & 0xFF00) >> 8;
            sBlue_ = color2 & 0xFF;
            --objHeight;
            --objWidth;
            if (isLightGraphics) {
                g.setColor((sRed__ - pRed__) / 2 + pRed__, (sGreen - pGreen) / 2 + pGreen, (sBlue_ - pBlue_) / 2 + pBlue_);
                g.drawRect(objX, objY, objWidth, objHeight);
            } else {
                g.setColor(color1);
                g.drawLine(objX, objY, objX, objY + objHeight);
                g.setColor(color2);
                g.drawLine(objX + objWidth, objY, objX + objWidth, objY + objHeight);
                for (int x = 0; x < objWidth; ++x) {
                    g.setColor((sRed__ - pRed__) * x / objWidth + pRed__, (sGreen - pGreen) * x / objWidth + pGreen, (sBlue_ - pBlue_) * x / objWidth + pBlue_);
                    g.drawLine(objX + x, objY, objX + x, objY);
                    g.drawLine(objX + x, objY + objHeight, objX + x, objY + objHeight);
                }
            }
        }
    }

    public static Image smoothImage(Image sourceImage, int imageX, int imageY, int imageWidth, int imageHeight) {
        int[] rgbData = new int[(imageWidth -= imageX) * (imageHeight -= imageY)];
        sourceImage.getRGB(rgbData, 0, imageWidth, imageX, imageY, imageWidth, imageHeight);
        for (int y = 1; y < imageHeight; ++y) {
            int prevY = (y - 1) * imageWidth;
            int currY = y * imageWidth;
            int nextY = y + 1 < imageHeight ? (y + 1) * imageWidth : currY;
            for (int x = 1; x < imageWidth - 1; ++x) {
                int currPoint = rgbData[currY + x];
                int prevYPoint = rgbData[prevY + x];
                int prevXPoint = rgbData[currY + x - 1];
                int nextYPoint = rgbData[nextY + x];
                int nextXPoint = rgbData[currY + x + 1];
                int b = ((currPoint & 0xFF0000) + (prevYPoint & 0xFF0000) + (prevXPoint & 0xFF0000) + (nextYPoint & 0xFF0000) + (nextXPoint & 0xFF0000)) / 5 & 0xFF0000;
                int g = ((currPoint & 0xFF00) + (prevYPoint & 0xFF00) + (prevXPoint & 0xFF00) + (nextYPoint & 0xFF00) + (nextXPoint & 0xFF00)) / 5 & 0xFF00;
                int r = ((currPoint & 0xFF) + (prevYPoint & 0xFF) + (prevXPoint & 0xFF) + (nextYPoint & 0xFF) + (nextXPoint & 0xFF)) / 5 & 0xFF;
                rgbData[currY + x] = r | g | b;
            }
        }
        return Image.createRGBImage((int[])rgbData, (int)imageWidth, (int)imageHeight, (boolean)false);
    }

    public static Image opaqueImage(Image sourceImage, Image __destImage, int prcSrcToDest) {
        if (prcSrcToDest > 100) {
            prcSrcToDest = 100;
        } else if (prcSrcToDest < 0) {
            prcSrcToDest = 0;
        }
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int[] rgbData = new int[imageWidth * imageHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        int[] rgbDest = new int[imageWidth * imageHeight];
        __destImage.getRGB(rgbDest, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        int prcDestToSrc = 100 - prcSrcToDest;
        for (int y = 0; y < imageHeight; ++y) {
            int currY = y * imageWidth;
            for (int x = 0; x < imageWidth; ++x) {
                int currPoint = rgbData[currY + x];
                int destPoint = rgbDest[currY + x];
                int b = ((currPoint & 0xFF0000) * prcSrcToDest + (destPoint & 0xFF0000) * prcDestToSrc) / 100 & 0xFF0000;
                int g = ((currPoint & 0xFF00) * prcSrcToDest + (destPoint & 0xFF00) * prcDestToSrc) / 100 & 0xFF00;
                int r = ((currPoint & 0xFF) * prcSrcToDest + (destPoint & 0xFF) * prcDestToSrc) / 100 & 0xFF;
                rgbData[currY + x] = r | g | b;
            }
        }
        return Image.createRGBImage((int[])rgbData, (int)imageWidth, (int)imageHeight, (boolean)false);
    }

    public static Image resizeImageWithAlphaProportional(Image sourceImage, int prcSize, int prcAlpha) {
        if (prcSize > 100) {
            prcSize = 100;
        } else if (prcSize <= 0) {
            return Image.createImage((int)1, (int)1);
        }
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int destWidth = imageWidth * prcSize / 100;
        int destHeight = imageHeight * prcSize / 100;
        int[] rgbData = new int[imageWidth * imageHeight];
        int[] rgbDest = new int[destWidth * destHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        int yy = 0;
        for (int y = 0; y < destHeight; ++y) {
            int currY = y * destWidth;
            int xx = 0;
            for (int x = 0; x < destWidth; ++x) {
                try {
                    int currPoint = rgbData[(yy * 100 + xx) / 100];
                    int a = currPoint & 0xFF000000;
                    int r = currPoint & 0xFF;
                    int g = currPoint & 0xFF00;
                    int b = currPoint & 0xFF0000;
                    a = a == -16777216 ? 256 : (a >>= 24);
                    a = (a -= 255 * prcAlpha / 100) >= 256 ? -16777216 : (a <<= 24);
                    rgbDest[currY + x] = a | r | g | b;
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                xx += 10000 / prcSize;
            }
            yy = y * imageHeight / destHeight * imageWidth;
        }
        return Image.createRGBImage((int[])rgbDest, (int)destWidth, (int)destHeight, (boolean)true);
    }

    public static Image resizeImageProportional(Image sourceImage, int prcSize) {
        if (prcSize > 100) {
            prcSize = 100;
        } else if (prcSize <= 0) {
            return Image.createImage((int)1, (int)1);
        }
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int destWidth = imageWidth * prcSize / 100;
        int destHeight = imageHeight * prcSize / 100;
        int[] rgbData = new int[imageWidth * imageHeight];
        int[] rgbDest = new int[destWidth * destHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        int yy = 0;
        for (int y = 0; y < destHeight; ++y) {
            int currY = y * destWidth;
            int xx = 0;
            for (int x = 0; x < destWidth; ++x) {
                try {
                    rgbDest[currY + x] = rgbData[(yy * 100 + xx) / 100];
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                xx += 10000 / prcSize;
            }
            yy = y * imageHeight / destHeight * imageWidth;
        }
        return Image.createRGBImage((int[])rgbDest, (int)destWidth, (int)destHeight, (boolean)false);
    }

    public static Image resizeImageSmoothProportional(Image sourceImage, int prcSize) {
        int addon;
        int A;
        int B;
        int G;
        int R;
        int total;
        int j;
        int i;
        int k;
        int part;
        int A2;
        int B2;
        int G2;
        int R2;
        int total2;
        int m;
        int a;
        int b;
        int g;
        int r;
        int addon2;
        int part2;
        int j2;
        int i2;
        int k2;
        if (prcSize > 100) {
            prcSize = 100;
        } else if (prcSize <= 0) {
            return Image.createImage((int)1, (int)1);
        }
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int destWidth = imageWidth * prcSize / 100;
        int destHeight = imageHeight * prcSize / 100;
        int[] rgbData = new int[imageWidth * imageHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        int[] lines = new int[destWidth * imageHeight];
        int[] columns = new int[destWidth * destHeight];
        if (destWidth < imageWidth) {
            for (k2 = 0; k2 < imageHeight; ++k2) {
                i2 = k2 * imageWidth;
                j2 = k2 * destWidth;
                part2 = destWidth;
                addon2 = 0;
                r = 0;
                g = 0;
                b = 0;
                a = 0;
                for (m = 0; m < destWidth; ++m) {
                    total2 = imageWidth;
                    R2 = 0;
                    G2 = 0;
                    B2 = 0;
                    A2 = 0;
                    if (addon2 != 0) {
                        R2 = r * addon2;
                        G2 = g * addon2;
                        B2 = b * addon2;
                        A2 = a * addon2;
                        total2 -= addon2;
                    }
                    while (0 < total2) {
                        a = rgbData[i2] >> 24 & 0xFF;
                        r = rgbData[i2] >> 16 & 0xFF;
                        g = rgbData[i2] >> 8 & 0xFF;
                        b = rgbData[i2++] & 0xFF;
                        if (total2 > part2) {
                            R2 += r * part2;
                            G2 += g * part2;
                            B2 += b * part2;
                            A2 += a * part2;
                        } else {
                            addon2 = part2 - total2;
                            lines[j2++] = (R2 += r * total2) / imageWidth << 16 | (G2 += g * total2) / imageWidth << 8 | (B2 += b * total2) / imageWidth | (A2 += a * total2) / imageWidth << 24;
                        }
                        total2 -= part2;
                    }
                }
            }
        } else {
            part = imageWidth;
            for (k = 0; k < imageHeight; ++k) {
                i = k * imageWidth;
                j = k * destWidth;
                total = 0;
                r = 0;
                g = 0;
                b = 0;
                a = 0;
                for (m = 0; m < destWidth; ++m) {
                    R = 0;
                    G = 0;
                    B = 0;
                    A = 0;
                    if (total >= part) {
                        R = r * part;
                        G = g * part;
                        B = b * part;
                        A = a * part;
                        total -= part;
                    } else {
                        if (0 != total) {
                            R = r * total;
                            G = g * total;
                            B = b * total;
                            A = a * total;
                        }
                        a = rgbData[i] >> 24 & 0xFF;
                        r = rgbData[i] >> 16 & 0xFF;
                        g = rgbData[i] >> 8 & 0xFF;
                        b = rgbData[i++] & 0xFF;
                        addon = part - total;
                        R += r * addon;
                        G += g * addon;
                        B += b * addon;
                        A += a * addon;
                        total = destWidth - addon;
                    }
                    lines[j++] = R / imageWidth << 16 | G / imageWidth << 8 | B / imageWidth | A / imageWidth << 24;
                }
            }
        }
        if (destHeight < imageHeight) {
            for (k2 = 0; k2 < destWidth; ++k2) {
                i2 = k2;
                j2 = k2;
                part2 = destHeight;
                addon2 = 0;
                r = 0;
                g = 0;
                b = 0;
                a = 0;
                for (m = 0; m < destHeight; ++m) {
                    total2 = imageHeight;
                    R2 = 0;
                    G2 = 0;
                    B2 = 0;
                    A2 = 0;
                    if (addon2 != 0) {
                        R2 = r * addon2;
                        G2 = g * addon2;
                        B2 = b * addon2;
                        A2 = a;
                        total2 -= addon2;
                    }
                    while (0 < total2) {
                        a = lines[i2] & 0xFF000000;
                        r = lines[i2] >> 16 & 0xFF;
                        g = lines[i2] >> 8 & 0xFF;
                        b = lines[i2] & 0xFF;
                        i2 += destWidth;
                        if (total2 > part2) {
                            R2 += r * part2;
                            G2 += g * part2;
                            B2 += b * part2;
                            A2 += a;
                        } else {
                            addon2 = part2 - total2;
                            columns[j2] = 0 != (A2 += a) ? (R2 += r * total2) / imageHeight << 16 | (G2 += g * total2) / imageHeight << 8 | (B2 += b * total2) / imageHeight | 0xFF000000 : 0;
                            j2 += destWidth;
                        }
                        total2 -= part2;
                    }
                }
            }
        } else {
            part = imageHeight;
            for (k = 0; k < destWidth; ++k) {
                i = k;
                j = k;
                total = 0;
                r = 0;
                g = 0;
                b = 0;
                a = 0;
                for (m = 0; m < destHeight; ++m) {
                    R = 0;
                    G = 0;
                    B = 0;
                    A = 0;
                    if (total >= part) {
                        R = r * part;
                        G = g * part;
                        B = b * part;
                        A = a;
                        total -= part;
                    } else {
                        if (0 != total) {
                            R = r * total;
                            G = g * total;
                            B = b * total;
                            A = a;
                        }
                        a = lines[i] & 0xFF000000;
                        r = lines[i] >> 16 & 0xFF;
                        g = lines[i] >> 8 & 0xFF;
                        b = lines[i] & 0xFF;
                        i += destWidth;
                        addon = part - total;
                        R += r * addon;
                        G += g * addon;
                        B += b * addon;
                        A += a;
                        total = destHeight - addon;
                    }
                    columns[j] = 0 != A ? R / imageHeight << 16 | G / imageHeight << 8 | B / imageHeight | 0xFF000000 : 0;
                    j += destWidth;
                }
            }
        }
        return Image.createRGBImage((int[])columns, (int)destWidth, (int)destHeight, (boolean)true);
    }

    public static Image blendColorAndImage(Image sourceImage, int blendColor) {
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int[] rgbData = new int[imageWidth * imageHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        pRed__ = blendColor & 0xFF;
        pGreen = (blendColor & 0xFF00) >> 8;
        pBlue_ = (blendColor & 0xFF0000) >> 16;
        for (int y = 0; y < imageHeight * imageWidth; ++y) {
            int currPoint = rgbData[y];
            int r = currPoint & 0xFF;
            int g = (currPoint & 0xFF00) >> 8;
            int b = (currPoint & 0xFF0000) >> 16;
            r = (r + pRed__) / 2;
            g = (g + pGreen) / 2;
            b = (b + pBlue_) / 2;
            rgbData[y] = r | g << 8 | b << 16;
        }
        return Image.createRGBImage((int[])rgbData, (int)imageWidth, (int)imageHeight, (boolean)false);
    }

    public static Image grayScaleImage(Image sourceImage) {
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int[] rgbData = new int[imageWidth * imageHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        for (int y = 0; y < imageHeight * imageWidth; ++y) {
            int currPoint = rgbData[y];
            int r = currPoint & 0xFF;
            int g = (currPoint & 0xFF00) >> 8;
            int b = (currPoint & 0xFF0000) >> 16;
            int grayColor = r * 76 / 255 + g * 149 / 255 + b * 29 / 255;
            rgbData[y] = grayColor | grayColor << 8 | grayColor << 16;
        }
        return Image.createRGBImage((int[])rgbData, (int)imageWidth, (int)imageHeight, (boolean)false);
    }

    public static Image setAlphaToImage(Image sourceImage, int prcAlpha) {
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int[] rgbData = new int[imageWidth * imageHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        for (int y = 0; y < imageHeight * imageWidth; ++y) {
            int currPoint = rgbData[y];
            int a = currPoint & 0xFF000000;
            int r = currPoint & 0xFF;
            int g = currPoint & 0xFF00;
            int b = currPoint & 0xFF0000;
            a = a == -16777216 ? 256 : (a >>= 24);
            a = (a -= 255 * prcAlpha / 100) >= 256 ? -16777216 : (a <<= 24);
            rgbData[y] = a | r | g | b;
        }
        return Image.createRGBImage((int[])rgbData, (int)imageWidth, (int)imageHeight, (boolean)true);
    }

    public static Image colorizeImage(Image sourceImage, int prcAlpha) {
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        int[] rgbData = new int[imageWidth * imageHeight];
        sourceImage.getRGB(rgbData, 0, imageWidth, 0, 0, imageWidth, imageHeight);
        for (int y = 0; y < imageHeight; ++y) {
            int currY = y * imageWidth;
            for (int x = 0; x < imageWidth; ++x) {
                int currPoint = rgbData[currY + x];
                int a = currPoint & 0xFF000000;
                int r = currPoint & 0xFF;
                int g = currPoint & 0xFF00;
                int b = currPoint & 0xFF0000;
                a = a == -16777216 ? 256 : (a >>= 24);
                b >>= 16;
                g >>= 8;
                if ((a -= 255 * prcAlpha / 100) < 0) {
                    a = 0;
                }
                if (a >= 256) {
                    a = 256;
                }
                a = a >= 256 ? -16777216 : (a <<= 24);
                rgbData[currY + x] = a | r | (g <<= 8) | (b <<= 16);
            }
        }
        return Image.createRGBImage((int[])rgbData, (int)imageWidth, (int)imageHeight, (boolean)true);
    }

    public static Image drawCornerShadow(int i, int j, int k, int l) {
        int i1 = i >>> 24;
        i &= 0xFFFFFF;
        int[] ai = new int[j * k];
        int j1 = 0;
        int k1 = 0;
        int byte0 = 0;
        int l1 = 0;
        switch (l) {
            case 0: {
                j1 = 1;
                k1 = -j + 1;
                byte0 = -1;
                l1 = k - 1;
                break;
            }
            case 1: {
                j1 = 1;
                k1 = 0;
                byte0 = -1;
                l1 = k - 1;
                break;
            }
            case 2: {
                j1 = 1;
                k1 = 0;
                byte0 = 1;
                l1 = 0;
                break;
            }
            case 3: {
                j1 = 1;
                k1 = -j + 1;
                byte0 = 1;
                l1 = 0;
            }
        }
        for (l = 0; l < j; ++l) {
            for (int i2 = 0; i2 < k; ++i2) {
                float f1 = l * j1 + k1;
                int j2 = i2 * byte0 + l1;
                f1 = (float)Math.sqrt(f1 * f1 + (float)(j2 * j2));
                j2 = (int)((float)i1 * (f1 - (float)j) * (f1 - (float)j) / (float)(j * j));
                if (f1 > (float)j) {
                    j2 = 0;
                }
                if (j2 < 0) {
                    j2 = 0;
                }
                ai[l + j * i2] = j2 << 24 | i;
            }
        }
        return Image.createRGBImage((int[])ai, (int)j, (int)k, (boolean)true);
    }

    public static Image drawShadow(int i, int j, int k, int l) {
        int i1 = i >>> 24;
        i &= 0xFFFFFF;
        int[] ai = new int[j * k];
        if (l == 0 || l == 2) {
            for (int j1 = 0; j1 < j; ++j1) {
                int l1 = j - 1 - j1;
                if (l == 2) {
                    l1 = j1;
                }
                l1 = i1 * (l1 - j) * (l1 - j) / (j * j);
                for (int j2 = 0; j2 < k; ++j2) {
                    ai[j1 + j * j2] = l1 << 24 | i;
                }
            }
        } else {
            for (int k1 = 0; k1 < k; ++k1) {
                int i2 = k - 1 - k1;
                if (l == 3) {
                    i2 = k1;
                }
                i2 = i1 * (i2 - k) * (i2 - k) / (k * k);
                for (int k2 = 0; k2 < j; ++k2) {
                    ai[k2 + j * k1] = i2 << 24 | i;
                }
            }
        }
        return Image.createRGBImage((int[])ai, (int)j, (int)k, (boolean)true);
    }

    public static Image fillShadow(int i, int j, int k) {
        int[] ai = new int[j * k];
        for (int k1 = 0; k1 < ai.length; ++k1) {
            ai[k1] = i;
        }
        return Image.createRGBImage((int[])ai, (int)j, (int)k, (boolean)true);
    }
}

