/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.utils;

import com.tomclaw.utils.TransUtil;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import java.util.Vector;

public class DataUtil {
    public static String codeString(String toCode) {
        String encoded = new String();
        for (int c = 0; c < toCode.length(); ++c) {
            String buffer = String.valueOf((int)toCode.charAt(c));
            if (buffer.length() == 1) {
                buffer = "0" + buffer;
            }
            if (buffer.length() == 2) {
                buffer = "0" + buffer;
            }
            if (buffer.length() == 3) {
                buffer = "0" + buffer;
            }
            if (buffer.length() == 4) {
                buffer = "0" + buffer;
            }
            encoded = encoded + buffer;
        }
        return encoded;
    }

    public static String byteArray2stringConvertXfes(byte[] ba) {
        StringBuffer sb = new StringBuffer(ba.length + 10);
        int chunkStart = 0;
        int chunkLen = 0;
        for (int i = 0; i < ba.length; ++i) {
            byte b = ba[i];
            if (b != -2) {
                ++chunkLen;
                continue;
            }
            sb.append(DataUtil.byteArray2string(ba, chunkStart, chunkLen));
            ++i;
            while (i < ba.length) {
                if (ba[i] != 254) {
                    --i;
                    break;
                }
                ++i;
            }
            chunkStart = i + 1;
            chunkLen = 0;
            if (i >= ba.length) break;
            sb.append("\r\n");
        }
        if (chunkLen > 0) {
            sb.append(DataUtil.byteArray2string(ba, chunkStart, chunkLen));
        }
        return sb.toString();
    }

    public static String byteArray2string(byte[] ba) {
        return DataUtil.byteArray2string(ba, 0, ba.length);
    }

    public static String byteArray2string(byte[] ba, int ofs, int len) {
        if (len == 0) {
            return "";
        }
        try {
            return new String(ba, ofs, len);
        }
        catch (Exception e) {
            return new String(ba, ofs, len);
        }
    }

    public static int put8(byte[] buf, int offset, int a) {
        buf[offset] = (byte)(a & 0xFF);
        return 1;
    }

    public static int put16(byte[] buf, int offset, int a) {
        buf[offset] = (byte)(a >> 8 & 0xFF);
        buf[++offset] = (byte)(a & 0xFF);
        return 2;
    }

    public static int put16_reversed(byte[] buf, int offset, int a) {
        buf[offset] = (byte)(a & 0xFF);
        buf[++offset] = (byte)(a >> 8 & 0xFF);
        return 2;
    }

    public static int put32(byte[] buf, int offset, long a) {
        buf[offset] = (byte)(a >> 24 & 0xFFL);
        buf[++offset] = (byte)(a >> 16 & 0xFFL);
        buf[++offset] = (byte)(a >> 8 & 0xFFL);
        buf[++offset] = (byte)(a & 0xFFL);
        return 4;
    }

    public static int put32_reversed(byte[] buf, int offset, long a) {
        buf[offset] = (byte)(a & 0xFFL);
        buf[++offset] = (byte)(a >> 8 & 0xFFL);
        buf[++offset] = (byte)(a >> 16 & 0xFFL);
        buf[++offset] = (byte)(a >> 24 & 0xFFL);
        return 4;
    }

    public static void putArray_reversed(byte[] buf, int offset, byte[] array) {
        for (int c = offset; c < array.length + offset; ++c) {
            buf[c] = array[array.length - 1 - (c - offset)];
        }
    }

    public static void putArray(byte[] buf, int offset, byte[] array) {
        for (int c = offset; c < array.length + offset; ++c) {
            buf[c] = array[c - offset];
        }
    }

    public static byte[] mmputil_prepareBytesFromLongReversed(long num) {
        byte[] data = new byte[4];
        DataUtil.put32_reversed(data, 0, num);
        return data;
    }

    public static byte[] mmputil_prepareBytesFromLong(long num) {
        byte[] data = new byte[4];
        DataUtil.put32(data, 0, num);
        return data;
    }

    public static byte[] mmputil_prepareBytesWthLength(byte[] string) {
        byte[] data = new byte[4 + string.length];
        DataUtil.put32_reversed(data, 0, string.length);
        if (string.length > 0) {
            DataUtil.putArray(data, 4, string);
        }
        return data;
    }

    public static byte[] mmputil_prepareByteStringWthLength(String string) {
        byte[] data = new byte[4 + string.length()];
        DataUtil.put32_reversed(data, 0, string.length());
        DataUtil.putArray(data, 4, string.getBytes());
        return data;
    }

    public static long reverseLong(long num) {
        long revNum = (num & 0xFFL) << 24 & 0xFFFFFFFFFF000000L;
        revNum |= (num >> 8 & 0xFFL) << 16 & 0xFF0000L;
        revNum |= (long)((byte)(num >> 16 & 0xFFL)) << 8 & 0xFF00L;
        return revNum |= (long)((byte)(num >> 24 & 0xFFL)) & 0xFFL;
    }

    public static int aim_puttlv_str_(byte[] buf, int offset, int tlv_type, byte[] stringAsByteArray) {
        int delta = 0;
        delta += DataUtil.put16(buf, offset + delta, tlv_type);
        delta += DataUtil.put16(buf, offset + delta, stringAsByteArray.length);
        System.arraycopy(stringAsByteArray, 0, buf, offset + delta, stringAsByteArray.length);
        return delta += stringAsByteArray.length;
    }

    public static byte[] string2byteArray(String s) {
        return s.getBytes();
    }

    public static int get8int(byte[] buf, int offset) {
        return buf[offset] & 0xFF;
    }

    public static byte get8(byte[] buf, int offset) {
        return (byte)(buf[offset] & 0xFF);
    }

    public static int get16(byte[] buf, int offset) {
        int val = buf[offset] << 8 & 0xFF00;
        return val |= buf[++offset] & 0xFF;
    }

    public static int get16_reversed(byte[] buf, int offset) {
        int val = buf[offset + 1] << 8 & 0xFF00;
        return val |= buf[offset] & 0xFF;
    }

    public static long get32(byte[] buf, int off, boolean bigEndian) {
        long val;
        if (bigEndian) {
            val = (long)buf[off] << 24 & 0xFFFFFFFFFF000000L;
            val |= (long)buf[++off] << 16 & 0xFF0000L;
            val |= (long)buf[++off] << 8 & 0xFF00L;
            val |= (long)buf[++off] & 0xFFL;
        } else {
            val = (long)buf[off] & 0xFFL;
            val |= (long)buf[++off] << 8 & 0xFF00L;
            val |= (long)buf[++off] << 16 & 0xFF0000L;
            val |= (long)buf[++off] << 24 & 0xFFFFFFFFFF000000L;
        }
        return val;
    }

    public static long get32_reversed(byte[] buf, int off, boolean bigEndian) {
        byte[] data = new byte[]{buf[off + 3], buf[off + 2], buf[off + 1], buf[off]};
        long val = DataUtil.get32(data, 0, bigEndian);
        return val;
    }

    public static byte[] getByteArray(byte[] buf, int offset) {
        return DataUtil.getByteArray(buf, offset + 1, DataUtil.get8int(buf, offset));
    }

    public static byte[] getByteArray(byte[] buf, int offset, int length) {
        byte[] b = TransUtil.createByteArray(length);
        System.arraycopy(buf, offset, b, 0, b.length);
        return b;
    }

    public static String getString(byte[] buf, int offset) {
        byte[] b = DataUtil.getByteArray(buf, offset);
        return DataUtil.byteArray2string(b);
    }

    public static byte[] getTlv(byte[] buf, int off) {
        if (off + 4 > buf.length) {
            return null;
        }
        int length = DataUtil.get16(buf, off + 2);
        if (off + 4 + length > buf.length) {
            return null;
        }
        byte[] value = new byte[length];
        System.arraycopy(buf, off + 4, value, 0, length);
        return value;
    }

    public static String getMetaString(int offset, byte[] data) {
        int length = DataUtil.get16_reversed(data, offset);
        String metaString = new String(data).substring(offset + 2, offset + 2 + length - 1);
        metaString = metaString + " ";
        offset += length;
        return metaString;
    }

    public static void nextBytes(byte[] unkBytes) {
        Random random = new Random();
        for (int c = 0; c < unkBytes.length; ++c) {
            unkBytes[c] = (byte)random.nextInt();
        }
    }

    public static byte[] byteStringToBytes(String text, char separator, int radix) {
        String[] strings = DataUtil.explode(text, separator);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (int i = 0; i < strings.length; ++i) {
            String item = strings[i];
            if (item.charAt(0) == '*') {
                for (int j = 1; j < item.length(); ++j) {
                    bytes.write((byte)item.charAt(j));
                }
                continue;
            }
            bytes.write(Integer.parseInt(item, radix));
        }
        return bytes.toByteArray();
    }

    public static String[] explode(String text, char separator) {
        Vector<String> tmp = new Vector<String>();
        StringBuffer strBuf = new StringBuffer();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char chr = text.charAt(i);
            if (chr == separator) {
                tmp.addElement(strBuf.toString());
                strBuf.delete(0, strBuf.length());
                continue;
            }
            strBuf.append(chr);
        }
        tmp.addElement(strBuf.toString());
        Object[] result = new String[tmp.size()];
        tmp.copyInto(result);
        return result;
    }
}

