/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite.smiles;

import com.tomclaw.tcuilite.smiles.Smiles;

public class SmileLink {
    public int smileIndex = -1;
    public int x;
    public int y;
    public int frameIndex = 0;
    public int backColor = 0xFFFFFF;
    public long frameTime = -1L;

    public SmileLink(int smileIndex) {
        this.smileIndex = smileIndex;
    }

    public void updateLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void analyzeFrame() {
        if (Smiles.smilesType == 0) {
            if (this.frameTime != -1L && System.currentTimeMillis() - this.frameTime < (long)Smiles.smiles[this.smileIndex].getFramesDelay()[this.frameIndex]) {
                return;
            }
            ++this.frameIndex;
            if (this.frameIndex >= Smiles.smiles[this.smileIndex].getFramesDelay().length) {
                this.frameIndex = 0;
            }
            this.frameTime = System.currentTimeMillis();
        }
    }

    public int getWidth() {
        return Smiles.smiles[this.smileIndex].getWidth();
    }

    public int getHeight() {
        return Smiles.smiles[this.smileIndex].getHeight();
    }
}

