/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Scroll;
import com.tomclaw.tcuilite.Settings;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Popup
extends Scroll {
    public Vector items = null;
    public int selectedIndex;
    public Soft soft;
    static Image popup;
    public int startIndex;
    public boolean t_wasDrawFlag = false;
    private static Image shadowCorner;
    private Image shadowHorizontal;
    private Image shadowVertical;
    private Image back;
    public static int foreColor;
    public static int foreSelColor;
    public static int backGradFrom;
    public static int backGradTo;
    public static int selectedGradFrom;
    public static int selectedGradTo;
    public static int selectedUpOutline;
    public static int selectedBottomOutline;
    public static int shadowBorder;
    public static int alphaBackColor;
    public static int shadowColor;
    public static final int alphaBackIndex = -603979776;
    public static final int shadowIndex = Integer.MIN_VALUE;
    public static final int shadowSize = 10;
    public int itemHeight;
    private PopupItem templistItem;
    private int imageOffset;

    public Popup() {
        this.items = new Vector();
        this.loadPopupImage();
    }

    public Popup(Vector items) {
        this.items = items;
        this.loadPopupImage();
    }

    private void loadPopupImage() {
        try {
            popup = Image.createImage((String)Settings.POPUP_IMAGE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addItem(PopupItem popupItem) {
        this.items.addElement(popupItem);
    }

    public void repaintBackground(Graphics g, int paintX, int paintY) {
        if (Settings.MENU_DRAW_SHADOWS && this.checkCache()) {
            g.drawImage(shadowCorner, this.x - 10, this.y - 10, 20);
            g.drawRegion(shadowCorner, 0, 0, 10, 10, 2, this.x + this.width + 1, this.y - 10, 20);
            g.drawRegion(shadowCorner, 0, 0, 10, 10, 7, this.x + this.width + 1, this.y + this.height, 20);
            g.drawRegion(shadowCorner, 0, 0, 10, 10, 1, this.x - 10, this.y + this.height, 20);
            g.drawImage(this.shadowVertical, this.x - 10, this.y, 20);
            g.drawImage(this.shadowHorizontal, this.x, this.y - 10, 20);
            g.drawRegion(this.shadowVertical, 0, 0, 10, this.height, 2, this.x + this.width + 1, this.y, 20);
            g.drawRegion(this.shadowHorizontal, 0, 0, this.width + 1, 10, 1, this.x, this.y + this.height, 20);
        }
        if (Settings.MENU_DRAW_ALPHABACK) {
            g.drawImage(this.back, this.x, this.y, 20);
        } else {
            DrawUtil.fillVerticalGradient(g, paintX + this.x + 1, paintY + this.y + 1, this.width - 1 - this.repaintScrollWidth, this.height - 1, backGradFrom, backGradTo);
            g.setColor(scrollBorder);
            g.drawRect(paintX + this.x, paintY + this.y, this.width, this.height - 1);
        }
    }

    public void repaintItems(Graphics g, int paintX, int paintY) {
        this.itemHeight = Theme.font.getHeight() + Theme.upSize * 2;
        if (!this.items.isEmpty() && this.items.size() > this.height / this.itemHeight) {
            this.repaintScrollWidth = Theme.scrollWidth;
            if (this.selectedIndex == -1) {
                this.selectedIndex = 0;
            }
        } else if (this.items.isEmpty()) {
            this.selectedIndex = -1;
        } else {
            this.repaintScrollWidth = -1;
            if (this.selectedIndex == -1) {
                this.selectedIndex = 0;
            }
        }
        if (!this.items.isEmpty()) {
            if (this.selectedIndex >= this.items.size()) {
                this.selectedIndex = this.items.size() - 1;
            } else if (this.selectedIndex < 0) {
                this.selectedIndex = 0;
            }
        }
        g.setFont(Theme.font);
        for (int c = this.startIndex = this.yOffset / this.itemHeight; c < this.startIndex + this.height / this.itemHeight + 1; ++c) {
            if (c == this.selectedIndex) {
                DrawUtil.fillVerticalGradient(g, paintX + this.x, paintY + this.y + c * this.itemHeight - this.yOffset, this.width - this.repaintScrollWidth, this.itemHeight, selectedGradFrom, selectedGradTo);
                g.setColor(selectedUpOutline);
                g.drawLine(paintX + this.x, paintY + this.y + c * this.itemHeight - this.yOffset, paintX + this.x + this.width - 1 - 1 - this.repaintScrollWidth + 1, paintY + this.y + c * this.itemHeight - this.yOffset);
                g.setColor(selectedBottomOutline);
                g.drawLine(paintX + this.x, paintY + this.y + (c + 1) * this.itemHeight - this.yOffset, paintX + this.x + this.width - 1 - 1 - this.repaintScrollWidth + 1, paintY + this.y + (c + 1) * this.itemHeight - this.yOffset);
                g.setColor(foreSelColor);
            } else {
                g.setColor(foreColor);
            }
            if (c >= this.items.size()) continue;
            this.templistItem = (PopupItem)this.items.elementAt(c);
            if (this.templistItem.imageFileHash != 0) {
                this.imageOffset = Splitter.drawImage(g, this.templistItem.imageFileHash, this.templistItem.imageIndex, paintX + this.x + Theme.upSize + 1, paintY + this.y + c * this.itemHeight - this.yOffset + this.itemHeight / 2, true);
                if (this.imageOffset > 0) {
                    this.imageOffset += Theme.upSize;
                }
            } else {
                this.imageOffset = 0;
            }
            if (!this.templistItem.isEmpty()) {
                g.drawImage(popup, paintX + this.x + this.width - popup.getWidth() - this.repaintScrollWidth, paintY + this.y + 1 + c * this.itemHeight - this.yOffset + this.itemHeight / 2, 3);
            }
            g.drawString(this.templistItem.title, paintX + this.x + 1 + Theme.upSize + 1 + this.imageOffset, paintY + this.y + 1 + c * this.itemHeight - this.yOffset + Theme.upSize + 1, 20);
        }
        if (this.repaintScrollWidth > 0) {
            if (!Settings.MENU_DRAW_ALPHABACK) {
                g.setColor(scrollBack);
                g.fillRect(paintX + this.x + this.width - this.repaintScrollWidth, paintY + this.y + 1, this.repaintScrollWidth, this.height - 2);
            }
            this.scrollStart = this.height * this.yOffset / (this.items.size() * this.itemHeight);
            this.scrollHeight = this.height * this.height / (this.items.size() * this.itemHeight) - 1;
            DrawUtil.fillHorizontalGradient(g, paintX + this.x + this.width - this.repaintScrollWidth, paintY + this.y + this.scrollStart, this.repaintScrollWidth, this.scrollHeight, scrollGradFrom, scrollGradTo);
            if (this.scrollHeight > 6) {
                g.setColor(scrollFixShadow);
                g.fillRect(paintX + this.x + this.width - this.repaintScrollWidth + 1, paintY + this.y + this.scrollStart + this.scrollHeight / 2 - 1, this.repaintScrollWidth - 2, 5);
                g.setColor(scrollFix);
                g.drawLine(paintX + this.x + this.width - this.repaintScrollWidth + 1, paintY + this.y + this.scrollStart + this.scrollHeight / 2 - 2, paintX + this.x + this.width - 2, paintY + this.y + this.scrollStart + this.scrollHeight / 2 - 2);
                g.drawLine(paintX + this.x + this.width - this.repaintScrollWidth + 1, paintY + this.y + this.scrollStart + this.scrollHeight / 2, paintX + this.x + this.width - 2, paintY + this.y + this.scrollStart + this.scrollHeight / 2);
                g.drawLine(paintX + this.x + this.width - this.repaintScrollWidth + 1, paintY + this.y + this.scrollStart + this.scrollHeight / 2 + 2, paintX + this.x + this.width - 2, paintY + this.y + this.scrollStart + this.scrollHeight / 2 + 2);
            }
            g.setColor(scrollBorder);
            g.drawRect(paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y + this.height * this.yOffset / (this.items.size() * this.itemHeight), this.repaintScrollWidth, this.height * this.height / (this.items.size() * this.itemHeight) - 1);
            if (Settings.MENU_DRAW_ALPHABACK) {
                g.setColor(shadowBorder);
                g.drawLine(paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y, paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y + this.height - 1);
                g.setColor(scrollBorder);
                g.drawLine(paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y + this.scrollStart, paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y + this.scrollStart + this.scrollHeight);
                g.drawLine(paintX + this.x + this.width, paintY + this.y + this.scrollStart, paintX + this.x + this.width, paintY + this.y + this.scrollStart + this.scrollHeight);
            } else {
                g.drawLine(paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y, paintX + this.x + this.width - this.repaintScrollWidth - 1, paintY + this.y + this.height - 1);
            }
        }
    }

    public void repaint(Graphics g) {
        this.repaint(g, 0, 0);
    }

    public void repaint(Graphics g, int paintX, int paintY) {
        this.repaintBackground(g, paintX, paintY);
        g.setClip(paintX + this.x, paintY + this.y, this.width + 1, this.height + 1);
        this.repaintItems(g, paintX, paintY);
    }

    public void prepareBackground() {
        if (Settings.MENU_DRAW_SHADOWS) {
            if (shadowCorner == null) {
                shadowCorner = DrawUtil.drawCornerShadow(shadowColor | Integer.MIN_VALUE, 10, 10, 0);
            }
            this.shadowVertical = DrawUtil.drawShadow(shadowColor | Integer.MIN_VALUE, 10, this.height, 0);
            this.shadowHorizontal = DrawUtil.drawShadow(shadowColor | Integer.MIN_VALUE, this.width + 1, 10, 1);
        }
        if (Settings.MENU_DRAW_ALPHABACK) {
            this.back = DrawUtil.fillShadow(alphaBackColor | 0xDC000000, this.width + 1, this.height);
        }
    }

    public boolean defineSize(int maxHeight) {
        int o_width = this.width;
        int o_height = this.height;
        this.itemHeight = Theme.font.getHeight() + Theme.upSize * 2;
        this.height = this.itemHeight * this.items.size() + 1;
        this.width = 0;
        for (int c = 0; c < this.items.size(); ++c) {
            int tempImageSize = 0;
            if (((PopupItem)this.items.elementAt((int)c)).imageFileHash != 0) {
                try {
                    tempImageSize = Splitter.getImageGroup((int)((PopupItem)this.items.elementAt((int)c)).imageFileHash).size + Theme.upSize;
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
            }
            if (Theme.font.stringWidth(((PopupItem)this.items.elementAt((int)c)).title) + Theme.upSize * 2 + 4 + (((PopupItem)this.items.elementAt(c)).isEmpty() ? 0 : popup.getWidth() + Theme.upSize) + tempImageSize <= this.width) continue;
            this.width = Theme.font.stringWidth(((PopupItem)this.items.elementAt((int)c)).title) + Theme.upSize * 2 + 4 + (((PopupItem)this.items.elementAt(c)).isEmpty() ? 0 : popup.getWidth() + Theme.upSize) + tempImageSize;
        }
        if (this.height + 10 > maxHeight) {
            this.height = this.itemHeight * ((maxHeight - 10) / this.itemHeight);
            this.width += Theme.scrollWidth;
            if (o_width != this.width || o_height != this.height || !this.checkCache()) {
                this.prepareBackground();
            }
            return true;
        }
        if (o_width != this.width || o_height != this.height || !this.checkCache()) {
            this.prepareBackground();
        }
        return false;
    }

    public void keyPressed(int keyCode) {
        if (this.items.isEmpty()) {
            this.selectedIndex = -1;
            return;
        }
        if (Screen.getExtGameAct(keyCode) == 1) {
            if (this.selectedIndex == 0) {
                this.selectedIndex = this.items.size() - 1;
                this.yOffset = this.itemHeight * this.items.size() - this.height + 1;
                if (this.yOffset < 0) {
                    this.yOffset = 0;
                }
                return;
            }
            --this.selectedIndex;
            if (this.yOffset > this.selectedIndex * this.itemHeight) {
                this.yOffset = this.selectedIndex * this.itemHeight;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 6) {
            if (this.selectedIndex == this.items.size() - 1) {
                this.selectedIndex = 0;
                this.yOffset = 0;
                return;
            }
            ++this.selectedIndex;
            if (this.yOffset + this.height < (this.selectedIndex + 1) * this.itemHeight + 1) {
                this.yOffset = (this.selectedIndex + 1) * this.itemHeight - this.height + 1;
            }
        }
        if (keyCode == 49) {
            this.selectedIndex = 0;
            this.yOffset = 0;
        }
        if (keyCode == 55) {
            this.selectedIndex = this.items.size() - 1;
            this.yOffset = this.itemHeight * this.items.size() - this.height + 1;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void pointerPressed(int x, int y) {
        this.t_wasDrawFlag = false;
        if (this.items.isEmpty()) {
            this.selectedIndex = -1;
            return;
        }
        if (x < this.x || y < this.y || x > this.x + this.width || y > this.y + this.height) {
            return;
        }
        if (x > this.x + this.width - this.repaintScrollWidth) {
            this.isScrollAction = true;
        } else {
            this.isScrollAction = false;
            if ((-this.y + this.yOffset + y) / this.itemHeight == this.selectedIndex) {
                return;
            }
            this.selectedIndex = (-this.y + this.yOffset + y) / this.itemHeight;
            if (this.selectedIndex > this.items.size() - 1) {
                this.selectedIndex = this.items.size() - 1;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.t_wasDrawFlag && this.selectedIndex != -1 && this.selectedIndex < this.items.size() && ((PopupItem)this.items.elementAt(this.selectedIndex)).isEmpty()) {
            ((PopupItem)this.items.elementAt(this.selectedIndex)).actionPerformed();
            this.soft.isLeftPressed = false;
            this.soft.isRightPressed = false;
        }
        this.t_wasDrawFlag = false;
        this.prevYDrag = -1;
    }

    public boolean pointerDragged(int x, int y) {
        this.t_wasDrawFlag = true;
        if (this.items.isEmpty()) {
            this.selectedIndex = -1;
            return false;
        }
        if (this.isScrollAction) {
            this.scrollStart = y - this.y - this.scrollHeight / 2;
            this.yOffset = this.scrollStart * (this.items.size() * this.itemHeight) / this.height;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.items.size() * this.itemHeight - this.height + 1) {
                this.yOffset = this.items.size() * this.itemHeight - this.height + 1;
            } else {
                return true;
            }
            return false;
        }
        if (this.repaintScrollWidth > 0) {
            if (this.prevYDrag == -1) {
                this.prevYDrag = this.yOffset + y;
                return true;
            }
            this.yOffset = this.prevYDrag - y;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.items.size() * this.itemHeight - this.height + 1) {
                this.yOffset = this.items.size() * this.itemHeight - this.height + 1;
            } else {
                return true;
            }
            return false;
        }
        return true;
    }

    public static void clearCache() {
        shadowCorner = null;
    }

    private boolean checkCache() {
        return shadowCorner != null && this.shadowVertical != null && this.shadowHorizontal != null;
    }

    static {
        foreColor = 0;
        foreSelColor = 0;
        backGradFrom = 0xEFEFEF;
        backGradTo = 0xCECFCE;
        selectedGradFrom = 0xDDDDFF;
        selectedGradTo = 0xBBAAEE;
        selectedUpOutline = 0xCCCCEE;
        selectedBottomOutline = 0xAAAACC;
        shadowBorder = 0xD9D8D9;
        alphaBackColor = 0xEAEAEA;
        shadowColor = 657930;
    }
}

