/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.images.Splitter;
import com.tomclaw.tcuilite.ListEvent;
import com.tomclaw.tcuilite.ListItem;
import com.tomclaw.tcuilite.ListRmsRenderer;
import com.tomclaw.tcuilite.Screen;
import com.tomclaw.tcuilite.Scroll;
import com.tomclaw.tcuilite.Theme;
import com.tomclaw.utils.DrawUtil;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class List
extends Scroll {
    public RecordStore recordStore;
    public ListRmsRenderer listRmsRenderer;
    public Vector items = new Vector();
    public int selectedIndex = 0;
    public ListEvent listEvent = null;
    public int startIndex = 0;
    public boolean isSelectedState = false;
    public static int foreColor = 0x555555;
    public static int foreSelColor = 0x555555;
    public static int backColor = 0xFFFFFF;
    public static int hrLine = 0xDDDDDD;
    public static int selectedGradFrom = 0xDDDDFF;
    public static int selectedGradTo = 0xBBAAEE;
    public static int selectedUpOutline = 0xCCCCEE;
    public static int selectedBottomOutline = 0xAAAACC;
    public int itemHeight;
    private ListItem templistItem;
    private int imageOffset = 0;

    public List() {
    }

    public List(String fileName) {
        this.openRecordStore(fileName);
    }

    public void addItem(ListItem listItem) {
        this.items.addElement(listItem);
        if (this.recordStore != null) {
            byte[] abyte0 = this.listRmsRenderer.getRmsData(listItem);
            try {
                this.recordStore.addRecord(abyte0, 0, abyte0.length);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void repaint(Graphics g) {
        this.repaint(g, 0, 0);
    }

    public void repaint(Graphics g, int paintX, int paintY) {
        this.itemHeight = Theme.font.getHeight() + Theme.upSize * 2;
        if (!this.items.isEmpty() && this.items.size() > this.height / this.itemHeight) {
            this.repaintScrollWidth = Theme.scrollWidth;
            if (this.selectedIndex == -1) {
                this.selectedIndex = 0;
            }
        } else if (this.items.isEmpty()) {
            this.selectedIndex = -1;
        } else {
            this.repaintScrollWidth = -1;
            if (this.selectedIndex == -1) {
                this.selectedIndex = 0;
            }
        }
        if (this.selectedIndex >= this.items.size()) {
            this.selectedIndex = this.items.size() - 1;
        }
        if (this.yOffset != 0 && this.items.size() * this.itemHeight - this.yOffset < this.height) {
            this.yOffset = this.items.size() * this.itemHeight > this.height ? this.items.size() * this.itemHeight - this.height : 0;
        }
        g.setFont(Theme.font);
        g.setColor(backColor);
        g.fillRect(paintX + this.x, paintY + this.y, this.width - this.repaintScrollWidth, this.height);
        for (int c = this.startIndex = this.yOffset / this.itemHeight; c < this.startIndex + this.height / this.itemHeight + 2; ++c) {
            if (c == this.selectedIndex) {
                DrawUtil.fillVerticalGradient(g, paintX + this.x, paintY + this.y + c * this.itemHeight - this.yOffset, this.width - 1 - this.repaintScrollWidth - this.x, this.itemHeight, selectedGradFrom, selectedGradTo);
                g.setColor(selectedUpOutline);
                g.drawLine(paintX + this.x, paintY + this.y + c * this.itemHeight - this.yOffset, paintX + this.x + this.width - 2 - 1 - this.repaintScrollWidth + 1, paintY + this.y + c * this.itemHeight - this.yOffset);
                g.setColor(selectedBottomOutline);
                g.drawLine(paintX + this.x, paintY + this.y + (c + 1) * this.itemHeight - this.yOffset, paintX + this.x + this.width - 2 - 1 - this.repaintScrollWidth + 1, paintY + this.y + (c + 1) * this.itemHeight - this.yOffset);
                g.setColor(foreSelColor);
            } else {
                g.setColor(hrLine);
                g.drawLine(paintX + this.x, paintY + this.y + (c + 1) * this.itemHeight - this.yOffset, paintX + this.x + 1 + this.width - 2 - this.repaintScrollWidth, paintY + this.y + (c + 1) * this.itemHeight - this.yOffset);
                g.setColor(foreColor);
            }
            if (c >= this.items.size()) continue;
            this.templistItem = this.getElement(c);
            if (this.templistItem.imageFileHash != 0) {
                this.imageOffset = Splitter.drawImage(g, this.templistItem.imageFileHash, this.templistItem.imageIndex, paintX + this.x + Theme.upSize + 1, paintY + this.y + c * this.itemHeight - this.yOffset + this.itemHeight / 2 + 1, true);
                if (this.imageOffset > 0) {
                    this.imageOffset += Theme.upSize;
                }
            } else {
                this.imageOffset = 0;
            }
            g.drawString(this.templistItem.title, paintX + this.x + Theme.upSize + 1 + this.imageOffset, paintY + this.y + c * this.itemHeight - this.yOffset + Theme.upSize + 1, 20);
            if (this.templistItem.descr == null) continue;
            g.setFont(Theme.titleFont);
            g.drawString(this.templistItem.descr, paintX + this.x + this.width - Theme.titleFont.stringWidth(this.templistItem.descr) - this.repaintScrollWidth - Theme.upSize, paintY + this.y + c * this.itemHeight - this.yOffset + Theme.upSize + 1, 20);
            g.setFont(Theme.font);
        }
        this.totalHeight = this.items.size() * this.itemHeight;
        super.repaint(g, paintX, paintY);
    }

    public void keyPressed(int keyCode) {
        if (this.items.isEmpty()) {
            this.selectedIndex = -1;
            return;
        }
        if (Screen.getExtGameAct(keyCode) == 1) {
            if (this.selectedIndex == 0) {
                this.selectedIndex = this.items.size() - 1;
                this.yOffset = this.itemHeight * this.items.size() - this.height + 1;
                if (this.yOffset < 0) {
                    this.yOffset = 0;
                }
                return;
            }
            --this.selectedIndex;
            if (this.yOffset > this.selectedIndex * this.itemHeight) {
                this.yOffset = this.selectedIndex * this.itemHeight;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 6) {
            if (this.selectedIndex == this.items.size() - 1) {
                this.selectedIndex = 0;
                this.yOffset = 0;
                return;
            }
            ++this.selectedIndex;
            if (this.yOffset + this.height < (this.selectedIndex + 1) * this.itemHeight + 1) {
                this.yOffset = (this.selectedIndex + 1) * this.itemHeight - this.height + 1;
            }
        }
        if (Screen.getExtGameAct(keyCode) == 8 && this.selectedIndex != -1 && this.selectedIndex < this.items.size()) {
            this.getElement(this.selectedIndex).actionPerformed();
            if (this.listEvent != null) {
                this.listEvent.actionPerformed(this.getElement(this.selectedIndex));
            }
        }
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void pointerPressed(int x, int y) {
        if (this.items.isEmpty()) {
            this.setSelectedIndex(-1);
            return;
        }
        if (x < this.x || y < this.y || x > this.x + this.width || y > this.y + this.height) {
            return;
        }
        if (x > this.x + this.width - this.repaintScrollWidth) {
            this.isScrollAction = true;
        } else {
            this.isScrollAction = false;
            this.setSelectedIndex((-this.y + this.yOffset + y) / this.itemHeight);
            if (this.selectedIndex > this.items.size() - 1) {
                this.setSelectedIndex(this.items.size() - 1);
            }
            if (this.isSelectedState && this.selectedIndex != -1 && this.selectedIndex < this.items.size()) {
                this.getElement(this.selectedIndex).actionPerformed();
                if (this.listEvent != null) {
                    this.listEvent.actionPerformed(this.getElement(this.selectedIndex));
                }
            }
            this.isSelectedState = true;
        }
    }

    public void pointerReleased(int x, int y) {
        this.prevYDrag = -1;
    }

    public boolean pointerDragged(int x, int y) {
        if (this.items.isEmpty()) {
            this.setSelectedIndex(-1);
            return false;
        }
        if (this.isScrollAction) {
            this.scrollStart = y - this.y - this.scrollHeight / 2;
            this.yOffset = this.scrollStart * (this.items.size() * this.itemHeight) / this.height;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.items.size() * this.itemHeight - this.height + 1) {
                this.yOffset = this.items.size() * this.itemHeight - this.height + 1;
            } else {
                return true;
            }
            return false;
        }
        if (this.repaintScrollWidth > 0) {
            if (this.prevYDrag == -1) {
                this.prevYDrag = this.yOffset + y;
                return true;
            }
            this.yOffset = this.prevYDrag - y;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            } else if (this.yOffset > this.items.size() * this.itemHeight - this.height + 1) {
                this.yOffset = this.items.size() * this.itemHeight - this.height + 1;
            } else {
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean openRecordStore(String fileName) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)fileName, (boolean)false);
            this.items.setSize(this.recordStore.getNumRecords());
            return true;
        }
        catch (Throwable ex) {
            this.recordStore = null;
            return false;
        }
    }

    public ListItem getElement(int index) {
        if (this.items.elementAt(index) != null) {
            return (ListItem)this.items.elementAt(index);
        }
        if (this.recordStore != null) {
            try {
                byte[] abyte0 = this.recordStore.getRecord(index + 1);
                ListItem listItem = this.listRmsRenderer.getRmsItem(abyte0);
                this.items.setElementAt(listItem, index);
                return listItem;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex != this.selectedIndex) {
            this.isSelectedState = false;
            this.selectedIndex = selectedIndex;
        }
    }
}

