/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.tcuilite;

import com.tomclaw.tcuilite.Content;
import com.tomclaw.tcuilite.PaneObject;
import com.tomclaw.tcuilite.PlainContent;
import com.tomclaw.utils.DrawUtil;
import javax.microedition.lcdui.Graphics;

public class Label
extends PaneObject {
    private Content content;
    private boolean isTitle = false;
    private boolean isHeader = false;
    public static int foreColor = 0x555555;
    public static int borderColor = 11570160;
    public static int focusedBackColor = 13881855;
    public static int actOuterLight = 12437503;
    public static int actInnerLight = 9214719;
    public static int headerForeColor = 0x55555555;
    public static int headerGradFrom = 0xADAAAD;
    public static int headerGradTo = 0xE7E3E7;
    public static int headerHr = 0xD6D3D6;

    public Label(String caption) {
        this(new PlainContent(caption));
    }

    public Label(Content content) {
        this.content = content;
        this.content.setColor(foreColor);
        this.setFocusable(false);
    }

    public void repaint(Graphics g) {
        if (this.isTitle) {
            g.setColor(borderColor);
            g.drawRect(this.x + 2, this.y + 2, this.width - 4, this.height - 4);
            g.setColor(focusedBackColor);
            g.fillRect(this.x + 3, this.y + 3, this.width - 5, this.height - 5);
        } else if (this.isHeader) {
            DrawUtil.fillVerticalGradient(g, this.x, this.y, this.width + 1, this.height, headerGradFrom, headerGradTo);
            g.setColor(headerHr);
            g.drawLine(this.x, this.y + this.height - 1, this.x + this.width, this.y + this.height - 1);
        }
        if (this.getFocusable() && this.getFocused()) {
            g.setColor(actOuterLight);
            g.drawRect(this.x, this.y, this.width, this.height);
            g.setColor(actInnerLight);
            g.drawRect(this.x + 1, this.y + 1, this.width - 2, this.height - 2);
        }
        g.setColor(this.isHeader ? headerForeColor : foreColor);
        this.content.paint(g);
    }

    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.content.setLocation(x, y);
    }

    public void setSize(int width, int height) {
        if (this.width != width) {
            this.width = width;
            this.content.setWidth(width);
            this.updateCaption();
        }
        this.height = this.getHeight();
    }

    public int getHeight() {
        return this.content.getHeight();
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public final void setCaption(String text) {
        this.content.setText(text);
    }

    public void updateCaption() {
        this.content.update();
    }

    public void setTitle(boolean isTitle) {
        this.isTitle = isTitle;
        this.updateCaption();
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
        this.updateCaption();
    }

    public String getStringValue() {
        return this.content.getText();
    }

    public void setContent(Content content) {
        this.content = content;
        this.content.setColor(foreColor);
    }

    public Content getContent() {
        return this.content;
    }
}

