/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.BuddyItem;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.Resource;
import com.tomclaw.mandarin.xmpp.XmppStatusUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class XmppItem
extends BuddyItem {
    public static final int NORMAL_BUDDY = 2;
    public Hashtable resources = new Hashtable();
    public boolean isGroupChat = false;
    public String groupChatNick = null;
    public String groupChatSubject = null;

    public XmppItem() {
    }

    public XmppItem(String userId) {
        super(userId);
    }

    public XmppItem(String userId, String name) {
        super(userId);
        this.setUserNick(name);
    }

    public int getUnreadCount() {
        int count = 0;
        Enumeration elements = this.resources.elements();
        while (elements.hasMoreElements()) {
            count += ((Resource)elements.nextElement()).unreadCount;
        }
        return count;
    }

    public int getUnreadCount(String resource) {
        return this.getResource((String)resource).unreadCount;
    }

    public void setUnreadCount(int unreadCount, String resource) {
        this.getResource((String)resource).unreadCount = unreadCount;
    }

    public void updateUiData() {
        String string = this.title = this.userNick == null || this.userNick.length() == 0 ? this.userId : this.userNick;
        if (this.resources.size() > 1) {
            this.title = this.title + " (" + (this.isGroupChat ? this.resources.size() - 1 : this.resources.size()) + ")";
        }
        int chatImage = -1;
        this.weight = 0;
        int status = this.getStatusIndex();
        if (status != XmppStatusUtil.offlineIndex && MidletMain.isSortOnline) {
            this.weight = -2;
        }
        if (this.getUnreadCount() > 0) {
            chatImage = 7;
            if (MidletMain.isRaiseUnread) {
                this.weight = -3;
            }
        }
        this.imageLeftIndex = new int[]{chatImage, status};
        this.imageRightIndex = new int[]{-1, -1, -1, -1, -1};
        if (MidletMain.chatFrame != null) {
            this.isBold = MidletMain.chatFrame.getChatTab(this.userId) != null || MidletMain.getBoolean(MidletMain.uniquest, String.valueOf("xmpp" + this.getUserId().hashCode()), "ON_TOP");
            this.weight = this.isBold ? -3 : this.weight;
        }
        try {
            if (MidletMain.uniquest.getGroup(String.valueOf("xmpp" + this.getUserId().hashCode())) != null) {
                this.imageRightIndex[4] = 25;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Resource getResource(String resource) {
        Resource t_resource = (Resource)this.resources.get(resource);
        if (t_resource == null) {
            t_resource = new Resource(resource);
            this.resources.put(resource, t_resource);
        }
        return t_resource;
    }

    public int getResourcesCount() {
        return this.resources.size();
    }

    public Resource getUnreadResource() {
        Enumeration elements = this.resources.elements();
        while (elements.hasMoreElements()) {
            Resource resource = (Resource)elements.nextElement();
            if (resource.unreadCount <= 0) continue;
            return resource;
        }
        return null;
    }

    public Resource getDefaultResource() {
        if (this.getResourcesCount() == 1) {
            return (Resource)this.resources.elements().nextElement();
        }
        return this.getResource("");
    }

    public boolean removeResource(String resource) {
        return this.resources.remove(resource) != null;
    }

    public void offlineResources() {
        if (!this.resources.isEmpty()) {
            Enumeration elements = this.resources.elements();
            while (elements.hasMoreElements()) {
                Resource resource = (Resource)elements.nextElement();
                resource.statusIndex = XmppStatusUtil.offlineIndex;
            }
        }
    }

    public int getBuddyType() {
        return 2;
    }

    public void setStatusIndex(int statusIndex, String resource) {
        if (resource == null) {
            this.offlineResources();
        } else {
            Resource _resource = this.getResource(resource);
            if (_resource != null) {
                _resource.statusIndex = statusIndex;
            }
        }
    }

    public int getStatusIndex() {
        if (this.isGroupChat) {
            return XmppStatusUtil.groupChatIndex;
        }
        if (!this.resources.isEmpty()) {
            Enumeration elements = this.resources.elements();
            while (elements.hasMoreElements()) {
                Resource resource = (Resource)elements.nextElement();
                if (resource.statusIndex == XmppStatusUtil.offlineIndex) continue;
                return resource.statusIndex;
            }
        }
        return XmppStatusUtil.offlineIndex;
    }
}

