/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.utils.StringUtil;
import java.io.InputStream;
import java.util.Hashtable;

public class XmlReader {
    public static final int TAG_UNKNOWN = 255;
    public static final int TAG_PLAIN = 0;
    public static final int TAG_QUESTION = 1;
    public static final int TAG_SELFCLOSING = 2;
    public static final int TAG_CLOSING = 3;
    public static final int TAG_COMMENT = 4;
    public InputStream inputStream;
    public String tagName = null;
    public int tagType = 255;
    public String body;
    public Hashtable attributes = new Hashtable();

    public XmlReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean nextTag() throws Throwable {
        int read;
        this.tagName = null;
        this.tagType = 255;
        int p_read = 0;
        StringBuffer buffer = new StringBuffer();
        boolean isReadTagName = false;
        boolean isCommentTag = false;
        boolean isReadAttributes = false;
        boolean isReadingAttrName = false;
        boolean isReadingAttrValue = false;
        boolean isAwaitingAttrName = false;
        boolean isAwaitingAttrValue = false;
        String mb_body = "";
        this.body = "";
        this.attributes.clear();
        String attribute = null;
        int tagSize = 0;
        while ((read = this.inputStream.read()) != -1) {
            ++tagSize;
            buffer.append((char)read);
            if (isReadTagName) {
                if (read == 63) {
                    this.tagType = 1;
                    isReadAttributes = true;
                    buffer.delete(0, 1);
                } else if (read == 33) {
                    this.tagType = 4;
                    isCommentTag = true;
                    isReadTagName = false;
                } else if (read == 47) {
                    this.tagType = 3;
                    buffer.setLength(0);
                    isReadTagName = false;
                    isReadAttributes = true;
                    this.body = mb_body;
                } else {
                    if (read == 62) {
                        this.tagType = 0;
                        this.tagName = this.subChars(buffer, 0, buffer.length() - 1);
                        return true;
                    }
                    if (read == 32) {
                        this.tagType = 0;
                        this.tagName = this.subChars(buffer, 0, buffer.length() - 1);
                        isReadTagName = false;
                        isReadAttributes = true;
                        isAwaitingAttrName = true;
                    }
                }
            } else if (isReadAttributes) {
                if (read == 62) {
                    if (this.tagType == 3) {
                        this.tagName = this.subChars(buffer, 0, buffer.length() - 1);
                    } else if (buffer.length() >= 2 && buffer.charAt(buffer.length() - 2) == '/') {
                        this.tagType = 2;
                    } else if (buffer.length() >= 2 && buffer.charAt(buffer.length() - 2) == '?') {
                        this.tagType = 1;
                    }
                    return true;
                }
                if (isAwaitingAttrName && read != 32 && read != 9 && read != 10) {
                    isAwaitingAttrName = false;
                    isReadingAttrName = true;
                    buffer.setLength(0);
                    buffer.append((char)read);
                }
                if (isReadingAttrName && (read == 61 || read == 32 || read == 9 || read == 10)) {
                    isReadingAttrName = false;
                    isAwaitingAttrValue = true;
                    buffer.setLength(buffer.length() - 1);
                    attribute = buffer.toString();
                } else if (isAwaitingAttrValue && (read == 34 || read == 39)) {
                    isAwaitingAttrValue = false;
                    isReadingAttrValue = true;
                    buffer.setLength(0);
                } else if (isReadingAttrValue && (read == 39 || read == 34) && p_read != 92) {
                    isReadingAttrValue = false;
                    isAwaitingAttrName = true;
                    this.attributes.put(attribute, this.subChars(buffer, 0, buffer.length() - 1));
                }
            } else if (isCommentTag) {
                if (read == 62) {
                    return true;
                }
            } else if (read == 60) {
                mb_body = this.subChars(buffer, 0, buffer.length() - 1);
                buffer.setLength(0);
                isReadTagName = true;
            }
            p_read = read;
        }
        MidletMain.incrementDataCount(tagSize);
        return false;
    }

    public String getAttrValue(String attribute, boolean isNullMayBe) {
        String value = (String)this.attributes.get(attribute);
        return isNullMayBe ? value : (value == null ? "" : value);
    }

    public String subChars(StringBuffer sb, int start, int end) {
        return this.subChars(sb, start, end, true);
    }

    public String subChars(StringBuffer sb, int start, int end, boolean utf8) {
        byte[] data = new byte[end - start];
        for (int c = 0; c < data.length; ++c) {
            data[c] = (byte)sb.charAt(c);
        }
        return StringUtil.toStringFromXmlWellFormed(StringUtil.byteArrayToString(data, utf8));
    }

    public String getBody() {
        return this.body == null ? "" : this.body;
    }
}

