/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.InfoFrame;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.AffiliationAddFrame;
import com.tomclaw.mandarin.xmpp.GroupChatUser;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.List;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Tab;
import com.tomclaw.tcuilite.TabEvent;
import com.tomclaw.tcuilite.TabItem;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import java.io.IOException;
import java.util.Vector;

public class GroupChatUsersFrame
extends Window {
    private XmppAccountRoot xmppAccountRoot;
    private String groupChatJid;
    private boolean isRole;
    private Tab tab;
    private List participantList;
    private List moderatorList;
    private List memberList;
    private List adminList;
    private List ownerList;
    private List outcastList;
    private String requestId = "";

    public GroupChatUsersFrame(final XmppAccountRoot xmppAccountRoot, final String groupChatJid, final boolean isRole) {
        super(MidletMain.screen);
        this.xmppAccountRoot = xmppAccountRoot;
        this.isRole = isRole;
        this.groupChatJid = groupChatJid;
        this.header = new Header(Localization.getMessage("GROUP_CHAT_USERS_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(GroupChatUsersFrame.this.s_prevWindow);
            }
        };
        final PopupItem infoPopupItem = new PopupItem(Localization.getMessage("INFO_AFFILIATION")){

            public void actionPerformed() {
                if (((List)((GroupChatUsersFrame)GroupChatUsersFrame.this).tab.gObject).selectedIndex != -1 && ((List)((GroupChatUsersFrame)GroupChatUsersFrame.this).tab.gObject).selectedIndex < ((List)((GroupChatUsersFrame)GroupChatUsersFrame.this).tab.gObject).items.size()) {
                    GroupChatUser groupChatUser = (GroupChatUser)((List)((GroupChatUsersFrame)GroupChatUsersFrame.this).tab.gObject).items.elementAt(((List)((GroupChatUsersFrame)GroupChatUsersFrame.this).tab.gObject).selectedIndex);
                    String[] param = null;
                    String[] value = null;
                    if (groupChatUser.affiliation != null) {
                        param = new String[]{"AFFILIATION_JID", "NICK", "AFFILIATION_REASON", "AFFILIATION"};
                        value = new String[]{groupChatUser.jid, groupChatUser.nick, groupChatUser.reason == null ? Localization.getMessage("NO_REASON") : groupChatUser.reason, Localization.getMessage(groupChatUser.affiliation.toUpperCase())};
                    } else if (groupChatUser.role != null) {
                        param = new String[]{"AFFILIATION_JID", "NICK", "AFFILIATION_REASON", "ROLE"};
                        value = new String[]{groupChatUser.jid, groupChatUser.nick, groupChatUser.reason == null ? Localization.getMessage("NO_REASON") : groupChatUser.reason, Localization.getMessage(groupChatUser.role.toUpperCase())};
                    }
                    InfoFrame infoFrame = new InfoFrame(param, value);
                    infoFrame.s_prevWindow = GroupChatUsersFrame.this;
                    MidletMain.screen.setActiveWindow(infoFrame);
                }
            }
        };
        PopupItem roleItem = new PopupItem(Localization.getMessage("ROLE_INFO")){

            public void actionPerformed() {
                infoPopupItem.actionPerformed();
            }
        };
        PopupItem affiliationItem = new PopupItem(Localization.getMessage("AFFILIATION_ITEM"));
        affiliationItem.addSubItem(new PopupItem(Localization.getMessage("ADD_AFFILIATION")){

            public void actionPerformed() {
                MidletMain.affiliationAddFrame = new AffiliationAddFrame(xmppAccountRoot, groupChatJid);
                MidletMain.affiliationAddFrame.s_prevWindow = GroupChatUsersFrame.this;
                MidletMain.screen.setActiveWindow(MidletMain.affiliationAddFrame);
            }
        });
        affiliationItem.addSubItem(new PopupItem(Localization.getMessage("REMOVE_AFFILIATION")){

            public void actionPerformed() {
                try {
                    GroupChatUsersFrame.this.removeItem();
                }
                catch (IOException ex) {
                    Handler.showFail(Localization.getMessage("IO_EXCEPTION"));
                }
            }
        });
        affiliationItem.addSubItem(infoPopupItem);
        this.tab = new Tab(MidletMain.screen);
        if (isRole) {
            this.participantList = new List();
            this.moderatorList = new List();
            this.tab.addTabItem(new TabItem(Localization.getMessage("GROUP_CHAT_PARTICIPANT"), 0, -1));
            this.tab.addTabItem(new TabItem(Localization.getMessage("GROUP_CHAT_MODERATOR"), 0, -1));
            this.tab.setGObject(this.participantList);
            this.soft.rightSoft = roleItem;
        } else {
            this.memberList = new List();
            this.adminList = new List();
            this.ownerList = new List();
            this.outcastList = new List();
            this.tab.addTabItem(new TabItem(Localization.getMessage("GROUP_CHAT_MEMBER"), 0, -1));
            this.tab.addTabItem(new TabItem(Localization.getMessage("GROUP_CHAT_ADMIN"), 0, -1));
            this.tab.addTabItem(new TabItem(Localization.getMessage("GROUP_CHAT_OWNER"), 0, -1));
            this.tab.addTabItem(new TabItem(Localization.getMessage("GROUP_CHAT_OUTCAST"), 0, -1));
            this.tab.setGObject(this.memberList);
            this.soft.rightSoft = affiliationItem;
        }
        this.tab.tabEvent = new TabEvent(){

            public void stateChanged(int previousIndex, int selectedIndex, int tabsCount) {
                if (isRole) {
                    if (selectedIndex == 0) {
                        GroupChatUsersFrame.this.tab.setGObject(GroupChatUsersFrame.this.participantList);
                    } else if (selectedIndex == 1) {
                        GroupChatUsersFrame.this.tab.setGObject(GroupChatUsersFrame.this.moderatorList);
                    }
                } else if (selectedIndex == 0) {
                    GroupChatUsersFrame.this.tab.setGObject(GroupChatUsersFrame.this.memberList);
                } else if (selectedIndex == 1) {
                    GroupChatUsersFrame.this.tab.setGObject(GroupChatUsersFrame.this.adminList);
                } else if (selectedIndex == 2) {
                    GroupChatUsersFrame.this.tab.setGObject(GroupChatUsersFrame.this.ownerList);
                } else if (selectedIndex == 3) {
                    GroupChatUsersFrame.this.tab.setGObject(GroupChatUsersFrame.this.outcastList);
                }
            }
        };
        this.tab.selectedIndex = 0;
        this.setGObject(this.tab);
        try {
            this.requestLists();
        }
        catch (IOException ex) {
            Handler.showFail(Localization.getMessage("USERS_READING_FAILED"));
        }
    }

    public final void requestLists() throws IOException {
        this.requestId = "grchus_frm_".concat(this.xmppAccountRoot.xmppSession.getId());
        if (this.isRole) {
            XmppSender.requestGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId.concat("participant"), "role", "participant");
            XmppSender.requestGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId.concat("moderator"), "role", "moderator");
        } else {
            XmppSender.requestGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId.concat("member"), "affiliation", "member");
            XmppSender.requestGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId.concat("admin"), "affiliation", "admin");
            XmppSender.requestGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId.concat("owner"), "affiliation", "owner");
            XmppSender.requestGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId.concat("outcast"), "affiliation", "outcast");
        }
        MidletMain.screen.setWaitScreenState(true);
    }

    public void removeItem() throws IOException {
        if (((List)this.tab.gObject).selectedIndex != -1 && ((List)this.tab.gObject).selectedIndex < ((List)this.tab.gObject).items.size()) {
            GroupChatUser groupChatUser = (GroupChatUser)((List)this.tab.gObject).items.elementAt(((List)this.tab.gObject).selectedIndex);
            this.requestId = "grchus_rm_frm_".concat(this.xmppAccountRoot.xmppSession.getId());
            MidletMain.screen.setWaitScreenState(true);
            XmppSender.affiliationAddGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId, groupChatUser.jid, "none", "");
            this.requestLists();
        }
    }

    public void setResult(XmppAccountRoot xmppAccountRoot, String id, Vector items) {
        if (this.xmppAccountRoot.equals(xmppAccountRoot) && id.startsWith(this.requestId)) {
            if (id.endsWith("participant")) {
                this.participantList.items = items;
            } else if (id.endsWith("moderator")) {
                this.moderatorList.items = items;
            } else if (id.endsWith("member")) {
                this.memberList.items = items;
            } else if (id.endsWith("admin")) {
                this.adminList.items = items;
            } else if (id.endsWith("owner")) {
                this.ownerList.items = items;
            } else if (id.endsWith("outcast")) {
                this.outcastList.items = items;
            }
            MidletMain.screen.setWaitScreenState(false);
        }
    }

    public void setError(XmppAccountRoot xmppAccountRoot, String id) {
        if (this.xmppAccountRoot.equals(xmppAccountRoot) && id.startsWith(this.requestId)) {
            MidletMain.screen.setWaitScreenState(false);
            Handler.showFail(Localization.getMessage("PERMISSION_DENIED"));
            this.requestId = "";
        }
    }
}

