/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.xmpp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.xmpp.XmppAccountRoot;
import com.tomclaw.mandarin.xmpp.XmppSender;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Radio;
import com.tomclaw.tcuilite.RadioGroup;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import java.io.IOException;

public class AffiliationAddFrame
extends Window {
    private XmppAccountRoot xmppAccountRoot;
    private String groupChatJid;
    private Field jidField;
    private RadioGroup afflTypeGroup;
    private Field reasonField;
    private String requestId = "";

    public AffiliationAddFrame(XmppAccountRoot xmppAccountRoot, String groupChatJid) {
        super(MidletMain.screen);
        this.xmppAccountRoot = xmppAccountRoot;
        this.groupChatJid = groupChatJid;
        this.header = new Header(Localization.getMessage("AFFILIATION_ADD_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(AffiliationAddFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("AFFILIATION_ADD")){

            public void actionPerformed() {
                try {
                    AffiliationAddFrame.this.sendAffiliationAdd();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Pane pane = new Pane(null, false);
        pane.addItem(new Label(Localization.getMessage("AFFILIATION_JID").concat(":")));
        this.jidField = new Field("");
        this.jidField.setFocusable(true);
        this.jidField.setFocused(true);
        pane.addItem(this.jidField);
        this.afflTypeGroup = new RadioGroup();
        Radio memberRadio = new Radio(Localization.getMessage("GROUP_CHAT_MEMBER"), true);
        Radio adminRadio = new Radio(Localization.getMessage("GROUP_CHAT_ADMIN"), false);
        Radio ownerRadio = new Radio(Localization.getMessage("GROUP_CHAT_OWNER"), false);
        Radio outcastRadio = new Radio(Localization.getMessage("GROUP_CHAT_OUTCAST"), false);
        memberRadio.setFocusable(true);
        adminRadio.setFocusable(true);
        ownerRadio.setFocusable(true);
        outcastRadio.setFocusable(true);
        this.afflTypeGroup.addRadio(memberRadio);
        this.afflTypeGroup.addRadio(adminRadio);
        this.afflTypeGroup.addRadio(ownerRadio);
        this.afflTypeGroup.addRadio(outcastRadio);
        pane.addItem(new Label(Localization.getMessage("AFFILIATION_TYPE").concat(":")));
        pane.addItem(memberRadio);
        pane.addItem(adminRadio);
        pane.addItem(ownerRadio);
        pane.addItem(outcastRadio);
        pane.addItem(new Label(Localization.getMessage("AFFILIATION_REASON")));
        this.reasonField = new Field("");
        this.reasonField.setFocusable(true);
        pane.addItem(this.reasonField);
        this.setGObject(pane);
    }

    public void sendAffiliationAdd() throws IOException {
        String afflType = "none";
        switch (this.afflTypeGroup.getCombed()) {
            case 0: {
                afflType = "member";
                break;
            }
            case 1: {
                afflType = "admin";
                break;
            }
            case 2: {
                afflType = "owner";
                break;
            }
            case 3: {
                afflType = "outcast";
            }
        }
        this.requestId = "afladd_frm_".concat(this.xmppAccountRoot.xmppSession.getId());
        XmppSender.affiliationAddGroupChatLists(this.xmppAccountRoot.xmppSession, this.groupChatJid, this.requestId, this.jidField.getText(), afflType, this.reasonField.getText());
        MidletMain.screen.setWaitScreenState(true);
    }

    public void setRequestResult(XmppAccountRoot xmppAccountRoot, String requestId) {
        if (xmppAccountRoot.equals(this.xmppAccountRoot) && requestId.equals(this.requestId)) {
            MidletMain.screen.setWaitScreenState(false);
            MidletMain.screen.setActiveWindow(this.s_prevWindow);
            try {
                MidletMain.groupChatUsersFrame.requestLists();
            }
            catch (IOException ex) {
                Handler.showFail(Localization.getMessage("USERS_READING_FAILED"));
            }
        }
    }
}

