/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.net;

import com.tomclaw.mandarin.net.Spore;
import com.tomclaw.utils.LogUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class SporedStream
extends OutputStream {
    private OutputStream outputStream;
    private Vector sporeQueue;
    public boolean isAlive;
    public Thread thread;

    public SporedStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.sporeQueue = new Vector();
        this.isAlive = false;
        this.thread = null;
        this.start();
    }

    public void releaseSpore(Spore spore) {
        this.sporeQueue.addElement(spore);
    }

    private void start() {
        this.stop();
        this.thread = new Thread(){

            public void run() {
                SporedStream.this.isAlive = true;
                LogUtil.outMessage("Spores stream now alive. ");
                try {
                    while (SporedStream.this.isAlive) {
                        if (SporedStream.this.sporeQueue.isEmpty()) {
                            LogUtil.outMessage("Zzz... (Spored stream)");
                            1.sleep(1000L);
                            continue;
                        }
                        LogUtil.outMessage("Spore preparing... ");
                        Spore spore = (Spore)SporedStream.this.sporeQueue.firstElement();
                        spore.invoke();
                        SporedStream.this.outputStream.write(spore.toByteArray());
                        SporedStream.this.outputStream.flush();
                        SporedStream.this.sporeQueue.removeElementAt(0);
                        LogUtil.outMessage("Spore sent. ");
                    }
                    LogUtil.outMessage("Cycle exit (spored). ");
                }
                catch (Throwable ex) {
                    LogUtil.outMessage("Exception in spored stream thread: " + ex.getMessage(), true);
                }
                SporedStream.this.isAlive = false;
                SporedStream.this.stop();
                LogUtil.outMessage("Connection destroyed (spored). ");
            }
        };
        this.thread.setPriority(1);
        this.thread.start();
    }

    private void stop() {
        if (this.thread != null) {
            LogUtil.outMessage("Thread stopping (spored)...");
            if (this.isAlive) {
                this.isAlive = false;
                try {
                    this.thread.join();
                }
                catch (InterruptedException ex) {
                    LogUtil.outMessage("Exception while stopping spored stream thread: " + ex.getMessage(), true);
                }
            }
            this.thread = null;
            LogUtil.outMessage("Thread stopped (spored).");
        } else {
            this.isAlive = false;
        }
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    public void close() throws IOException {
        this.stop();
        this.outputStream.close();
    }
}

