/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.mmp;

import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;

public class MmpStatusUtil {
    public static int phoneStatus = 56;
    public static final String[] statusesDescr = new String[]{"STATUS_OFFLINE", "STATUS_ONLINE", "STATUS_AWAY", "STATUS_FFC", "STATUS_DND", "STATUS_INVISIBLE"};
    public static final long[] statusIds = new long[]{0L, 1L, 2L, 260L, 516L, Integer.MIN_VALUE};
    public static final String[] statusesNames = new String[]{"status_0", "status_1", "status_2", "status_chat", "status_dnd", "status_3"};
    public static final String statusX = "status_";
    public static int baseStatusCount = 5;
    public static int extStatusCount = 50;

    public static boolean expectIsStatus(long status) {
        for (int c = 0; c < statusIds.length; ++c) {
            if (statusIds[c] != status) continue;
            return true;
        }
        return status + 2L >> 8 < (long)(extStatusCount + baseStatusCount);
    }

    public static int getStatusIndex(String statusName) {
        if (!StringUtil.isNullOrEmpty(statusName)) {
            for (int c = 0; c < statusesNames.length; ++c) {
                if (!statusName.equals(statusesNames[c])) continue;
                return c;
            }
            if (statusName.startsWith(statusX)) {
                try {
                    return 2 + Integer.parseInt(statusName.substring(statusX.length()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return 0;
    }

    public static String getStatusName(long statusId) {
        LogUtil.outMessage("getStatusName(" + statusId + ")");
        int index = MmpStatusUtil.getStatusIndex(statusId);
        LogUtil.outMessage("index = " + index);
        if (index >= statusesNames.length) {
            return statusX.concat(String.valueOf(index - 2));
        }
        return statusesNames[index];
    }

    public static String getStatusDescr(int index) {
        if (index >= statusIds.length) {
            return "MMP_EXT_" + index;
        }
        return statusesDescr[index];
    }

    public static int getStatusCount() {
        return baseStatusCount + extStatusCount;
    }

    public static long getStatus(int index) {
        if (index >= statusIds.length) {
            return (index -= 2) << 8 | 4;
        }
        return statusIds[index];
    }

    public static int getStatusIndex(long statusId) {
        for (int c = 0; c < statusIds.length; ++c) {
            if (statusId != statusIds[c]) continue;
            return c;
        }
        return (int)(statusId - 4L >> 8) + 2;
    }
}

