/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.mmp;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.mmp.MmpPacketParser;
import com.tomclaw.mandarin.mmp.MmpPacketSender;
import com.tomclaw.mandarin.mmp.Packet;
import com.tomclaw.mandarin.net.BinarySpore;
import com.tomclaw.mandarin.net.IncorrectAddressException;
import com.tomclaw.mandarin.net.NetConnection;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import java.io.IOException;

public class MmpSession
implements Runnable {
    public NetConnection netConnection;
    public int seqNum = 1;
    public boolean isAlive = false;
    public long pingDelay = 60000L;
    public static String clientId = null;
    public static String mraVer = null;
    public Thread listener = null;
    public MmpAccountRoot mmpAccountRoot;
    public boolean isError = false;

    public MmpSession(MmpAccountRoot mmpAccountRoot) {
        this.mmpAccountRoot = mmpAccountRoot;
        int major = Integer.parseInt(MidletMain.version.substring(0, MidletMain.version.indexOf(".")));
        int minor = Integer.parseInt(MidletMain.version.substring(MidletMain.version.indexOf(".") + 1));
        byte major1 = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(0)));
        byte main1 = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(1)));
        byte submain1 = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(2)));
        byte minor1 = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(3)));
        clientId = "client=\"Mandarin IM\" name=\"mandarin_im\" version=\"" + major + "." + minor + "\" build=\"" + major1 + main1 + submain1 + minor1 + "\"";
        mraVer = "Mandarin IM " + major + "." + minor;
    }

    public boolean login_stage(String hostPort, String userId, String passwrd, long statusId, String statusString) throws IncorrectAddressException, IOException, InterruptedException, IncorrectAddressException {
        this.isAlive = true;
        this.netConnection = new NetConnection();
        LogUtil.outMessage("Connecting...");
        this.netConnection.connectAddress(hostPort);
        Handler.setConnectionStage(this.mmpAccountRoot, 1);
        LogUtil.outMessage("Connected to: " + hostPort);
        byte[] header = this.netConnection.readTo((byte)10);
        Handler.setConnectionStage(this.mmpAccountRoot, 2);
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(header, "MRIM_CS_HELLO_ACK: ");
        }
        hostPort = new String(header, 0, header.length - 1);
        LogUtil.outMessage("Closing connection...");
        this.netConnection.disconnect();
        Handler.setConnectionStage(this.mmpAccountRoot, 3);
        LogUtil.outMessage("Connecting to RCS: " + hostPort);
        this.netConnection.connectAddress(hostPort);
        Handler.setConnectionStage(this.mmpAccountRoot, 4);
        LogUtil.outMessage("Conneced");
        Packet packet = new Packet();
        packet.seq = this.seqNum++;
        packet.msg = 4097L;
        packet.send(this.netConnection.outputStream);
        Handler.setConnectionStage(this.mmpAccountRoot, 5);
        LogUtil.outMessage("Hello packet sent");
        packet = this.receivePacket();
        this.pingDelay = DataUtil.get32_reversed(packet.data.byteString, 0, true) * 1000L;
        LogUtil.outMessage("Hello ack received");
        LogUtil.outMessage(">> pingDelay = " + this.pingDelay);
        Thread thread = new Thread(){

            public void run() {
                while (MmpSession.this.isAlive) {
                    try {
                        1.sleep(MmpSession.this.pingDelay);
                        BinarySpore binarySpore = new BinarySpore(){

                            public void onRun() throws Throwable {
                                Packet packet = new Packet();
                                packet.seq = (this).MmpSession.this.seqNum++;
                                packet.msg = 4102L;
                                packet.send(this);
                            }
                        };
                        MmpSession.this.netConnection.outputStream.releaseSpore(binarySpore);
                    }
                    catch (InterruptedException ex) {
                        LogUtil.outMessage("Can't send ping due to interrupt exception!");
                    }
                }
            }
        };
        thread.setPriority(1);
        thread.start();
        Handler.setConnectionStage(this.mmpAccountRoot, 6);
        Thread httpPing = new Thread(){

            public void run() {
                while (MmpSession.this.isAlive && MidletMain.httpHiddenPing > 0) {
                    try {
                        2.sleep(MidletMain.httpHiddenPing * 1000);
                        NetConnection.httpPing("http://www.mail.ru");
                    }
                    catch (Throwable ex) {
                        LogUtil.outMessage(ex.getMessage());
                    }
                }
            }
        };
        httpPing.setPriority(1);
        httpPing.start();
        Handler.setConnectionStage(this.mmpAccountRoot, 7);
        packet = new Packet();
        packet.seq = this.seqNum++;
        packet.msg = 4152L;
        packet.proto = 65550L;
        packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(userId));
        packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(passwrd));
        MmpPacketSender.appendStatusChunk(packet, statusId, statusString, true);
        packet.send(this.netConnection.outputStream);
        LogUtil.outMessage("Login sent");
        Handler.setConnectionStage(this.mmpAccountRoot, 8);
        packet = this.receivePacket();
        if (packet.msg == 4100L) {
            LogUtil.outMessage("Login ack received");
            this.listener = new Thread(this);
            this.listener.start();
            return true;
        }
        if (packet.msg == 4101L) {
            LogUtil.outMessage("Login rejected");
        }
        Handler.setConnectionStage(this.mmpAccountRoot, 9);
        return false;
    }

    public Packet receivePacket() throws IOException, InterruptedException, IndexOutOfBoundsException {
        Packet packet = new Packet();
        byte[] data = this.netConnection.read(44);
        if (data.length >= 44) {
            packet.parseHeader(data);
            packet.data.byteString = this.netConnection.read((int)packet.dlen);
            if (MidletMain.logLevel == 1) {
                LogUtil.outMessage(">> Header received");
                LogUtil.outMessage("   recv. head: " + HexUtil.bytesToString(data));
                LogUtil.outMessage("   recv. data: " + HexUtil.bytesToString(packet.data.byteString));
            }
            return packet;
        }
        LogUtil.outMessage(">> Header size is less than 44");
        if (MidletMain.logLevel == 1) {
            LogUtil.outMessage("   " + HexUtil.bytesToString(data));
        }
        return null;
    }

    public void disconnect() {
        this.isAlive = false;
        try {
            this.netConnection.disconnect();
        }
        catch (IOException ex) {
            LogUtil.outMessage("Couldn't disconnect from MMP");
        }
    }

    public void run() {
        this.isError = false;
        while (this.isAlive) {
            try {
                MmpPacketParser.parsePacket(this.mmpAccountRoot, this.receivePacket());
                if (MidletMain.pack_count > MidletMain.pack_count_invoke_gc) {
                    System.gc();
                    MidletMain.pack_count = 0;
                }
                ++MidletMain.pack_count;
            }
            catch (Throwable ex) {
                if (!this.isAlive) continue;
                this.isError = true;
                this.isAlive = false;
                LogUtil.outMessage(ex.getMessage(), true);
            }
        }
        try {
            this.netConnection.disconnect();
        }
        catch (Throwable ex) {
            LogUtil.outMessage("Disconnect failed: " + this.toString(), true);
        }
        int prevStatus = this.mmpAccountRoot.statusIndex;
        Handler.disconnectEvent(this.mmpAccountRoot);
        if (MidletMain.autoReconnect && this.isError) {
            try {
                Thread.sleep(MidletMain.reconnectTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mmpAccountRoot.connectAction(prevStatus);
        }
    }

    void setNetConnection(NetConnection netConnection) {
        this.netConnection = netConnection;
    }
}

