/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.mmp;

import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.mmp.MmpAccountRoot;
import com.tomclaw.mandarin.mmp.MmpSession;
import com.tomclaw.mandarin.mmp.MmpStatusUtil;
import com.tomclaw.mandarin.mmp.Packet;
import com.tomclaw.mandarin.net.BinarySpore;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;

public class MmpPacketSender {
    public static void MRIM_CS_CHANGE_STATUS(final MmpAccountRoot mmpAccountRoot, final long statusId, final String statusString) {
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = mmpAccountRoot.session.seqNum++;
                packet.msg = 4130L;
                packet.proto = 65558L;
                MmpPacketSender.appendStatusChunk(packet, statusId, statusString, false);
                packet.send(this);
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
    }

    public static void appendStatusChunk(Packet packet, long statusId, String statusString, boolean isSendClientInfo) {
        if (StringUtil.isNullOrEmpty(statusString)) {
            statusString = Localization.getMessage(MmpStatusUtil.getStatusDescr(MmpStatusUtil.getStatusIndex(statusId)));
        }
        byte[] temp = new byte[4];
        DataUtil.put32_reversed(temp, 0, statusId & 7L);
        packet.data.append(temp);
        packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(MmpStatusUtil.getStatusName(statusId)));
        packet.data.append(DataUtil.mmputil_prepareBytesWthLength(StringUtil.string1251ToByteArray(Localization.getMessage(MmpStatusUtil.getStatusDescr(MmpStatusUtil.getStatusIndex(statusId))))));
        packet.data.append(DataUtil.mmputil_prepareBytesWthLength(StringUtil.string1251ToByteArray(statusString)));
        if (isSendClientInfo) {
            DataUtil.put32_reversed(temp, 0, MmpSession.clientId.length() + MmpSession.mraVer.length());
            packet.data.append(temp);
            packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(MmpSession.clientId));
            packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(MmpSession.mraVer));
            packet.data.append(temp);
        } else {
            DataUtil.put32_reversed(temp, 0, 0L);
            packet.data.append(temp);
        }
    }

    public static byte[] MRIM_CS_MESSAGE(final MmpAccountRoot mmpAccountRoot, final String destMail, final String messageText, final long flags, final String addon) {
        final byte[] msgCookie = new byte[8];
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                LogUtil.outMessage(">>> MRIM_CS_MESSAGE to " + destMail);
                Packet packet = new Packet();
                packet.seq = mmpAccountRoot.session.seqNum++;
                packet.msg = 4104L;
                packet.proto = 65558L;
                packet.data.append(DataUtil.mmputil_prepareBytesFromLong(flags));
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(destMail));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(StringUtil.string1251ToByteArray(messageText)));
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(addon));
                packet.send(this);
                packet.dumpPacketData();
                DataUtil.put32(msgCookie, 0, packet.seq);
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
        return msgCookie;
    }

    public static void MRIM_CS_MESSAGE_RECV(final MmpAccountRoot mmpAccountRoot, final String destMail, final byte[] cookie) {
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = mmpAccountRoot.session.seqNum++;
                packet.msg = 4113L;
                packet.proto = 65550L;
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(destMail));
                packet.data.append(cookie);
                packet.send(this);
                packet.dumpPacketData();
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
    }

    public static Cookie MRIM_CS_ADD_CONTACT(MmpAccountRoot mmpAccountRoot, final long flags, final long groupId, final byte[] contact, final byte[] name, final byte[] unused) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = cookie.cookieValue;
                packet.msg = 4121L;
                packet.proto = 65557L;
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(flags));
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(groupId));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(contact));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(name));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(unused));
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(0L));
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(0L));
                packet.send(this);
                packet.dumpPacketData();
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static Cookie MRIM_CS_MODIFY_CONTACT(MmpAccountRoot mmpAccountRoot, final long id, final long flags, final long groupId, final byte[] contact, final byte[] name, final String phones) {
        final Cookie cookie = new Cookie();
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = cookie.cookieValue;
                packet.msg = 4123L;
                packet.proto = 65557L;
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(id));
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(flags));
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(groupId));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(contact));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(name));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(phones.getBytes()));
                packet.send(this);
                packet.dumpPacketData();
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
        return cookie;
    }

    public static void MRIM_CS_AUTHORIZE(final MmpAccountRoot mmpAccountRoot, final String destMail) {
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = mmpAccountRoot.session.seqNum++;
                packet.msg = 4128L;
                packet.proto = 65550L;
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(destMail));
                packet.send(this);
                packet.dumpPacketData();
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
    }

    public static void MRIM_CS_WP_REQUEST(final MmpAccountRoot mmpAccountRoot, final String destMail) {
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = mmpAccountRoot.session.seqNum++;
                packet.msg = 4137L;
                packet.proto = 65557L;
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(0L));
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(destMail.substring(0, destMail.indexOf(64))));
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(1L));
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(destMail.substring(destMail.indexOf(64) + 1)));
                packet.send(this);
                packet.dumpPacketData();
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
    }

    public static void MRIM_CS_SMS_MESSAGE(final MmpAccountRoot mmpAccountRoot, final String destMail, final String messText) {
        BinarySpore binarySpore = new BinarySpore(){

            public void onRun() throws Throwable {
                Packet packet = new Packet();
                packet.seq = mmpAccountRoot.session.seqNum++;
                packet.msg = 4153L;
                packet.proto = 65557L;
                packet.data.append(DataUtil.mmputil_prepareBytesFromLongReversed(0L));
                packet.data.append(DataUtil.mmputil_prepareByteStringWthLength(destMail));
                packet.data.append(DataUtil.mmputil_prepareBytesWthLength(StringUtil.string1251ToByteArray(messText)));
                packet.send(this);
                packet.dumpPacketData();
            }
        };
        mmpAccountRoot.session.netConnection.outputStream.releaseSpore(binarySpore);
    }
}

