/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.UpdateChecker;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Button;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.RichContent;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.TagUtil;
import javax.microedition.io.ConnectionNotFoundException;

public class UpdateCheckFrame
extends Window {
    private Pane pane;
    private Label sendLabel;
    private Label infoLabel;

    public UpdateCheckFrame(boolean isAutoCheck) {
        super(MidletMain.screen);
        if (isAutoCheck) {
            this.showRequestForm();
        } else {
            this.showPlainForm();
        }
    }

    public final void showRequestForm() {
        this.header = new Header(Localization.getMessage("UPDATE_CHECK_REQUEST"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(UpdateCheckFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("CHECK")){

            public void actionPerformed() {
                UpdateCheckFrame.this.showPlainForm();
                MidletMain.screen.repaint();
            }
        };
        this.pane = new Pane(null, false);
        this.sendLabel = new Label(Localization.getMessage("UPDATE_CHECK_NOTIFY"));
        this.sendLabel.setTitle(true);
        this.pane.addItem(this.sendLabel);
        this.infoLabel = new Label(Localization.getMessage("CHECKING_CAUSE"));
        this.pane.addItem(this.infoLabel);
        this.setGObject(this.pane);
    }

    public final void showPlainForm() {
        this.header = new Header(Localization.getMessage("UPDATE_CHECK_FRAME"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(UpdateCheckFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("HOMEPAGE")){

            public void actionPerformed() {
                try {
                    MidletMain.midletMain.platformRequest("http://www.tomclaw.com");
                }
                catch (ConnectionNotFoundException connectionNotFoundException) {
                    // empty catch block
                }
            }
        };
        this.pane = new Pane(null, false);
        this.sendLabel = new Label(Localization.getMessage("UPDATE_CHECK_STATUS"));
        this.sendLabel.setHeader(true);
        this.pane.addItem(this.sendLabel);
        this.infoLabel = new Label(Localization.getMessage("CHECKING_LABEL"));
        this.pane.addItem(this.infoLabel);
        this.setGObject(this.pane);
        this.requestUpdateCheck();
    }

    public final void requestUpdateCheck() {
        new Thread(){

            public void run() {
                try {
                    if (UpdateChecker.isUpdatePresent()) {
                        UpdateCheckFrame.this.sendLabel.setCaption(Localization.getMessage("UPDATE_STATUS"));
                        UpdateCheckFrame.this.infoLabel.setCaption(Localization.getMessage("UPDATE_IS_READY"));
                        UpdateCheckFrame.this.addLabels("LATEST_VERSION", UpdateChecker.latestVersion);
                        UpdateCheckFrame.this.addLabels("DOWNLOAD_COUNT", String.valueOf(UpdateChecker.downloadCount));
                        UpdateCheckFrame.this.addLabels("UPDATE_COUNT", String.valueOf(UpdateChecker.updateCount));
                        UpdateCheckFrame.this.addLabels("VERSION_URL", UpdateChecker.versionURL);
                        Button dlButton = new Button(Localization.getMessage("DOWNLOAD")){

                            public void actionPerformed() {
                                try {
                                    MidletMain.midletMain.platformRequest(UpdateChecker.versionURL);
                                }
                                catch (ConnectionNotFoundException connectionNotFoundException) {
                                    // empty catch block
                                }
                            }
                        };
                        dlButton.setFocusable(true);
                        dlButton.setFocused(true);
                        UpdateCheckFrame.this.pane.addItem(dlButton);
                        UpdateCheckFrame.this.addLabels("CHANGE_LOG", TagUtil.removeTags(UpdateChecker.changeLog));
                    } else {
                        UpdateCheckFrame.this.sendLabel.setCaption(Localization.getMessage("UPDATE_STATUS"));
                        UpdateCheckFrame.this.infoLabel.setCaption(Localization.getMessage("VERSION_UP_TO_DATE"));
                        UpdateCheckFrame.this.addLabels("COMING_VERSION", UpdateChecker.comingVersion);
                        UpdateCheckFrame.this.addLabels("COMING_DATE", UpdateChecker.comingDate);
                        UpdateCheckFrame.this.addLabels("COMING_TEXT", UpdateChecker.comingText);
                    }
                }
                catch (Throwable ex) {
                    UpdateCheckFrame.this.infoLabel.setCaption(Localization.getMessage("UPDATE_CHECK_FAILED"));
                }
                MidletMain.screen.repaint();
            }
        }.start();
    }

    private void addLabels(String title, String descr) {
        this.pane.addItem(new Label(new RichContent("[p][b]" + Localization.getMessage(title) + ": [/b]" + descr + "[/p]")));
    }
}

