/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Gauge;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.RichContent;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;

public class TransactionItemFrame
extends Window {
    public final DirectConnection directConnection;
    private Pane pane;
    private Label ___proxyLabel;
    private Label ___speedLabel;
    private Gauge gauge;
    private String proxyString;

    public TransactionItemFrame(final DirectConnection directConnection) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("TRANSACTION_WITH").concat(" ").concat(directConnection.getBuddyId()));
        this.directConnection = directConnection;
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("BACK")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(TransactionItemFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("STOP")){

            public void actionPerformed() {
                try {
                    directConnection.sendStop();
                }
                catch (IOException ex) {
                    LogUtil.outMessage("IOException: ".concat(ex.getMessage()));
                }
            }
        };
        this.pane = new Pane(null, false);
        this.addLabels("BUDDYID_LABEL", directConnection.getBuddyId());
        this.addLabels("FILENAME_LABEL", StringUtil.byteArrayToString(directConnection.getFileName(), true));
        this.addLabels("FILESIZE_LABEL", String.valueOf(directConnection.getFileByteSize()));
        this.___proxyLabel = this.addLabels("PROXY_LABEL", Localization.getMessage("NO_PROXY"));
        this.___speedLabel = this.addLabels("SPEED_LABEL", Localization.getMessage("CALCULATING"));
        this.gauge = new Gauge(Localization.getMessage("STATUS_LABEL"));
        this.pane.addItem(this.gauge);
        this.updateData();
        this.setGObject(this.pane);
    }

    private Label addLabels(String title, String descr) {
        Label label = this.updateLabels(new Label(new RichContent("")), title, descr);
        this.pane.addItem(label);
        return label;
    }

    private Label updateLabels(Label label, String title, String descr) {
        label.getContent().setText("[p][b]" + Localization.getMessage(title) + ": [/b]" + descr + "[/p]");
        label.updateCaption();
        return label;
    }

    public final void updateData() {
        this.proxyString = this.directConnection.getProxyIp() != null && this.directConnection.getProxyPort() != -1 ? this.directConnection.getProxyIp() + ":" + this.directConnection.getProxyPort() : Localization.getMessage("NO_PROXY");
        this.updateLabels(this.___proxyLabel, "PROXY_LABEL", this.proxyString);
        this.updateLabels(this.___speedLabel, "SPEED_LABEL", this.directConnection.getSpeed() + " " + Localization.getMessage("KBIT_PER_SEC"));
        this.gauge.caption = Localization.getMessage(this.directConnection.getStatusString());
        this.gauge.setValue(this.directConnection.getPercentValue());
        MidletMain.screen.repaint();
    }
}

