/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.main;

import com.tomclaw.mandarin.core.AccountRoot;
import com.tomclaw.mandarin.core.BuddyGroup;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.core.Queue;
import com.tomclaw.mandarin.core.QueueAction;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.tcuilite.Field;
import com.tomclaw.tcuilite.Header;
import com.tomclaw.tcuilite.Label;
import com.tomclaw.tcuilite.Pane;
import com.tomclaw.tcuilite.PopupItem;
import com.tomclaw.tcuilite.Soft;
import com.tomclaw.tcuilite.Window;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.util.Hashtable;

public class AddingGroupFrame
extends Window {
    private Field groupNameField;

    public AddingGroupFrame(final AccountRoot accountRoot) {
        super(MidletMain.screen);
        this.header = new Header(Localization.getMessage("ADD_GROUP"));
        this.soft = new Soft(MidletMain.screen);
        this.soft.leftSoft = new PopupItem(Localization.getMessage("CANCEL")){

            public void actionPerformed() {
                MidletMain.screen.setActiveWindow(AddingGroupFrame.this.s_prevWindow);
            }
        };
        this.soft.rightSoft = new PopupItem(Localization.getMessage("ADD")){

            public void actionPerformed() {
                if (!StringUtil.isFill(AddingGroupFrame.this.groupNameField.getText())) {
                    Handler.showNotify(Localization.getMessage("EMPTY_FIELD"));
                } else {
                    BuddyGroup buddyGroup = accountRoot.getGroupInstance();
                    buddyGroup.setUserId(AddingGroupFrame.this.groupNameField.getText());
                    Cookie cookie = accountRoot.addGroup(buddyGroup);
                    QueueAction queueAction = new QueueAction(accountRoot, buddyGroup, cookie){

                        public void actionPerformed(Hashtable params) {
                            this.accountRoot.getBuddyItems().addElement(this.buddyGroup);
                            LogUtil.outMessage("Action Performed");
                            this.buddyGroup.updateUiData();
                            this.accountRoot.updateOfflineBuddylist();
                        }
                    };
                    LogUtil.outMessage("QueueAction created");
                    Queue.pushQueueAction(queueAction);
                    MidletMain.screen.setActiveWindow(AddingGroupFrame.this.s_prevWindow);
                }
            }
        };
        Pane pane = new Pane(null, false);
        Label notifyLabel = new Label(Localization.getMessage("GROUP_ADDING"));
        notifyLabel.setHeader(true);
        pane.addItem(notifyLabel);
        pane.addItem(new Label(Localization.getMessage("ENTER_NAME_HERE")));
        this.groupNameField = new Field("");
        this.groupNameField.setFocusable(true);
        this.groupNameField.setFocused(true);
        this.groupNameField.title = Localization.getMessage("GROUP_NAME");
        pane.addItem(this.groupNameField);
        this.setGObject(pane);
    }
}

