/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.IcqPacketParser;
import com.tomclaw.mandarin.icq.IcqPacketSender;
import com.tomclaw.mandarin.icq.LegacyProtocolException;
import com.tomclaw.mandarin.icq.LoginFailedException;
import com.tomclaw.mandarin.icq.Snac;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.net.IncorrectAddressException;
import com.tomclaw.mandarin.net.NetConnection;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.MD5;
import com.tomclaw.utils.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class IcqSession
implements Runnable {
    public NetConnection netConnection = null;
    public int seq = 0;
    private boolean isAlive = true;
    public final IcqAccountRoot icqAccountRoot;
    public boolean isError = true;
    public boolean isRequestSsi = false;

    public IcqSession(IcqAccountRoot icqAccountRoot) {
        this.icqAccountRoot = icqAccountRoot;
    }

    public void setNetConnection(NetConnection netConnection) {
        this.netConnection = netConnection;
    }

    public int getNextSeq() {
        return ++this.seq;
    }

    public void loginMd5(int initStatus) throws IOException, InterruptedException, IncorrectAddressException, LegacyProtocolException, LoginFailedException {
        boolean authSuccess = false;
        LogUtil.outMessage("MD5 method");
        byte[] packetData = this.receivePacket();
        LogUtil.outMessage("Protocol received");
        byte[] flapHeader = Snac.createFlapHeader(1, this.getNextSeq(), 4);
        ByteArrayOutputStream bas = new ByteArrayOutputStream(flapHeader.length + 4);
        bas.write(flapHeader);
        bas.write(packetData);
        bas.flush();
        this.netConnection.write(bas.toByteArray());
        LogUtil.outMessage("Protocol sent");
        Snac snac = new Snac(23, 6, 0, 0, 0L);
        snac.addWord(1);
        snac.addWordLString(this.icqAccountRoot.userId);
        snac.addWord(75);
        snac.addWord(0);
        snac.addWord(90);
        snac.addWord(0);
        LogUtil.outMessage("sending auth key request");
        snac.send(this.getNetworkConnection().outputStream, this.getNextSeq());
        packetData = this.receivePacket();
        int snacFamily = DataUtil.get16(packetData, 0);
        int snacSubtype = DataUtil.get16(packetData, 2);
        LogUtil.outMessage("snacFamily: " + snacFamily);
        LogUtil.outMessage("snacSubtype: " + snacSubtype);
        if (MidletMain.logLevel == 1) {
            LogUtil.outMessage("Data: " + HexUtil.bytesToString(packetData));
        }
        if (snacFamily == 23 && snacSubtype == 7) {
            int keyLength = DataUtil.get16(packetData, 10);
            String key = DataUtil.byteArray2string(packetData, 12, keyLength);
            LogUtil.outMessage("Key: " + key);
            Handler.setConnectionStage(this.icqAccountRoot, 2);
            String aol = "AOL Instant Messenger (SM)";
            MD5 md5 = new MD5(key.concat(this.icqAccountRoot.userPassword).concat(aol).getBytes());
            byte[] md5hash = md5.doFinal();
            LogUtil.outMessage("MD5 Hash: " + HexUtil.bytesToString(md5hash));
            snac = new Snac(23, 2, 0, 0, 0L);
            snac.addWord(1);
            snac.addWordLString(this.icqAccountRoot.userId);
            snac.addWord(37);
            snac.addWord(md5hash.length);
            snac.addByteArray(md5hash);
            LogUtil.outMessage("sending MD5 hash");
            snac.send(this.getNetworkConnection().outputStream, this.getNextSeq());
            String bosHostPort = new String();
            byte[] cookie = new byte[]{};
            byte[] authResponse = this.receivePacket();
            LogUtil.outMessage("Auth: " + HexUtil.bytesToString(authResponse));
            int offset = 10;
            LogUtil.outMessage("authResponse.length = " + authResponse.length);
            while (offset < authResponse.length) {
                int respType = DataUtil.get16(authResponse, offset);
                int respLength = DataUtil.get16(authResponse, offset += 2);
                byte[] respValue = DataUtil.getByteArray(authResponse, offset += 2, respLength);
                offset += respLength;
                LogUtil.outMessage("Type: " + respType);
                switch (respType) {
                    case 1: {
                        LogUtil.outMessage("Screen name (UIN)");
                        break;
                    }
                    case 4: {
                        LogUtil.outMessage("Error page description url");
                        LogUtil.outMessage(new String(respValue));
                        break;
                    }
                    case 8: {
                        LogUtil.outMessage("Authorization error");
                        break;
                    }
                    case 12: {
                        LogUtil.outMessage("Unknown error");
                        break;
                    }
                    case 5: {
                        LogUtil.outMessage("BOS server address");
                        bosHostPort = new String(respValue);
                        authSuccess = true;
                        break;
                    }
                    case 6: {
                        LogUtil.outMessage("Authorization cookie");
                        cookie = respValue;
                        authSuccess &= true;
                    }
                }
            }
            if (authSuccess) {
                this.netConnection.disconnect();
                LogUtil.outMessage("Auth disconnected. Connecting to BOS: " + bosHostPort);
                Handler.setConnectionStage(this.icqAccountRoot, 4);
                this.netConnection.connectAddress(bosHostPort);
                LogUtil.outMessage("Connected to BOS");
                this.protocolNegotation(cookie, initStatus);
                return;
            }
        }
        LogUtil.outMessage("Login failed");
        throw new LoginFailedException();
    }

    public void login(int initStatus) throws IOException, InterruptedException, IncorrectAddressException, LegacyProtocolException, LoginFailedException {
        this.isAlive = true;
        if (this.icqAccountRoot.userId.indexOf(64) == -1) {
            this.loginMd5(initStatus);
            return;
        }
        boolean authSuccess = false;
        this.receivePacket();
        byte[] password_b = DataUtil.string2byteArray(this.icqAccountRoot.userPassword);
        byte[] xor_table = new byte[]{-13, 38, -127, -60, 57, -122, -37, -110};
        int xorindex = 0;
        for (int i = 0; i < password_b.length; ++i) {
            int n = i;
            password_b[n] = (byte)(password_b[n] ^ xor_table[xorindex++]);
            if (xorindex < xor_table.length) continue;
            xorindex = 0;
        }
        Snac snac = new Snac();
        snac.addDWord(1L);
        snac.addWord(86);
        snac.addWord(0);
        snac.addWord(1);
        snac.addWordLString(this.icqAccountRoot.userId);
        snac.addWord(2);
        snac.addWord(password_b.length);
        snac.addByteArray(password_b);
        byte[] flapHeader = Snac.createFlapHeader(1, this.getNextSeq(), snac.getByteArray().size());
        ByteArrayOutputStream bas = new ByteArrayOutputStream(flapHeader.length + snac.getByteArray().size());
        bas.write(flapHeader);
        bas.write(snac.getByteArray().toByteArray());
        bas.flush();
        this.netConnection.write(bas.toByteArray());
        String bosHostPort = new String();
        byte[] cookie = new byte[]{};
        byte[] authResponse = this.receivePacket();
        LogUtil.outMessage("Auth: " + HexUtil.bytesToString(authResponse));
        int offset = 0;
        LogUtil.outMessage("authResponse.length = " + authResponse.length);
        while (offset < authResponse.length) {
            int respType = DataUtil.get16(authResponse, offset);
            int respLength = DataUtil.get16(authResponse, offset += 2);
            byte[] respValue = DataUtil.getByteArray(authResponse, offset += 2, respLength);
            offset += respLength;
            LogUtil.outMessage("Type: " + respType);
            switch (respType) {
                case 1: {
                    LogUtil.outMessage("Screen name (UIN)");
                    MidletMain.mainFrame.getAccountTab((String)this.icqAccountRoot.getUserId()).accountUserId = StringUtil.byteArrayToString(respValue);
                    this.icqAccountRoot.userId = StringUtil.byteArrayToString(respValue);
                    LogUtil.outMessage("value = " + this.icqAccountRoot.userId);
                    break;
                }
                case 4: {
                    LogUtil.outMessage("Error page description url");
                    LogUtil.outMessage(new String(respValue));
                    break;
                }
                case 8: {
                    LogUtil.outMessage("Authorization error");
                    break;
                }
                case 12: {
                    LogUtil.outMessage("Unknown error");
                    break;
                }
                case 5: {
                    LogUtil.outMessage("BOS server address");
                    bosHostPort = new String(respValue);
                    authSuccess = true;
                    break;
                }
                case 6: {
                    LogUtil.outMessage("Authorization cookie");
                    cookie = respValue;
                    authSuccess &= true;
                }
            }
        }
        if (authSuccess) {
            this.netConnection.disconnect();
            LogUtil.outMessage("Auth disconnected. Connecting to BOS: " + bosHostPort);
            Handler.setConnectionStage(this.icqAccountRoot, 4);
            this.netConnection.connectAddress(bosHostPort);
            LogUtil.outMessage("Connected to BOS");
            this.protocolNegotation(cookie, initStatus);
            return;
        }
        LogUtil.outMessage("Login failed");
        throw new LoginFailedException();
    }

    public void protocolNegotation(byte[] cookie, int initStatus) throws IOException, InterruptedException, LegacyProtocolException {
        Handler.setConnectionStage(this.icqAccountRoot, 5);
        this.receiveAllPackets();
        byte[] chipsa_flapHeader = Snac.createFlapHeader(1, ++this.seq, 8 + cookie.length);
        byte[] xxx = new byte[8];
        int offset = 0;
        offset += DataUtil.put16(xxx, offset, 0);
        offset += DataUtil.put16(xxx, offset, 1);
        offset += DataUtil.put16(xxx, offset, 6);
        offset += DataUtil.put16(xxx, offset, cookie.length);
        byte[] cookie_reply = new byte[chipsa_flapHeader.length + xxx.length + cookie.length];
        System.arraycopy(chipsa_flapHeader, 0, cookie_reply, 0, chipsa_flapHeader.length);
        System.arraycopy(xxx, 0, cookie_reply, chipsa_flapHeader.length, xxx.length);
        System.arraycopy(cookie, 0, cookie_reply, chipsa_flapHeader.length + xxx.length, cookie.length);
        this.netConnection.write(cookie_reply);
        this.netConnection.flush();
        LogUtil.outMessage("Login to BOS is complete");
        Handler.setConnectionStage(this.icqAccountRoot, 6);
        this.receiveAllPackets();
        Snac snac = new Snac(1, 23, 0, 0, 23L);
        snac.addByteArray(new byte[]{0, 1, 0, 4, 0, 2, 0, 1, 0, 3, 0, 1, 0, 4, 0, 1, 0, 8, 0, 1, 0, 9, 0, 1, 0, 10, 0, 1, 0, 11, 0, 1, 0, 12, 0, 1, 0, 19, 0, 4, 0, 21, 0, 1, 0, 34, 0, 1, 0, 36, 0, 1, 0, 37, 0, 1});
        snac.send(this.netConnection.outputStream, ++this.seq);
        this.receiveAllPackets();
        snac = new Snac(1, 6, 0, 0, 7L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        this.receiveAllPackets();
        snac = new Snac(1, 8, 0, 0, 8L);
        snac.addWord(1);
        snac.addWord(2);
        snac.addWord(3);
        snac.addWord(4);
        snac.addWord(5);
        snac.send(this.netConnection.outputStream, ++this.seq);
        Handler.setConnectionStage(this.icqAccountRoot, 7);
        snac = new Snac(2, 2, 0, 0, 9L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        this.receiveAllPackets();
        IcqPacketSender.sendCapabilities(this.icqAccountRoot.session, this.icqAccountRoot.xStatusId, initStatus);
        snac = new Snac(3, 2, 0, 0, 10L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        Handler.setConnectionStage(this.icqAccountRoot, 8);
        snac = new Snac(4, 4, 0, 0, 11L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        snac = new Snac(4, 2, 0, 0, 12L);
        snac.addWord(0);
        snac.addDWord(11L);
        snac.addWord(8000);
        snac.addWord(999);
        snac.addWord(999);
        snac.addWord(0);
        snac.addWord(0);
        snac.send(this.netConnection.outputStream, ++this.seq);
        snac = new Snac(9, 2, 0, 0, 13L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        snac = new Snac(19, 2, 0, 0, 14L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        Handler.setConnectionStage(this.icqAccountRoot, 9);
        snac = new Snac(19, 4, 0, 0, 15L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        this.receiveAllPackets();
        snac = new Snac(19, 7, 0, 0, 16L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        this.finalActions(initStatus);
    }

    public void finalActions(int initStatus) throws IOException, IOException, InterruptedException {
        Snac snac = new Snac(1, 30, 0, 0, 6L);
        snac.addByteArray(new byte[]{0, 6, 0, 4});
        snac.addWord(1);
        if (initStatus < 4096) {
            snac.addWord(initStatus);
        } else {
            snac.addWord(0);
        }
        snac.addByteArray(new byte[]{0, 8, 0, 2, 0, 0, 0, 12, 0, 37, -64, -88, 4, 107, 0, 0, 115, 116, 4, 0, 11, 0, -82, -16, -98, 0, 0, 0, 80, 0, 0, 0, 3, 119, 101, 120, 104});
        try {
            byte major = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(0)));
            byte main = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(1)));
            byte submain = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(2)));
            byte minor = (byte)Integer.parseInt(String.valueOf(MidletMain.build.charAt(3)));
            LogUtil.outMessage("Version: " + major + "." + main + "." + submain + "." + minor);
            snac.addByte(major);
            snac.addByte(main);
            snac.addByte(submain);
            snac.addByte(minor);
        }
        catch (Throwable ex) {
            snac.addWord(0);
        }
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0});
        snac.send(this.netConnection.outputStream, ++this.seq);
        IcqPacketSender.setUpdatePrivacy(this.icqAccountRoot.session, this.icqAccountRoot.privateBuddyId, this.icqAccountRoot.pStatusId);
        snac = new Snac(1, 2, 0, 0, 2L);
        snac.addWord(1);
        snac.addWord(3);
        snac.addDWord(69636L);
        snac.addWord(2);
        snac.addWord(1);
        snac.addDWord(65796L);
        snac.addWord(3);
        snac.addWord(1);
        snac.addDWord(69636L);
        snac.addWord(4);
        snac.addWord(1);
        snac.addDWord(69636L);
        snac.addWord(6);
        snac.addWord(1);
        snac.addDWord(69636L);
        snac.addWord(8);
        snac.addWord(1);
        snac.addDWord(69636L);
        snac.addWord(9);
        snac.addWord(1);
        snac.addDWord(69636L);
        snac.addWord(10);
        snac.addWord(1);
        snac.addDWord(69636L);
        snac.addWord(19);
        snac.addWord(2);
        snac.addDWord(69636L);
        snac.send(this.netConnection.outputStream, ++this.seq);
        IcqPacketSender.requestOfflineMessages(this.icqAccountRoot.session, this.icqAccountRoot.userId);
        new Thread(this).start();
        Handler.setConnectionStage(this.icqAccountRoot, 10);
    }

    public void receiveAllPackets() throws IOException, InterruptedException, LegacyProtocolException {
        while (this.isAlive) {
            this.receivePacket();
            if (this.netConnection.getAvailable() >= 6) continue;
            break;
        }
    }

    public byte[] receivePacket() throws IOException, InterruptedException, LegacyProtocolException {
        byte[] flapData = this.netConnection.read(6);
        if (flapData == null || !this.isAlive) {
            LogUtil.outMessage("Disconnected. Flap reading aborted.");
            this.disconnect();
            return null;
        }
        int dataFieldLength = DataUtil.get16(flapData, 4);
        byte[] data = this.netConnection.read(dataFieldLength);
        if (data == null || !this.isAlive) {
            LogUtil.outMessage("Disconnected. Flap body reading aborted.");
            this.disconnect();
            return null;
        }
        IcqPacketParser.parsePacket(this.icqAccountRoot, data);
        return data;
    }

    public NetConnection getNetworkConnection() {
        return this.netConnection;
    }

    public void disconnect() {
        this.isAlive = false;
        try {
            this.netConnection.disconnect();
        }
        catch (Throwable ex) {
            LogUtil.outMessage("Coulnd't disconnect from ICQ!", true);
        }
    }

    public boolean getAlive() {
        return this.isAlive;
    }

    public void run() {
        Thread keepAlive = new Thread(){

            public void run() {
                while (IcqSession.this.isAlive && IcqSession.this.netConnection != null) {
                    try {
                        IcqPacketSender.sendKeepAlive(IcqSession.this.icqAccountRoot.session);
                        1.sleep(MidletMain.keepAliveDelay * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        keepAlive.setPriority(1);
        keepAlive.start();
        Thread httpPing = new Thread(){

            public void run() {
                while (IcqSession.this.isAlive && MidletMain.httpHiddenPing > 0) {
                    try {
                        NetConnection.httpPing("http://www.icq.com");
                        2.sleep(MidletMain.httpHiddenPing * 1000);
                    }
                    catch (Throwable ex) {
                        LogUtil.outMessage("HTTP hidden connection failed");
                    }
                }
            }
        };
        httpPing.setPriority(1);
        httpPing.start();
        this.isError = false;
        while (this.isAlive) {
            try {
                this.receivePacket();
                if (MidletMain.pack_count > MidletMain.pack_count_invoke_gc) {
                    System.gc();
                    MidletMain.pack_count = 0;
                }
                ++MidletMain.pack_count;
            }
            catch (IOException ex) {
                if (!this.isAlive) continue;
                this.isError = true;
                this.disconnect();
                LogUtil.outMessage("Failed: " + ex.getMessage(), true);
            }
            catch (Throwable ex1) {
                LogUtil.outMessage("Error in listener: " + ex1.getMessage(), true);
            }
        }
        this.isAlive = true;
        try {
            this.netConnection.disconnect();
            this.netConnection = null;
        }
        catch (IOException ex) {
            LogUtil.outMessage("Disconnect failed: " + this.toString(), true);
        }
        int prevStatus = this.icqAccountRoot.statusIndex;
        this.icqAccountRoot.statusIndex = 0;
        Handler.disconnectEvent(this.icqAccountRoot);
        if (MidletMain.autoReconnect && this.isError) {
            try {
                Thread.sleep(MidletMain.reconnectTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.icqAccountRoot.connectAction(prevStatus);
        }
    }
}

