/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.core.BuddyInfo;
import com.tomclaw.mandarin.core.Cookie;
import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.icq.Capability;
import com.tomclaw.mandarin.icq.ClientInfo;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.IcqGroup;
import com.tomclaw.mandarin.icq.IcqItem;
import com.tomclaw.mandarin.icq.IcqPacketSender;
import com.tomclaw.mandarin.icq.IcqStatusUtil;
import com.tomclaw.mandarin.icq.LegacyProtocolException;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.mmp.MmpPacketParser;
import com.tomclaw.tcuilite.localization.Localization;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import com.tomclaw.utils.TimeUtil;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;

public class IcqPacketParser {
    public static final int GENERIC_SERVICE_CONTROLS = 1;
    public static final int LOCATION_SERVICES = 2;
    public static final int BUDDY_LIST_MANAGEMENT_SERVICE = 3;
    public static final int ICBM_SERVICE = 4;
    public static final int PRIVACY_MANAGEMENT_SERVICE = 9;
    public static final int USAGE_STATS_SERVICE = 11;
    public static final int SSBI_SERVICE = 16;
    public static final int SSI_SERVICE = 19;
    public static final int ICQ_SPECIFIC_EXTENSIONS_SERVICE = 21;
    public static final int AUTHORIZATION_REGISTRATION_SERVICE = 23;
    public static final int BROADCAST_SERVICE = 133;
    public static final int BUDDY_USER_INFO = 37;
    public static final int TLV_AV_AUTH = 102;
    public static final int TLV_GR_IDS = 200;
    public static final int TLV_UNK = 201;
    public static final int TLV_AIM_PR_SET = 202;
    public static final int TLV_VIS_CLASS = 203;
    public static final int TLV_ALL_OTH_SEE = 204;
    public static final int TLV_SHORTCUT = 205;
    public static final int TLV_IMPORT_TIME = 212;
    public static final int TLV_BUDDY_ICON = 213;
    public static final int TLV_NICK_NAME = 305;
    public static final int TLV_MAIL_ADDR = 311;
    public static final int TLV_SMS_NUMBER = 314;
    public static final int TLV_BUDDY_COMMENT = 316;
    public static final int TLV_PERS_ALERTS = 317;
    public static final int TLV_SOUND_BUDDY = 318;
    public static final int TLV_FIRST_MESS = 325;
    public static final int UNDEFINED_TYPE = 255;
    public static final int NORMAL_UIN = 0;
    public static final int NORMAL_GROUP = 1;
    public static final int DELETED_UIN = 25;
    public static final int SYSTEM_GROUP = 32;
    public static final int UNK1_SYSTEM_TYPE = 29;
    public static final int UNK2_SYSTEM_TYPE = 21;
    public static final int PERMIT_LIST_RECORD = 2;
    public static final int DENY_LIST_RECORD = 3;
    public static final int IGNORE_LIST_RECORD = 14;
    public static final int PRESENCE_INFO = 5;
    public static final int OWN_ICON_AVATAR = 20;
    public static final int LAST_UPDATE_DATE = 15;
    public static final int PERMIT_DENY_SETTINGS = 4;
    public static final int OWN_GROUP_TYPE = 256;
    public static boolean isReceivePhantoms = false;
    public static final byte MTYPE_PLAIN = 1;
    public static final byte MTYPE_CHAT = 2;
    public static final byte MTYPE_FILEREQ = 3;
    public static final byte MTYPE_URL = 4;
    public static final byte MTYPE_AUTHREQ = 6;
    public static final byte MTYPE_AUTHDENY = 7;
    public static final byte MTYPE_AUTHOK = 8;
    public static final byte MTYPE_SERVER = 9;
    public static final byte MTYPE_ADDED = 12;
    public static final byte MTYPE_WWP = 13;
    public static final byte MTYPE_EEXPRESS = 14;
    public static final byte MTYPE_CONTACTS = 19;
    public static final byte MTYPE_PLUGIN = 26;
    public static final byte MTYPE_AUTOAWAY = -24;
    public static final byte MTYPE_AUTOBUSY = -23;
    public static final byte MTYPE_AUTONA = -22;
    public static final byte MTYPE_AUTODND = -21;
    public static final byte MTYPE_AUTOFFC = -20;
    public static final byte MFLAG_NORMAL = 1;
    public static final byte MFLAG_AUTO = 3;
    public static final byte MFLAG_MULTI = -128;
    public static final int SSI_NO_ERRORS = 0;
    public static final int SSI_NOT_FOUND = 2;
    public static final int SSI_ALR_EXIST = 3;
    public static final int SSI_ADD_ERROR = 10;
    public static final int SSI_LIMIT_EXC = 12;
    public static final int SSI_TICQTOAIM = 13;
    public static final int SSI_AUTH_REQD = 14;
    public static final int UMD_PROFILE_USER = 101;
    public static final int UMD_PROFILE_FIRST_NAME = 102;
    public static final int UMD_PROFILE_LAST_NAME = 103;
    public static final int UMD_PROFILE_GENDER = 104;
    public static final int UMD_PROFILE_HOME_ADDRESS = 105;
    public static final int UMD_PROFILE_FRIENDLY_NAME = 106;
    public static final int UMD_PROFILE_WEBSITE_1 = 107;
    public static final int UMD_PROFILE_RELATIONSHIP_STATUS = 108;
    public static final int UMD_PROFILE_LANG_1 = 109;
    public static final int UMD_PROFILE_JOBS = 110;
    public static final int UMD_PROFILE_ABOUT_ME = 111;
    public static final int UMD_PROFILE_BIRTH_DATE = 112;
    public static final int UMD_PROFILE_ONLINE_STATUS = 2035;
    public static final int UMD_PROFILE_WEBAWARE = 2050;
    public static final int UMD_PROFILE_STATUS_LINE = 2052;
    public static final int UMD_PROFILE_VALIDATED_CELLULAR = 2056;
    private static final int CI_GENDER_UNKNOWN = 0;
    private static final int CI_GENDER_MALE = 1;
    private static final int CI_GENDER_FEMALE = 2;

    public static void parsePacket(IcqAccountRoot icqAccountRoot, byte[] packetData) throws LegacyProtocolException {
        int snacFamily = DataUtil.get16(packetData, 0);
        int snacSubtype = DataUtil.get16(packetData, 2);
        int snacFlags = 0;
        byte[] snacRequestId = new byte[]{};
        if (packetData.length > 4) {
            snacFlags = DataUtil.get16(packetData, 4);
            snacRequestId = DataUtil.getByteArray(packetData, 6, 4);
        }
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(System.err, packetData, ">> SNAC (" + HexUtil.toHexString(snacFamily) + ", " + HexUtil.toHexString(snacSubtype) + "): ");
        }
        switch (snacFamily) {
            case 3: {
                IcqPacketParser.BLMService(icqAccountRoot, packetData, snacSubtype, snacFlags, snacRequestId);
                break;
            }
            case 4: {
                IcqPacketParser.ICBMService(icqAccountRoot, packetData, snacSubtype, snacFlags, snacRequestId);
                break;
            }
            case 19: {
                IcqPacketParser.SSIServiceSnacParser(icqAccountRoot, packetData, snacSubtype, snacFlags, snacRequestId);
                break;
            }
            case 21: {
                IcqPacketParser.ICQSpecificExtService(icqAccountRoot, packetData, snacSubtype, snacFlags, snacRequestId);
                break;
            }
            case 37: {
                IcqPacketParser.ICQBuddyUserInfo(icqAccountRoot, packetData, snacSubtype, snacFlags, snacRequestId);
                break;
            }
        }
    }

    public void parserError(int errorCode) {
    }

    public static void BLMService(IcqAccountRoot icqAccountRoot, byte[] packetData, int snacSubtype, int snacFlags, byte[] snacRequestId) {
        switch (snacSubtype) {
            case 11: {
                Capability[] caps = null;
                ClientInfo clientInfo = new ClientInfo();
                int buddyStatus = IcqStatusUtil.getStatus(1);
                int point = 10;
                int buddyNameLength = DataUtil.get8int(packetData, point);
                byte[] buddyName = new byte[buddyNameLength];
                System.arraycopy(packetData, ++point, buddyName, 0, buddyNameLength);
                String buddyId = new String(buddyName);
                int warningLevel = DataUtil.get16(packetData, point += buddyNameLength);
                int tlvCount = DataUtil.get16(packetData, point += 2);
                point += 2;
                block16: for (int c = 0; c < tlvCount; ++c) {
                    int valueID = DataUtil.get16(packetData, point);
                    int length = DataUtil.get16(packetData, point += 2);
                    byte[] value = new byte[length];
                    System.arraycopy(packetData, point += 2, value, 0, length);
                    point += length;
                    switch (valueID) {
                        case 1: {
                            continue block16;
                        }
                        case 2: {
                            continue block16;
                        }
                        case 3: {
                            clientInfo.signOnTime = DataUtil.get32(value, 0, true);
                            continue block16;
                        }
                        case 4: {
                            clientInfo.idleTime = DataUtil.get16(value, 0);
                            continue block16;
                        }
                        case 5: {
                            clientInfo.memberSinceTime = DataUtil.get32(value, 0, true);
                            continue block16;
                        }
                        case 6: {
                            int firstPart = DataUtil.get16(value, 0);
                            int secondPart = DataUtil.get16(value, 2);
                            LogUtil.outMessage("Status: \n    first part: " + firstPart + "\n" + "    second part:" + secondPart);
                            if (IcqStatusUtil.expectIsStatus(secondPart) && secondPart != IcqStatusUtil.getStatus(0)) {
                                buddyStatus = secondPart;
                                continue block16;
                            }
                            buddyStatus = IcqStatusUtil.getStatus(1);
                            continue block16;
                        }
                        case 10: {
                            clientInfo.externalIp = new byte[]{(byte)DataUtil.get8int(value, 0), (byte)DataUtil.get8int(value, 1), (byte)DataUtil.get8int(value, 2), (byte)DataUtil.get8int(value, 3)};
                            LogUtil.outMessage("ip addr ext: " + clientInfo.externalIp[0] + "." + clientInfo.externalIp[1] + "." + clientInfo.externalIp[2] + "." + clientInfo.externalIp[3]);
                            continue block16;
                        }
                        case 12: {
                            clientInfo.internalIp = new byte[]{(byte)DataUtil.get8int(value, 0), (byte)DataUtil.get8int(value, 1), (byte)DataUtil.get8int(value, 2), (byte)DataUtil.get8int(value, 3)};
                            clientInfo.dcTcpPort = DataUtil.get32(value, 4, true);
                            clientInfo.dcType = (byte)DataUtil.get8int(value, 8);
                            clientInfo.dcProtocolVersion = DataUtil.get16(value, 9);
                            clientInfo.dcAuthCookie = DataUtil.get32(value, 11, true);
                            clientInfo.webFrontPort = DataUtil.get32(value, 15, true);
                            clientInfo.clientFeatures = DataUtil.get32(value, 19, true);
                            clientInfo.lastInfoUpdateTime = DataUtil.get32(value, 23, true);
                            clientInfo.lastExtInfoUpdateTime = DataUtil.get32(value, 27, true);
                            clientInfo.lastExtStatusUpdateTime = DataUtil.get32(value, 31, true);
                            clientInfo.unk = DataUtil.get8int(value, 35);
                            LogUtil.outMessage("ip addr int: " + clientInfo.internalIp[0] + "." + clientInfo.internalIp[1] + "." + clientInfo.internalIp[2] + "." + clientInfo.internalIp[3]);
                            LogUtil.outMessage("dc tcp port: " + clientInfo.dcTcpPort);
                            LogUtil.outMessage("dc type: " + clientInfo.dcType);
                            LogUtil.outMessage("dc protocol version: " + clientInfo.dcProtocolVersion);
                            LogUtil.outMessage("dc auth cookie: " + clientInfo.dcAuthCookie);
                            LogUtil.outMessage("web front port: " + clientInfo.webFrontPort);
                            LogUtil.outMessage("client features: " + clientInfo.clientFeatures);
                            LogUtil.outMessage("last info update time: " + clientInfo.lastInfoUpdateTime);
                            LogUtil.outMessage("last status update time: " + clientInfo.lastExtInfoUpdateTime);
                            LogUtil.outMessage("last ext status update time: " + clientInfo.lastExtStatusUpdateTime);
                            LogUtil.outMessage("unknown: " + clientInfo.unk);
                            continue block16;
                        }
                        case 13: {
                            int capabilitiesCount = value.length / 16;
                            LogUtil.outMessage("caps_count: " + capabilitiesCount);
                            caps = new Capability[capabilitiesCount];
                            for (int i = 0; i < capabilitiesCount; ++i) {
                                caps[i] = new Capability();
                                System.arraycopy(value, i * 16, caps[i].capBytes, 0, 16);
                                if (MidletMain.logLevel != 1) continue;
                                HexUtil.dump_(caps[i].capBytes, buddyId + ": ");
                            }
                            continue block16;
                        }
                        case 15: {
                            clientInfo.onLineTime = System.currentTimeMillis() / 1000L - DataUtil.get32(value, 0, true);
                        }
                    }
                }
                Handler.setBuddyStatus(icqAccountRoot, buddyId, buddyStatus, caps, clientInfo);
                break;
            }
            case 12: {
                int offset = 10;
                int buddyIdLength = DataUtil.get8int(packetData, offset);
                String buddyId = DataUtil.byteArray2string(packetData, ++offset, buddyIdLength);
                Handler.setBuddyStatus(icqAccountRoot, buddyId, IcqStatusUtil.getStatus(0), null, null);
                break;
            }
        }
    }

    public static void ICBMService(IcqAccountRoot icqAccountRoot, byte[] packetData, int snacSubtype, int snacFlags, byte[] snacRequestId) throws LegacyProtocolException {
        switch (snacSubtype) {
            case 11: {
                int offset = 10;
                byte[] msgCookie = ArrayUtil.copyOfRange(packetData, offset, offset + 8);
                int messageChannel = DataUtil.get16(packetData, offset += 8);
                byte screenNameLength = (byte)DataUtil.get8int(packetData, offset += 2);
                String screenName = new String(ArrayUtil.copyOfRange(packetData, ++offset, offset + screenNameLength));
                int reason = DataUtil.get16(packetData, offset += screenNameLength);
                offset += 2;
                switch (reason) {
                    case 3: {
                        LogUtil.outMessage("Reason 0x0003");
                        if (messageChannel == 1) {
                            Handler.msgAck(icqAccountRoot, screenName, null, msgCookie);
                            break;
                        }
                        int length = DataUtil.get16_reversed(packetData, offset);
                        int protocolVersion = DataUtil.get16_reversed(packetData, offset += 2);
                        byte[] plugin = DataUtil.getByteArray(packetData, offset += 2, 16);
                        offset += 16;
                        LogUtil.outMessage("plugin: " + HexUtil.bytesToString(plugin));
                        if (!ArrayUtil.equals(plugin, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0})) break;
                        LogUtil.outMessage("Plugin correct");
                        int unk1 = DataUtil.get16_reversed(packetData, offset);
                        long capabilities = DataUtil.get32_reversed(packetData, offset += 2, true);
                        LogUtil.outMessage("capabilities: " + capabilities);
                        byte unk2 = (byte)DataUtil.get8int(packetData, offset += 4);
                        int downcounter = DataUtil.get16_reversed(packetData, ++offset);
                        LogUtil.outMessage("downcounter: " + downcounter);
                        int chunkLength = DataUtil.get16_reversed(packetData, offset += 2);
                        LogUtil.outMessage("chunkLength: " + chunkLength);
                        int unk3 = DataUtil.get16_reversed(packetData, offset += 2);
                        offset += 2;
                        int msgType = DataUtil.get8int(packetData, offset += 12);
                        ++offset;
                        LogUtil.outMessage("msgType: " + msgType);
                        if ((msgType & 0xFF) == 232) {
                            byte msgFlags = (byte)DataUtil.get8int(packetData, offset);
                            int statusCode = DataUtil.get16_reversed(packetData, ++offset);
                            int priorityCode = DataUtil.get16_reversed(packetData, offset += 2);
                            int textLength = DataUtil.get16_reversed(packetData, offset += 2);
                            byte[] msgText = DataUtil.getByteArray(packetData, offset += 2, textLength);
                            Handler.setStatusMessage(icqAccountRoot, msgCookie, msgText);
                            break;
                        }
                        if (msgType != 26) break;
                        LogUtil.outMessage("msgType == 0x1a");
                        LogUtil.outMessage("response=" + StringUtil.byteArrayToString(packetData));
                        try {
                            ArrayUtil response = new ArrayUtil(packetData);
                            LogUtil.outMessage("Parsing...");
                            ArrayUtil xTitle = new ArrayUtil(response.subarray(response.indexOf("title&gt;".getBytes()) + "title&gt;".length(), response.indexOf("/title&gt;".getBytes())));
                            xTitle.byteString = xTitle.subarray(0, xTitle.indexOf("&lt;".getBytes()));
                            LogUtil.outMessage("xTitle = " + xTitle.getString());
                            ArrayUtil xText = new ArrayUtil(response.subarray(response.indexOf("desc&gt;".getBytes()) + "desc&gt;".length(), response.indexOf("/desc&gt;".getBytes())));
                            xText.byteString = xText.subarray(0, xText.indexOf("&lt;".getBytes()));
                            LogUtil.outMessage("xText = " + xText.getString());
                            LogUtil.outMessage("XTRAZ_RESPONSE: " + xTitle + ": " + xText);
                            Handler.setXStatusMessage(icqAccountRoot, msgCookie, xTitle.byteString, xText.byteString);
                            break;
                        }
                        catch (Throwable ex1) {
                            LogUtil.outMessage("Error in parsing XStatus: " + ex1.getMessage());
                        }
                    }
                }
                break;
            }
            case 7: {
                int offset = 10;
                byte[] msgCookie = ArrayUtil.copyOfRange(packetData, offset, offset + 8);
                int messageChannel = DataUtil.get16(packetData, offset += 8);
                byte screenNameLength = (byte)DataUtil.get8int(packetData, offset += 2);
                String screenName = new String(ArrayUtil.copyOfRange(packetData, ++offset, offset + screenNameLength));
                int senderWarningLevel = DataUtil.get16(packetData, offset += screenNameLength);
                int numberOfTlvs = DataUtil.get16(packetData, offset += 2);
                offset += 2;
                LogUtil.outMessage("Mess from: " + screenName);
                LogUtil.outMessage("There are " + numberOfTlvs + " TLV's");
                LogUtil.outMessage("Message channel: " + messageChannel);
                boolean isAutomatedMess = false;
                int messCharsetNumber = -1;
                int messCharsetSubset = -1;
                byte[] asciiString = new byte[]{};
                byte messageType = 1;
                byte messageFlags = 1;
                int ch2msgType = -1;
                byte[] guid = new byte[16];
                Object guidString = null;
                int[] proxyIp = new int[4];
                int dcTcpPort = -1;
                boolean isViaRendezvousServer = false;
                long fileLength = -1L;
                byte[] fileName = null;
                block54: for (int c = 0; c < numberOfTlvs; ++c) {
                    int type = DataUtil.get16(packetData, offset);
                    int length = DataUtil.get16(packetData, offset += 2);
                    byte[] value = ArrayUtil.copyOfRange(packetData, offset += 2, offset + length);
                    offset += length;
                    if (MidletMain.logLevel == 1) {
                        HexUtil.dump_(value, "TLV.Type(" + HexUtil.toHexString(type) + ") ");
                    }
                    switch (type) {
                        case 1: {
                            LogUtil.outMessage("Buddy class: ignored");
                            continue block54;
                        }
                        case 6: {
                            int firstPart = DataUtil.get16(value, 0);
                            int secondPart = DataUtil.get16(value, 2);
                            LogUtil.outMessage("Status: \n    first part: " + firstPart + "\n" + "    second part:" + secondPart);
                            int buddyStatus = IcqStatusUtil.expectIsStatus(secondPart) ? secondPart : IcqStatusUtil.getStatus(1);
                            LogUtil.outMessage("Buddy status: " + buddyStatus);
                            continue block54;
                        }
                        case 15: {
                            LogUtil.outMessage("Online time: ignored");
                            continue block54;
                        }
                        case 3: {
                            LogUtil.outMessage("Account creation time: ignored");
                            continue block54;
                        }
                        case 4: {
                            isAutomatedMess = true;
                            LogUtil.outMessage("This is automated message");
                        }
                    }
                }
                block55: while (offset < packetData.length) {
                    int type = DataUtil.get16(packetData, offset);
                    int length = DataUtil.get16(packetData, offset += 2);
                    byte[] value = ArrayUtil.copyOfRange(packetData, offset += 2, offset + length);
                    offset += length;
                    if (MidletMain.logLevel == 1) {
                        HexUtil.dump_(value, "TLV.Type(" + HexUtil.toHexString(type) + ") ");
                    }
                    switch (type) {
                        case 2: {
                            LogUtil.outMessage("Channel 1 message data");
                            if (messageChannel != 1) break;
                            int point = 0;
                            while (value.length > point) {
                                byte fragId = (byte)DataUtil.get8int(value, point);
                                byte fragVer = (byte)DataUtil.get8int(value, ++point);
                                int tlvLength = DataUtil.get16(value, ++point);
                                byte[] fragData = ArrayUtil.copyOfRange(value, point += 2, point + tlvLength);
                                point += tlvLength;
                                if (fragVer > 1) {
                                    throw new LegacyProtocolException();
                                }
                                switch (fragId) {
                                    case 5: {
                                        break;
                                    }
                                    case 1: {
                                        messCharsetNumber = DataUtil.get16(fragData, 0);
                                        messCharsetSubset = DataUtil.get16(fragData, 2);
                                        asciiString = DataUtil.getByteArray(fragData, 4, tlvLength - 4);
                                    }
                                }
                            }
                            continue block55;
                        }
                        case 5: {
                            int point;
                            if (messageChannel == 2) {
                                if (MidletMain.logLevel == 1) {
                                    HexUtil.dump_(value, "TLV(0x0005): ");
                                }
                                ch2msgType = DataUtil.get16(value, 0);
                                LogUtil.outMessage("Channel 2 message type: " + ch2msgType);
                                msgCookie = DataUtil.getByteArray(value, 2, 8);
                                if (MidletMain.logLevel == 1) {
                                    HexUtil.dump_(msgCookie, "cookie: ");
                                }
                                guid = DataUtil.getByteArray(value, 10, 16);
                                point = 26;
                                if (MidletMain.logLevel == 1) {
                                    HexUtil.dump_(guid, "guid: ");
                                }
                                while (value.length > point) {
                                    int insType = DataUtil.get16(value, point);
                                    int insLength = DataUtil.get16(value, point += 2);
                                    byte[] insValue = ArrayUtil.copyOfRange(value, point += 2, point + insLength);
                                    point += insLength;
                                    switch (insType) {
                                        case 2: {
                                            proxyIp = new int[]{DataUtil.get8int(insValue, 0), DataUtil.get8int(insValue, 1), DataUtil.get8int(insValue, 2), DataUtil.get8int(insValue, 3)};
                                            LogUtil.outMessage("ip addr proxy: " + proxyIp[0] + "." + proxyIp[1] + "." + proxyIp[2] + "." + proxyIp[3]);
                                            break;
                                        }
                                        case 4: {
                                            break;
                                        }
                                        case 5: {
                                            dcTcpPort = DataUtil.get16(insValue, 0);
                                            break;
                                        }
                                        case 16: {
                                            isViaRendezvousServer = true;
                                            break;
                                        }
                                        case 10: {
                                            break;
                                        }
                                        case 11: {
                                            break;
                                        }
                                        case 15: {
                                            break;
                                        }
                                        case 10001: {
                                            int fdPoint;
                                            if (ArrayUtil.equals(guid, new byte[]{9, 70, 19, 67, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0})) {
                                                fdPoint = 0;
                                                DataUtil.get16(insValue, fdPoint);
                                                DataUtil.get16(insValue, fdPoint += 2);
                                                fileLength = DataUtil.get32(insValue, fdPoint += 2, true);
                                                fileName = DataUtil.getByteArray(insValue, fdPoint += 4, insValue.length - 8 - 1);
                                                break;
                                            }
                                            if (MidletMain.logLevel == 1) {
                                                HexUtil.dump_(value, "ch2: ");
                                            }
                                            fdPoint = 0;
                                            int follDataLength = DataUtil.get16_reversed(insValue, fdPoint);
                                            int protVersion = DataUtil.get16_reversed(insValue, fdPoint += 2);
                                            byte[] plugin = DataUtil.getByteArray(insValue, fdPoint += 2, 16);
                                            int unkWord = DataUtil.get16(insValue, fdPoint += 16);
                                            long cliCapFlag = DataUtil.get16_reversed(insValue, fdPoint += 2);
                                            byte unkByte = (byte)DataUtil.get8int(insValue, fdPoint += 4);
                                            int downCounter = DataUtil.get16_reversed(insValue, ++fdPoint);
                                            int nFollDataLength = DataUtil.get16_reversed(insValue, fdPoint += 2);
                                            int secDCounter = DataUtil.get16_reversed(insValue, fdPoint += 2);
                                            DataUtil.getByteArray(insValue, fdPoint += 2, nFollDataLength - 2);
                                            fdPoint += nFollDataLength - 2;
                                            LogUtil.outMessage("prot. version: " + protVersion);
                                            if (MidletMain.logLevel == 1) {
                                                HexUtil.dump_(plugin, "plugin: ");
                                            }
                                            LogUtil.outMessage("Other data length: " + (insLength - follDataLength - nFollDataLength));
                                            if (!ArrayUtil.equals(plugin, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0})) break;
                                            messageType = (byte)DataUtil.get8int(insValue, fdPoint);
                                            messageFlags = (byte)DataUtil.get8int(insValue, ++fdPoint);
                                            int statusCode = DataUtil.get16_reversed(insValue, ++fdPoint);
                                            int priorityCode = DataUtil.get16_reversed(insValue, fdPoint += 2);
                                            int messageStringLength = DataUtil.get16_reversed(insValue, fdPoint += 2);
                                            asciiString = DataUtil.getByteArray(insValue, fdPoint += 2, messageStringLength);
                                            fdPoint += messageStringLength;
                                        }
                                    }
                                }
                                continue block55;
                            }
                            if (messageChannel != 4) break;
                            screenName = String.valueOf(DataUtil.get32_reversed(value, 0, true));
                            messageType = (byte)DataUtil.get8int(value, 4);
                            messageFlags = (byte)DataUtil.get8int(value, 5);
                            int messStringLength = DataUtil.get16_reversed(value, 6);
                            asciiString = DataUtil.getByteArray(value, 8, messStringLength);
                        }
                    }
                }
                LogUtil.outMessage("------- Data for all channels -------");
                LogUtil.outMessage("Sender screenname: " + screenName);
                LogUtil.outMessage("Message charset number: " + messCharsetNumber);
                LogUtil.outMessage("Message charset subset: " + messCharsetSubset);
                LogUtil.outMessage("Message text string: " + new String(asciiString));
                LogUtil.outMessage("--------- From Channel 2, 4 ---------");
                LogUtil.outMessage("Message type: " + messageType);
                LogUtil.outMessage("Message flags: " + messageFlags);
                LogUtil.outMessage("--------- DC ------------------------");
                LogUtil.outMessage("External ip: " + proxyIp[0] + "." + proxyIp[1] + "." + proxyIp[2] + "." + proxyIp[3]);
                LogUtil.outMessage("Listening port: " + dcTcpPort);
                String stringCookie = new String();
                for (int c = 0; c < 8; ++c) {
                    stringCookie = stringCookie + HexUtil.toHexString(msgCookie[c]) + ", ";
                }
                LogUtil.outMessage("Cookie: " + stringCookie);
                if (ArrayUtil.equals(guid, new byte[]{9, 70, 19, 67, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0})) {
                    LogUtil.outMessage("Type: " + HexUtil.toHexString0x(ch2msgType));
                    Handler.performTransferAction(icqAccountRoot, ch2msgType, screenName, proxyIp, dcTcpPort, isViaRendezvousServer, fileLength, fileName, msgCookie, false);
                    break;
                }
                if (MidletMain.logLevel == 1) {
                    HexUtil.dump_(asciiString, "ascii: ");
                }
                String decodedString = null;
                if (asciiString != null) {
                    try {
                        decodedString = messCharsetNumber == 2 ? StringUtil.removeCr(StringUtil.ucs2beByteArrayToString(asciiString)) : StringUtil.removeCr(StringUtil.byteArrayToString(asciiString, true));
                    }
                    catch (Throwable ex1) {
                        // empty catch block
                    }
                }
                LogUtil.outMessage("Detecting type of: " + messageType);
                switch (messageType) {
                    case 1: {
                        LogUtil.outMessage("Plain message");
                        Handler.recMess(icqAccountRoot, screenName, null, null, decodedString, msgCookie, 7);
                        IcqPacketSender.sendMsgAck(icqAccountRoot.session, messageChannel, screenName, msgCookie);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        Handler.recMess(icqAccountRoot, screenName, null, null, decodedString, msgCookie, 0);
                        break;
                    }
                    case 6: {
                        Handler.recMess(icqAccountRoot, screenName, null, null, decodedString, msgCookie, 1);
                        break;
                    }
                    case 7: {
                        Handler.recMess(icqAccountRoot, screenName, null, null, decodedString, msgCookie, 2);
                        break;
                    }
                    case 8: {
                        Handler.recMess(icqAccountRoot, screenName, null, null, decodedString, msgCookie, 3);
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 14: {
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 26: {
                        Handler.sendXStatusMessage(icqAccountRoot, msgCookie, screenName);
                        break;
                    }
                    case -24: 
                    case -23: 
                    case -22: 
                    case -21: 
                    case -20: {
                        Handler.sendStatusMessage(icqAccountRoot, msgCookie, screenName);
                    }
                }
                break;
            }
            case 12: {
                int offset = 10;
                byte[] msgCookie = DataUtil.getByteArray(packetData, offset, 8);
                int msgChannel = DataUtil.get16(packetData, offset += 8);
                byte userUinStringLength = (byte)DataUtil.get8int(packetData, offset += 2);
                String uinString = DataUtil.byteArray2string(packetData, ++offset, userUinStringLength);
                LogUtil.outMessage("Message delivired ", true);
                LogUtil.outMessage("Message channel: " + msgChannel);
                LogUtil.outMessage("Message from: " + uinString);
                String stringCookie = new String();
                for (int c = 0; c < 8; ++c) {
                    stringCookie = stringCookie + HexUtil.toHexString(msgCookie[c]) + ", ";
                }
                LogUtil.outMessage(stringCookie);
                Handler.msgAck(icqAccountRoot, uinString, null, msgCookie);
                break;
            }
            case 20: {
                int offset = 10;
                offset += 8;
                byte buddyNameLength = (byte)DataUtil.get8int(packetData, offset += 2);
                String buddyName = new String(DataUtil.getByteArray(packetData, ++offset, buddyNameLength));
                int notificationType = DataUtil.get16(packetData, offset += buddyNameLength);
                LogUtil.outMessage("buddyName: " + buddyName);
                LogUtil.outMessage("notificationType: " + notificationType);
                Handler.setBuddyTypingStatus(icqAccountRoot, buddyName, null, notificationType != 0, false);
                break;
            }
        }
    }

    private static void SSIServiceSnacParser(IcqAccountRoot icqAccountRoot, byte[] packetData, int snacSubtype, int snacFlags, byte[] snacRequestId) throws LegacyProtocolException {
        try {
            switch (snacSubtype) {
                case 6: {
                    int buddyCount = 0;
                    int privateBuddyId = -1;
                    Vector<IcqGroup> buddyList = new Vector<IcqGroup>();
                    Vector<IcqItem> privateList = new Vector<IcqItem>();
                    int offset = 10;
                    int ssiVersion = DataUtil.get8int(packetData, offset);
                    if (ssiVersion > 1) {
                        throw new LegacyProtocolException();
                    }
                    ++offset;
                    if (ssiVersion == 0) {
                        int ssiObjectCount = DataUtil.get16(packetData, offset);
                        LogUtil.outMessage("SSI objects count: " + ssiObjectCount);
                        offset += 2;
                        for (int c = 0; c < ssiObjectCount; ++c) {
                            IcqGroup groupItem = null;
                            int buddyNameLength = DataUtil.get16(packetData, offset);
                            byte[] buddyName = new byte[buddyNameLength];
                            System.arraycopy(packetData, offset += 2, buddyName, 0, buddyNameLength);
                            int buddyGroupID = DataUtil.get16(packetData, offset += buddyNameLength);
                            int buddyID = DataUtil.get16(packetData, offset += 2);
                            int buddyType = DataUtil.get16(packetData, offset += 2);
                            int ssiTLVLen = DataUtil.get16(packetData, offset += 2);
                            offset += 2;
                            boolean toAddFlag = false;
                            boolean toPrivateFlag = false;
                            IcqItem buddyItem = new IcqItem("");
                            switch (buddyType) {
                                case 29: {
                                    break;
                                }
                                case 21: {
                                    break;
                                }
                                case 2: {
                                    buddyItem.buddyType = 5;
                                    toPrivateFlag = true;
                                    break;
                                }
                                case 3: {
                                    buddyItem.buddyType = 6;
                                    toPrivateFlag = true;
                                    break;
                                }
                                case 14: {
                                    buddyItem.buddyType = 7;
                                    toPrivateFlag = true;
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case 20: {
                                    break;
                                }
                                case 15: {
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                case 256: {
                                    break;
                                }
                                case 1: {
                                    groupItem = new IcqGroup("");
                                    buddyItem = null;
                                    groupItem.buddyType = 1;
                                    toAddFlag = true;
                                    break;
                                }
                                case 32: {
                                    groupItem = new IcqGroup("");
                                    buddyItem = null;
                                    groupItem.buddyType = 3;
                                    toAddFlag = isReceivePhantoms;
                                    break;
                                }
                                case 0: {
                                    buddyItem.buddyType = 2;
                                    toAddFlag = true;
                                    break;
                                }
                                case 25: {
                                    buddyItem.buddyType = 4;
                                    toAddFlag = isReceivePhantoms;
                                    break;
                                }
                                default: {
                                    LogUtil.outMessage("unk_type: " + new String(buddyName));
                                    buddyItem.buddyType = 2;
                                    toAddFlag = false;
                                }
                            }
                            if (buddyItem != null) {
                                buddyItem.userId = StringUtil.byteArrayToString(buddyName, true);
                                buddyItem.groupId = buddyGroupID;
                                buddyItem.buddyId = buddyID;
                                buddyItem.userNick = buddyItem.userId;
                                LogUtil.outMessage(" - " + buddyItem.userId);
                            } else if (groupItem != null) {
                                groupItem.userId = StringUtil.byteArrayToString(buddyName, true);
                                groupItem.groupId = buddyGroupID;
                                groupItem.buddyId = buddyID;
                            }
                            int pointBefore = offset;
                            while (offset < pointBefore + ssiTLVLen) {
                                int valueID = DataUtil.get16(packetData, offset);
                                int length = DataUtil.get16(packetData, offset += 2);
                                byte[] value = new byte[length];
                                System.arraycopy(packetData, offset += 2, value, 0, length);
                                offset += length;
                                switch (valueID) {
                                    case 202: {
                                        LogUtil.outMessage("This is the byte that tells the AIM servers your privacy setting. If 1, then allow all users to see you. If 2, then block all users from seeing you. If 3, then allow only the users in the permit list. If 4, then block only the users in the deny list. If 5, then allow only users on your buddy list.");
                                        LogUtil.outMessage("buddyItem ? =null : " + (buddyItem == null));
                                        byte privacySettings = value[0];
                                        privateBuddyId = buddyItem.buddyId;
                                        LogUtil.outMessage("private buddy id: " + privateBuddyId);
                                        break;
                                    }
                                    case 204: {
                                        break;
                                    }
                                    case 102: {
                                        buddyItem.isAvaitingAuth = true;
                                        break;
                                    }
                                    case 316: {
                                        break;
                                    }
                                    case 213: {
                                        break;
                                    }
                                    case 200: {
                                        break;
                                    }
                                    case 212: {
                                        break;
                                    }
                                    case 311: {
                                        break;
                                    }
                                    case 305: {
                                        if (buddyItem != null) {
                                            buddyItem.userNick = StringUtil.byteArrayToString(value, true);
                                            break;
                                        }
                                        if (groupItem == null) break;
                                        groupItem.userId = StringUtil.byteArrayToString(value, true);
                                        break;
                                    }
                                    case 317: {
                                        break;
                                    }
                                    case 205: {
                                        break;
                                    }
                                    case 314: {
                                        break;
                                    }
                                    case 201: {
                                        break;
                                    }
                                    case 203: {
                                        break;
                                    }
                                    case 318: {
                                        break;
                                    }
                                }
                            }
                            if (groupItem != null && groupItem.buddyId == 0 && groupItem.groupId == 0) {
                                groupItem.buddyType = 0;
                                continue;
                            }
                            if (toPrivateFlag) {
                                buddyItem.updateUiData();
                                privateList.addElement(buddyItem);
                                continue;
                            }
                            if (!toAddFlag) continue;
                            if (groupItem != null) {
                                groupItem.updateUiData();
                                LogUtil.outMessage("[ ".concat(groupItem.userId).concat(" ]"));
                                buddyList.addElement(groupItem);
                                continue;
                            }
                            if (buddyItem == null) continue;
                            buddyItem.updateUiData();
                            LogUtil.outMessage(buddyItem.userId.concat(" = ").concat(buddyItem.userNick));
                            if (buddyList.isEmpty()) {
                                groupItem = new IcqGroup("");
                                groupItem.buddyType = -1;
                                buddyList.addElement(groupItem);
                            }
                            ++buddyCount;
                            ((IcqGroup)buddyList.lastElement()).addChild(buddyItem);
                        }
                    }
                    LogUtil.outMessage("Final private buddy id: " + privateBuddyId);
                    if (!buddyList.isEmpty()) {
                        LogUtil.outMessage("snacFlags = " + snacFlags);
                        Handler.setBuddyList(icqAccountRoot, buddyList, privateList, privateBuddyId, snacFlags, snacRequestId);
                    }
                    LogUtil.outMessage("Buddy added count: " + buddyCount);
                    break;
                }
                case 14: {
                    int offset = packetData.length - 2;
                    int resultCode = DataUtil.get16(packetData, offset);
                    long requestIdLong = DataUtil.get32(snacRequestId, 0, true);
                    Cookie cookie = new Cookie(requestIdLong);
                    LogUtil.outMessage("cookieString = " + cookie.cookieString);
                    LogUtil.outMessage("resultCode = " + resultCode);
                    String errorString = null;
                    switch (resultCode) {
                        case 0: {
                            Handler.processQueueAction(icqAccountRoot, cookie, null);
                            break;
                        }
                        case 2: {
                            errorString = "SSI_NOT_FOUND";
                            break;
                        }
                        case 3: {
                            errorString = "SSI_ALR_EXIST";
                            break;
                        }
                        case 10: {
                            errorString = "SSI_ADD_ERROR";
                            break;
                        }
                        case 12: {
                            errorString = "SSI_LIMIT_EXC";
                            break;
                        }
                        case 13: {
                            errorString = "SSI_TICQTOAIM";
                            break;
                        }
                        case 14: {
                            errorString = "SSI_AUTH_REQD";
                            break;
                        }
                        default: {
                            errorString = "ERROR";
                        }
                    }
                    if (errorString == null) break;
                    Handler.cancelQueueAction(icqAccountRoot, cookie, errorString);
                    break;
                }
                case 25: {
                    int offset = 18;
                    byte userIdLength = DataUtil.get8(packetData, offset);
                    String userId = StringUtil.byteArrayToString(packetData, ++offset, userIdLength, true);
                    LogUtil.outMessage("userId: " + userId);
                    int reasonLength = DataUtil.get16(packetData, offset += userIdLength);
                    String reason = StringUtil.byteArrayToString(packetData, offset += 2, reasonLength, true);
                    LogUtil.outMessage("reason: " + reason);
                    offset += reasonLength;
                    Handler.recMess(icqAccountRoot, userId, null, null, reason, snacRequestId, 1);
                    break;
                }
            }
        }
        catch (Throwable ex1) {
            LogUtil.outMessage(ex1);
        }
    }

    public static void ICQSpecificExtService(IcqAccountRoot icqAccountRoot, byte[] packetData, int snacSubtype, int snacFlags, byte[] snacRequestId) {
        switch (snacSubtype) {
            case 1: {
                int point = 10;
                int errorCode = DataUtil.get16(packetData, point);
                LogUtil.outMessage("Ext Service Error: " + errorCode, true);
                break;
            }
        }
    }

    public static void ICQBuddyUserInfo(IcqAccountRoot icqAccountRoot, byte[] packetData, int snacSubtype, int snacFlags, byte[] snacRequestId) {
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(packetData, "buddy info: ");
        }
        BuddyInfo buddyInfo = new BuddyInfo();
        int offset = 10;
        int result = (int)DataUtil.get32(packetData, offset, true);
        offset += 4;
        if (result == 0) {
            LogUtil.outMessage("Info OK");
            offset += DataUtil.get16(packetData, offset) + 2 + 8;
            int count = (int)DataUtil.get32(packetData, offset, true);
            offset += 4;
            LogUtil.outMessage("Count: " + count);
            int n = count;
            while (--n >= 0) {
                int len = DataUtil.get16(packetData, offset);
                buddyInfo.nickName = buddyInfo.buddyId = StringUtil.byteArrayToString(packetData, offset += 2, len, true);
                offset += len;
                int prefsCount = DataUtil.get16(packetData, offset += 8);
                offset += 2;
                block13: while (--prefsCount >= 0) {
                    int prefType = DataUtil.get16(packetData, offset);
                    offset += 2;
                    switch (prefType) {
                        case 102: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.addKeyValue("FIRST_NAME_LABEL", StringUtil.byteArrayToString(packetData, offset += 2, len, true));
                            offset += len;
                            continue block13;
                        }
                        case 103: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.addKeyValue("LAST_NAME_LABEL", StringUtil.byteArrayToString(packetData, offset += 2, len, true));
                            offset += len;
                            continue block13;
                        }
                        case 104: {
                            buddyInfo.addKeyValue("GENDER_LABEL", Math.max(1L, DataUtil.get32(packetData, offset + 2, true)) == 1L ? Localization.getMessage("GENDER_MALE") : Localization.getMessage("GENDER_FEMALE"));
                            break;
                        }
                        case 106: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.nickName = StringUtil.byteArrayToString(packetData, offset += 2, len, true);
                            offset += len;
                            continue block13;
                        }
                        case 107: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.addKeyValue("WEBSITE_LABEL", StringUtil.byteArrayToString(packetData, offset += 2, len, true));
                            offset += len;
                            continue block13;
                        }
                        case 111: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.addKeyValue("ABOUT_ME_LABEL", StringUtil.byteArrayToString(packetData, offset += 2, len, true));
                            offset += len;
                            continue block13;
                        }
                        case 112: {
                            long date = DataUtil.get32(packetData, offset + 2, true);
                            if (date <= 0L) break;
                            buddyInfo.addKeyValue("BIRTH_DATE_LABEL", TimeUtil.getDateString(date += 86400L, false));
                            break;
                        }
                        case 2050: {
                            break;
                        }
                        case 2052: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.addKeyValue("STATUSDESC", StringUtil.byteArrayToString(packetData, offset += 2, len, true));
                            offset += len;
                            continue block13;
                        }
                        case 2056: {
                            len = DataUtil.get16(packetData, offset);
                            buddyInfo.addKeyValue("VALIDATED_CELLULAR_LABEL", StringUtil.byteArrayToString(packetData, offset += 2, len, true));
                            offset += len;
                            continue block13;
                        }
                    }
                    offset += DataUtil.get16(packetData, offset) + 2;
                }
                offset += 4;
                LogUtil.outMessage("Info completed");
                buddyInfo.avatar = IcqPacketParser.downloadAvatar(buddyInfo.buddyId);
                Handler.showUserShortInfo(icqAccountRoot, buddyInfo);
            }
        }
    }

    public static Image downloadAvatar(String userId) {
        if (!StringUtil.isNullOrEmpty(userId)) {
            int atIndex = userId.indexOf(64);
            if (atIndex != -1) {
                String domain = userId.substring(atIndex + 1);
                LogUtil.outMessage("Domain: " + domain);
                if (!StringUtil.isNullOrEmpty(domain) && (domain.equals("corp.mail.ru") || domain.equals("mail.ru") || domain.equals("inbox.ru") || domain.equals("bk.ru") || domain.equals("list.ru"))) {
                    return MmpPacketParser.downloadAvatar(userId);
                }
            }
            try {
                HttpConnection http = (HttpConnection)Connector.open((String)("http://api.icq.net/expressions/get?f=native&type=buddyIcon&t=" + userId), (int)1, (boolean)true);
                http.setRequestMethod("GET");
                if (http.getResponseCode() == 200) {
                    int read;
                    InputStream stream = http.openInputStream();
                    ArrayUtil array = new ArrayUtil();
                    byte[] buffer = new byte[4096];
                    while ((read = stream.read(buffer)) >= 0) {
                        array.append(buffer, 0, read);
                    }
                    return Image.createImage((byte[])array.byteString, (int)0, (int)array.length());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

